/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data;

import com.clickhouse.data.value.UnsignedByte;
import com.clickhouse.data.value.UnsignedInteger;
import com.clickhouse.data.value.UnsignedLong;
import com.clickhouse.data.value.UnsignedShort;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;

public enum ClickHouseDataType {
    Bool(Boolean.class, false, false, true, 1, 1, 0, 0, 0, false, "BOOLEAN"),
    Date(LocalDate.class, false, false, false, 2, 10, 0, 0, 0, false, new String[0]),
    Date32(LocalDate.class, false, false, false, 4, 10, 0, 0, 0, false, new String[0]),
    DateTime(LocalDateTime.class, true, false, false, 0, 29, 0, 0, 9, false, "TIMESTAMP"),
    DateTime32(LocalDateTime.class, true, false, false, 4, 19, 0, 0, 0, false, new String[0]),
    DateTime64(LocalDateTime.class, true, false, false, 8, 29, 3, 0, 9, false, new String[0]),
    Enum8(String.class, true, true, false, 1, 0, 0, 0, 0, false, "ENUM"),
    Enum16(String.class, true, true, false, 2, 0, 0, 0, 0, false, new String[0]),
    FixedString(String.class, true, true, false, 0, 0, 0, 0, 0, false, "BINARY"),
    Int8(Byte.class, false, true, true, 1, 3, 0, 0, 0, false, "BYTE", "INT1", "INT1 SIGNED", "TINYINT", "TINYINT SIGNED"),
    UInt8(UnsignedByte.class, false, true, false, 1, 3, 0, 0, 0, false, "INT1 UNSIGNED", "TINYINT UNSIGNED"),
    Int16(Short.class, false, true, true, 2, 5, 0, 0, 0, false, "SMALLINT", "SMALLINT SIGNED"),
    UInt16(UnsignedShort.class, false, true, false, 2, 5, 0, 0, 0, false, "SMALLINT UNSIGNED", "YEAR"),
    Int32(Integer.class, false, true, true, 4, 10, 0, 0, 0, false, "INT", "INT SIGNED", "INTEGER", "INTEGER SIGNED", "MEDIUMINT", "MEDIUMINT SIGNED"),
    UInt32(UnsignedInteger.class, false, true, false, 4, 10, 0, 0, 0, false, "INT UNSIGNED", "INTEGER UNSIGNED", "MEDIUMINT UNSIGNED"),
    Int64(Long.class, false, true, true, 8, 19, 0, 0, 0, false, "BIGINT", "BIGINT SIGNED", "TIME"),
    IntervalYear(Long.class, false, true, true, 8, 19, 0, 0, 0, false, new String[0]),
    IntervalQuarter(Long.class, false, true, true, 8, 19, 0, 0, 0, false, new String[0]),
    IntervalMonth(Long.class, false, true, true, 8, 19, 0, 0, 0, false, new String[0]),
    IntervalWeek(Long.class, false, true, true, 8, 19, 0, 0, 0, false, new String[0]),
    IntervalDay(Long.class, false, true, true, 8, 19, 0, 0, 0, false, new String[0]),
    IntervalHour(Long.class, false, true, true, 8, 19, 0, 0, 0, false, new String[0]),
    IntervalMinute(Long.class, false, true, true, 8, 19, 0, 0, 0, false, new String[0]),
    IntervalSecond(Long.class, false, true, true, 8, 19, 0, 0, 0, false, new String[0]),
    IntervalMicrosecond(Long.class, false, true, true, 8, 19, 0, 0, 0, false, new String[0]),
    IntervalMillisecond(Long.class, false, true, true, 8, 19, 0, 0, 0, false, new String[0]),
    IntervalNanosecond(Long.class, false, true, true, 8, 19, 0, 0, 0, false, new String[0]),
    UInt64(UnsignedLong.class, false, true, false, 8, 20, 0, 0, 0, false, "BIGINT UNSIGNED", "BIT", "SET"),
    Int128(BigInteger.class, false, true, true, 16, 39, 0, 0, 0, false, new String[0]),
    UInt128(BigInteger.class, false, true, false, 16, 39, 0, 0, 0, false, new String[0]),
    Int256(BigInteger.class, false, true, true, 32, 77, 0, 0, 0, false, new String[0]),
    UInt256(BigInteger.class, false, true, false, 32, 78, 0, 0, 0, false, new String[0]),
    Decimal(BigDecimal.class, true, false, true, 0, 76, 0, 0, 76, false, "DEC", "FIXED", "NUMERIC"),
    Decimal32(BigDecimal.class, true, false, true, 4, 9, 9, 0, 9, false, new String[0]),
    Decimal64(BigDecimal.class, true, false, true, 8, 18, 18, 0, 18, false, new String[0]),
    Decimal128(BigDecimal.class, true, false, true, 16, 38, 38, 0, 38, false, new String[0]),
    Decimal256(BigDecimal.class, true, false, true, 32, 76, 20, 0, 76, false, new String[0]),
    Float32(Float.class, false, true, true, 4, 12, 0, 0, 38, false, "FLOAT", "REAL", "SINGLE"),
    Float64(Double.class, false, true, true, 8, 22, 0, 0, 308, false, "DOUBLE", "DOUBLE PRECISION"),
    IPv4(Inet4Address.class, false, true, false, 4, 10, 0, 0, 0, false, "INET4"),
    IPv6(Inet6Address.class, false, true, false, 16, 39, 0, 0, 0, false, "INET6"),
    UUID(UUID.class, false, true, false, 16, 69, 0, 0, 0, false, new String[0]),
    Point(Object.class, false, true, true, 33, 0, 0, 0, 0, true, new String[0]),
    Polygon(Object.class, false, true, true, 0, 0, 0, 0, 0, true, new String[0]),
    MultiPolygon(Object.class, false, true, true, 0, 0, 0, 0, 0, true, new String[0]),
    Ring(Object.class, false, true, true, 0, 0, 0, 0, 0, true, new String[0]),
    JSON(Object.class, false, false, false, 0, 0, 0, 0, 0, true, new String[0]),
    Object(Object.class, true, true, false, 0, 0, 0, 0, 0, true, new String[0]),
    String(String.class, false, true, false, 0, 0, 0, 0, 0, false, "BINARY LARGE OBJECT", "BINARY VARYING", "BLOB", "BYTEA", "CHAR", "CHAR LARGE OBJECT", "CHAR VARYING", "CHARACTER", "CHARACTER LARGE OBJECT", "CHARACTER VARYING", "CLOB", "GEOMETRY", "LONGBLOB", "LONGTEXT", "MEDIUMBLOB", "MEDIUMTEXT", "NATIONAL CHAR", "NATIONAL CHAR VARYING", "NATIONAL CHARACTER", "NATIONAL CHARACTER LARGE OBJECT", "NATIONAL CHARACTER VARYING", "NCHAR", "NCHAR LARGE OBJECT", "NCHAR VARYING", "NVARCHAR", "TEXT", "TINYBLOB", "TINYTEXT", "VARBINARY", "VARCHAR", "VARCHAR2"),
    Array(Object.class, true, true, false, 0, 0, 0, 0, 0, true, new String[0]),
    Map(Map.class, true, true, false, 0, 0, 0, 0, 0, true, new String[0]),
    Nested(Object.class, true, true, false, 0, 0, 0, 0, 0, true, new String[0]),
    Tuple(List.class, true, true, false, 0, 0, 0, 0, 0, true, new String[0]),
    Nothing(Object.class, false, true, false, 0, 0, 0, 0, 0, true, new String[0]),
    SimpleAggregateFunction(String.class, true, true, false, 0, 0, 0, 0, 0, false, new String[0]),
    AggregateFunction(String.class, true, true, false, 0, 0, 0, 0, 0, true, new String[0]);

    public static final Set<String> allAliases;
    public static final Map<String, ClickHouseDataType> name2type;
    private final Class<?> objectType;
    private final Class<?> widerObjectType;
    private final Class<?> primitiveType;
    private final Class<?> widerPrimitiveType;
    private final boolean parameter;
    private final boolean caseSensitive;
    private final boolean signed;
    private final List<String> aliases;
    private final int byteLength;
    private final int maxPrecision;
    private final int defaultScale;
    private final int minScale;
    private final int maxScale;
    private final boolean nestedType;

    public static boolean isAlias(String typeName) {
        return typeName != null && !typeName.isEmpty() && allAliases.contains(typeName.trim().toUpperCase());
    }

    public static List<String> match(String part) {
        LinkedList<String> types = new LinkedList<String>();
        for (ClickHouseDataType t : ClickHouseDataType.values()) {
            if (t.isCaseSensitive()) {
                if (!t.name().equals(part)) continue;
                types.add(t.name());
                break;
            }
            if (!t.name().equalsIgnoreCase(part)) continue;
            types.add(part);
            break;
        }
        if (types.isEmpty()) {
            part = part.toUpperCase();
            String prefix = part + ' ';
            for (String alias : allAliases) {
                if ((alias.length() != part.length() || !alias.equals(part)) && (alias.length() <= part.length() || !alias.startsWith(prefix))) continue;
                types.add(alias);
            }
        }
        return types;
    }

    public static boolean mayStartWith(String ... prefixes) {
        if (prefixes == null || prefixes.length == 0) {
            return false;
        }
        StringBuilder builder = new StringBuilder();
        int len = prefixes.length;
        for (int i = 0; i < len; ++i) {
            builder.append(prefixes[i].toUpperCase()).append(' ');
        }
        String prefix = builder.toString();
        builder.setLength(builder.length() - 1);
        String typeName = builder.toString();
        for (String alias : allAliases) {
            if (!alias.startsWith(prefix) && !alias.equals(typeName)) continue;
            return true;
        }
        return false;
    }

    public static ClickHouseDataType of(String typeName) {
        if (typeName == null || (typeName = typeName.trim()).isEmpty()) {
            throw new IllegalArgumentException("Non-empty typeName is required");
        }
        ClickHouseDataType type = name2type.get(typeName);
        if (type == null) {
            type = name2type.get(typeName.toUpperCase());
        }
        if (type == null) {
            throw new IllegalArgumentException("Unknown data type: " + typeName);
        }
        return type;
    }

    public static Class<?> toObjectType(Class<?> javaClass) {
        if (Boolean.TYPE == javaClass) {
            javaClass = Boolean.class;
        } else if (Byte.TYPE == javaClass) {
            javaClass = Byte.class;
        } else if (Integer.TYPE == javaClass) {
            javaClass = Integer.class;
        } else if (Long.TYPE == javaClass) {
            javaClass = Long.class;
        } else if (Short.TYPE == javaClass || Character.TYPE == javaClass || Character.class == javaClass) {
            javaClass = Short.class;
        } else if (Float.TYPE == javaClass) {
            javaClass = Float.class;
        } else if (Double.TYPE == javaClass) {
            javaClass = Double.class;
        } else if (javaClass == null) {
            javaClass = Object.class;
        }
        return javaClass;
    }

    public static Class<?> toWiderObjectType(Class<?> javaClass) {
        if (Boolean.TYPE == javaClass) {
            javaClass = Boolean.class;
        } else if (Byte.TYPE == javaClass || Byte.class == javaClass || UnsignedByte.class == javaClass) {
            javaClass = Short.class;
        } else if (Integer.TYPE == javaClass || Integer.class == javaClass || UnsignedInteger.class == javaClass) {
            javaClass = Long.class;
        } else if (Long.TYPE == javaClass || Long.class == javaClass) {
            javaClass = UnsignedLong.class;
        } else if (Short.TYPE == javaClass || Short.class == javaClass || UnsignedShort.class == javaClass || Character.TYPE == javaClass || Character.class == javaClass) {
            javaClass = Integer.class;
        } else if (Float.TYPE == javaClass) {
            javaClass = Float.class;
        } else if (Double.TYPE == javaClass) {
            javaClass = Double.class;
        } else if (javaClass == null) {
            javaClass = Object.class;
        }
        return javaClass;
    }

    public static Class<?> toPrimitiveType(Class<?> javaClass) {
        if (Boolean.class == javaClass) {
            javaClass = Boolean.TYPE;
        } else if (Byte.class == javaClass || UnsignedByte.class == javaClass) {
            javaClass = Byte.TYPE;
        } else if (Integer.class == javaClass || UnsignedInteger.class == javaClass) {
            javaClass = Integer.TYPE;
        } else if (Long.class == javaClass || UnsignedLong.class == javaClass) {
            javaClass = Long.TYPE;
        } else if (Short.class == javaClass || UnsignedShort.class == javaClass || Character.class == javaClass || Character.TYPE == javaClass) {
            javaClass = Short.TYPE;
        } else if (Float.class == javaClass) {
            javaClass = Float.TYPE;
        } else if (Double.class == javaClass) {
            javaClass = Double.TYPE;
        } else if (javaClass == null) {
            javaClass = Object.class;
        }
        return javaClass;
    }

    public static Class<?> toWiderPrimitiveType(Class<?> javaClass) {
        if (Boolean.class == javaClass || Boolean.TYPE == javaClass) {
            javaClass = Boolean.TYPE;
        } else if (Byte.class == javaClass || UnsignedByte.class == javaClass || Byte.TYPE == javaClass) {
            javaClass = Short.TYPE;
        } else if (Integer.class == javaClass || UnsignedInteger.class == javaClass || Integer.TYPE == javaClass) {
            javaClass = Long.TYPE;
        } else if (Long.class == javaClass || Long.TYPE == javaClass) {
            javaClass = UnsignedLong.class;
        } else if (Short.class == javaClass || UnsignedShort.class == javaClass || Short.TYPE == javaClass || Character.class == javaClass || Character.TYPE == javaClass) {
            javaClass = Integer.TYPE;
        } else if (Float.class == javaClass) {
            javaClass = Float.TYPE;
        } else if (Double.class == javaClass) {
            javaClass = Double.TYPE;
        } else if (javaClass == null) {
            javaClass = Object.class;
        }
        return javaClass;
    }

    private ClickHouseDataType(Class<?> javaClass, boolean parameter, boolean caseSensitive, boolean signed, int byteLength, int maxPrecision, int defaultScale, int minScale, int maxScale, boolean nestedType, String ... aliases) {
        this.objectType = ClickHouseDataType.toObjectType(javaClass);
        this.widerObjectType = !signed ? ClickHouseDataType.toWiderObjectType(javaClass) : this.objectType;
        this.primitiveType = ClickHouseDataType.toPrimitiveType(javaClass);
        this.widerPrimitiveType = !signed ? ClickHouseDataType.toWiderPrimitiveType(javaClass) : this.primitiveType;
        this.parameter = parameter;
        this.caseSensitive = caseSensitive;
        this.signed = signed;
        this.byteLength = byteLength;
        this.maxPrecision = maxPrecision;
        this.defaultScale = defaultScale;
        this.minScale = minScale;
        this.maxScale = maxScale;
        this.nestedType = nestedType;
        this.aliases = aliases == null || aliases.length == 0 ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(aliases));
    }

    public Class<?> getObjectClass() {
        return this.objectType;
    }

    public Class<?> getWiderObjectClass() {
        return this.widerObjectType;
    }

    public Class<?> getPrimitiveClass() {
        return this.primitiveType;
    }

    public Class<?> getWiderPrimitiveClass() {
        return this.widerPrimitiveType;
    }

    public boolean hasParameter() {
        return this.parameter;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isNested() {
        return this.nestedType;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public int getByteLength() {
        return this.byteLength;
    }

    public int getMaxPrecision() {
        return this.maxPrecision;
    }

    public int getDefaultScale() {
        return this.defaultScale;
    }

    public int getMinScale() {
        return this.minScale;
    }

    public int getMaxScale() {
        return this.maxScale;
    }

    static {
        TreeSet<String> set = new TreeSet<String>();
        HashMap<String, ClickHouseDataType> map = new HashMap<String, ClickHouseDataType>();
        String errorMsg = "[%s] is used by type [%s]";
        ClickHouseDataType used = null;
        for (ClickHouseDataType t : ClickHouseDataType.values()) {
            String name = t.name();
            if (!t.isCaseSensitive()) {
                name = name.toUpperCase();
            }
            if ((used = map.put(name, t)) != null) {
                throw new IllegalStateException(java.lang.String.format(Locale.ROOT, errorMsg, name, used.name()));
            }
            for (String alias : t.aliases) {
                String aliasInUpperCase = alias.toUpperCase();
                set.add(aliasInUpperCase);
                used = map.put(aliasInUpperCase, t);
                if (used == null) continue;
                throw new IllegalStateException(java.lang.String.format(Locale.ROOT, errorMsg, alias, used.name()));
            }
        }
        allAliases = Collections.unmodifiableSet(set);
        name2type = Collections.unmodifiableMap(map);
    }
}

