/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.config;

import com.clickhouse.client.config.ClickHouseDefaults;
import com.clickhouse.client.config.ClickHouseHealthCheckMethod;
import com.clickhouse.client.config.ClickHouseProxyType;
import com.clickhouse.client.config.ClickHouseSslMode;
import com.clickhouse.config.ClickHouseOption;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseCompression;
import com.clickhouse.data.ClickHouseDataConfig;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

@Deprecated
public enum ClickHouseClientOption implements ClickHouseOption
{
    ASYNC("async", true, "Whether the client should run in async mode."),
    AUTO_DISCOVERY("auto_discovery", false, "Whether the client should discover more nodes from system tables and/or clickhouse-keeper/zookeeper."),
    CUSTOM_SETTINGS("custom_settings", "", "Comma separated custom server settings for all queries."),
    CUSTOM_SOCKET_FACTORY("custom_socket_factory", "", "Full qualified class name of custom socket factory. This is only supported by TCP client and Apache Http Client."),
    CUSTOM_SOCKET_FACTORY_OPTIONS("custom_socket_factory_options", "", "Comma separated options for custom socket factory."),
    LOAD_BALANCING_POLICY("load_balancing_policy", "", "Load balancing policy, can be one of '', 'firstAlive', 'random', 'roundRobin', or full qualified class name implementing ClickHouseLoadBalancingPolicy."),
    LOAD_BALANCING_TAGS("load_balancing_tags", "", "Load balancing tags for filtering out nodes."),
    HEALTH_CHECK_INTERVAL("health_check_interval", 0, "Health check interval in milliseconds, zero or negative value means one-time."),
    HEALTH_CHECK_METHOD("health_check_method", ClickHouseHealthCheckMethod.SELECT_ONE, "Health check method."),
    NODE_DISCOVERY_INTERVAL("node_discovery_interval", 0, "Node discovery interval in milliseconds, zero or negative value means one-time discovery."),
    NODE_DISCOVERY_LIMIT("node_discovery_limit", 100, "Maximum number of nodes can be discovered at a time, zero or negative value means no limit."),
    NODE_CHECK_INTERVAL("node_check_interval", 0, "Node check interval in milliseconds, negative number is treated as zero."),
    NODE_GROUP_SIZE("node_group_size", 50, "Maximum number of nodes can be used for operation at a time, zero or negative value means all."),
    CHECK_ALL_NODES("check_all_nodes", false, "Whether to perform health check against all nodes or just faulty ones."),
    BUFFER_SIZE("buffer_size", 8192, "Default buffer size in byte for both request and response."),
    BUFFER_QUEUE_VARIATION("buffer_queue_variation", 100, "Number of times the buffer queue is filled up before increasing capacity of buffer queue. Zero or negative value means the queue length is fixed."),
    READ_BUFFER_SIZE("read_buffer_size", 0, "Read buffer size in byte, zero or negative value means same as buffer_size"),
    WRITE_BUFFER_SIZE("write_buffer_size", 0, "Write buffer size in byte, zero or negative value means same as buffer_size"),
    REQUEST_CHUNK_SIZE("request_chunk_size", 0, "Maximum request chunk size in byte, zero or negative value means same as write_buffer_size"),
    REQUEST_BUFFERING("request_buffering", ClickHouseDefaults.BUFFERING.getDefaultValue(), "Request buffering mode"),
    RESPONSE_BUFFERING("response_buffering", ClickHouseDefaults.BUFFERING.getDefaultValue(), "Response buffering mode."),
    CLIENT_NAME("client_name", "ClickHouse Java Client", "Client name, which is either 'client_name' or 'http_user_agent' shows up in system.query_log table."),
    COMPRESS("compress", true, "Whether the server will compress response it sends to client."),
    DECOMPRESS("decompress", false, "Whether the server will decompress request from client."),
    COMPRESS_ALGORITHM("compress_algorithm", ClickHouseCompression.LZ4, "Algorithm used for server to compress response."),
    DECOMPRESS_ALGORITHM("decompress_algorithm", ClickHouseCompression.LZ4, "Algorithm for server to decompress request."),
    COMPRESS_LEVEL("compress_level", -1, "Compression level for response, -1 standards for default"),
    DECOMPRESS_LEVEL("decompress_level", -1, "Compression level for request, -1 standards for default"),
    CONNECTION_TIMEOUT("connect_timeout", 5000, "Connection timeout in milliseconds. It's also used for waiting a connection being closed."),
    DATABASE("database", "", "Default database."),
    FAILOVER("failover", 0, "Maximum number of times failover can happen for a request, zero or negative value means no failover."),
    FORMAT("format", ClickHouseDataConfig.DEFAULT_FORMAT, "Default format."),
    LOG_LEADING_COMMENT("log_leading_comment", false, "Whether to log leading comment(as log_comment in system.query_log) of the query."),
    MAX_BUFFER_SIZE("max_buffer_size", 0x100000, "Maximum buffer size in byte can be used for streaming."),
    MAX_MAPPER_CACHE("max_mapper_cache", 100, "Maximum number of mappers can be cached."),
    MAX_EXECUTION_TIME("max_execution_time", 0, "Maximum query execution time in seconds, 0 means no limit."),
    MAX_QUEUED_BUFFERS("max_queued_buffers", 512, "Maximum queued in-memory buffers, 0 or negative number means no limit."),
    MAX_QUEUED_REQUESTS("max_queued_requests", 0, "Maximum queued requests, 0 or negative number means no limit."),
    MAX_RESULT_ROWS("max_result_rows", 0L, "Limit on the number of rows in the result. Also checked for subqueries, and on remote servers when running parts of a distributed query."),
    RESULT_OVERFLOW_MODE("result_overflow_mode", "throw", "What to do if the result is overflowed."),
    MAX_THREADS_PER_CLIENT("max_threads_per_client", 0, "Size of thread pool for each client instance, 0 or negative number means the client will use shared thread pool."),
    MAX_CORE_THREAD_TTL("max_core_thread_ttl", 0L, "Maximum time in milliseconds a core thread can be idle before being terminated. 0 or negative number means immediate termination."),
    PRODUCT_NAME("product_name", "ClickHouse-JavaClient", "Product name used in user agent."),
    RENAME_RESPONSE_COLUMN("rename_response_column", ClickHouseDataConfig.DEFAULT_COLUMN_RENAME_METHOD, "Method to rename response columns."),
    RETRY("retry", 0, "Maximum number of times retry can happen for a request, zero or negative value means no retry."),
    REPEAT_ON_SESSION_LOCK("repeat_on_session_lock", true, "Whether to repeat execution when session is locked, until timed out(according to 'session_timeout' or 'connect_timeout')."),
    REUSE_VALUE_WRAPPER("reuse_value_wrapper", true, "Whether to reuse wrapper of value(e.g. ClickHouseValue or ClickHouseRecord) for memory efficiency."),
    SERVER_REVISION("server_revision", 54442, "Server revision."),
    SERVER_TIME_ZONE("server_time_zone", "", "Server timezone."),
    SERVER_VERSION("server_version", "", "Server version."),
    SESSION_ID("session_id", "", "Session id"),
    SESSION_CHECK("session_check", false, "Whether to check if existence of session id."),
    SESSION_TIMEOUT("session_timeout", 0, "Session timeout in seconds. 0 or negative number means same as server default."),
    SOCKET_TIMEOUT("socket_timeout", 30000, "Socket timeout in milliseconds."),
    SOCKET_REUSEADDR("socket_reuseaddr", false, "Whether allows for the reuse of local addresses and ports. Only works for client using custom Socket(e.g. TCP client or HTTP provider with custom SocketFactory etc.)."),
    SOCKET_KEEPALIVE("socket_keepalive", false, "Whether to enable keep-alive packets for a socket connection. Only works for client using custom Socket."),
    SOCKET_LINGER("socket_linger", -1, "Seconds to wait while data is being transmitted before closing the socket. Use negative number to disable the option. Only works for client using custom Socket(e.g. TCP client or HTTP provider with custom SocketFactory etc.)."),
    SOCKET_IP_TOS("socket_ip_tos", 0, "Socket IP_TOS option which indicates IP package priority. Only works for client using custom Socket."),
    SOCKET_TCP_NODELAY("socket_tcp_nodelay", false, ""),
    SOCKET_RCVBUF("socket_rcvbuf", 0, "Size of the socket receive buffer in bytes. Only works for client using custom Socket."),
    SOCKET_SNDBUF("socket_sndbuf", 0, "Size of the socket send buffer in bytes. Only works for client using custom Socket."),
    SSL("ssl", false, "Whether to enable SSL/TLS for the connection."),
    SSL_MODE("sslmode", ClickHouseSslMode.STRICT, "verify or not certificate: none (don't verify), strict (verify)"),
    SSL_ROOT_CERTIFICATE("sslrootcert", "", "SSL/TLS root certificates."),
    SSL_CERTIFICATE("sslcert", "", "SSL/TLS certificate."),
    SSL_KEY("sslkey", "", "RSA key in PKCS#8 format.", true),
    KEY_STORE_TYPE("key_store_type", "", "Specifies the type or format of the keystore/truststore file used for SSL/TLS configuration, such as \"JKS\" (Java KeyStore) or \"PKCS12.\"", true),
    TRUST_STORE("trust_store", "", "Path to the truststore file", true),
    KEY_STORE_PASSWORD("key_store_password", "", "Password needed to access the keystore file specified in the keystore config", true),
    TRANSACTION_TIMEOUT("transaction_timeout", 0, "Transaction timeout in seconds. 0 or negative number means same as session_timeout."),
    WIDEN_UNSIGNED_TYPES("widen_unsigned_types", false, "Whether to convert unsigned types to the next widest type(e.g. use short for UInt8 instead of byte, and UnsignedLong for UInt64)."),
    USE_BINARY_STRING("use_binary_string", false, "Whether to support binary string. Enable this option to treat FixedString and String as byte array."),
    USE_BLOCKING_QUEUE("use_blocking_queue", false, "Whether to use blocking queue for buffering."),
    USE_COMPILATION("use_compilation", false, "Whether to use compilation(generated byte code) in object mapping and serialization."),
    USE_OBJECTS_IN_ARRAYS("use_objects_in_arrays", false, "Whether Object[] should be used instead of primitive arrays."),
    PROXY_TYPE("proxy_type", ClickHouseProxyType.IGNORE, "Type of proxy can be used to access ClickHouse server. To use an HTTP/SOCKS proxy, you must specify proxy_host and proxy_port."),
    PROXY_HOST("proxy_host", "", "Set ClickHouse server proxy hostname."),
    PROXY_PORT("proxy_port", -1, "Set ClickHouse server proxy port."),
    PROXY_USERNAME("proxy_username", "", "Set ClickHouse server proxy username."),
    PROXY_PASSWORD("proxy_password", "", "Set ClickHouse server proxy password."),
    USE_SERVER_TIME_ZONE("use_server_time_zone", true, "Whether to use server time zone. On connection init select timezone() will be executed"),
    USE_SERVER_TIME_ZONE_FOR_DATES("use_server_time_zone_for_dates", false, "Whether to use timezone from server on Date parsing in getDate(). If false, Date returned is a wrapper of a timestamp at start of the day in client timezone. If true - at start of the day in server or use_time_zone timezone."),
    USE_TIME_ZONE("use_time_zone", "", "Time zone of all DateTime* values. Only used when use_server_time_zone is false. Empty value means client time zone."),
    QUERY_ID("query_id", "", "Query id"),
    CONNECTION_TTL("connection_ttl", 0L, "Connection time to live in milliseconds. 0 or negative number means no limit."),
    MEASURE_REQUEST_TIME("debug_measure_request_time", false, "Whether to measure request time. If true, the time will be logged in debug mode."),
    SSL_SOCKET_SNI("ssl_socket_sni", "", " SNI SSL parameter that will be set for each outbound SSL socket.");

    private final String key;
    private final Serializable defaultValue;
    private final Class<? extends Serializable> clazz;
    private final String description;
    private final boolean sensitive;
    private static final Map<String, ClickHouseClientOption> options;
    static final String UNKNOWN = "unknown";
    public static final String LATEST_KNOWN_VERSION = "0.6.3";
    public static final String PRODUCT_VERSION;
    public static final String PRODUCT_REVISION;
    public static final String CLIENT_OS_INFO;
    public static final String CLIENT_JVM_INFO;
    public static final String CLIENT_USER;
    public static final String CLIENT_HOST;

    public static String readVersionFromResource(String resourceFilePath) {
        String tmpVersion = UNKNOWN;
        try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceFilePath);){
            Properties p = new Properties();
            p.load(in);
            String tmp = p.getProperty("version");
            if (tmp != null && !tmp.isEmpty() && !tmp.equals("${revision}")) {
                tmpVersion = tmp;
            }
        }
        catch (Exception e) {
            try (InputStream in2 = ClickHouseClientOption.class.getClassLoader().getResourceAsStream(resourceFilePath);){
                Properties p = new Properties();
                p.load(in2);
                String tmp = p.getProperty("version");
                if (tmp != null && !tmp.isEmpty() && !tmp.equals("${revision}")) {
                    tmpVersion = tmp;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return tmpVersion;
    }

    public static String buildUserAgent(String productName, String additionalProperty) {
        productName = productName == null || productName.isEmpty() ? (String)((Object)PRODUCT_NAME.getEffectiveDefaultValue()) : productName.trim();
        StringBuilder builder = new StringBuilder(productName).append(PRODUCT_VERSION.isEmpty() ? "" : "/" + PRODUCT_VERSION);
        if (!String.valueOf(PRODUCT_NAME.getDefaultValue()).equals(productName)) {
            builder.append(" ").append(PRODUCT_NAME.getDefaultValue()).append(LATEST_KNOWN_VERSION);
        }
        builder.append(" (").append(CLIENT_JVM_INFO);
        if (additionalProperty != null && !additionalProperty.isEmpty()) {
            builder.append("; ").append(additionalProperty.trim());
        }
        return builder.append(")").toString();
    }

    public static String getSystemConfig(String propertyName, String defaultValue) {
        String propertyValue = System.getProperty(propertyName);
        if (defaultValue == null) {
            return propertyValue;
        }
        return propertyValue == null || propertyValue.isEmpty() ? defaultValue : propertyValue;
    }

    public static ClickHouseClientOption fromKey(String key) {
        return options.get(key);
    }

    private <T extends Serializable> ClickHouseClientOption(String key, T defaultValue, String description) {
        this(key, defaultValue, description, false);
    }

    private <T extends Serializable> ClickHouseClientOption(String key, T defaultValue, String description, boolean sensitive) {
        this.key = (String)ClickHouseChecker.nonNull((Object)key, (String)"key");
        this.defaultValue = (Serializable)ClickHouseChecker.nonNull(defaultValue, (String)"defaultValue");
        this.clazz = defaultValue.getClass();
        this.description = (String)ClickHouseChecker.nonNull((Object)description, (String)"description");
        this.sensitive = sensitive;
    }

    public Serializable getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public String getKey() {
        return this.key;
    }

    public Class<? extends Serializable> getValueType() {
        return this.clazz;
    }

    public boolean isSensitive() {
        return this.sensitive;
    }

    static {
        HashMap<String, ClickHouseClientOption> map = new HashMap<String, ClickHouseClientOption>();
        for (ClickHouseClientOption o : ClickHouseClientOption.values()) {
            if (map.put(o.getKey(), o) == null) continue;
            throw new IllegalStateException("Duplicated key found: " + o.getKey());
        }
        options = Collections.unmodifiableMap(map);
        PRODUCT_VERSION = ClickHouseClientOption.readVersionFromResource("clickhouse-client-version.properties");
        PRODUCT_REVISION = UNKNOWN;
        CLIENT_OS_INFO = ClickHouseClientOption.getSystemConfig("os.name", "O/S") + '/' + ClickHouseClientOption.getSystemConfig("os.version", UNKNOWN);
        String javaVersion = System.getProperty("java.vendor.version");
        if (javaVersion == null || javaVersion.isEmpty() || javaVersion.indexOf(32) >= 0) {
            javaVersion = ClickHouseClientOption.getSystemConfig("java.vm.version", ClickHouseClientOption.getSystemConfig("java.version", UNKNOWN));
        }
        CLIENT_JVM_INFO = ClickHouseClientOption.getSystemConfig("java.vm.name", "Java") + '/' + javaVersion;
        CLIENT_USER = ClickHouseClientOption.getSystemConfig("user.name", UNKNOWN);
        String host = null;
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        CLIENT_HOST = host == null || host.isEmpty() ? UNKNOWN : host;
    }
}

