/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.config.ClickHouseDefaults;
import com.clickhouse.client.naming.SrvResolver;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.logging.Logger;
import com.clickhouse.logging.LoggerFactory;
import java.net.InetSocketAddress;

public class ClickHouseDnsResolver {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseDnsResolver.class);
    private static final ClickHouseDnsResolver instance = (ClickHouseDnsResolver)ClickHouseUtils.getService(ClickHouseDnsResolver.class, (Object)new ClickHouseDnsResolver());

    protected static ClickHouseDnsResolver newInstance() {
        ClickHouseDnsResolver resolver = null;
        if (((Boolean)ClickHouseDefaults.SRV_RESOLVE.getEffectiveDefaultValue()).booleanValue()) {
            try {
                resolver = new SrvResolver();
            }
            catch (Throwable e) {
                log.warn((Object)"Failed to enable SRV resolver due to:", e);
            }
        }
        return resolver == null ? new ClickHouseDnsResolver() : resolver;
    }

    public static ClickHouseDnsResolver getInstance() {
        return instance;
    }

    public InetSocketAddress resolve(ClickHouseProtocol protocol, String host, int port) {
        return new InetSocketAddress(host, port);
    }
}

