/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseDataType;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import com.clickhouse.client.data.ClickHouseBitmap;
import com.clickhouse.client.data.ClickHouseObjectValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.UUID;

public class ClickHouseBitmapValue
extends ClickHouseObjectValue<ClickHouseBitmap> {
    public static ClickHouseBitmapValue ofEmpty(ClickHouseDataType valueType) {
        return ClickHouseBitmapValue.ofEmpty(null, valueType);
    }

    public static ClickHouseBitmapValue ofEmpty(ClickHouseValue ref, ClickHouseDataType valueType) {
        ClickHouseBitmap v = ClickHouseBitmap.empty(valueType);
        return ref instanceof ClickHouseBitmapValue ? (ClickHouseBitmapValue)((ClickHouseBitmapValue)ref).set(v) : new ClickHouseBitmapValue(v);
    }

    public static ClickHouseBitmapValue of(ClickHouseBitmap value) {
        return ClickHouseBitmapValue.of(null, value);
    }

    public static ClickHouseBitmapValue of(ClickHouseValue ref, ClickHouseBitmap value) {
        if (value == null) {
            value = ClickHouseBitmap.empty();
        }
        return ref instanceof ClickHouseBitmapValue ? (ClickHouseBitmapValue)((ClickHouseBitmapValue)ref).set(value) : new ClickHouseBitmapValue(value);
    }

    protected ClickHouseBitmapValue(ClickHouseBitmap value) {
        super(value);
    }

    @Override
    public ClickHouseBitmapValue copy(boolean deep) {
        return new ClickHouseBitmapValue((ClickHouseBitmap)this.getValue());
    }

    @Override
    public boolean isNullOrEmpty() {
        return ((ClickHouseBitmap)this.getValue()).isEmpty();
    }

    @Override
    public byte asByte() {
        if (this.isNullOrEmpty()) {
            return 0;
        }
        ClickHouseBitmap v = (ClickHouseBitmap)this.getValue();
        if (v.getCardinality() != 1) {
            throw new IllegalArgumentException(ClickHouseUtils.format("Expect only one element but we got %d", v.getLongCardinality()));
        }
        return v.innerType.getByteLength() > 4 ? (byte)v.toLongArray()[0] : (byte)v.toIntArray()[0];
    }

    @Override
    public short asShort() {
        if (this.isNullOrEmpty()) {
            return 0;
        }
        ClickHouseBitmap v = (ClickHouseBitmap)this.getValue();
        if (v.getCardinality() != 1) {
            throw new IllegalArgumentException(ClickHouseUtils.format("Expect only one element but we got %d", v.getLongCardinality()));
        }
        return v.innerType.getByteLength() > 4 ? (short)v.toLongArray()[0] : (short)v.toIntArray()[0];
    }

    @Override
    public int asInteger() {
        if (this.isNullOrEmpty()) {
            return 0;
        }
        ClickHouseBitmap v = (ClickHouseBitmap)this.getValue();
        if (v.getCardinality() != 1) {
            throw new IllegalArgumentException(ClickHouseUtils.format("Expect only one element but we got %d", v.getLongCardinality()));
        }
        return v.innerType.getByteLength() > 4 ? (int)v.toLongArray()[0] : v.toIntArray()[0];
    }

    @Override
    public long asLong() {
        if (this.isNullOrEmpty()) {
            return 0L;
        }
        ClickHouseBitmap v = (ClickHouseBitmap)this.getValue();
        if (v.getCardinality() != 1) {
            throw new IllegalArgumentException(ClickHouseUtils.format("Expect only one element but we got %d", v.getLongCardinality()));
        }
        return v.innerType.getByteLength() > 4 ? v.toLongArray()[0] : (long)v.toIntArray()[0];
    }

    @Override
    public BigInteger asBigInteger() {
        if (this.isNullOrEmpty()) {
            return null;
        }
        return BigInteger.valueOf(this.asLong());
    }

    @Override
    public float asFloat() {
        return this.isNullOrEmpty() ? 0.0f : (float)this.asInteger();
    }

    @Override
    public double asDouble() {
        return this.isNullOrEmpty() ? 0.0 : (double)this.asLong();
    }

    @Override
    public BigDecimal asBigDecimal(int scale) {
        return this.isNullOrEmpty() ? null : new BigDecimal(this.asBigInteger()).setScale(scale);
    }

    @Override
    public Object asObject() {
        return this.getValue();
    }

    public long getCardinality() {
        return this.isNullOrEmpty() ? 0L : ((ClickHouseBitmap)this.getValue()).getLongCardinality();
    }

    @Override
    public String toSqlExpression() {
        return this.isNullOrEmpty() ? "NULL" : String.valueOf(this.getValue());
    }

    @Override
    public ClickHouseBitmapValue update(boolean value) {
        this.set(ClickHouseBitmap.wrap(value ? (byte)1 : 0));
        return this;
    }

    @Override
    public ClickHouseBitmapValue update(char value) {
        this.set(ClickHouseBitmap.wrap((short)value));
        return this;
    }

    @Override
    public ClickHouseBitmapValue update(byte value) {
        this.set(ClickHouseBitmap.wrap(value));
        return this;
    }

    @Override
    public ClickHouseBitmapValue update(short value) {
        this.set(ClickHouseBitmap.wrap(value));
        return this;
    }

    @Override
    public ClickHouseBitmapValue update(int value) {
        this.set(ClickHouseBitmap.wrap(value));
        return this;
    }

    @Override
    public ClickHouseBitmapValue update(long value) {
        this.set(ClickHouseBitmap.wrap(value));
        return this;
    }

    @Override
    public ClickHouseBitmapValue update(float value) {
        this.set(ClickHouseBitmap.wrap((int)value));
        return this;
    }

    @Override
    public ClickHouseBitmapValue update(double value) {
        this.set(ClickHouseBitmap.wrap((long)value));
        return this;
    }

    @Override
    public ClickHouseBitmapValue update(BigInteger value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(ClickHouseBitmap.wrap(value.longValue()));
        }
        return this;
    }

    @Override
    public ClickHouseBitmapValue update(BigDecimal value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(ClickHouseBitmap.wrap(value.longValue()));
        }
        return this;
    }

    @Override
    public ClickHouseBitmapValue update(Enum<?> value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(ClickHouseBitmap.wrap(value.ordinal()));
        }
        return this;
    }

    @Override
    public ClickHouseBitmapValue update(Inet4Address value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(ClickHouseBitmap.wrap(ClickHouseValues.convertToBigInteger(value).longValue()));
        }
        return this;
    }

    @Override
    public ClickHouseBitmapValue update(Inet6Address value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(ClickHouseBitmap.wrap(ClickHouseValues.convertToBigInteger(value).longValue()));
        }
        return this;
    }

    @Override
    public ClickHouseBitmapValue update(LocalDate value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(ClickHouseBitmap.wrap(value.toEpochDay()));
        }
        return this;
    }

    @Override
    public ClickHouseBitmapValue update(LocalTime value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(ClickHouseBitmap.wrap(value.toSecondOfDay()));
        }
        return this;
    }

    @Override
    public ClickHouseBitmapValue update(LocalDateTime value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(ClickHouseBitmap.wrap(value.toEpochSecond(ZoneOffset.UTC)));
        }
        return this;
    }

    @Override
    public ClickHouseBitmapValue update(String value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(ClickHouseBitmap.wrap(Long.parseLong(value)));
        }
        return this;
    }

    @Override
    public ClickHouseBitmapValue update(UUID value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(ClickHouseBitmap.wrap(ClickHouseValues.convertToBigInteger(value).longValue()));
        }
        return this;
    }

    @Override
    public ClickHouseBitmapValue update(ClickHouseValue value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else if (value instanceof ClickHouseBitmapValue) {
            this.set((ClickHouseBitmap)((ClickHouseBitmapValue)value).getValue());
        } else {
            this.set(ClickHouseBitmap.wrap(value.asInteger()));
        }
        return this;
    }

    @Override
    public ClickHouseBitmapValue update(Object value) {
        if (value instanceof ClickHouseBitmap) {
            this.set((ClickHouseBitmap)value);
            return this;
        }
        super.update(value);
        return this;
    }
}

