/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseAggregateFunction;
import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseColumn;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseDataType;
import com.clickhouse.client.ClickHouseDeserializer;
import com.clickhouse.client.ClickHouseInputStream;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.data.ClickHouseArrayValue;
import com.clickhouse.client.data.ClickHouseBigDecimalValue;
import com.clickhouse.client.data.ClickHouseBigIntegerValue;
import com.clickhouse.client.data.ClickHouseBitmapValue;
import com.clickhouse.client.data.ClickHouseByteValue;
import com.clickhouse.client.data.ClickHouseDateTimeValue;
import com.clickhouse.client.data.ClickHouseDateValue;
import com.clickhouse.client.data.ClickHouseDoubleValue;
import com.clickhouse.client.data.ClickHouseEmptyValue;
import com.clickhouse.client.data.ClickHouseFloatValue;
import com.clickhouse.client.data.ClickHouseGeoMultiPolygonValue;
import com.clickhouse.client.data.ClickHouseGeoPointValue;
import com.clickhouse.client.data.ClickHouseGeoPolygonValue;
import com.clickhouse.client.data.ClickHouseGeoRingValue;
import com.clickhouse.client.data.ClickHouseIntegerValue;
import com.clickhouse.client.data.ClickHouseIpv4Value;
import com.clickhouse.client.data.ClickHouseIpv6Value;
import com.clickhouse.client.data.ClickHouseLongValue;
import com.clickhouse.client.data.ClickHouseMapValue;
import com.clickhouse.client.data.ClickHouseNestedValue;
import com.clickhouse.client.data.ClickHouseOffsetDateTimeValue;
import com.clickhouse.client.data.ClickHouseShortValue;
import com.clickhouse.client.data.ClickHouseStringValue;
import com.clickhouse.client.data.ClickHouseTupleValue;
import com.clickhouse.client.data.ClickHouseUuidValue;
import com.clickhouse.client.data.array.ClickHouseByteArrayValue;
import com.clickhouse.client.data.array.ClickHouseDoubleArrayValue;
import com.clickhouse.client.data.array.ClickHouseFloatArrayValue;
import com.clickhouse.client.data.array.ClickHouseIntArrayValue;
import com.clickhouse.client.data.array.ClickHouseLongArrayValue;
import com.clickhouse.client.data.array.ClickHouseShortArrayValue;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;

public final class ClickHouseValues {
    public static final BigInteger BIGINT_HL_BOUNDARY = BigInteger.ONE.shiftLeft(64);
    public static final BigInteger BIGINT_SL_BOUNDARY = BigInteger.valueOf(Long.MAX_VALUE);
    public static final LocalDate DATE_ZERO = LocalDate.ofEpochDay(0L);
    public static final LocalDateTime DATETIME_ZERO = LocalDateTime.ofEpochSecond(0L, 0, ZoneOffset.UTC);
    public static final LocalTime TIME_ZERO = LocalTime.ofSecondOfDay(0L);
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final short[] EMPTY_SHORT_ARRAY = new short[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final String EMPTY_ARRAY_EXPR = "[]";
    public static final BigDecimal NANOS = new BigDecimal(BigInteger.TEN.pow(9));
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter TIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
    public static final DateTimeFormatter DATETIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
    public static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("UTC");
    public static final ZoneId UTC_ZONE = UTC_TIMEZONE.toZoneId();
    public static final String NULL_EXPR = "NULL";
    public static final String NAN_EXPR = "NaN";
    public static final String INF_EXPR = "Inf";
    public static final String NINF_EXPR = "-Inf";
    public static final String ERROR_INVALID_POINT = "A point should have two and only two double values, but we got: ";
    public static final String ERROR_SINGLETON_ARRAY = "Only singleton array is allowed, but we got: ";
    public static final String ERROR_SINGLETON_COLLECTION = "Only singleton collection is allowed, but we got: ";
    public static final String ERROR_SINGLETON_MAP = "Only singleton map is allowed, but we got: ";
    public static final String PARAM_PRECISION = "precision";
    public static final String PARAM_SCALE = "scale";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_CHAR = "char";
    public static final String TYPE_BYTE = "byte";
    public static final String TYPE_SHORT = "short";
    public static final String TYPE_INT = "int";
    public static final String TYPE_LONG = "long";
    public static final String TYPE_FLOAT = "float";
    public static final String TYPE_DOUBLE = "double";
    public static final String TYPE_BIG_DECIMAL = "BigDecimal";
    public static final String TYPE_BIG_INTEGER = "BigInteger";
    public static final String TYPE_DATE = "Date";
    public static final String TYPE_TIME = "Time";
    public static final String TYPE_DATE_TIME = "DateTime";
    public static final String TYPE_ENUM = "Enum";
    public static final String TYPE_IPV4 = "Inet4Address";
    public static final String TYPE_IPV6 = "Inet6Address";
    public static final String TYPE_STRING = "String";
    public static final String TYPE_UUID = "UUID";
    public static final String TYPE_OBJECT = "Object";
    public static final String TYPE_ARRAY = "Array";
    public static final String TYPE_MAP = "Map";
    public static final String TYPE_NESTED = "Nested";
    public static final String TYPE_TUPLE = "Tuple";
    public static final String TYPE_POINT = "Point";
    public static final String TYPE_RING = "Ring";
    public static final String TYPE_POLYGON = "Polygon";
    public static final String TYPE_MULTI_POLYGON = "MultiPolygon";
    public static final String TYPE_CLASS = "Class";

    public static BigInteger convertToBigInteger(Inet4Address value) {
        return value == null ? null : new BigInteger(1, value.getAddress());
    }

    public static BigInteger convertToBigInteger(Inet6Address value) {
        return value == null ? null : new BigInteger(1, value.getAddress());
    }

    public static BigInteger convertToBigInteger(UUID value) {
        if (value == null) {
            return null;
        }
        BigInteger high = BigInteger.valueOf(value.getMostSignificantBits());
        BigInteger low = BigInteger.valueOf(value.getLeastSignificantBits());
        if (high.signum() < 0) {
            high = high.add(BIGINT_HL_BOUNDARY);
        }
        if (low.signum() < 0) {
            low = low.add(BIGINT_HL_BOUNDARY);
        }
        return low.add(high.multiply(BIGINT_HL_BOUNDARY));
    }

    public static LocalDateTime convertToDateTime(BigDecimal value) {
        if (value == null) {
            return null;
        }
        if (value.scale() == 0) {
            return LocalDateTime.ofEpochSecond(value.longValue(), 0, ZoneOffset.UTC);
        }
        if (value.signum() >= 0) {
            return LocalDateTime.ofEpochSecond(value.longValue(), value.remainder(BigDecimal.ONE).multiply(NANOS).intValue(), ZoneOffset.UTC);
        }
        long v = NANOS.add(value.remainder(BigDecimal.ONE).multiply(NANOS)).longValue();
        int nanoSeconds = v < 1000000000L ? (int)v : 0;
        return LocalDateTime.ofEpochSecond(value.longValue() - (long)(nanoSeconds > 0 ? 1 : 0), nanoSeconds, ZoneOffset.UTC);
    }

    public static ZonedDateTime convertToDateTime(BigDecimal value, TimeZone tz) {
        if (value == null) {
            return null;
        }
        return ClickHouseValues.convertToDateTime(value, tz != null ? tz.toZoneId() : UTC_ZONE);
    }

    public static ZonedDateTime convertToDateTime(BigDecimal value, ZoneId zone) {
        if (value == null) {
            return null;
        }
        if (zone == null) {
            zone = UTC_ZONE;
        }
        if (value.scale() == 0) {
            return Instant.ofEpochSecond(value.longValue(), 0L).atZone(zone);
        }
        if (value.signum() >= 0) {
            return Instant.ofEpochSecond(value.longValue(), value.remainder(BigDecimal.ONE).multiply(NANOS).intValue()).atZone(zone);
        }
        long v = NANOS.add(value.remainder(BigDecimal.ONE).multiply(NANOS)).longValue();
        int nanoSeconds = v < 1000000000L ? (int)v : 0;
        return Instant.ofEpochSecond(value.longValue() - (long)(nanoSeconds > 0 ? 1 : 0), nanoSeconds).atZone(zone);
    }

    public static OffsetDateTime convertToDateTime(BigDecimal value, ZoneOffset offset) {
        if (value == null) {
            return null;
        }
        if (offset == null) {
            offset = ZoneOffset.UTC;
        }
        if (value.scale() == 0) {
            return Instant.ofEpochSecond(value.longValue(), 0L).atOffset(offset);
        }
        if (value.signum() >= 0) {
            return Instant.ofEpochSecond(value.longValue(), value.remainder(BigDecimal.ONE).multiply(NANOS).intValue()).atOffset(offset);
        }
        long v = NANOS.add(value.remainder(BigDecimal.ONE).multiply(NANOS)).longValue();
        int nanoSeconds = v < 1000000000L ? (int)v : 0;
        return Instant.ofEpochSecond(value.longValue() - (long)(nanoSeconds > 0 ? 1 : 0), nanoSeconds).atOffset(offset);
    }

    public static Inet4Address convertToIpv4(Inet6Address value) {
        if (value == null) {
            return null;
        }
        byte[] bytes = value.getAddress();
        boolean invalid = false;
        for (int i = 0; i < 10; ++i) {
            if (bytes[i] == 0) continue;
            invalid = true;
            break;
        }
        if (!invalid) {
            boolean bl = invalid = bytes[10] != 255 || bytes[11] != 255;
        }
        if (invalid) {
            throw new IllegalArgumentException("Failed to convert IPv6 to IPv4");
        }
        byte[] addr = new byte[4];
        System.arraycopy(bytes, 12, addr, 0, 4);
        try {
            return (Inet4Address)InetAddress.getByAddress(addr);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Inet4Address convertToIpv4(int value) {
        byte[] bytes = new byte[]{(byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        try {
            return (Inet4Address)InetAddress.getByAddress(bytes);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Inet4Address convertToIpv4(String value) {
        if (value == null) {
            return null;
        }
        try {
            for (InetAddress addr : InetAddress.getAllByName(value)) {
                if (!(addr instanceof Inet4Address)) continue;
                return (Inet4Address)addr;
            }
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(ClickHouseUtils.format("Failed to convert [%s] to Inet4Address", value), e);
        }
        throw new IllegalArgumentException(ClickHouseUtils.format("No Inet4Address for [%s]", value));
    }

    public static Inet6Address convertToIpv6(BigInteger value) {
        if (value == null) {
            return null;
        }
        byte[] bytes = ClickHouseChecker.nonNull(value, "value").toByteArray();
        int len = bytes.length;
        if (len > 16) {
            throw new IllegalArgumentException("The number is too large to be converted to IPv6: " + value);
        }
        if (len < 16) {
            byte[] addr = new byte[16];
            int diff = 16 - len;
            for (int i = len - 1; i >= 0; --i) {
                addr[i + diff] = bytes[i];
            }
            bytes = addr;
        }
        try {
            return Inet6Address.getByAddress(null, bytes, null);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Inet6Address convertToIpv6(Inet4Address value) {
        if (value == null) {
            return null;
        }
        byte[] bytes = new byte[16];
        bytes[10] = -1;
        bytes[11] = -1;
        System.arraycopy(value.getAddress(), 0, bytes, 12, 4);
        try {
            return Inet6Address.getByAddress(null, bytes, null);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Inet6Address convertToIpv6(String value) {
        if (value == null) {
            return null;
        }
        try {
            for (InetAddress addr : InetAddress.getAllByName(value)) {
                if (!(addr instanceof Inet6Address)) continue;
                return (Inet6Address)addr;
            }
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(ClickHouseUtils.format("Failed to convert [%s] to Inet6Address", value), e);
        }
        throw new IllegalArgumentException(ClickHouseUtils.format("No Inet6Address for [%s]", value));
    }

    public static String convertToSqlExpression(Object value) {
        String s;
        if (value == null) {
            return NULL_EXPR;
        }
        if (value instanceof String) {
            s = ClickHouseValues.convertToQuotedString(value);
        } else if (value instanceof ClickHouseValue) {
            s = ((ClickHouseValue)value).toSqlExpression();
        } else if (value instanceof UUID) {
            s = "" + '\'' + value + '\'';
        } else if (value instanceof LocalDate) {
            s = '\'' + ((LocalDate)value).format(DATE_FORMATTER) + '\'';
        } else if (value instanceof LocalTime) {
            s = '\'' + ((LocalTime)value).format(TIME_FORMATTER) + '\'';
        } else if (value instanceof LocalDateTime) {
            s = '\'' + ((LocalDateTime)value).format(DATETIME_FORMATTER) + '\'';
        } else if (value instanceof OffsetDateTime) {
            s = '\'' + ((OffsetDateTime)value).format(DATETIME_FORMATTER) + '\'';
        } else if (value instanceof ZonedDateTime) {
            s = '\'' + ((ZonedDateTime)value).format(DATETIME_FORMATTER) + '\'';
        } else if (value instanceof InetAddress) {
            s = '\'' + ((InetAddress)value).getHostAddress() + '\'';
        } else if (value instanceof Enum) {
            s = String.valueOf(((Enum)value).ordinal());
        } else if (value instanceof Object[]) {
            StringBuilder builder = new StringBuilder().append('[');
            for (Object o : (Object[])value) {
                builder.append(ClickHouseValues.convertToSqlExpression(o)).append(',');
            }
            if (builder.length() > 1) {
                builder.setLength(builder.length() - 1);
            }
            s = builder.append(']').toString();
        } else if (value instanceof Collection) {
            StringBuilder builder = new StringBuilder().append('(');
            for (Object v : (Collection)value) {
                builder.append(ClickHouseValues.convertToSqlExpression(v)).append(',');
            }
            if (builder.length() > 1) {
                builder.setLength(builder.length() - 1);
            }
            s = builder.append(')').toString();
        } else if (value instanceof Enumeration) {
            StringBuilder builder = new StringBuilder().append('(');
            Enumeration v = (Enumeration)value;
            while (v.hasMoreElements()) {
                builder.append(ClickHouseValues.convertToSqlExpression(v.nextElement())).append(',');
            }
            if (builder.length() > 1) {
                builder.setLength(builder.length() - 1);
            }
            s = builder.append(')').toString();
        } else if (value instanceof Map) {
            StringBuilder builder = new StringBuilder().append('{');
            for (Map.Entry v : ((Map)value).entrySet()) {
                builder.append(ClickHouseValues.convertToSqlExpression(v.getKey())).append(" : ").append(ClickHouseValues.convertToSqlExpression(v.getValue())).append(',');
            }
            if (builder.length() > 1) {
                builder.setLength(builder.length() - 1);
            }
            s = builder.append('}').toString();
        } else {
            s = value instanceof Boolean ? String.valueOf((Boolean)value != false ? 1 : 0) : (value instanceof Character ? String.valueOf((int)((Character)value).charValue()) : (value instanceof boolean[] ? ClickHouseValues.convertToString((boolean[])value) : (value instanceof char[] ? ClickHouseValues.convertToString((char[])value) : (value instanceof byte[] ? ClickHouseValues.convertToString((byte[])value) : (value instanceof short[] ? ClickHouseValues.convertToString((short[])value) : (value instanceof int[] ? ClickHouseValues.convertToString((int[])value) : (value instanceof long[] ? ClickHouseValues.convertToString((long[])value) : (value instanceof float[] ? ClickHouseValues.convertToString((float[])value) : (value instanceof double[] ? ClickHouseValues.convertToString((double[])value) : String.valueOf(value))))))))));
        }
        return s;
    }

    public static String convertToString(boolean[] value) {
        if (value == null) {
            return NULL_EXPR;
        }
        if (value.length == 0) {
            return EMPTY_ARRAY_EXPR;
        }
        StringBuilder builder = new StringBuilder().append('[');
        for (boolean v : value) {
            builder.append(v ? 1 : 0).append(',');
        }
        builder.setLength(builder.length() - 1);
        return builder.append(']').toString();
    }

    public static String convertToString(char[] value) {
        if (value == null) {
            return NULL_EXPR;
        }
        if (value.length == 0) {
            return EMPTY_ARRAY_EXPR;
        }
        StringBuilder builder = new StringBuilder().append('[');
        for (char v : value) {
            builder.append((int)v).append(',');
        }
        builder.setLength(builder.length() - 1);
        return builder.append(']').toString();
    }

    public static String convertToString(byte[] value) {
        if (value == null) {
            return NULL_EXPR;
        }
        if (value.length == 0) {
            return EMPTY_ARRAY_EXPR;
        }
        StringBuilder builder = new StringBuilder().append('[');
        for (byte v : value) {
            builder.append(v).append(',');
        }
        builder.setLength(builder.length() - 1);
        return builder.append(']').toString();
    }

    public static String convertToString(short[] value) {
        if (value == null) {
            return NULL_EXPR;
        }
        if (value.length == 0) {
            return EMPTY_ARRAY_EXPR;
        }
        StringBuilder builder = new StringBuilder().append('[');
        for (short v : value) {
            builder.append(v).append(',');
        }
        builder.setLength(builder.length() - 1);
        return builder.append(']').toString();
    }

    public static String convertToString(int[] value) {
        if (value == null) {
            return NULL_EXPR;
        }
        if (value.length == 0) {
            return EMPTY_ARRAY_EXPR;
        }
        StringBuilder builder = new StringBuilder().append('[');
        for (int v : value) {
            builder.append(v).append(',');
        }
        builder.setLength(builder.length() - 1);
        return builder.append(']').toString();
    }

    public static String convertToString(long[] value) {
        if (value == null) {
            return NULL_EXPR;
        }
        if (value.length == 0) {
            return EMPTY_ARRAY_EXPR;
        }
        StringBuilder builder = new StringBuilder().append('[');
        for (long v : value) {
            builder.append(v).append(',');
        }
        builder.setLength(builder.length() - 1);
        return builder.append(']').toString();
    }

    public static String convertToString(float[] value) {
        if (value == null) {
            return NULL_EXPR;
        }
        if (value.length == 0) {
            return EMPTY_ARRAY_EXPR;
        }
        StringBuilder builder = new StringBuilder().append('[');
        for (float v : value) {
            builder.append(v).append(',');
        }
        builder.setLength(builder.length() - 1);
        return builder.append(']').toString();
    }

    public static String convertToString(double[] value) {
        if (value == null) {
            return NULL_EXPR;
        }
        if (value.length == 0) {
            return EMPTY_ARRAY_EXPR;
        }
        StringBuilder builder = new StringBuilder().append('[');
        for (double v : value) {
            builder.append(v).append(',');
        }
        builder.setLength(builder.length() - 1);
        return builder.append(']').toString();
    }

    public static String convertToString(ClickHouseValue value) {
        return value == null ? "null" : value.getClass().getSimpleName() + '[' + value.asString() + ']';
    }

    public static String convertToString(Object value) {
        return String.valueOf(value);
    }

    public static UUID convertToUuid(BigInteger value) {
        if (value == null) {
            return null;
        }
        BigInteger[] parts = value.divideAndRemainder(BIGINT_HL_BOUNDARY);
        BigInteger high = parts[0];
        BigInteger low = parts[1];
        if (BIGINT_SL_BOUNDARY.compareTo(high) < 0) {
            high = high.subtract(BIGINT_HL_BOUNDARY);
        }
        if (BIGINT_SL_BOUNDARY.compareTo(low) < 0) {
            low = low.subtract(BIGINT_HL_BOUNDARY);
        }
        return new UUID(high.longValueExact(), low.longValueExact());
    }

    public static String convertToQuotedString(Object value) {
        if (value == null) {
            return NULL_EXPR;
        }
        return '\'' + ClickHouseUtils.escape(value.toString(), '\'') + '\'';
    }

    public static <T> T[] createObjectArray(Class<T> clazz, int length, int level) {
        if (level < 1) {
            level = 1;
        } else if (level > 255) {
            level = 255;
        }
        int[] dimensions = new int[level];
        dimensions[0] = length < 0 ? 0 : length;
        return (Object[])Array.newInstance(ClickHouseDataType.toObjectType(clazz), dimensions);
    }

    public static Object createPrimitiveArray(Class<?> clazz, int length, int level) {
        if (level < 1) {
            level = 1;
        } else if (level > 255) {
            level = 255;
        }
        int[] dimensions = new int[level];
        dimensions[0] = length < 0 ? 0 : length;
        return Array.newInstance(ClickHouseDataType.toPrimitiveType(clazz), dimensions);
    }

    static ClickHouseArrayValue<?> fillByteArray(ClickHouseArrayValue<?> array, ClickHouseConfig config, ClickHouseColumn column, ClickHouseInputStream input, ClickHouseDeserializer<ClickHouseValue> deserializer, int length) throws IOException {
        byte[] values = new byte[length];
        ClickHouseByteValue ref = ClickHouseByteValue.ofNull();
        for (int i = 0; i < length; ++i) {
            values[i] = deserializer.deserialize(ref, config, column, input).asByte();
        }
        return array.update(values);
    }

    public static Object extractSingleValue(Collection<?> value) {
        if (value == null || value.size() != 1) {
            throw new IllegalArgumentException(ERROR_SINGLETON_COLLECTION + value);
        }
        return value.iterator().next();
    }

    public static Object extractSingleValue(Enumeration<?> value) {
        if (value == null || !value.hasMoreElements()) {
            throw new IllegalArgumentException(ERROR_SINGLETON_COLLECTION + value);
        }
        Object v = value.nextElement();
        if (value.hasMoreElements()) {
            throw new IllegalArgumentException(ERROR_SINGLETON_COLLECTION + value);
        }
        return v;
    }

    public static Object extractSingleValue(Map<?, ?> value) {
        if (value == null || value.size() != 1) {
            throw new IllegalArgumentException(ERROR_SINGLETON_MAP + value);
        }
        return value.values().iterator().next();
    }

    public static ClickHouseValue newValue(ClickHouseColumn column) {
        return ClickHouseValues.newValue(ClickHouseChecker.nonNull(column, "column").getDataType(), column);
    }

    public static ClickHouseValue newValue(ClickHouseDataType type) {
        return ClickHouseValues.newValue(ClickHouseChecker.nonNull(type, "type"), null);
    }

    private static ClickHouseValue newValue(ClickHouseDataType type, ClickHouseColumn column) {
        ClickHouseValue value = null;
        switch (type) {
            case Enum: 
            case Enum8: 
            case Int8: {
                value = ClickHouseByteValue.ofNull();
                break;
            }
            case UInt8: 
            case Enum16: 
            case Int16: {
                value = ClickHouseShortValue.ofNull();
                break;
            }
            case UInt16: 
            case Int32: {
                value = ClickHouseIntegerValue.ofNull();
                break;
            }
            case UInt32: 
            case IntervalYear: 
            case IntervalQuarter: 
            case IntervalMonth: 
            case IntervalWeek: 
            case IntervalDay: 
            case IntervalHour: 
            case IntervalMinute: 
            case IntervalSecond: 
            case Int64: {
                value = ClickHouseLongValue.ofNull(false);
                break;
            }
            case UInt64: {
                value = ClickHouseLongValue.ofNull(true);
                break;
            }
            case Int128: 
            case UInt128: 
            case Int256: 
            case UInt256: {
                value = ClickHouseBigIntegerValue.ofNull();
                break;
            }
            case Float32: {
                value = ClickHouseFloatValue.ofNull();
                break;
            }
            case Float64: {
                value = ClickHouseDoubleValue.ofNull();
                break;
            }
            case Decimal: 
            case Decimal32: 
            case Decimal64: 
            case Decimal128: 
            case Decimal256: {
                value = ClickHouseBigDecimalValue.ofNull();
                break;
            }
            case Date: 
            case Date32: {
                value = ClickHouseDateValue.ofNull();
                break;
            }
            case DateTime: 
            case DateTime32: 
            case DateTime64: {
                if (column == null) {
                    value = ClickHouseDateTimeValue.ofNull(0);
                    break;
                }
                if (column.getTimeZone() == null) {
                    value = ClickHouseDateTimeValue.ofNull(column.getScale());
                    break;
                }
                value = ClickHouseOffsetDateTimeValue.ofNull(column.getScale(), column.getTimeZone());
                break;
            }
            case IPv4: {
                value = ClickHouseIpv4Value.ofNull();
                break;
            }
            case IPv6: {
                value = ClickHouseIpv6Value.ofNull();
                break;
            }
            case FixedString: 
            case String: {
                value = ClickHouseStringValue.ofNull();
                break;
            }
            case UUID: {
                value = ClickHouseUuidValue.ofNull();
                break;
            }
            case Point: {
                value = ClickHouseGeoPointValue.ofOrigin();
                break;
            }
            case Ring: {
                value = ClickHouseGeoRingValue.ofEmpty();
                break;
            }
            case Polygon: {
                value = ClickHouseGeoPolygonValue.ofEmpty();
                break;
            }
            case MultiPolygon: {
                value = ClickHouseGeoMultiPolygonValue.ofEmpty();
                break;
            }
            case AggregateFunction: {
                if (column == null || column.getAggregateFunction() != ClickHouseAggregateFunction.groupBitmap) break;
                value = ClickHouseBitmapValue.ofEmpty(column.getNestedColumns().get(0).getDataType());
                break;
            }
            case Array: {
                if (column == null) {
                    value = ClickHouseArrayValue.ofEmpty();
                    break;
                }
                if (column.getArrayNestedLevel() > 1) {
                    value = ClickHouseArrayValue.of((Object[])ClickHouseValues.createPrimitiveArray(column.getArrayBaseColumn().getDataType().getPrimitiveClass(), 0, column.getArrayNestedLevel()));
                    break;
                }
                Class<?> javaClass = column.getArrayBaseColumn().getDataType().getPrimitiveClass();
                if (Byte.TYPE == javaClass) {
                    value = ClickHouseByteArrayValue.ofEmpty();
                    break;
                }
                if (Short.TYPE == javaClass) {
                    value = ClickHouseShortArrayValue.ofEmpty();
                    break;
                }
                if (Integer.TYPE == javaClass) {
                    value = ClickHouseIntArrayValue.ofEmpty();
                    break;
                }
                if (Long.TYPE == javaClass) {
                    value = ClickHouseLongArrayValue.ofEmpty();
                    break;
                }
                if (Float.TYPE == javaClass) {
                    value = ClickHouseFloatArrayValue.ofEmpty();
                    break;
                }
                if (Double.TYPE == javaClass) {
                    value = ClickHouseDoubleArrayValue.ofEmpty();
                    break;
                }
                value = ClickHouseArrayValue.ofEmpty();
                break;
            }
            case Map: {
                if (column == null) {
                    throw new IllegalArgumentException("column types for key and value are required");
                }
                value = ClickHouseMapValue.ofEmpty(column.getKeyInfo().getDataType().getObjectClass(), column.getValueInfo().getDataType().getObjectClass());
                break;
            }
            case Nested: {
                if (column == null) {
                    throw new IllegalArgumentException("nested column types are required");
                }
                value = ClickHouseNestedValue.ofEmpty(column.getNestedColumns());
                break;
            }
            case Tuple: {
                value = ClickHouseTupleValue.of(new Object[0]);
                break;
            }
            case Nothing: {
                value = ClickHouseEmptyValue.INSTANCE;
                break;
            }
        }
        if (value == null) {
            throw new IllegalArgumentException("Unsupported data type: " + type.name());
        }
        return value;
    }

    private ClickHouseValues() {
    }
}

