/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

public enum ClickHouseFormat {
    RowBinary(true, true, true, false, true),
    RowBinaryWithNamesAndTypes(true, true, true, true, true, RowBinary),
    TabSeparated(true, true, false, false, true),
    TabSeparatedRaw(true, true, false, false, true),
    TabSeparatedWithNames(true, true, false, true, true, TabSeparated),
    TabSeparatedWithNamesAndTypes(true, true, false, true, true, TabSeparated),
    Arrow(true, true, true, true, false),
    ArrowStream(true, true, true, true, false),
    Avro(true, true, true, true, false),
    AvroConfluent(true, false, true, false, false),
    CSV(true, true, false, false, true),
    CSVWithNames(true, true, false, true, true, CSV),
    CapnProto(true, false, true, false, false),
    CustomSeparated(true, true, false, false, true),
    CustomSeparatedIgnoreSpaces(true, true, false, false, true),
    JSONCompactEachRow(true, true, false, false, true),
    JSONCompactEachRowWithNamesAndTypes(true, true, false, true, true),
    JSON(false, true, false, false, false, JSONCompactEachRow),
    JSONAsString(true, false, false, false, false),
    JSONCompact(false, true, false, false, false, JSONCompactEachRow),
    JSONCompactStringsEachRow(true, true, false, false, true),
    JSONCompactStringsEachRowWithNamesAndTypes(true, true, false, true, true, JSONCompactStringsEachRow),
    JSONCompactStrings(false, true, false, false, false, JSONCompactStringsEachRow),
    JSONEachRow(true, true, false, false, true),
    JSONEachRowWithProgress(false, true, false, false, true, JSONEachRow),
    JSONStringsEachRow(true, true, false, false, true),
    JSONStringsEachRowWithProgress(false, true, false, false, true, JSONStringsEachRow),
    JSONStringEachRow(false, false, false, false, true, JSONStringsEachRow),
    JSONStrings(false, true, false, false, false, JSONStringsEachRow),
    LineAsString(true, false, false, false, true),
    Markdown(false, true, false, false, true),
    MsgPack(true, true, true, false, false),
    MySQLWire(false, true, true, false, false),
    Native(true, true, true, true, false),
    Null(false, true, false, false, false),
    ODBCDriver2(false, true, true, false, false),
    ORC(true, false, true, true, false),
    Parquet(true, true, true, true, false),
    PostgreSQLWire(false, true, true, false, false),
    Pretty(false, true, false, false, false),
    PrettyCompact(false, true, false, false, false),
    PrettyCompactMonoBlock(false, true, false, false, false),
    PrettyCompactNoEscapes(false, true, false, false, false),
    PrettyNoEscapes(false, true, false, false, false),
    PrettySpace(false, true, false, false, false),
    PrettySpaceNoEscapes(false, true, false, false, false),
    Protobuf(true, true, true, true, false),
    ProtobufSingle(true, true, true, true, false),
    RawBLOB(true, true, true, false, false),
    Regexp(true, false, false, false, false),
    TSKV(true, true, false, false, false),
    TSV(true, true, false, false, true),
    TSVRaw(true, true, false, false, true),
    TSVWithNames(true, true, false, true, true, TSV),
    TSVWithNamesAndTypes(true, true, false, true, true, TSV),
    Template(true, true, false, true, true),
    TemplateIgnoreSpaces(true, false, false, true, true),
    Values(true, true, false, false, true),
    Vertical(false, true, false, false, false),
    XML(false, true, false, false, false);

    private final boolean input;
    private final boolean output;
    private final boolean binary;
    private final boolean header;
    private final boolean rowBased;
    private final ClickHouseFormat defaultInput;

    private ClickHouseFormat(boolean input, boolean output, boolean binary, boolean header, boolean rowBased) {
        this(input, output, binary, header, rowBased, null);
    }

    private ClickHouseFormat(boolean input, boolean output, boolean binary, boolean header, boolean rowBased, ClickHouseFormat defaultInputFormat) {
        this.input = input;
        this.output = output;
        this.binary = binary;
        this.header = output && header;
        this.rowBased = rowBased;
        if (defaultInputFormat != null) {
            this.defaultInput = defaultInputFormat;
        } else if (input) {
            this.defaultInput = this;
        } else {
            String typeName = binary ? "RowBinary" : "TabSeparated";
            try {
                this.defaultInput = (ClickHouseFormat)((Object)((Object)((Object)this)).getClass().getField(typeName).get(null));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to initialize format", e);
            }
        }
    }

    public boolean supportsInput() {
        return this.input;
    }

    public boolean supportsOutput() {
        return this.output;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public boolean isText() {
        return !this.binary;
    }

    public boolean hasHeader() {
        return this.header;
    }

    public boolean isRowBased() {
        return this.rowBased;
    }

    public ClickHouseFormat defaultInputFormat() {
        return this.defaultInput;
    }
}

