/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseUtils;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

public class ClickHouseByteBuffer
implements Serializable {
    private static final long serialVersionUID = -8178041799873465082L;
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final ByteBuffer EMPTY_BUFFER = ByteBuffer.wrap(EMPTY_BYTES).asReadOnlyBuffer();
    protected byte[] array;
    protected int position;
    protected int length;

    public static ClickHouseByteBuffer newInstance() {
        return new ClickHouseByteBuffer(EMPTY_BYTES, 0, 0);
    }

    public static ClickHouseByteBuffer of(byte[] bytes) {
        return bytes == null || bytes.length == 0 ? ClickHouseByteBuffer.newInstance() : new ClickHouseByteBuffer(bytes, 0, bytes.length);
    }

    public static ClickHouseByteBuffer of(byte[] bytes, int offset, int length) {
        if (bytes == null || bytes.length == 0 || length == 0) {
            return ClickHouseByteBuffer.newInstance();
        }
        ClickHouseByteBuffer.validate(bytes, offset, length);
        return new ClickHouseByteBuffer(bytes, offset, length);
    }

    public static ClickHouseByteBuffer of(List<byte[]> list, int offset, int length) {
        ClickHouseByteBuffer buf = ClickHouseByteBuffer.newInstance();
        if (list == null || list.isEmpty() || length == 0) {
            return buf;
        }
        return buf.update(list, offset, length);
    }

    static void validate(byte[] bytes, int offset, int length) {
        int len = ClickHouseChecker.nonNull(bytes, "Byte array").length;
        if (ClickHouseChecker.between(offset, "Offset", 0, len) + ClickHouseChecker.between(length, "Length", 0, len) > len) {
            throw new IllegalArgumentException(ClickHouseUtils.format("Offset(%d) plus length(%d) should not greater than %d", offset, length, len));
        }
    }

    protected ClickHouseByteBuffer(byte[] bytes, int offset, int length) {
        this.array = bytes;
        this.position = offset;
        this.length = length;
    }

    public int asInt32() {
        return this.getInt32(0);
    }

    public long asUnsignedInt32() {
        return this.getUnsignedInt32(0);
    }

    public int getInt32(int offset) {
        offset += this.position;
        return 0xFF & this.array[offset++] | (0xFF & this.array[offset++]) << 8 | (0xFF & this.array[offset++]) << 16 | (0xFF & this.array[offset]) << 24;
    }

    public long getUnsignedInt32(int offset) {
        return 0xFFFFFFFFL & (long)this.getInt32(offset);
    }

    public long asInt64() {
        return this.getInt64(0);
    }

    public BigInteger asUnsignedInt64() {
        return this.getBigInteger(0, 8, true);
    }

    public long getInt64(int offset) {
        offset += this.position;
        return 0xFFL & (long)this.array[offset++] | (0xFFL & (long)this.array[offset++]) << 8 | (0xFFL & (long)this.array[offset++]) << 16 | (0xFFL & (long)this.array[offset++]) << 24 | (0xFFL & (long)this.array[offset++]) << 32 | (0xFFL & (long)this.array[offset++]) << 40 | (0xFFL & (long)this.array[offset++]) << 48 | (0xFFL & (long)this.array[offset]) << 56;
    }

    public BigInteger asBigInteger() {
        return this.getBigInteger(0, this.length, false);
    }

    public BigInteger asUnsignedBigInteger() {
        return this.getBigInteger(0, this.length, true);
    }

    public BigInteger getBigInteger(int offset, int byteLength, boolean unsigned) {
        this.reverse(offset, byteLength);
        byte[] bytes = this.array;
        if (offset != 0 || this.array.length != byteLength) {
            bytes = new byte[byteLength];
            System.arraycopy(this.array, offset + this.position, bytes, 0, byteLength);
        }
        return unsigned ? new BigInteger(1, bytes) : new BigInteger(bytes);
    }

    public UUID asUuid() {
        return this.getUuid(0);
    }

    public UUID getUuid(int offset) {
        return new UUID(this.getInt64(offset), this.getInt64(offset + 8));
    }

    public String asAsciiString() {
        return this.asString(StandardCharsets.US_ASCII);
    }

    public String asString(Charset charset) {
        return new String(this.array, this.position, this.length, charset != null ? charset : StandardCharsets.UTF_8);
    }

    public String asUnicodeString() {
        return this.asString(StandardCharsets.UTF_8);
    }

    public ClickHouseByteBuffer compact() {
        if (this.position > 0 || this.length < this.array.length) {
            byte[] bytes = new byte[this.length];
            System.arraycopy(this.array, this.position, bytes, 0, this.length);
            this.array = bytes;
            this.position = 0;
        }
        return this;
    }

    public boolean isEmpty() {
        return this.length < 1;
    }

    public ClickHouseByteBuffer reset() {
        this.array = EMPTY_BYTES;
        this.position = 0;
        this.length = 0;
        return this;
    }

    public ClickHouseByteBuffer reverse() {
        return this.reverse(0, this.length);
    }

    public ClickHouseByteBuffer reverse(int offset, int length) {
        if (length > 1) {
            int i;
            int l = (offset += this.position) + length;
            int len = i + length / 2;
            for (i = offset; i < len; ++i) {
                byte b = this.array[i];
                this.array[i] = this.array[--l];
                this.array[l] = b;
            }
        }
        return this;
    }

    public ClickHouseByteBuffer slice(int offset, int length) {
        if (offset == 0 && length == this.length) {
            return this;
        }
        return ClickHouseByteBuffer.of(this.array, offset + this.position, length);
    }

    public ClickHouseByteBuffer update(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            this.reset();
        } else {
            this.array = bytes;
            this.position = 0;
            this.length = bytes.length;
        }
        return this;
    }

    public ClickHouseByteBuffer update(byte[] bytes, int offset, int length) {
        if (bytes == null || bytes.length == 0 || length == 0) {
            return this.reset();
        }
        ClickHouseByteBuffer.validate(bytes, offset, length);
        this.array = bytes;
        this.position = offset;
        this.length = length;
        return this;
    }

    public ClickHouseByteBuffer update(List<byte[]> list, int offset, int length) {
        if (list == null || list.isEmpty() || length == 0) {
            return this.reset();
        }
        if (list.size() == 1) {
            return this.update(list.get(0), offset, length);
        }
        byte[][] bb = new byte[list.size()][];
        int limit = offset + length;
        int len = 0;
        int index = 0;
        int startIndex = -1;
        int startOffset = -1;
        int endIndex = -1;
        int endOffset = -1;
        for (byte[] bytes : list) {
            if (startIndex < 0 && (len += ClickHouseChecker.nonNull(bytes, "Byte array").length) > offset) {
                startIndex = index;
                startOffset = offset - (len - bytes.length);
            }
            if (endIndex < 0 && len >= limit) {
                endIndex = index;
                endOffset = limit - (len - bytes.length);
            }
            bb[index++] = bytes;
        }
        if (ClickHouseChecker.between(offset, "Offset", 0, len) + ClickHouseChecker.between(length, "Length", 0, len) > len) {
            throw new IllegalArgumentException(ClickHouseUtils.format("Offset(%d) plus length(%d) should not greater than %d", offset, length, len));
        }
        if (startIndex == endIndex) {
            this.array = bb[startIndex];
            this.position = startOffset;
            this.length = length;
        } else {
            this.array = new byte[length];
            byte[] bytes = bb[startIndex];
            System.arraycopy(bytes, startOffset, this.array, 0, bytes.length - startOffset);
            startOffset = bytes.length - startOffset;
            for (int i = startIndex + 1; i < endIndex; ++i) {
                bytes = bb[i];
                System.arraycopy(bytes, 0, this.array, startOffset, bytes.length);
                startOffset += bytes.length;
            }
            bytes = bb[endIndex];
            System.arraycopy(bytes, 0, this.array, startOffset, endOffset);
            this.position = 0;
            this.length = length;
        }
        return this;
    }

    public byte[] array() {
        return this.array;
    }

    public byte firstByte() {
        return this.array[this.position];
    }

    public byte lastByte() {
        return this.array[this.position + this.length - 1];
    }

    public int position() {
        return this.position;
    }

    public ClickHouseByteBuffer position(int newPosition) {
        this.position = newPosition;
        return this;
    }

    public int length() {
        return this.length;
    }

    public int limit() {
        return this.position + this.length;
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + Arrays.hashCode(this.array);
        result = 31 * result + this.position;
        result = 31 * result + this.length;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClickHouseByteBuffer other = (ClickHouseByteBuffer)obj;
        return Arrays.equals(this.array, other.array) && this.position == other.position && this.length == other.length;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "array=" + this.array + ", position=" + this.position + ", length=" + this.length + ')';
    }
}

