/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.ClickHouseValues;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public interface ClickHouseValue
extends Serializable {
    default public UnsupportedOperationException newUnsupportedException(String from, String to) {
        return new UnsupportedOperationException(ClickHouseUtils.format("Converting [%s] to [%s] is not supported", from, to));
    }

    default public ClickHouseValue copy() {
        return this.copy(false);
    }

    public ClickHouseValue copy(boolean var1);

    default public boolean isInfinity() {
        double value = this.asDouble();
        return value == Double.NEGATIVE_INFINITY || value == Double.POSITIVE_INFINITY;
    }

    default public boolean isNaN() {
        double v = this.asDouble();
        return v != v;
    }

    public boolean isNullOrEmpty();

    default public Object[] asArray() {
        if (this.isNullOrEmpty()) {
            return ClickHouseValues.EMPTY_OBJECT_ARRAY;
        }
        return new Object[]{this.asObject()};
    }

    default public <T> T[] asArray(Class<T> clazz) {
        if (this.isNullOrEmpty()) {
            return ClickHouseValues.EMPTY_OBJECT_ARRAY;
        }
        Object[] array = (Object[])Array.newInstance(ClickHouseChecker.nonNull(clazz, "Class"), 1);
        array[0] = this.asObject(clazz);
        return array;
    }

    default public InputStream asByteStream() {
        byte[] byArray;
        if (this.isNullOrEmpty()) {
            byArray = new byte[]{};
        } else {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = this.asByte();
        }
        byte[] bytes = byArray;
        return new ByteArrayInputStream(bytes);
    }

    default public Reader asCharacterStream() {
        String s = this.isNullOrEmpty() ? "" : this.asString();
        return new StringReader(s);
    }

    default public boolean asBoolean() {
        return !this.isNullOrEmpty() && ClickHouseChecker.between(this.asByte(), 0, 1) == 1;
    }

    default public char asCharacter() {
        return (char)this.asShort();
    }

    public byte asByte();

    public short asShort();

    public int asInteger();

    public long asLong();

    public BigInteger asBigInteger();

    public float asFloat();

    public double asDouble();

    default public BigDecimal asBigDecimal() {
        return this.asBigDecimal(0);
    }

    public BigDecimal asBigDecimal(int var1);

    default public LocalDate asDate() {
        if (this.isNullOrEmpty()) {
            return null;
        }
        return LocalDate.ofEpochDay(this.asLong());
    }

    default public LocalTime asTime() {
        return this.asTime(0);
    }

    default public LocalTime asTime(int scale) {
        if (this.isNullOrEmpty()) {
            return null;
        }
        return this.asDateTime(scale).toLocalTime();
    }

    default public LocalDateTime asDateTime() {
        return this.asDateTime(0);
    }

    default public Instant asInstant() {
        return this.asInstant(0);
    }

    default public OffsetDateTime asOffsetDateTime() {
        return this.asOffsetDateTime(0);
    }

    default public ZonedDateTime asZonedDateTime() {
        return this.asZonedDateTime(0);
    }

    default public LocalDateTime asDateTime(int scale) {
        if (this.isNullOrEmpty()) {
            return null;
        }
        return ClickHouseValues.convertToDateTime(this.asBigDecimal(ClickHouseChecker.between(scale, "scale", 0, 9)));
    }

    default public Instant asInstant(int scale) {
        if (this.isNullOrEmpty()) {
            return null;
        }
        return ClickHouseValues.convertToInstant(this.asBigDecimal(ClickHouseChecker.between(scale, "scale", 0, 9)));
    }

    default public OffsetDateTime asOffsetDateTime(int scale) {
        if (this.isNullOrEmpty()) {
            return null;
        }
        return this.asDateTime(scale).atOffset(ZoneOffset.UTC);
    }

    default public ZonedDateTime asZonedDateTime(int scale) {
        if (this.isNullOrEmpty()) {
            return null;
        }
        return this.asDateTime(scale).atZone(ClickHouseValues.UTC_ZONE);
    }

    default public <T extends Enum<T>> T asEnum(Class<T> enumType) {
        if (this.isNullOrEmpty()) {
            return null;
        }
        int value = this.asInteger();
        for (Enum t : (Enum[])ClickHouseChecker.nonNull(enumType, "Class").getEnumConstants()) {
            if (t.ordinal() != value) continue;
            return (T)t;
        }
        throw new IllegalArgumentException(ClickHouseUtils.format("Ordinal[%d] not found in %s", value, enumType.getName()));
    }

    default public Inet4Address asInet4Address() {
        if (this.isNullOrEmpty()) {
            return null;
        }
        return ClickHouseValues.convertToIpv4(this.asInteger());
    }

    default public Inet6Address asInet6Address() {
        if (this.isNullOrEmpty()) {
            return null;
        }
        return ClickHouseValues.convertToIpv6(this.asBigInteger());
    }

    default public Map<Object, Object> asMap() {
        if (this.isNullOrEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        int index = 1;
        for (Object v : this.asArray()) {
            map.put(index++, v);
        }
        return map;
    }

    default public <K, V> Map<K, V> asMap(Class<K> keyClass, Class<V> valueClass) {
        if (this.isNullOrEmpty()) {
            return Collections.emptyMap();
        }
        ClickHouseChecker.nonNull(keyClass, "keyClass");
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        int index = 1;
        for (V v : this.asArray(valueClass)) {
            map.put(keyClass.cast(index++), v);
        }
        return map;
    }

    public Object asObject();

    default public <T, E extends Enum<E>> T asObject(Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return clazz.cast(this.asBoolean());
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return clazz.cast(this.asByte());
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return clazz.cast(Character.valueOf(this.asCharacter()));
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return clazz.cast(this.asShort());
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return clazz.cast(this.asInteger());
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return clazz.cast(this.asLong());
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return clazz.cast(Float.valueOf(this.asFloat()));
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return clazz.cast(this.asDouble());
        }
        if (clazz == String.class) {
            return clazz.cast(this.asString());
        }
        if (clazz == LocalDate.class) {
            return clazz.cast(this.asDate());
        }
        if (clazz == LocalDateTime.class) {
            return clazz.cast(this.asDateTime());
        }
        if (clazz == Instant.class) {
            return clazz.cast(this.asInstant());
        }
        if (clazz == OffsetDateTime.class) {
            return clazz.cast(this.asOffsetDateTime());
        }
        if (clazz == ZonedDateTime.class) {
            return clazz.cast(this.asZonedDateTime());
        }
        if (clazz == LocalTime.class) {
            return clazz.cast(this.asTime());
        }
        if (clazz == BigInteger.class) {
            return clazz.cast(this.asBigInteger());
        }
        if (clazz == BigDecimal.class) {
            return clazz.cast(this.asBigDecimal());
        }
        if (clazz == Inet4Address.class) {
            return clazz.cast(this.asInet4Address());
        }
        if (clazz == Inet6Address.class) {
            return clazz.cast(this.asInet6Address());
        }
        if (clazz == UUID.class) {
            return clazz.cast(this.asUuid());
        }
        if (Array.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.asArray());
        }
        if (List.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.asTuple());
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.asEnum(clazz));
        }
        return clazz.cast(this.asObject());
    }

    default public byte[] asBinary() {
        return this.asBinary(0, null);
    }

    default public byte[] asBinary(int length) {
        return this.asBinary(length, null);
    }

    default public byte[] asBinary(Charset charset) {
        return this.asBinary(0, charset);
    }

    default public byte[] asBinary(int length, Charset charset) {
        if (this.isNullOrEmpty()) {
            return null;
        }
        byte[] bytes = this.asString().getBytes(charset == null ? StandardCharsets.UTF_8 : charset);
        if (length > 0) {
            ClickHouseChecker.notWithDifferentLength(bytes, length);
        }
        return bytes;
    }

    default public String asString() {
        return this.asString(0, null);
    }

    default public String asString(int length) {
        return this.asString(length, null);
    }

    default public String asString(Charset charset) {
        return this.asString(0, charset);
    }

    default public String asString(int length, Charset charset) {
        if (this.isNullOrEmpty()) {
            return null;
        }
        String str = String.valueOf(this.asObject());
        if (length > 0) {
            ClickHouseChecker.notWithDifferentLength(str.getBytes(charset == null ? StandardCharsets.UTF_8 : charset), length);
        }
        return str;
    }

    default public List<Object> asTuple() {
        return Arrays.asList(this.asArray());
    }

    default public UUID asUuid() {
        if (this.isNullOrEmpty()) {
            return null;
        }
        return ClickHouseValues.convertToUuid(this.asBigInteger());
    }

    public ClickHouseValue resetToNullOrEmpty();

    public String toSqlExpression();

    default public ClickHouseValue update(InputStream value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.update(new InputStreamReader(value, StandardCharsets.UTF_8));
        }
        return this;
    }

    default public ClickHouseValue update(Reader value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            StringBuilder builder = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(value);){
                int num;
                int bufferSize = 1024;
                char[] buffer = new char[bufferSize];
                while ((num = reader.read(buffer, 0, buffer.length)) > 0) {
                    builder.append(buffer, 0, num);
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to read", e);
            }
            this.update(builder.toString());
        }
        return this;
    }

    default public ClickHouseValue update(boolean value) {
        return this.update(value ? (byte)1 : 0);
    }

    default public ClickHouseValue update(boolean[] value) {
        if (value == null || value.length == 0) {
            return this.resetToNullOrEmpty();
        }
        if (value.length != 1) {
            throw new IllegalArgumentException("Only singleton array is allowed, but we got: " + Arrays.toString(value));
        }
        return this.update(value[0]);
    }

    default public ClickHouseValue update(char value) {
        return this.update((int)value);
    }

    default public ClickHouseValue update(char[] value) {
        if (value == null || value.length == 0) {
            return this.resetToNullOrEmpty();
        }
        if (value.length != 1) {
            throw new IllegalArgumentException("Only singleton array is allowed, but we got: " + Arrays.toString(value));
        }
        return this.update(value[0]);
    }

    public ClickHouseValue update(byte var1);

    default public ClickHouseValue update(byte[] value) {
        if (value == null || value.length == 0) {
            return this.resetToNullOrEmpty();
        }
        if (value.length != 1) {
            throw new IllegalArgumentException("Only singleton array is allowed, but we got: " + Arrays.toString(value));
        }
        return this.update(value[0]);
    }

    public ClickHouseValue update(short var1);

    default public ClickHouseValue update(short[] value) {
        if (value == null || value.length == 0) {
            return this.resetToNullOrEmpty();
        }
        if (value.length != 1) {
            throw new IllegalArgumentException("Only singleton array is allowed, but we got: " + Arrays.toString(value));
        }
        return this.update(value[0]);
    }

    public ClickHouseValue update(int var1);

    default public ClickHouseValue update(int[] value) {
        if (value == null || value.length == 0) {
            return this.resetToNullOrEmpty();
        }
        if (value.length != 1) {
            throw new IllegalArgumentException("Only singleton array is allowed, but we got: " + Arrays.toString(value));
        }
        return this.update(value[0]);
    }

    public ClickHouseValue update(long var1);

    default public ClickHouseValue update(long[] value) {
        if (value == null || value.length == 0) {
            return this.resetToNullOrEmpty();
        }
        if (value.length != 1) {
            throw new IllegalArgumentException("Only singleton array is allowed, but we got: " + Arrays.toString(value));
        }
        return this.update(value[0]);
    }

    public ClickHouseValue update(float var1);

    default public ClickHouseValue update(float[] value) {
        if (value == null || value.length == 0) {
            return this.resetToNullOrEmpty();
        }
        if (value.length != 1) {
            throw new IllegalArgumentException("Only singleton array is allowed, but we got: " + Arrays.toString(value));
        }
        return this.update(value[0]);
    }

    public ClickHouseValue update(double var1);

    default public ClickHouseValue update(double[] value) {
        if (value == null || value.length == 0) {
            return this.resetToNullOrEmpty();
        }
        if (value.length != 1) {
            throw new IllegalArgumentException("Only singleton array is allowed, but we got: " + Arrays.toString(value));
        }
        return this.update(value[0]);
    }

    public ClickHouseValue update(BigInteger var1);

    public ClickHouseValue update(BigDecimal var1);

    default public ClickHouseValue update(Enum<?> value) {
        return value == null ? this.resetToNullOrEmpty() : this.update(value.ordinal());
    }

    default public ClickHouseValue update(Inet4Address value) {
        return value == null ? this.resetToNullOrEmpty() : this.update(new BigInteger(1, value.getAddress()));
    }

    default public ClickHouseValue update(Inet6Address value) {
        return value == null ? this.resetToNullOrEmpty() : this.update(new BigInteger(1, value.getAddress()));
    }

    default public ClickHouseValue update(LocalDate value) {
        return value == null ? this.resetToNullOrEmpty() : this.update(value.toEpochDay());
    }

    default public ClickHouseValue update(LocalTime value) {
        return value == null ? this.resetToNullOrEmpty() : this.update(value.toSecondOfDay());
    }

    default public ClickHouseValue update(LocalDateTime value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        long seconds = value.toEpochSecond(ZoneOffset.UTC);
        int nanos = value.getNano();
        return nanos > 0 ? this.update(BigDecimal.valueOf(seconds).add(BigDecimal.valueOf(nanos, 9).divide(ClickHouseValues.NANOS))) : this.update(seconds);
    }

    default public ClickHouseValue update(Instant value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        long seconds = value.getEpochSecond();
        int nanos = value.getNano();
        return nanos > 0 ? this.update(BigDecimal.valueOf(seconds).add(BigDecimal.valueOf(nanos, 9).divide(ClickHouseValues.NANOS))) : this.update(seconds);
    }

    default public ClickHouseValue update(OffsetDateTime value) {
        return this.update(value != null ? value.toLocalDateTime() : null);
    }

    default public ClickHouseValue update(ZonedDateTime value) {
        return this.update(value != null ? value.toLocalDateTime() : null);
    }

    default public ClickHouseValue update(Collection<?> value) {
        int size;
        int n = size = value == null ? 0 : value.size();
        if (size == 0) {
            return this.resetToNullOrEmpty();
        }
        if (size != 1) {
            throw new IllegalArgumentException("Only singleton collection is allowed, but we got: " + value);
        }
        return this.update(value.iterator().next());
    }

    default public ClickHouseValue update(Enumeration<?> value) {
        if (value == null || !value.hasMoreElements()) {
            return this.resetToNullOrEmpty();
        }
        Object v = value.nextElement();
        if (value.hasMoreElements()) {
            throw new IllegalArgumentException("Only singleton collection is allowed, but we got: " + value);
        }
        return this.update(v);
    }

    default public ClickHouseValue update(Map<?, ?> value) {
        int size;
        int n = size = value == null ? 0 : value.size();
        if (size == 0) {
            return this.resetToNullOrEmpty();
        }
        if (size != 1) {
            throw new IllegalArgumentException("Only singleton map is allowed, but we got: " + value);
        }
        return this.update(value.values().iterator().next());
    }

    public ClickHouseValue update(String var1);

    default public ClickHouseValue update(UUID value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        BigInteger high = BigInteger.valueOf(value.getMostSignificantBits());
        BigInteger low = BigInteger.valueOf(value.getLeastSignificantBits());
        if (high.signum() < 0) {
            high = high.add(ClickHouseValues.BIGINT_HL_BOUNDARY);
        }
        if (low.signum() < 0) {
            low = low.add(ClickHouseValues.BIGINT_HL_BOUNDARY);
        }
        return this.update(low.add(high.multiply(ClickHouseValues.BIGINT_HL_BOUNDARY)));
    }

    public ClickHouseValue update(ClickHouseValue var1);

    default public ClickHouseValue update(Object[] value) {
        if (value == null || value.length == 0) {
            return this.resetToNullOrEmpty();
        }
        if (value.length != 1) {
            throw new IllegalArgumentException("Only singleton array is allowed, but we got: " + Arrays.toString(value));
        }
        return this.update(value[0]);
    }

    default public ClickHouseValue updateUnknown(Object value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.update(String.valueOf(value));
    }

    default public ClickHouseValue update(Object value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        if (value instanceof Boolean) {
            return this.update((Boolean)value);
        }
        if (value instanceof boolean[]) {
            return this.update((boolean[])value);
        }
        if (value instanceof Character) {
            return this.update(((Character)value).charValue());
        }
        if (value instanceof char[]) {
            return this.update((char[])value);
        }
        if (value instanceof Byte) {
            return this.update((Byte)value);
        }
        if (value instanceof byte[]) {
            return this.update((byte[])value);
        }
        if (value instanceof Short) {
            return this.update((Short)value);
        }
        if (value instanceof short[]) {
            return this.update((short[])value);
        }
        if (value instanceof Integer) {
            return this.update((Integer)value);
        }
        if (value instanceof int[]) {
            return this.update((int[])value);
        }
        if (value instanceof Long) {
            return this.update((Long)value);
        }
        if (value instanceof long[]) {
            return this.update((long[])value);
        }
        if (value instanceof Float) {
            return this.update(((Float)value).floatValue());
        }
        if (value instanceof float[]) {
            return this.update((float[])value);
        }
        if (value instanceof Double) {
            return this.update((Double)value);
        }
        if (value instanceof double[]) {
            return this.update((double[])value);
        }
        if (value instanceof BigDecimal) {
            return this.update((BigDecimal)value);
        }
        if (value instanceof BigInteger) {
            return this.update((BigInteger)value);
        }
        if (value instanceof Enum) {
            return this.update((Enum)value);
        }
        if (value instanceof Inet4Address) {
            return this.update((Inet4Address)value);
        }
        if (value instanceof Inet6Address) {
            return this.update((Inet6Address)value);
        }
        if (value instanceof LocalDate) {
            return this.update((LocalDate)value);
        }
        if (value instanceof LocalTime) {
            return this.update((LocalTime)value);
        }
        if (value instanceof LocalDateTime) {
            return this.update((LocalDateTime)value);
        }
        if (value instanceof Instant) {
            return this.update((Instant)value);
        }
        if (value instanceof OffsetDateTime) {
            return this.update((OffsetDateTime)value);
        }
        if (value instanceof ZonedDateTime) {
            return this.update((ZonedDateTime)value);
        }
        if (value instanceof Collection) {
            return this.update((Collection)value);
        }
        if (value instanceof Enumeration) {
            return this.update((Enumeration)value);
        }
        if (value instanceof Map) {
            return this.update((Map)value);
        }
        if (value instanceof Object[]) {
            return this.update((Object[])value);
        }
        if (value instanceof UUID) {
            return this.update((UUID)value);
        }
        if (value instanceof String) {
            return this.update((String)value);
        }
        if (value instanceof InputStream) {
            return this.update((InputStream)value);
        }
        if (value instanceof Reader) {
            return this.update((Reader)value);
        }
        if (value instanceof ClickHouseValue) {
            return this.update((ClickHouseValue)value);
        }
        return this.updateUnknown(value);
    }
}

