/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseByteBuffer;
import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseOutputStream;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.config.ClickHouseClientOption;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public abstract class ClickHouseInputStream
extends InputStream {
    @Deprecated
    public static final byte[] EMPTY_BYTES = ClickHouseByteBuffer.EMPTY_BYTES;
    @Deprecated
    public static final ByteBuffer EMPTY_BUFFER = ClickHouseByteBuffer.EMPTY_BUFFER;
    static final int MIN_BUFFER_SIZE = 1;
    static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;
    static final String INCOMPLETE_READ_ERROR = "Reached end of input stream after reading %d of %d bytes";
    protected final Runnable afterClose;
    protected final ClickHouseByteBuffer byteBuffer;
    protected boolean closed;

    public static ClickHouseInputStream of(BlockingQueue<ByteBuffer> queue, int timeout) {
        return new BlockingInputStream(queue, timeout, null);
    }

    public static ClickHouseInputStream of(BlockingQueue<ByteBuffer> queue, int timeout, Runnable afterClose) {
        return new BlockingInputStream(queue, timeout, afterClose);
    }

    public static ClickHouseInputStream of(InputStream input) {
        return ClickHouseInputStream.of(input, (int)((Integer)ClickHouseClientOption.MAX_BUFFER_SIZE.getDefaultValue()), null);
    }

    public static ClickHouseInputStream of(InputStream input, int bufferSize) {
        return ClickHouseInputStream.of(input, bufferSize, null);
    }

    public static ClickHouseInputStream of(InputStream input, int bufferSize, Runnable afterClose) {
        return input instanceof ClickHouseInputStream ? (ClickHouseInputStream)input : new WrappedInputStream(input, bufferSize, afterClose);
    }

    protected ClickHouseInputStream(Runnable afterClose) {
        this.afterClose = afterClose;
        this.byteBuffer = ClickHouseByteBuffer.newInstance();
        this.closed = false;
    }

    protected void closeQuietly() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public abstract int peek() throws IOException;

    public abstract long pipe(ClickHouseOutputStream var1) throws IOException;

    public int readUnsignedByte() throws IOException {
        return 0xFF & this.readByte();
    }

    public abstract byte readByte() throws IOException;

    public byte[] readBytes(int length) throws IOException {
        int read;
        if (length <= 0) {
            return ClickHouseByteBuffer.EMPTY_BYTES;
        }
        if (this.closed) {
            throw new IOException("Stream has been closed");
        }
        byte[] bytes = new byte[length];
        for (int offset = 0; offset < length; offset += read) {
            read = this.read(bytes, offset, length - offset);
            if (read != -1) continue;
            this.closeQuietly();
            throw offset == 0 ? new EOFException() : new IOException(ClickHouseUtils.format(INCOMPLETE_READ_ERROR, offset, length));
        }
        return bytes;
    }

    public ClickHouseByteBuffer read(int len) throws IOException {
        return len <= 0 ? this.byteBuffer.reset() : this.byteBuffer.update(this.readBytes(len));
    }

    public String readString(Charset charset) throws IOException {
        return this.readString(this.readVarInt(), charset);
    }

    public String readString(int byteLength, Charset charset) throws IOException {
        if (byteLength < 1) {
            return "";
        }
        ClickHouseByteBuffer buf = this.read(byteLength);
        return new String(buf.array, buf.position, buf.length, charset != null ? charset : StandardCharsets.UTF_8);
    }

    public String readAsciiString() throws IOException {
        return this.readString(this.readVarInt(), StandardCharsets.US_ASCII);
    }

    public String readAsciiString(int byteLength) throws IOException {
        return this.readString(byteLength, StandardCharsets.US_ASCII);
    }

    public String readUnicodeString() throws IOException {
        return this.readString(this.readVarInt(), StandardCharsets.UTF_8);
    }

    public String readUnicodeString(int byteLength) throws IOException {
        return this.readString(byteLength, StandardCharsets.UTF_8);
    }

    public int readVarInt() throws IOException {
        long result = 0L;
        int shift = 0;
        for (int i = 0; i < 9; ++i) {
            byte b = this.readByte();
            result |= (long)((b & 0x7F) << shift);
            if ((b & 0x80) == 0) break;
            shift += 7;
        }
        return (int)result;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.byteBuffer.reset();
            if (this.afterClose != null) {
                this.afterClose.run();
            }
        }
    }

    static final class WrappedInputStream
    extends ClickHouseInputStream {
        private final InputStream in;
        private final byte[] buffer;
        private int position;
        private int limit;

        WrappedInputStream(InputStream input, int bufferSize, Runnable afterClose) {
            super(afterClose);
            this.in = ClickHouseChecker.nonNull(input, "InputStream");
            this.buffer = new byte[ClickHouseChecker.between(bufferSize, "BufferSize", 1, 0x7FFFFFF7)];
            this.position = 0;
            this.limit = 0;
        }

        private void ensureOpen() throws IOException {
            if (this.closed) {
                throw new IOException(ClickHouseUtils.format("Wrapped input stream(%s) has been closed", this.in));
            }
        }

        private boolean updateBuffer() throws IOException {
            int read;
            if (this.closed) {
                return false;
            }
            byte[] buf = this.buffer;
            int len = buf.length;
            int offset = 0;
            if (this.position > 0 && (offset = this.limit - this.position) > 0) {
                for (int i = 0; i < offset; ++i) {
                    buf[i] = buf[this.position + i];
                }
            }
            while (offset < len && (read = this.in.read(buf, offset, len - offset)) != -1) {
                offset += read;
            }
            this.limit = offset;
            this.position = 0;
            return this.limit > this.position;
        }

        @Override
        public int available() throws IOException {
            return this.limit > this.position || this.updateBuffer() ? this.limit - this.position : 0;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                this.in.close();
            }
            finally {
                this.position = 0;
                this.limit = 0;
                super.close();
            }
        }

        @Override
        public int peek() throws IOException {
            return this.limit > this.position || this.updateBuffer() ? 0xFF & this.buffer[this.position] : -1;
        }

        @Override
        public long pipe(ClickHouseOutputStream output) throws IOException {
            long count = 0L;
            if (output == null || output.isClosed()) {
                return count;
            }
            this.ensureOpen();
            int remain = this.limit - this.position;
            if (remain > 0) {
                output.write(this.buffer, this.position, remain);
                count += (long)remain;
                this.position = this.limit;
            }
            while ((remain = this.in.read(this.buffer)) != -1) {
                output.write(this.buffer, 0, remain);
                count += (long)remain;
            }
            return count;
        }

        @Override
        public int read() throws IOException {
            this.ensureOpen();
            int value = -1;
            if (this.position < this.limit || this.updateBuffer()) {
                value = 0xFF & this.buffer[this.position++];
            }
            return value;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int read;
            if ((len | off | b.length) < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (off == b.length) {
                throw new IOException("Nothing to read");
            }
            if (this.buffer == b) {
                throw new IllegalArgumentException("Please pass a different byte array instead of internal buffer for reading");
            }
            if (this.position + len <= this.limit) {
                System.arraycopy(this.buffer, this.position, b, off, len);
                this.position += len;
                return len;
            }
            if (len <= this.buffer.length) {
                if (!this.updateBuffer()) {
                    return -1;
                }
                System.arraycopy(this.buffer, 0, b, off, this.limit);
                this.position = this.limit;
                return this.limit;
            }
            this.ensureOpen();
            int counter = 0;
            int remain = this.limit - this.position;
            if (remain > 0) {
                System.arraycopy(this.buffer, this.position, b, off, remain);
                counter += remain;
                off += remain;
            }
            while (counter < len && (read = this.in.read(b, off, len - off)) != -1) {
                off += read;
            }
            return counter;
        }

        @Override
        public ClickHouseByteBuffer read(int len) throws IOException {
            if (len <= 0) {
                return this.byteBuffer.reset();
            }
            this.ensureOpen();
            if (this.position >= this.limit && !this.updateBuffer()) {
                this.closeQuietly();
                throw new EOFException();
            }
            int newLimit = this.position + len;
            if (this.limit >= newLimit) {
                this.byteBuffer.update(this.buffer, this.position, len);
                this.position = newLimit;
            } else {
                this.byteBuffer.update(this.readBytes(len));
            }
            return this.byteBuffer;
        }

        @Override
        public byte readByte() throws IOException {
            if (this.position < this.limit || this.updateBuffer()) {
                return this.buffer[this.position++];
            }
            this.closeQuietly();
            throw new EOFException();
        }

        @Override
        public byte[] readBytes(int length) throws IOException {
            int size;
            if (length < 1) {
                return ClickHouseByteBuffer.EMPTY_BYTES;
            }
            if (this.position + length <= this.limit) {
                byte[] bytes = new byte[length];
                System.arraycopy(this.buffer, this.position, bytes, 0, length);
                this.position += length;
                return bytes;
            }
            if (length <= this.buffer.length) {
                if (!this.updateBuffer()) {
                    this.closeQuietly();
                    throw new EOFException(ClickHouseUtils.format("Failed to read %d bytes due to end of stream", length));
                }
                if (length > this.limit) {
                    throw new EOFException(ClickHouseUtils.format("Reached end of stream after reading %d bytes of %d", this.limit, length));
                }
                byte[] bytes = new byte[length];
                System.arraycopy(this.buffer, this.position, bytes, 0, length);
                this.position += length;
                return bytes;
            }
            this.ensureOpen();
            byte[] bytes = new byte[length];
            for (int counter = 0; counter < length; counter += size) {
                if (this.limit > this.position || this.updateBuffer()) {
                    size = Math.min(this.limit - this.position, length - counter);
                    System.arraycopy(this.buffer, this.position, bytes, counter, size);
                    this.position += size;
                    continue;
                }
                this.closeQuietly();
                throw counter == 0 ? new EOFException() : new IOException(ClickHouseUtils.format(ClickHouseInputStream.INCOMPLETE_READ_ERROR, counter, bytes.length));
            }
            return bytes;
        }

        @Override
        public long skip(long n) throws IOException {
            this.ensureOpen();
            long counter = 0L;
            while (n > 0L && (this.limit > this.position || this.updateBuffer())) {
                int remain = this.limit - this.position;
                if (n > (long)remain) {
                    n -= (long)remain;
                    counter += (long)remain;
                    this.position = this.limit;
                    continue;
                }
                counter += n;
                this.position = (int)((long)this.position + n);
                n = 0L;
            }
            return counter;
        }
    }

    static final class BlockingInputStream
    extends ClickHouseInputStream {
        private final BlockingQueue<ByteBuffer> queue;
        private final int timeout;
        private ByteBuffer buffer;

        BlockingInputStream(BlockingQueue<ByteBuffer> queue, int timeout, Runnable afterClose) {
            super(afterClose);
            this.queue = ClickHouseChecker.nonNull(queue, "Queue");
            this.timeout = timeout > 0 ? timeout : 0;
            this.buffer = null;
        }

        private void ensureOpen() throws IOException {
            if (this.closed) {
                throw new IOException(ClickHouseUtils.format("Blocking input stream(queue: %d, buffer: %d) has been closed", this.queue.size(), this.buffer != null ? this.buffer.remaining() : 0));
            }
            if (this.buffer == null || this.buffer != ClickHouseByteBuffer.EMPTY_BUFFER && !this.buffer.hasRemaining()) {
                this.updateBuffer();
            }
        }

        private int updateBuffer() throws IOException {
            try {
                if (this.timeout > 0) {
                    this.buffer = this.queue.poll(this.timeout, TimeUnit.MILLISECONDS);
                    if (this.buffer == null) {
                        throw new IOException(ClickHouseUtils.format("Read timed out after %d ms", this.timeout));
                    }
                } else {
                    this.buffer = this.queue.take();
                }
                return this.buffer.remaining();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Thread was interrupted when getting next buffer from queue", e);
            }
        }

        @Override
        public int available() throws IOException {
            if (this.closed || this.buffer == ClickHouseByteBuffer.EMPTY_BUFFER) {
                return 0;
            }
            return this.buffer == null || !this.buffer.hasRemaining() ? this.updateBuffer() : this.buffer.remaining();
        }

        @Override
        public void close() throws IOException {
            this.buffer = null;
            super.close();
        }

        @Override
        public int peek() throws IOException {
            this.ensureOpen();
            if (this.buffer == ClickHouseByteBuffer.EMPTY_BUFFER) {
                return -1;
            }
            int b = 0xFF & this.buffer.get();
            ((Buffer)this.buffer).position(this.buffer.position() - 1);
            return b;
        }

        @Override
        public long pipe(ClickHouseOutputStream output) throws IOException {
            long count = 0L;
            if (output == null || output.isClosed()) {
                return count;
            }
            this.ensureOpen();
            while (this.buffer != ClickHouseByteBuffer.EMPTY_BUFFER) {
                int remain = this.buffer.remaining();
                if (remain > 0) {
                    byte[] bytes;
                    if (this.buffer.hasArray()) {
                        bytes = this.buffer.array();
                        int pos = this.buffer.position();
                        output.write(bytes, pos, remain);
                        ((Buffer)this.buffer).position(pos + remain);
                    } else {
                        bytes = new byte[remain];
                        this.buffer.get(bytes);
                        output.write(bytes);
                    }
                    count += (long)remain;
                }
                this.updateBuffer();
            }
            return count;
        }

        @Override
        public int read() throws IOException {
            this.ensureOpen();
            if (this.buffer == ClickHouseByteBuffer.EMPTY_BUFFER) {
                return -1;
            }
            return 0xFF & this.buffer.get();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.ensureOpen();
            int offset = off;
            while (len > 0) {
                if (this.buffer == ClickHouseByteBuffer.EMPTY_BUFFER) {
                    return off > offset ? off - offset : -1;
                }
                int remain = this.buffer.remaining();
                if (remain >= len) {
                    this.buffer.get(b, off, len);
                    off += len;
                    len = 0;
                    continue;
                }
                this.buffer.get(b, off, remain);
                off += remain;
                len -= remain;
                this.updateBuffer();
            }
            return off - offset;
        }

        @Override
        public ClickHouseByteBuffer read(int len) throws IOException {
            if (len <= 0) {
                return this.byteBuffer.reset();
            }
            this.ensureOpen();
            if (this.buffer == ClickHouseByteBuffer.EMPTY_BUFFER) {
                this.closeQuietly();
                throw new EOFException();
            }
            if (this.buffer.remaining() >= len && this.buffer.hasArray()) {
                int position = this.buffer.position();
                this.byteBuffer.update(this.buffer.array(), position, len);
                ((Buffer)this.buffer).position(position + len);
            } else {
                this.byteBuffer.update(this.readBytes(len));
            }
            return this.byteBuffer;
        }

        @Override
        public byte readByte() throws IOException {
            this.ensureOpen();
            if (this.buffer == ClickHouseByteBuffer.EMPTY_BUFFER) {
                this.closeQuietly();
                throw new EOFException();
            }
            return this.buffer.get();
        }

        @Override
        public byte[] readBytes(int length) throws IOException {
            if (length < 1) {
                return ClickHouseByteBuffer.EMPTY_BYTES;
            }
            this.ensureOpen();
            byte[] bytes = new byte[length];
            int offset = 0;
            int len = length;
            while (len > 0) {
                if (this.buffer == ClickHouseByteBuffer.EMPTY_BUFFER) {
                    this.closeQuietly();
                    throw offset == 0 ? new EOFException() : new IOException(ClickHouseUtils.format(ClickHouseInputStream.INCOMPLETE_READ_ERROR, offset, length));
                }
                int remain = this.buffer.remaining();
                if (remain >= len) {
                    this.buffer.get(bytes, offset, len);
                    offset += len;
                    len = 0;
                    continue;
                }
                this.buffer.get(bytes, offset, remain);
                offset += remain;
                len -= remain;
                this.updateBuffer();
            }
            return bytes;
        }

        @Override
        public long skip(long n) throws IOException {
            this.ensureOpen();
            if (n == Long.MAX_VALUE) {
                long counter = this.buffer.remaining();
                while (this.buffer != ClickHouseByteBuffer.EMPTY_BUFFER && this.buffer.limit() > 0) {
                    counter += (long)this.buffer.limit();
                    this.updateBuffer();
                }
                return counter;
            }
            return super.skip(n);
        }
    }
}

