/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseAggregateFunction;
import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseDataType;
import com.clickhouse.client.ClickHouseEnum;
import com.clickhouse.client.ClickHouseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;

public final class ClickHouseColumn
implements Serializable {
    private static final long serialVersionUID = 8228660689532259640L;
    private static final String ERROR_MISSING_NESTED_TYPE = "Missing nested data type";
    private static final String KEYWORD_NULLABLE = "Nullable";
    private static final String KEYWORD_LOW_CARDINALITY = "LowCardinality";
    private static final String KEYWORD_AGGREGATE_FUNCTION = ClickHouseDataType.AggregateFunction.name();
    private static final String KEYWORD_SIMPLE_AGGREGATE_FUNCTION = ClickHouseDataType.SimpleAggregateFunction.name();
    private static final String KEYWORD_ARRAY = ClickHouseDataType.Array.name();
    private static final String KEYWORD_TUPLE = ClickHouseDataType.Tuple.name();
    private static final String KEYWORD_MAP = ClickHouseDataType.Map.name();
    private static final String KEYWORD_NESTED = ClickHouseDataType.Nested.name();
    private String originalTypeName;
    private String columnName;
    private ClickHouseAggregateFunction aggFuncType;
    private ClickHouseDataType dataType;
    private boolean nullable;
    private boolean lowCardinality;
    private TimeZone timeZone;
    private int precision;
    private int scale;
    private List<ClickHouseColumn> nested;
    private List<String> parameters;
    private ClickHouseEnum enumConstants;
    private int arrayLevel;
    private ClickHouseColumn arrayBaseColumn;

    private static ClickHouseColumn update(ClickHouseColumn column) {
        column.enumConstants = ClickHouseEnum.EMPTY;
        int size = column.parameters.size();
        column.precision = column.dataType.getMaxPrecision();
        switch (column.dataType) {
            case Array: {
                if (column.nested.isEmpty()) break;
                column.arrayLevel = 1;
                column.arrayBaseColumn = column.nested.get(0);
                while (column.arrayLevel < 255 && column.arrayBaseColumn.dataType == ClickHouseDataType.Array) {
                    ++column.arrayLevel;
                    column.arrayBaseColumn = column.arrayBaseColumn.nested.get(0);
                }
                break;
            }
            case Enum: 
            case Enum8: 
            case Enum16: {
                column.enumConstants = new ClickHouseEnum(column.parameters);
                break;
            }
            case DateTime: {
                TimeZone tz;
                if (size >= 2) {
                    column.scale = Integer.parseInt(column.parameters.get(0));
                    column.timeZone = TimeZone.getTimeZone(column.parameters.get(1).replace("'", ""));
                    break;
                }
                if (size != 1) break;
                column.timeZone = tz = TimeZone.getTimeZone(column.parameters.get(0).replace("'", ""));
                break;
            }
            case DateTime32: {
                TimeZone tz;
                if (size <= 0) break;
                column.timeZone = tz = TimeZone.getTimeZone(column.parameters.get(0).replace("'", ""));
                break;
            }
            case DateTime64: {
                if (size > 0) {
                    column.scale = Integer.parseInt(column.parameters.get(0));
                }
                if (size <= 1) break;
                column.timeZone = TimeZone.getTimeZone(column.parameters.get(1).replace("'", ""));
                break;
            }
            case Decimal: {
                if (size < 2) break;
                column.precision = Integer.parseInt(column.parameters.get(0));
                column.scale = Integer.parseInt(column.parameters.get(1));
                break;
            }
            case Decimal32: 
            case Decimal64: 
            case Decimal128: 
            case Decimal256: {
                if (size <= 0) break;
                column.scale = Integer.parseInt(column.parameters.get(0));
                break;
            }
            case FixedString: {
                if (size <= 0) break;
                column.precision = Integer.parseInt(column.parameters.get(0));
                break;
            }
        }
        return column;
    }

    protected static int readColumn(String args, int startIndex, int len, String name, List<ClickHouseColumn> list) {
        char c;
        List<ClickHouseColumn> nestedColumns;
        int index;
        String matchedKeyword;
        int index2;
        ClickHouseColumn column = null;
        StringBuilder builder = new StringBuilder();
        int brackets = 0;
        boolean nullable = false;
        boolean lowCardinality = false;
        int i = startIndex;
        if (args.startsWith(KEYWORD_LOW_CARDINALITY, i)) {
            lowCardinality = true;
            index2 = args.indexOf(40, i + KEYWORD_LOW_CARDINALITY.length());
            if (index2 < i) {
                throw new IllegalArgumentException(ERROR_MISSING_NESTED_TYPE);
            }
            i = index2 + 1;
            ++brackets;
        }
        if (args.startsWith(KEYWORD_NULLABLE, i)) {
            nullable = true;
            index2 = args.indexOf(40, i + KEYWORD_NULLABLE.length());
            if (index2 < i) {
                throw new IllegalArgumentException(ERROR_MISSING_NESTED_TYPE);
            }
            i = index2 + 1;
            ++brackets;
        }
        if (args.startsWith(matchedKeyword = KEYWORD_AGGREGATE_FUNCTION, i) || args.startsWith(matchedKeyword = KEYWORD_SIMPLE_AGGREGATE_FUNCTION, i)) {
            index = args.indexOf(40, i + matchedKeyword.length());
            if (index < i) {
                throw new IllegalArgumentException("Missing function parameters");
            }
            LinkedList<String> params = new LinkedList<String>();
            i = ClickHouseUtils.readParameters(args, index, len, params);
            ClickHouseAggregateFunction aggFunc = null;
            boolean isFirst = true;
            LinkedList<ClickHouseColumn> nestedColumns2 = new LinkedList<ClickHouseColumn>();
            for (String p : params) {
                if (isFirst) {
                    int pIndex = p.indexOf(40);
                    aggFunc = ClickHouseAggregateFunction.of(pIndex > 0 ? p.substring(0, pIndex) : p);
                    isFirst = false;
                    continue;
                }
                nestedColumns2.add(ClickHouseColumn.of("", p));
            }
            column = new ClickHouseColumn(ClickHouseDataType.valueOf(matchedKeyword), name, args.substring(startIndex, i), nullable, lowCardinality, params, nestedColumns2);
            column.aggFuncType = aggFunc;
        } else if (args.startsWith(KEYWORD_ARRAY, i)) {
            index = args.indexOf(40, i + KEYWORD_ARRAY.length());
            if (index < i) {
                throw new IllegalArgumentException(ERROR_MISSING_NESTED_TYPE);
            }
            int endIndex = ClickHouseUtils.skipBrackets(args, index, len, '(');
            nestedColumns = new LinkedList<ClickHouseColumn>();
            ClickHouseColumn.readColumn(args, index + 1, endIndex - 1, "", nestedColumns);
            if (nestedColumns.size() != 1) {
                throw new IllegalArgumentException("Array can have one and only one nested column, but we got: " + nestedColumns.size());
            }
            column = new ClickHouseColumn(ClickHouseDataType.Array, name, args.substring(startIndex, endIndex), nullable, lowCardinality, null, nestedColumns);
            i = endIndex;
        } else if (args.startsWith(KEYWORD_MAP, i)) {
            index = args.indexOf(40, i + KEYWORD_MAP.length());
            if (index < i) {
                throw new IllegalArgumentException(ERROR_MISSING_NESTED_TYPE);
            }
            int endIndex = ClickHouseUtils.skipBrackets(args, index, len, '(');
            nestedColumns = new LinkedList();
            for (i = index + 1; i < endIndex && (c = args.charAt(i)) != ')'; ++i) {
                if (c == ',' || Character.isWhitespace(c)) continue;
                i = ClickHouseColumn.readColumn(args, i, endIndex, "", nestedColumns) - 1;
            }
            if (nestedColumns.size() != 2) {
                throw new IllegalArgumentException("Map should have two nested columns(key and value), but we got: " + nestedColumns.size());
            }
            column = new ClickHouseColumn(ClickHouseDataType.Map, name, args.substring(startIndex, endIndex), nullable, lowCardinality, null, nestedColumns);
            i = endIndex;
        } else if (args.startsWith(KEYWORD_NESTED, i)) {
            index = args.indexOf(40, i + KEYWORD_NESTED.length());
            if (index < i) {
                throw new IllegalArgumentException(ERROR_MISSING_NESTED_TYPE);
            }
            i = ClickHouseUtils.skipBrackets(args, index, len, '(');
            String originalTypeName = args.substring(startIndex, i);
            nestedColumns = ClickHouseColumn.parse(args.substring(index + 1, i - 1));
            if (nestedColumns.isEmpty()) {
                throw new IllegalArgumentException("Nested should have at least one nested column");
            }
            column = new ClickHouseColumn(ClickHouseDataType.Nested, name, originalTypeName, nullable, lowCardinality, null, nestedColumns);
        } else if (args.startsWith(KEYWORD_TUPLE, i)) {
            index = args.indexOf(40, i + KEYWORD_TUPLE.length());
            if (index < i) {
                throw new IllegalArgumentException(ERROR_MISSING_NESTED_TYPE);
            }
            int endIndex = ClickHouseUtils.skipBrackets(args, index, len, '(');
            nestedColumns = new LinkedList();
            for (i = index + 1; i < endIndex && (c = args.charAt(i)) != ')'; ++i) {
                if (c == ',' || Character.isWhitespace(c)) continue;
                i = ClickHouseColumn.readColumn(args, i, endIndex, "", nestedColumns) - 1;
            }
            if (nestedColumns.isEmpty()) {
                throw new IllegalArgumentException("Tuple should have at least one nested column");
            }
            column = new ClickHouseColumn(ClickHouseDataType.Tuple, name, args.substring(startIndex, endIndex), nullable, lowCardinality, null, nestedColumns);
        }
        if (column == null) {
            LinkedList<String> params = new LinkedList<String>();
            for (i = ClickHouseUtils.readNameOrQuotedString(args, i, len, builder); i < len; ++i) {
                char ch = args.charAt(i);
                if (ch == '(') {
                    i = ClickHouseUtils.readParameters(args, i, len, params) - 1;
                    continue;
                }
                if (ch == ')') {
                    if (--brackets > 0) continue;
                    ++i;
                    break;
                }
                if (ch == ',') break;
                if (Character.isWhitespace(ch)) continue;
                StringBuilder sb = new StringBuilder();
                i = ClickHouseUtils.readNameOrQuotedString(args, i, len, sb);
                String modifier = sb.toString();
                sb.setLength(0);
                boolean startsWithNot = false;
                if ("not".equalsIgnoreCase(modifier)) {
                    startsWithNot = true;
                    i = ClickHouseUtils.readNameOrQuotedString(args, i, len, sb);
                    modifier = sb.toString();
                    sb.setLength(0);
                }
                if ("null".equalsIgnoreCase(modifier)) {
                    if (nullable) {
                        throw new IllegalArgumentException("Nullable and NULL cannot be used together");
                    }
                    nullable = !startsWithNot;
                    i = ClickHouseUtils.skipContentsUntil(args, i, len, ',') - 1;
                    break;
                }
                if (startsWithNot) {
                    throw new IllegalArgumentException("Expect keyword NULL after NOT");
                }
                if ("alias".equalsIgnoreCase(modifier) || "codec".equalsIgnoreCase(modifier) || "default".equalsIgnoreCase(modifier) || "materialized".equalsIgnoreCase(modifier) || "ttl".equalsIgnoreCase(modifier)) {
                    i = ClickHouseUtils.skipContentsUntil(args, i, len, ',') - 1;
                    break;
                }
                builder.append(' ').append(modifier);
                --i;
            }
            column = new ClickHouseColumn(ClickHouseDataType.of(builder.toString()), name, args.substring(startIndex, i), nullable, lowCardinality, params, null);
            builder.setLength(0);
        }
        list.add(ClickHouseColumn.update(column));
        return i;
    }

    public static ClickHouseColumn of(String columnName, ClickHouseDataType dataType, boolean nullable, int precision, int scale) {
        ClickHouseColumn column = new ClickHouseColumn(dataType, columnName, null, nullable, false, null, null);
        column.precision = precision;
        column.scale = scale;
        return column;
    }

    public static ClickHouseColumn of(String columnName, ClickHouseDataType dataType, boolean nullable, boolean lowCardinality, String ... parameters) {
        return ClickHouseColumn.update(new ClickHouseColumn(dataType, columnName, null, nullable, lowCardinality, Arrays.asList(parameters), null));
    }

    public static ClickHouseColumn of(String columnName, ClickHouseDataType dataType, boolean nullable, ClickHouseColumn ... nestedColumns) {
        return ClickHouseColumn.update(new ClickHouseColumn(dataType, columnName, null, nullable, false, null, Arrays.asList(nestedColumns)));
    }

    public static ClickHouseColumn of(String columnName, String columnType) {
        if (columnName == null || columnType == null) {
            throw new IllegalArgumentException("Non-null columnName and columnType are required");
        }
        ArrayList<ClickHouseColumn> list = new ArrayList<ClickHouseColumn>(1);
        ClickHouseColumn.readColumn(columnType, 0, columnType.length(), columnName, list);
        if (list.size() != 1) {
            throw new IllegalArgumentException("Failed to parse given column");
        }
        return (ClickHouseColumn)list.get(0);
    }

    public static List<ClickHouseColumn> parse(String args) {
        if (args == null || args.isEmpty()) {
            return Collections.emptyList();
        }
        String name = null;
        ClickHouseColumn column = null;
        LinkedList<ClickHouseColumn> list = new LinkedList<ClickHouseColumn>();
        StringBuilder builder = new StringBuilder();
        int len = args.length();
        for (int i = 0; i < len; ++i) {
            char ch = args.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            if (name == null) {
                i = ClickHouseUtils.readNameOrQuotedString(args, i, len, builder) - 1;
                name = builder.toString();
                builder.setLength(0);
                continue;
            }
            if (column == null) {
                LinkedList<ClickHouseColumn> colList = new LinkedList<ClickHouseColumn>();
                i = ClickHouseColumn.readColumn(args, i, len, name, colList) - 1;
                column = colList.getFirst();
                list.add(column);
                continue;
            }
            i = ClickHouseUtils.skipContentsUntil(args, i, len, ',') - 1;
            name = null;
            column = null;
        }
        ArrayList<ClickHouseColumn> c = new ArrayList<ClickHouseColumn>(list.size());
        for (ClickHouseColumn cc : list) {
            c.add(cc);
        }
        return Collections.unmodifiableList(c);
    }

    private ClickHouseColumn(String originalTypeName, String columnName) {
        this.originalTypeName = originalTypeName;
        this.columnName = columnName;
    }

    private ClickHouseColumn(ClickHouseDataType dataType, String columnName, String originalTypeName, boolean nullable, boolean lowCardinality, List<String> parameters, List<ClickHouseColumn> nestedColumns) {
        ArrayList<Object> list;
        this.aggFuncType = null;
        this.dataType = ClickHouseChecker.nonNull(dataType, "dataType");
        this.columnName = columnName == null ? "" : columnName;
        this.originalTypeName = originalTypeName == null ? dataType.name() : originalTypeName;
        this.nullable = nullable;
        this.lowCardinality = lowCardinality;
        if (parameters == null || parameters.isEmpty()) {
            this.parameters = Collections.emptyList();
        } else {
            list = new ArrayList<Object>(parameters.size());
            list.addAll(parameters);
            this.parameters = Collections.unmodifiableList(list);
        }
        if (nestedColumns == null || nestedColumns.isEmpty()) {
            this.nested = Collections.emptyList();
        } else {
            list = new ArrayList(nestedColumns.size());
            list.addAll(nestedColumns);
            this.nested = Collections.unmodifiableList(list);
        }
    }

    public boolean isAggregateFunction() {
        return this.dataType == ClickHouseDataType.AggregateFunction;
    }

    public boolean isArray() {
        return this.dataType == ClickHouseDataType.Array;
    }

    public boolean isEnum() {
        return this.dataType == ClickHouseDataType.Enum || this.dataType == ClickHouseDataType.Enum8 || this.dataType == ClickHouseDataType.Enum16;
    }

    public boolean isMap() {
        return this.dataType == ClickHouseDataType.Map;
    }

    public boolean isNested() {
        return this.dataType == ClickHouseDataType.Nested;
    }

    public boolean isTuple() {
        return this.dataType == ClickHouseDataType.Tuple;
    }

    public int getArrayNestedLevel() {
        return this.arrayLevel;
    }

    public ClickHouseColumn getArrayBaseColumn() {
        return this.arrayBaseColumn;
    }

    public ClickHouseDataType getDataType() {
        return this.dataType;
    }

    public ClickHouseEnum getEnumConstants() {
        return this.enumConstants;
    }

    public String getOriginalTypeName() {
        return this.originalTypeName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    boolean isLowCardinality() {
        return this.lowCardinality;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public TimeZone getTimeZoneOrDefault(TimeZone defaultTz) {
        return this.timeZone != null ? this.timeZone : defaultTz;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean hasNestedColumn() {
        return !this.nested.isEmpty();
    }

    public List<ClickHouseColumn> getNestedColumns() {
        return this.nested;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public ClickHouseColumn getKeyInfo() {
        return this.dataType == ClickHouseDataType.Map && this.nested.size() == 2 ? this.nested.get(0) : null;
    }

    public ClickHouseColumn getValueInfo() {
        return this.dataType == ClickHouseDataType.Map && this.nested.size() == 2 ? this.nested.get(1) : null;
    }

    public String getFunction() {
        return this.dataType == ClickHouseDataType.AggregateFunction ? this.parameters.get(0) : null;
    }

    public ClickHouseAggregateFunction getAggregateFunction() {
        return this.aggFuncType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.arrayBaseColumn == null ? 0 : this.arrayBaseColumn.hashCode());
        result = 31 * result + (this.aggFuncType == null ? 0 : this.aggFuncType.hashCode());
        result = 31 * result + this.arrayLevel;
        result = 31 * result + (this.columnName == null ? 0 : this.columnName.hashCode());
        result = 31 * result + (this.dataType == null ? 0 : this.dataType.hashCode());
        result = 31 * result + (this.lowCardinality ? 1231 : 1237);
        result = 31 * result + (this.nested == null ? 0 : this.nested.hashCode());
        result = 31 * result + (this.nullable ? 1231 : 1237);
        result = 31 * result + (this.originalTypeName == null ? 0 : this.originalTypeName.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + this.precision;
        result = 31 * result + this.scale;
        result = 31 * result + (this.timeZone == null ? 0 : this.timeZone.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClickHouseColumn other = (ClickHouseColumn)obj;
        return Objects.equals(this.arrayBaseColumn, other.arrayBaseColumn) && this.aggFuncType == other.aggFuncType && this.arrayLevel == other.arrayLevel && Objects.equals(this.columnName, other.columnName) && this.dataType == other.dataType && this.lowCardinality == other.lowCardinality && Objects.equals(this.nested, other.nested) && this.nullable == other.nullable && Objects.equals(this.originalTypeName, other.originalTypeName) && Objects.equals(this.parameters, other.parameters) && this.precision == other.precision && this.scale == other.scale && Objects.equals(this.timeZone, other.timeZone);
    }

    public String toString() {
        return (this.columnName == null || this.columnName.isEmpty() ? "column" : this.columnName) + ' ' + this.originalTypeName;
    }
}

