/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseByteBuffer;
import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.config.ClickHouseClientOption;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public abstract class ClickHouseOutputStream
extends OutputStream {
    protected final Runnable afterClose;
    protected boolean closed;

    public static ClickHouseOutputStream of(OutputStream output) {
        return ClickHouseOutputStream.of(output, (Integer)ClickHouseClientOption.MAX_BUFFER_SIZE.getDefaultValue());
    }

    public static ClickHouseOutputStream of(OutputStream output, int bufferSize) {
        return ClickHouseOutputStream.of(output, bufferSize, null);
    }

    public static ClickHouseOutputStream of(OutputStream output, int bufferSize, Runnable afterClose) {
        return output instanceof ClickHouseOutputStream ? (ClickHouseOutputStream)output : new WrappedOutputStream(output, bufferSize, afterClose);
    }

    protected ClickHouseOutputStream(Runnable afterClose) {
        this.afterClose = afterClose;
        this.closed = false;
    }

    @Override
    public final void write(int b) throws IOException {
        this.writeByte((byte)(0xFF & b));
    }

    @Override
    public final void write(byte[] b) throws IOException {
        this.writeBytes(b, 0, b.length);
    }

    @Override
    public final void write(byte[] b, int off, int len) throws IOException {
        this.writeBytes(b, off, len);
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (this.afterClose != null) {
                this.afterClose.run();
            }
        }
    }

    public abstract ClickHouseOutputStream writeByte(byte var1) throws IOException;

    public ClickHouseOutputStream writeBytes(ByteBuffer buffer, int offset, int length) throws IOException {
        if (buffer == null || offset < 0 || length < 0) {
            throw new IllegalArgumentException("Non-null ByteBuffer and positive offset and length are required");
        }
        byte[] bytes = new byte[length];
        buffer.get(bytes, offset, length);
        return this.writeBytes(bytes, 0, length);
    }

    public abstract ClickHouseOutputStream writeBytes(byte[] var1, int var2, int var3) throws IOException;

    public ClickHouseOutputStream writeBytes(ClickHouseByteBuffer buffer) throws IOException {
        if (buffer == null || buffer.isEmpty()) {
            return this;
        }
        return this.writeBytes(buffer.array(), buffer.position(), buffer.limit() - buffer.position());
    }

    public ClickHouseOutputStream writeString(String value, Charset charset) throws IOException {
        if (value == null || value.isEmpty()) {
            return this.writeByte((byte)0);
        }
        byte[] bytes = value.getBytes(charset != null ? charset : StandardCharsets.UTF_8);
        int len = bytes.length;
        this.writeVarInt(len);
        return this.writeBytes(bytes, 0, len);
    }

    public ClickHouseOutputStream writeAsciiString(String value) throws IOException {
        return this.writeString(value, StandardCharsets.US_ASCII);
    }

    public ClickHouseOutputStream writeUnicodeString(String value) throws IOException {
        return this.writeString(value, StandardCharsets.UTF_8);
    }

    public ClickHouseOutputStream writeVarInt(int value) throws IOException {
        return this.writeUnsignedVarInt(value);
    }

    public ClickHouseOutputStream writeUnsignedVarInt(long value) throws IOException {
        for (int i = 0; i < 9; ++i) {
            byte b = (byte)(value & 0x7FL);
            if (value > 127L) {
                b = (byte)(b | 0x80);
            }
            this.writeByte(b);
            if ((value >>= 7) == 0L) break;
        }
        return this;
    }

    static class WrappedOutputStream
    extends ClickHouseOutputStream {
        private final byte[] buffer;
        private final OutputStream out;
        private int count;

        private void flushBuffer() throws IOException {
            if (this.count > 0) {
                this.out.write(this.buffer, 0, this.count);
                this.count = 0;
            }
        }

        protected WrappedOutputStream(OutputStream out, int bufferSize, Runnable afterClose) {
            super(afterClose);
            this.buffer = new byte[bufferSize <= 0 ? 8192 : bufferSize];
            this.out = ClickHouseChecker.nonNull(out, "OutputStream");
            this.count = 0;
        }

        protected void ensureOpen() throws IOException {
            if (this.closed) {
                throw new IOException("Cannot operate on a closed output stream");
            }
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                this.flushBuffer();
                this.out.close();
            }
            finally {
                super.close();
            }
        }

        @Override
        public void flush() throws IOException {
            this.ensureOpen();
            this.flushBuffer();
            this.out.flush();
        }

        @Override
        public ClickHouseOutputStream writeByte(byte b) throws IOException {
            this.ensureOpen();
            if (this.count >= this.buffer.length) {
                this.flushBuffer();
            }
            this.buffer[this.count++] = b;
            return this;
        }

        @Override
        public ClickHouseOutputStream writeBytes(byte[] bytes, int offset, int length) throws IOException {
            this.ensureOpen();
            int len = this.buffer.length;
            if (length >= len) {
                this.flushBuffer();
                this.out.write(bytes, offset, length);
            } else {
                if (length > len - this.count) {
                    this.flushBuffer();
                }
                System.arraycopy(bytes, offset, this.buffer, this.count, length);
                this.count += length;
            }
            return this;
        }
    }
}

