/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Objects;
import java.util.UUID;

public class ClickHouseStringValue
implements ClickHouseValue {
    private String value;

    public static ClickHouseStringValue ofNull() {
        return ClickHouseStringValue.ofNull(null);
    }

    public static ClickHouseStringValue ofNull(ClickHouseValue ref) {
        return ref instanceof ClickHouseStringValue ? ((ClickHouseStringValue)ref).set(null) : new ClickHouseStringValue(null);
    }

    public static ClickHouseStringValue of(String value) {
        return ClickHouseStringValue.of(null, value);
    }

    public static ClickHouseStringValue of(ClickHouseValue ref, String value) {
        return ref instanceof ClickHouseStringValue ? ((ClickHouseStringValue)ref).set(value) : new ClickHouseStringValue(value);
    }

    protected ClickHouseStringValue(String value) {
        this.update(value);
    }

    protected ClickHouseStringValue set(String value) {
        this.value = value;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public ClickHouseStringValue copy(boolean deep) {
        return new ClickHouseStringValue(this.value);
    }

    @Override
    public boolean isNullOrEmpty() {
        return this.value == null;
    }

    @Override
    public boolean asBoolean() {
        return !this.isNullOrEmpty() && Boolean.parseBoolean(this.value);
    }

    @Override
    public byte asByte() {
        return this.isNullOrEmpty() ? (byte)0 : Byte.parseByte(this.value);
    }

    @Override
    public short asShort() {
        return this.isNullOrEmpty() ? (short)0 : Short.parseShort(this.value);
    }

    @Override
    public int asInteger() {
        return this.isNullOrEmpty() ? 0 : Integer.parseInt(this.value);
    }

    @Override
    public long asLong() {
        return this.isNullOrEmpty() ? 0L : Long.parseLong(this.value);
    }

    @Override
    public BigInteger asBigInteger() {
        return this.isNullOrEmpty() ? null : new BigInteger(this.value);
    }

    @Override
    public float asFloat() {
        return this.isNullOrEmpty() ? 0.0f : Float.parseFloat(this.value);
    }

    @Override
    public double asDouble() {
        return this.isNullOrEmpty() ? 0.0 : Double.parseDouble(this.value);
    }

    @Override
    public BigDecimal asBigDecimal(int scale) {
        return this.isNullOrEmpty() ? null : new BigDecimal(this.asBigInteger(), scale);
    }

    @Override
    public LocalDate asDate() {
        return this.isNullOrEmpty() ? null : LocalDate.parse(this.value, ClickHouseValues.DATE_FORMATTER);
    }

    @Override
    public LocalTime asTime() {
        return this.isNullOrEmpty() ? null : LocalTime.parse(this.value, ClickHouseValues.TIME_FORMATTER);
    }

    @Override
    public LocalDateTime asDateTime(int scale) {
        return this.isNullOrEmpty() ? null : LocalDateTime.parse(this.value, ClickHouseValues.DATETIME_FORMATTER);
    }

    @Override
    public <T extends Enum<T>> T asEnum(Class<T> enumType) {
        return this.isNullOrEmpty() ? null : (T)Enum.valueOf(enumType, this.value);
    }

    @Override
    public Inet4Address asInet4Address() {
        return ClickHouseValues.convertToIpv4(this.getValue());
    }

    @Override
    public Inet6Address asInet6Address() {
        return ClickHouseValues.convertToIpv6(this.getValue());
    }

    @Override
    public Object asObject() {
        return this.value;
    }

    @Override
    public String asString() {
        return this.value;
    }

    @Override
    public String asString(int length, Charset charset) {
        if (this.value != null && length > 0) {
            ClickHouseChecker.notWithDifferentLength(this.value.getBytes(charset == null ? StandardCharsets.UTF_8 : charset), length);
        }
        return this.value;
    }

    @Override
    public UUID asUuid() {
        return this.isNullOrEmpty() ? null : UUID.fromString(this.value);
    }

    @Override
    public ClickHouseStringValue resetToNullOrEmpty() {
        return this.set(null);
    }

    @Override
    public String toSqlExpression() {
        return ClickHouseValues.convertToQuotedString(this.value);
    }

    @Override
    public ClickHouseStringValue update(boolean value) {
        return this.set(String.valueOf(value));
    }

    @Override
    public ClickHouseStringValue update(char value) {
        return this.set(String.valueOf((int)value));
    }

    @Override
    public ClickHouseStringValue update(byte value) {
        return this.set(String.valueOf(value));
    }

    @Override
    public ClickHouseStringValue update(short value) {
        return this.set(String.valueOf(value));
    }

    @Override
    public ClickHouseStringValue update(int value) {
        return this.set(String.valueOf(value));
    }

    @Override
    public ClickHouseStringValue update(long value) {
        return this.set(String.valueOf(value));
    }

    @Override
    public ClickHouseStringValue update(float value) {
        return this.set(String.valueOf(value));
    }

    @Override
    public ClickHouseStringValue update(double value) {
        return this.set(String.valueOf(value));
    }

    @Override
    public ClickHouseValue update(BigInteger value) {
        return this.set(value == null ? null : String.valueOf(value));
    }

    @Override
    public ClickHouseValue update(BigDecimal value) {
        return this.set(value == null ? null : String.valueOf(value));
    }

    @Override
    public ClickHouseStringValue update(Enum<?> value) {
        return this.set(value == null ? null : value.name());
    }

    @Override
    public ClickHouseStringValue update(Inet4Address value) {
        return this.set(value == null ? null : value.getHostAddress());
    }

    @Override
    public ClickHouseStringValue update(Inet6Address value) {
        return this.set(value == null ? null : value.getHostAddress());
    }

    @Override
    public ClickHouseStringValue update(LocalDate value) {
        return this.set(value == null ? null : value.format(ClickHouseValues.DATE_FORMATTER));
    }

    @Override
    public ClickHouseStringValue update(LocalTime value) {
        return this.set(value == null ? null : value.format(ClickHouseValues.TIME_FORMATTER));
    }

    @Override
    public ClickHouseStringValue update(LocalDateTime value) {
        return this.set(value == null ? null : value.format(ClickHouseValues.DATETIME_FORMATTER));
    }

    @Override
    public ClickHouseStringValue update(String value) {
        return this.set(value);
    }

    @Override
    public ClickHouseStringValue update(UUID value) {
        return this.set(value == null ? null : value.toString());
    }

    @Override
    public ClickHouseStringValue update(ClickHouseValue value) {
        return this.set(value == null ? null : value.asString());
    }

    @Override
    public ClickHouseStringValue update(Object value) {
        return this.update(value == null ? null : value.toString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClickHouseStringValue v = (ClickHouseStringValue)obj;
        return this.value == v.value || this.value != null && this.value.equals(v.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return ClickHouseValues.convertToString(this);
    }
}

