/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.config.ClickHouseClientOption;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public abstract class ClickHouseInputStream
extends InputStream {
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final ByteBuffer EMPTY_BUFFER = ByteBuffer.wrap(EMPTY_BYTES).asReadOnlyBuffer();

    public static ClickHouseInputStream of(BlockingQueue<ByteBuffer> queue, int timeout) {
        return new BlockingInputStream(queue, timeout);
    }

    public static ClickHouseInputStream of(InputStream input) {
        return ClickHouseInputStream.of(input, (int)((Integer)ClickHouseClientOption.MAX_BUFFER_SIZE.getDefaultValue()));
    }

    public static ClickHouseInputStream of(InputStream input, int bufferSize) {
        return input instanceof ClickHouseInputStream ? (ClickHouseInputStream)input : new WrappedInputStream(input, bufferSize);
    }

    public int readUnsignedByte() throws IOException {
        return 0xFF & this.readByte();
    }

    public abstract byte readByte() throws IOException;

    public byte[] readBytes(int length) throws IOException {
        if (length <= 0) {
            return EMPTY_BYTES;
        }
        byte[] bytes = new byte[length];
        int c = 0;
        int n = 0;
        for (int l = length; l > 0; l -= n) {
            n = this.read(bytes, c, l);
            if (n != -1) {
                c += n;
                continue;
            }
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw c == 0 ? new EOFException() : new IOException(ClickHouseUtils.format("Reached end of input stream after reading %d of %d bytes", c, length));
        }
        return bytes;
    }

    public String readString(Charset charset) throws IOException {
        return this.readString(this.readVarInt(), charset);
    }

    public String readString(int byteLength, Charset charset) throws IOException {
        if (byteLength < 1) {
            return "";
        }
        return new String(this.readBytes(byteLength), charset != null ? charset : StandardCharsets.UTF_8);
    }

    public String readAsciiString() throws IOException {
        return this.readString(this.readVarInt(), StandardCharsets.US_ASCII);
    }

    public String readAsciiString(int byteLength) throws IOException {
        return this.readString(byteLength, StandardCharsets.US_ASCII);
    }

    public String readUnicodeString() throws IOException {
        return this.readString(this.readVarInt(), StandardCharsets.UTF_8);
    }

    public String readUnicodeString(int byteLength) throws IOException {
        return this.readString(byteLength, StandardCharsets.UTF_8);
    }

    public int readVarInt() throws IOException {
        long result = 0L;
        int shift = 0;
        for (int i = 0; i < 9; ++i) {
            byte b = this.readByte();
            result |= (long)((b & 0x7F) << shift);
            if ((b & 0x80) == 0) break;
            shift += 7;
        }
        return (int)result;
    }

    public abstract boolean isClosed();

    static final class WrappedInputStream
    extends ClickHouseInputStream {
        private final InputStream in;
        private final byte[] buffer;
        private int position;
        private int limit;
        private boolean closed;

        WrappedInputStream(InputStream input, int bufferSize) {
            this.in = ClickHouseChecker.nonNull(input, "InputStream");
            this.buffer = new byte[bufferSize];
            this.position = 0;
            this.limit = 0;
            this.closed = false;
        }

        private void ensureOpen() throws IOException {
            if (this.closed) {
                throw new IOException(ClickHouseUtils.format("Wrapped stream(%s) has been closed", this.in));
            }
        }

        private int updateBuffer() throws IOException {
            if (this.closed) {
                return -1;
            }
            this.position = 0;
            int count = this.in.read(this.buffer);
            this.limit = count > 0 ? count : 0;
            return count;
        }

        @Override
        public int available() throws IOException {
            return !this.closed && (this.position < this.limit || this.updateBuffer() > 0) ? this.limit - this.position : 0;
        }

        @Override
        public byte readByte() throws IOException {
            if (this.position >= this.limit && this.updateBuffer() < 0) {
                try {
                    this.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new EOFException();
            }
            return this.buffer[this.position++];
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                try {
                    this.in.close();
                }
                finally {
                    this.closed = true;
                    this.position = 0;
                    this.limit = 0;
                }
            }
        }

        @Override
        public int read() throws IOException {
            this.ensureOpen();
            int value = -1;
            if (this.position < this.limit || this.updateBuffer() > 0) {
                value = 0xFF & this.buffer[this.position++];
            }
            return value;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int counter;
            int size;
            if (this.position >= this.limit && this.updateBuffer() < 0) {
                return -1;
            }
            this.ensureOpen();
            for (counter = 0; counter < len; counter += size) {
                size = Math.min(this.limit - this.position, len - counter);
                System.arraycopy(this.buffer, this.position, b, off, size);
                this.position += size;
                off += size;
                if (this.position < this.limit || this.updateBuffer() >= 0) continue;
                break;
            }
            return counter;
        }

        @Override
        public byte[] readBytes(int length) throws IOException {
            int size;
            if (length <= 0) {
                return EMPTY_BYTES;
            }
            this.ensureOpen();
            byte[] bytes = new byte[length];
            int offset = 0;
            for (int counter = 0; counter < length; counter += size) {
                if (this.position >= this.limit && this.updateBuffer() < 0) {
                    try {
                        this.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw counter == 0 ? new EOFException() : new IOException(ClickHouseUtils.format("Reached end of input stream after reading %d of %d bytes", counter, bytes.length));
                }
                size = Math.min(this.limit - this.position, length - counter);
                System.arraycopy(this.buffer, this.position, bytes, offset, size);
                this.position += size;
                offset += size;
            }
            return bytes;
        }

        @Override
        public String readString(int byteLength, Charset charset) throws IOException {
            this.ensureOpen();
            if (byteLength < 1) {
                return "";
            }
            if (charset == null) {
                charset = StandardCharsets.UTF_8;
            }
            if (this.limit - this.position > byteLength) {
                int offset = this.position;
                this.position += byteLength;
                return new String(this.buffer, offset, byteLength, charset);
            }
            return new String(this.readBytes(byteLength), charset);
        }

        @Override
        public long skip(long n) throws IOException {
            this.ensureOpen();
            long counter = 0L;
            while (n > 0L && (this.position < this.limit || this.updateBuffer() >= 0)) {
                int remain = this.limit - this.position;
                if (n > (long)remain) {
                    n -= (long)remain;
                    counter += (long)remain;
                    this.position = this.limit;
                    continue;
                }
                counter += n;
                this.position = (int)((long)this.position + n);
                n = 0L;
            }
            return counter;
        }
    }

    static final class BlockingInputStream
    extends ClickHouseInputStream {
        private final BlockingQueue<ByteBuffer> queue;
        private final int timeout;
        private ByteBuffer buffer;
        private boolean closed;

        BlockingInputStream(BlockingQueue<ByteBuffer> queue, int timeout) {
            this.queue = ClickHouseChecker.nonNull(queue, "Queue");
            this.timeout = timeout;
            this.buffer = null;
            this.closed = false;
        }

        private void ensureOpen() throws IOException {
            if (this.closed) {
                throw new IOException(ClickHouseUtils.format("Blocking stream(queue: %d, buffer: %d) has been closed", this.queue.size(), this.buffer != null ? this.buffer.remaining() : 0));
            }
            if (this.buffer == null || this.buffer != EMPTY_BUFFER && !this.buffer.hasRemaining()) {
                this.updateBuffer();
            }
        }

        private int updateBuffer() throws IOException {
            try {
                if (this.timeout > 0) {
                    this.buffer = this.queue.poll(this.timeout, TimeUnit.MILLISECONDS);
                    if (this.buffer == null) {
                        throw new IOException(ClickHouseUtils.format("Read timed out after %d ms", this.timeout));
                    }
                } else {
                    this.buffer = this.queue.take();
                }
                return this.buffer.remaining();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Thread was interrupted when getting next buffer from queue", e);
            }
        }

        @Override
        public int available() throws IOException {
            if (this.closed || this.buffer == EMPTY_BUFFER) {
                return 0;
            }
            return this.buffer == null || !this.buffer.hasRemaining() ? this.updateBuffer() : this.buffer.remaining();
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            this.buffer = null;
        }

        @Override
        public byte readByte() throws IOException {
            this.ensureOpen();
            if (this.buffer == EMPTY_BUFFER) {
                this.close();
                throw new EOFException();
            }
            return this.buffer.get();
        }

        @Override
        public int read() throws IOException {
            this.ensureOpen();
            if (this.buffer == EMPTY_BUFFER) {
                return -1;
            }
            return 0xFF & this.buffer.get();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.ensureOpen();
            int counter = 0;
            while (len > 0) {
                if (this.buffer == EMPTY_BUFFER) {
                    return counter > 0 ? counter : -1;
                }
                int remain = this.buffer.remaining();
                if (remain >= len) {
                    this.buffer.get(b, off, len);
                    counter += len;
                    len = 0;
                    continue;
                }
                this.buffer.get(b, off, remain);
                counter += remain;
                off += remain;
                len -= remain;
                this.updateBuffer();
            }
            return counter;
        }

        @Override
        public String readString(int byteLength, Charset charset) throws IOException {
            this.ensureOpen();
            if (byteLength < 1) {
                return "";
            }
            if (charset == null) {
                charset = StandardCharsets.UTF_8;
            }
            if (!this.buffer.isReadOnly() && byteLength > 8 && this.buffer.remaining() > byteLength) {
                int pos = this.buffer.position();
                ((Buffer)this.buffer).position(pos + byteLength);
                return charset.decode(ByteBuffer.wrap(this.buffer.array(), pos, byteLength)).toString();
            }
            return new String(this.readBytes(byteLength), charset);
        }

        @Override
        public long skip(long n) throws IOException {
            this.ensureOpen();
            if (n == Long.MAX_VALUE) {
                long counter = this.buffer.remaining();
                while (this.buffer != EMPTY_BUFFER && this.buffer.limit() > 0) {
                    counter += (long)this.buffer.limit();
                    this.updateBuffer();
                }
                return counter;
            }
            return super.skip(n);
        }
    }
}

