/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.benchmark;

import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.infra.Blackhole;

public abstract class BaseState {
    private final Random random = new Random();
    private final Semaphore available;
    private final ExecutorService executor;

    public BaseState() {
        int consumers = Integer.parseInt(System.getProperty("consumers", "0"));
        if (consumers > 0) {
            this.available = new Semaphore(consumers);
            this.executor = Executors.newSingleThreadExecutor();
        } else {
            this.available = null;
            this.executor = null;
        }
    }

    protected int getRandomNumber(int bound) {
        return bound < 1 ? 0 : this.random.nextInt(bound);
    }

    protected void consume(Blackhole blackhole, Callable<?> task) throws InterruptedException {
        if (this.available != null) {
            this.available.acquire();
            this.executor.submit(() -> {
                try {
                    blackhole.consume(task.call());
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
                finally {
                    this.available.release();
                }
            });
        } else {
            try {
                blackhole.consume(task.call());
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    protected void dispose() {
        if (this.executor != null) {
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

