/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.pushtemplates;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.clevertap.android.pushtemplates.PTLog;
import com.clevertap.android.pushtemplates.Utils;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.pushnotification.CTPushNotificationReceiver;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.Task;
import java.util.concurrent.Callable;

public class PTPushNotificationReceiver
extends CTPushNotificationReceiver {
    public void onReceive(final Context context, final Intent intent) {
        if (intent.getStringExtra("wzrk_dl") == null) {
            intent.removeExtra("wzrk_dl");
        }
        super.onReceive(context, intent);
        Bundle extras = intent.getExtras();
        if (extras == null) {
            return;
        }
        CleverTapAPI cleverTapAPI = CleverTapAPI.getGlobalInstance((Context)context, (String)extras.getString("wzrk_acct_id"));
        if (cleverTapAPI != null) {
            try {
                CleverTapInstanceConfig config = cleverTapAPI.getCoreState().getConfig();
                Task task = CTExecutorFactory.executors((CleverTapInstanceConfig)config).postAsyncSafelyTask();
                task.execute("PTPushNotificationReceiver#cleanUpFiles", (Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        try {
                            Utils.deleteImageFromStorage(context, intent);
                            Utils.deleteSilentNotificationChannel(context);
                        }
                        catch (Throwable t) {
                            PTLog.verbose("Couldn't clean up images and/or couldn't delete silent notification channel: " + t.getLocalizedMessage());
                        }
                        return null;
                    }
                });
            }
            catch (Exception e) {
                PTLog.verbose("Couldn't clean up images and/or couldn't delete silent notification channel: " + e.getLocalizedMessage());
            }
        } else {
            PTLog.verbose("clevertap instance is null, not running PTPushNotificationReceiver#cleanUpFiles");
        }
    }
}

