/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.variables;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.variables.CTVariableUtils;
import com.clevertap.android.sdk.variables.JsonUtil;
import com.clevertap.android.sdk.variables.VarCache;
import com.clevertap.android.sdk.variables.callbacks.FetchVariablesCallback;
import com.clevertap.android.sdk.variables.callbacks.VariablesChangedCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.json.JSONArray;
import org.json.JSONObject;

public class CTVariables {
    private boolean hasVarsRequestCompleted = false;
    private boolean preRegisteredFilesDownloaded = false;
    private final List<VariablesChangedCallback> variablesChangedCallbacks = new ArrayList<VariablesChangedCallback>();
    private final List<VariablesChangedCallback> oneTimeVariablesChangedCallbacks = new ArrayList<VariablesChangedCallback>();
    private final List<VariablesChangedCallback> variablesChangedCallbacksNoDownloadsPending = new ArrayList<VariablesChangedCallback>();
    private final List<VariablesChangedCallback> oneTimeVariablesChangedCallbacksNoDownloadsPending = new ArrayList<VariablesChangedCallback>();
    private final VarCache varCache;

    private static void logD(String msg) {
        Logger.d("variables", msg);
    }

    public CTVariables(VarCache varCache) {
        this.varCache = varCache;
        Runnable triggerGlobalCallbacks = () -> {
            List<VariablesChangedCallback> list = this.variablesChangedCallbacks;
            synchronized (list) {
                for (VariablesChangedCallback callback : this.variablesChangedCallbacks) {
                    Utils.runOnUiThread(callback);
                }
            }
            list = this.oneTimeVariablesChangedCallbacks;
            synchronized (list) {
                for (VariablesChangedCallback callback : this.oneTimeVariablesChangedCallbacks) {
                    Utils.runOnUiThread(callback);
                }
                this.oneTimeVariablesChangedCallbacks.clear();
            }
        };
        this.varCache.setGlobalCallbacksRunnable(triggerGlobalCallbacks);
    }

    public void init() {
        CTVariables.logD("init() called");
        this.varCache.loadDiffs((Function0<Unit>)((Function0)() -> null));
    }

    public void handleVariableResponse(@Nullable JSONObject response, @Nullable FetchVariablesCallback fetchCallback) {
        CTVariables.logD("handleVariableResponse() called with: response = [" + response + "]");
        if (response == null) {
            this.handleVariableResponseError(fetchCallback);
        } else {
            this.handleVariableResponseSuccess(response, fetchCallback);
        }
    }

    public void handleAbVariantsResponse(@Nullable JSONArray abVariants) {
        CTVariables.logD("handleVariantsResponse() called with: abVariants  " + abVariants);
        List<Map<String, Object>> list = JsonUtil.listFromJsonFromDefault(abVariants);
        this.varCache.updateAbVariants(list);
    }

    public void handleVariableResponseError(@Nullable FetchVariablesCallback fetchCallback) {
        if (!this.hasVarsRequestCompleted().booleanValue()) {
            this.setHasVarsRequestCompleted(true);
            this.varCache.loadDiffsAndTriggerHandlers((Function0<Unit>)((Function0)() -> {
                this.triggerGlobalFilesCallbacks();
                this.preRegisteredFilesDownloaded = true;
                return null;
            }));
        }
        if (fetchCallback != null) {
            fetchCallback.onVariablesFetched(false);
        }
    }

    private void handleVariableResponseSuccess(@NonNull JSONObject response, @Nullable FetchVariablesCallback fetchCallback) {
        this.setHasVarsRequestCompleted(true);
        Map<String, Object> variableDiffs = JsonUtil.mapFromJson(response);
        variableDiffs = CTVariableUtils.convertFlatMapToNestedMaps(variableDiffs);
        this.varCache.updateDiffsAndTriggerHandlers(variableDiffs, (Function0<Unit>)((Function0)() -> {
            this.triggerGlobalFilesCallbacks();
            this.preRegisteredFilesDownloaded = true;
            return null;
        }));
        if (fetchCallback != null) {
            fetchCallback.onVariablesFetched(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerGlobalFilesCallbacks() {
        List<VariablesChangedCallback> list = this.variablesChangedCallbacksNoDownloadsPending;
        synchronized (list) {
            for (VariablesChangedCallback callback : this.variablesChangedCallbacksNoDownloadsPending) {
                Utils.runOnUiThread(callback);
            }
        }
        list = this.oneTimeVariablesChangedCallbacksNoDownloadsPending;
        synchronized (list) {
            for (VariablesChangedCallback callback : this.oneTimeVariablesChangedCallbacksNoDownloadsPending) {
                Utils.runOnUiThread(callback);
            }
            this.oneTimeVariablesChangedCallbacksNoDownloadsPending.clear();
        }
    }

    public void clearUserContent() {
        CTVariables.logD("Clear user content in CTVariables");
        this.setHasVarsRequestCompleted(false);
        this.preRegisteredFilesDownloaded = false;
        this.varCache.clearUserContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVariablesChangedCallback(@NonNull VariablesChangedCallback callback) {
        List<VariablesChangedCallback> list = this.variablesChangedCallbacks;
        synchronized (list) {
            this.variablesChangedCallbacks.add(callback);
        }
        if (this.hasVarsRequestCompleted) {
            callback.variablesChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOneTimeVariablesChangedCallback(@NonNull VariablesChangedCallback callback) {
        if (this.hasVarsRequestCompleted) {
            callback.variablesChanged();
        } else {
            List<VariablesChangedCallback> list = this.oneTimeVariablesChangedCallbacks;
            synchronized (list) {
                this.oneTimeVariablesChangedCallbacks.add(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onVariablesChangedAndNoDownloadsPending(@NonNull VariablesChangedCallback callback) {
        List<VariablesChangedCallback> list = this.variablesChangedCallbacksNoDownloadsPending;
        synchronized (list) {
            this.variablesChangedCallbacksNoDownloadsPending.add(callback);
        }
        if (this.preRegisteredFilesDownloaded) {
            callback.variablesChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onceVariablesChangedAndNoDownloadsPending(@NonNull VariablesChangedCallback callback) {
        if (this.preRegisteredFilesDownloaded) {
            callback.variablesChanged();
        } else {
            List<VariablesChangedCallback> list = this.oneTimeVariablesChangedCallbacksNoDownloadsPending;
            synchronized (list) {
                this.oneTimeVariablesChangedCallbacksNoDownloadsPending.add(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVariablesChangedCallback(@NonNull VariablesChangedCallback callback) {
        List<VariablesChangedCallback> list = this.variablesChangedCallbacks;
        synchronized (list) {
            this.variablesChangedCallbacks.remove(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOneTimeVariablesChangedHandler(@NonNull VariablesChangedCallback callback) {
        List<VariablesChangedCallback> list = this.oneTimeVariablesChangedCallbacks;
        synchronized (list) {
            this.oneTimeVariablesChangedCallbacks.remove(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllVariablesChangedCallbacks() {
        List<VariablesChangedCallback> list = this.variablesChangedCallbacks;
        synchronized (list) {
            this.variablesChangedCallbacks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllOneTimeVariablesChangedCallbacks() {
        List<VariablesChangedCallback> list = this.oneTimeVariablesChangedCallbacks;
        synchronized (list) {
            this.oneTimeVariablesChangedCallbacks.clear();
        }
    }

    public Boolean hasVarsRequestCompleted() {
        return this.hasVarsRequestCompleted;
    }

    public void setHasVarsRequestCompleted(boolean completed) {
        this.hasVarsRequestCompleted = completed;
    }

    VarCache getVarCache() {
        return this.varCache;
    }
}

