/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.validation.propertykey;

import com.clevertap.android.sdk.validation.DropReason;
import com.clevertap.android.sdk.validation.ValidationConfig;
import com.clevertap.android.sdk.validation.ValidationError;
import com.clevertap.android.sdk.validation.ValidationOutcome;
import com.clevertap.android.sdk.validation.ValidationResult;
import com.clevertap.android.sdk.validation.ValidationResultFactory;
import com.clevertap.android.sdk.validation.pipeline.KeyModification;
import com.clevertap.android.sdk.validation.pipeline.ModificationReason;
import com.clevertap.android.sdk.validation.pipeline.PropertyKeyNormalizationResult;
import com.clevertap.android.sdk.validation.pipeline.Validator;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/clevertap/android/sdk/validation/propertykey/EventPropertyKeyValidator;", "Lcom/clevertap/android/sdk/validation/pipeline/Validator;", "Lcom/clevertap/android/sdk/validation/pipeline/PropertyKeyNormalizationResult;", "<init>", "()V", "validate", "Lcom/clevertap/android/sdk/validation/ValidationOutcome;", "input", "config", "Lcom/clevertap/android/sdk/validation/ValidationConfig;", "clevertap-core_release"})
@SourceDebugExtension(value={"SMAP\nEventPropertyKeyValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventPropertyKeyValidator.kt\ncom/clevertap/android/sdk/validation/propertykey/EventPropertyKeyValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1863#2:65\n1863#2,2:66\n1864#2:68\n*S KotlinDebug\n*F\n+ 1 EventPropertyKeyValidator.kt\ncom/clevertap/android/sdk/validation/propertykey/EventPropertyKeyValidator\n*L\n33#1:65\n34#1:66,2\n33#1:68\n*E\n"})
public final class EventPropertyKeyValidator
implements Validator<PropertyKeyNormalizationResult> {
    @Override
    @NotNull
    public ValidationOutcome validate(@NotNull PropertyKeyNormalizationResult input, @NotNull ValidationConfig config) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        List errors = new ArrayList();
        if (input.getWasRemoved()) {
            ValidationResult error = ValidationResultFactory.create(ValidationError.EMPTY_KEY_ABORT, new String[0]);
            errors.add(error);
            return new ValidationOutcome.Drop(errors, DropReason.EMPTY_KEY);
        }
        Iterable $this$forEach$iv = input.getModifications();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KeyModification modification = (KeyModification)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = modification.getReasons();
            boolean $i$f$forEach2 = false;
            block5: for (Object element$iv2 : $this$forEach$iv2) {
                Object object;
                ModificationReason reason = (ModificationReason)((Object)element$iv2);
                boolean bl2 = false;
                switch (WhenMappings.$EnumSwitchMapping$0[reason.ordinal()]) {
                    case 1: {
                        String[] stringArray = new String[]{modification.getOriginalKey(), modification.getCleanedKey()};
                        object = ValidationResultFactory.create(ValidationError.KEY_INVALID_CHARACTERS, stringArray);
                        break;
                    }
                    case 2: {
                        object = config.getMaxKeyLength();
                        if (object == null) continue block5;
                        int limit = ((Number)object).intValue();
                        boolean bl3 = false;
                        String[] stringArray = new String[]{modification.getOriginalKey(), String.valueOf(limit), modification.getCleanedKey()};
                        ValidationResult validationResult = ValidationResultFactory.create(ValidationError.KEY_LENGTH_EXCEEDED, stringArray);
                        object = validationResult;
                        if (validationResult != null) break;
                        continue block5;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Object error = object;
                errors.add(error);
            }
        }
        return errors.isEmpty() ? (ValidationOutcome)new ValidationOutcome.Success(null, 1, null) : (ValidationOutcome)new ValidationOutcome.Warning(errors);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ModificationReason.values().length];
            try {
                nArray[ModificationReason.INVALID_CHARACTERS_REMOVED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModificationReason.TRUNCATED_TO_MAX_LENGTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

