/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.validation.eventdata;

import com.clevertap.android.sdk.validation.ValidationConfig;
import com.clevertap.android.sdk.validation.ValidationError;
import com.clevertap.android.sdk.validation.ValidationOutcome;
import com.clevertap.android.sdk.validation.ValidationResult;
import com.clevertap.android.sdk.validation.ValidationResultFactory;
import com.clevertap.android.sdk.validation.pipeline.EventDataMetrics;
import com.clevertap.android.sdk.validation.pipeline.EventDataNormalizationResult;
import com.clevertap.android.sdk.validation.pipeline.KeyModification;
import com.clevertap.android.sdk.validation.pipeline.ModificationReason;
import com.clevertap.android.sdk.validation.pipeline.RemovalReason;
import com.clevertap.android.sdk.validation.pipeline.RemovedItem;
import com.clevertap.android.sdk.validation.pipeline.Validator;
import com.clevertap.android.sdk.validation.pipeline.ValueModification;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016JU\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u00a2\u0006\u0002\u0010\u0017J-\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u00a2\u0006\u0002\u0010\u001aJ-\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u001c\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u001e\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u00a8\u0006\u001e"}, d2={"Lcom/clevertap/android/sdk/validation/eventdata/EventDataValidator;", "Lcom/clevertap/android/sdk/validation/pipeline/Validator;", "Lcom/clevertap/android/sdk/validation/pipeline/EventDataNormalizationResult;", "<init>", "()V", "validate", "Lcom/clevertap/android/sdk/validation/ValidationOutcome;", "input", "config", "Lcom/clevertap/android/sdk/validation/ValidationConfig;", "checkStructuralLimits", "", "metrics", "Lcom/clevertap/android/sdk/validation/pipeline/EventDataMetrics;", "maxDepth", "", "maxArrayKeyCount", "maxObjectKeyCount", "maxArrayLength", "maxKVPairCount", "errors", "", "Lcom/clevertap/android/sdk/validation/ValidationResult;", "(Lcom/clevertap/android/sdk/validation/pipeline/EventDataMetrics;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/util/List;)V", "checkKeyModifications", "maxKeyLength", "(Lcom/clevertap/android/sdk/validation/pipeline/EventDataMetrics;Ljava/lang/Integer;Ljava/util/List;)V", "checkValueModifications", "maxValueLength", "checkItemRemovals", "clevertap-core_release"})
@SourceDebugExtension(value={"SMAP\nEventDataValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventDataValidator.kt\ncom/clevertap/android/sdk/validation/eventdata/EventDataValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,231:1\n1863#2:232\n1863#2,2:233\n1864#2:235\n1863#2:236\n1863#2,2:237\n1864#2:239\n1863#2:240\n1864#2:242\n1#3:241\n*S KotlinDebug\n*F\n+ 1 EventDataValidator.kt\ncom/clevertap/android/sdk/validation/eventdata/EventDataValidator\n*L\n130#1:232\n131#1:233,2\n130#1:235\n161#1:236\n162#1:237,2\n161#1:239\n190#1:240\n190#1:242\n*E\n"})
public final class EventDataValidator
implements Validator<EventDataNormalizationResult> {
    @Override
    @NotNull
    public ValidationOutcome validate(@NotNull EventDataNormalizationResult input, @NotNull ValidationConfig config) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        List errors = new ArrayList();
        this.checkStructuralLimits(input.getMetrics(), config.getMaxDepth(), config.getMaxArrayKeyCount(), config.getMaxObjectKeyCount(), config.getMaxArrayLength(), config.getMaxKVPairCount(), errors);
        this.checkKeyModifications(input.getMetrics(), config.getMaxKeyLength(), errors);
        this.checkValueModifications(input.getMetrics(), config.getMaxValueLength(), errors);
        this.checkItemRemovals(input.getMetrics(), errors);
        return errors.isEmpty() ? (ValidationOutcome)new ValidationOutcome.Success(null, 1, null) : (ValidationOutcome)new ValidationOutcome.Warning(errors);
    }

    private final void checkStructuralLimits(EventDataMetrics metrics, Integer maxDepth, Integer maxArrayKeyCount, Integer maxObjectKeyCount, Integer maxArrayLength, Integer maxKVPairCount, List<ValidationResult> errors) {
        block9: {
            ValidationResult error;
            String[] stringArray;
            int limit;
            Integer n = maxDepth;
            if (n != null) {
                limit = ((Number)n).intValue();
                boolean bl = false;
                if (metrics.getMaxDepth() > limit) {
                    stringArray = new String[]{String.valueOf(metrics.getMaxDepth()), String.valueOf(limit)};
                    error = ValidationResultFactory.create(ValidationError.DEPTH_LIMIT_EXCEEDED, stringArray);
                    errors.add(error);
                }
            }
            Integer n2 = maxArrayKeyCount;
            if (n2 != null) {
                limit = ((Number)n2).intValue();
                boolean bl = false;
                if (metrics.getMaxArrayKeyCount() > limit) {
                    stringArray = new String[]{String.valueOf(metrics.getMaxArrayKeyCount()), String.valueOf(limit)};
                    error = ValidationResultFactory.create(ValidationError.ARRAY_KEY_COUNT_LIMIT_EXCEEDED, stringArray);
                    errors.add(error);
                }
            }
            Integer n3 = maxObjectKeyCount;
            if (n3 != null) {
                limit = ((Number)n3).intValue();
                boolean bl = false;
                if (metrics.getMaxObjectKeyCount() > limit) {
                    stringArray = new String[]{String.valueOf(metrics.getMaxObjectKeyCount()), String.valueOf(limit)};
                    error = ValidationResultFactory.create(ValidationError.OBJECT_KEY_COUNT_LIMIT_EXCEEDED, stringArray);
                    errors.add(error);
                }
            }
            Integer n4 = maxArrayLength;
            if (n4 != null) {
                limit = ((Number)n4).intValue();
                boolean bl = false;
                if (metrics.getMaxArrayLength() > limit) {
                    stringArray = new String[]{String.valueOf(metrics.getMaxArrayLength()), String.valueOf(limit)};
                    error = ValidationResultFactory.create(ValidationError.ARRAY_LENGTH_LIMIT_EXCEEDED, stringArray);
                    errors.add(error);
                }
            }
            Integer n5 = maxKVPairCount;
            if (n5 == null) break block9;
            limit = ((Number)n5).intValue();
            boolean bl = false;
            if (metrics.getMaxKVPairCount() > limit) {
                stringArray = new String[]{String.valueOf(metrics.getMaxKVPairCount()), String.valueOf(limit)};
                error = ValidationResultFactory.create(ValidationError.KV_PAIR_COUNT_LIMIT_EXCEEDED, stringArray);
                errors.add(error);
            }
        }
    }

    private final void checkKeyModifications(EventDataMetrics metrics, Integer maxKeyLength, List<ValidationResult> errors) {
        Iterable $this$forEach$iv = metrics.getKeysModified();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KeyModification modification = (KeyModification)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = modification.getReasons();
            boolean $i$f$forEach2 = false;
            block5: for (Object element$iv2 : $this$forEach$iv2) {
                Object object;
                ModificationReason reason = (ModificationReason)((Object)element$iv2);
                boolean bl2 = false;
                switch (WhenMappings.$EnumSwitchMapping$0[reason.ordinal()]) {
                    case 1: {
                        String[] stringArray = new String[]{modification.getOriginalKey(), modification.getCleanedKey()};
                        object = ValidationResultFactory.create(ValidationError.KEY_INVALID_CHARACTERS, stringArray);
                        break;
                    }
                    case 2: {
                        object = maxKeyLength;
                        if (object == null) continue block5;
                        int limit = ((Number)object).intValue();
                        boolean bl3 = false;
                        String[] stringArray = new String[]{modification.getOriginalKey(), String.valueOf(limit), modification.getCleanedKey()};
                        ValidationResult validationResult = ValidationResultFactory.create(ValidationError.KEY_LENGTH_EXCEEDED, stringArray);
                        object = validationResult;
                        if (validationResult != null) break;
                        continue block5;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Object error = object;
                errors.add((ValidationResult)error);
            }
        }
    }

    private final void checkValueModifications(EventDataMetrics metrics, Integer maxValueLength, List<ValidationResult> errors) {
        Iterable $this$forEach$iv = metrics.getValuesModified();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ValueModification modification = (ValueModification)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = modification.getReasons();
            boolean $i$f$forEach2 = false;
            block5: for (Object element$iv2 : $this$forEach$iv2) {
                Object object;
                ModificationReason reason = (ModificationReason)((Object)element$iv2);
                boolean bl2 = false;
                switch (WhenMappings.$EnumSwitchMapping$0[reason.ordinal()]) {
                    case 1: {
                        String[] stringArray = new String[]{modification.getOriginalValue(), modification.getKey(), modification.getCleanedValue()};
                        object = ValidationResultFactory.create(ValidationError.VALUE_INVALID_CHARACTERS, stringArray);
                        break;
                    }
                    case 2: {
                        object = maxValueLength;
                        if (object == null) continue block5;
                        int limit = ((Number)object).intValue();
                        boolean bl3 = false;
                        String[] stringArray = new String[]{modification.getOriginalValue(), modification.getKey(), String.valueOf(limit), modification.getCleanedValue()};
                        ValidationResult validationResult = ValidationResultFactory.create(ValidationError.VALUE_CHARS_LIMIT_EXCEEDED, stringArray);
                        object = validationResult;
                        if (validationResult != null) break;
                        continue block5;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Object error = object;
                errors.add((ValidationResult)error);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkItemRemovals(EventDataMetrics metrics, List<ValidationResult> errors) {
        $this$forEach$iv = metrics.getItemsRemoved();
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            item = (RemovedItem)element$iv;
            $i$a$-forEach-EventDataValidator$checkItemRemovals$1 = false;
            switch (WhenMappings.$EnumSwitchMapping$1[item.getReason().ordinal()]) {
                case 1: {
                    var9_9 = new String[]{item.getKey()};
                    v0 = ValidationResultFactory.create(ValidationError.NULL_VALUE_REMOVED, var9_9);
                    break;
                }
                case 2: {
                    var9_9 = new String[]{item.getKey()};
                    v0 = ValidationResultFactory.create(ValidationError.EMPTY_VALUE_REMOVED, var9_9);
                    break;
                }
                case 3: {
                    var9_9 = new String[]{item.getKey()};
                    v0 = ValidationResultFactory.create(ValidationError.EMPTY_KEY, var9_9);
                    break;
                }
                case 4: {
                    v1 = ValidationError.PROP_VALUE_NOT_PRIMITIVE;
                    var9_9 = new String[2];
                    var9_9[0] = item.getKey();
                    v2 = var9_9;
                    v3 = 1;
                    v4 = item.getOriginalValue();
                    if (v4 == null) ** GOTO lbl40
                    var10_10 = v4;
                    var11_11 = v3;
                    var12_12 = v2;
                    var13_13 = v1;
                    $i$a$-let-EventDataValidator$checkItemRemovals$1$error$1 = false;
                    var15_15 = Reflection.getOrCreateKotlinClass(it.getClass()).getSimpleName();
                    v1 = var13_13;
                    v2 = var12_12;
                    v3 = var11_11;
                    v5 = var15_15;
                    v4 = v5;
                    if (v5 != null) ** GOTO lbl41
lbl40:
                    // 2 sources

                    v4 = "null";
lbl41:
                    // 2 sources

                    v2[v3] = v4;
                    v0 = ValidationResultFactory.create(v1, var9_9);
                    break;
                }
                case 5: {
                    v0 = ValidationResultFactory.create(ValidationError.INVALID_PHONE, new String[0]);
                    break;
                }
                case 6: {
                    var9_9 = new String[]{String.valueOf(item.getOriginalValue())};
                    v0 = ValidationResultFactory.create(ValidationError.INVALID_COUNTRY_CODE, var9_9);
                    break;
                }
                case 7: {
                    var9_9 = new String[]{item.getKey()};
                    v0 = ValidationResultFactory.create(ValidationError.RESTRICTED_MULTI_VALUE_KEY, var9_9);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            error = v0;
            errors.add(error);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ModificationReason.values().length];
            try {
                nArray[ModificationReason.INVALID_CHARACTERS_REMOVED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModificationReason.TRUNCATED_TO_MAX_LENGTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[RemovalReason.values().length];
            try {
                nArray[RemovalReason.NULL_VALUE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RemovalReason.EMPTY_VALUE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RemovalReason.EMPTY_KEY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RemovalReason.NON_PRIMITIVE_VALUE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RemovalReason.INVALID_PHONE_NUMBER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RemovalReason.INVALID_COUNTRY_CODE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RemovalReason.RESTRICTED_KEY_NESTED_VALUE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

