/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.validation;

import androidx.annotation.RestrictTo;
import com.clevertap.android.sdk.validation.ValidationResult;
import java.util.ArrayList;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class ValidationResultStack {
    private static final Object pendingValidationResultsLock = new Object();
    private ArrayList<ValidationResult> pendingValidationResults = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushValidationResult(ValidationResult vr) {
        Object object = pendingValidationResultsLock;
        synchronized (object) {
            try {
                int len = this.pendingValidationResults.size();
                if (len > 50) {
                    ArrayList<ValidationResult> trimmed = new ArrayList<ValidationResult>();
                    for (int i = 10; i < len; ++i) {
                        trimmed.add(this.pendingValidationResults.get(i));
                    }
                    trimmed.add(vr);
                    this.pendingValidationResults = trimmed;
                } else {
                    this.pendingValidationResults.add(vr);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushValidationResult(List<ValidationResult> vrList) {
        if (vrList == null || vrList.isEmpty()) {
            return;
        }
        Object object = pendingValidationResultsLock;
        synchronized (object) {
            try {
                int currentSize = this.pendingValidationResults.size();
                int newSize = currentSize + vrList.size();
                if (newSize > 50) {
                    ArrayList<ValidationResult> trimmed = new ArrayList<ValidationResult>();
                    int skipCount = newSize - 40;
                    if (skipCount >= currentSize) {
                        int startIndex = vrList.size() - 40;
                        for (int i = Math.max(0, startIndex); i < vrList.size(); ++i) {
                            trimmed.add(vrList.get(i));
                        }
                    } else {
                        for (int i = skipCount; i < currentSize; ++i) {
                            trimmed.add(this.pendingValidationResults.get(i));
                        }
                        trimmed.addAll(vrList);
                    }
                    this.pendingValidationResults = trimmed;
                } else {
                    this.pendingValidationResults.addAll(vrList);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationResult popValidationResult() {
        ValidationResult vr = null;
        Object object = pendingValidationResultsLock;
        synchronized (object) {
            try {
                if (!this.pendingValidationResults.isEmpty()) {
                    vr = this.pendingValidationResults.remove(0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return vr;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public ArrayList<ValidationResult> getPendingValidationResults() {
        return this.pendingValidationResults;
    }
}

