/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.response;

import android.content.Context;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.ControllerManager;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.network.ArpRepo;
import com.clevertap.android.sdk.product_config.CTProductConfigController;
import com.clevertap.android.sdk.response.CleverTapResponseDecorator;
import com.clevertap.android.sdk.validation.ValidationConfig;
import java.util.HashSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ARPResponse
extends CleverTapResponseDecorator {
    private final CTProductConfigController ctProductConfigController;
    private final CleverTapInstanceConfig config;
    private final Logger logger;
    private final ValidationConfig validationConfig;
    private final ArpRepo arpRepo;

    public ARPResponse(CleverTapInstanceConfig config, ValidationConfig validationConfig, ControllerManager controllerManager, ArpRepo arpRepo) {
        this.config = config;
        this.ctProductConfigController = controllerManager.getCTProductConfigController();
        this.logger = this.config.getLogger();
        this.validationConfig = validationConfig;
        this.arpRepo = arpRepo;
    }

    @Override
    public void processResponse(JSONObject response, String stringBody, Context context) {
        block5: {
            try {
                JSONObject arp;
                if (!response.has("arp") || (arp = (JSONObject)response.get("arp")).length() <= 0) break block5;
                if (this.ctProductConfigController != null) {
                    this.ctProductConfigController.setArpValue(arp);
                }
                try {
                    this.processDiscardedEventsList(arp);
                }
                catch (Throwable t) {
                    this.logger.verbose("Error handling discarded events response: " + t.getLocalizedMessage());
                }
                this.arpRepo.handleARPUpdate(context, arp);
            }
            catch (Throwable t) {
                this.logger.verbose(this.config.getAccountId(), "Failed to process ARP", t);
            }
        }
    }

    private void processDiscardedEventsList(JSONObject response) {
        if (!response.has("d_e")) {
            this.logger.verbose(this.config.getAccountId(), "ARP doesn't contain the Discarded Events key");
            return;
        }
        try {
            HashSet<String> discardedEventsSet = new HashSet<String>();
            JSONArray discardedEventsArray = response.getJSONArray("d_e");
            for (int i = 0; i < discardedEventsArray.length(); ++i) {
                discardedEventsSet.add(discardedEventsArray.getString(i));
            }
            if (this.validationConfig != null) {
                this.validationConfig.updateDiscardedEventNames(discardedEventsSet);
            } else {
                this.logger.verbose(this.config.getAccountId(), "ValidationConfig object is NULL");
            }
        }
        catch (JSONException e) {
            this.logger.verbose(this.config.getAccountId(), "Error parsing discarded events list" + e.getLocalizedMessage());
        }
    }
}

