/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.pushnotification;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.pushnotification.CTPushNotificationReceiver;
import java.util.Random;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class LaunchPendingIntentFactory {
    public static PendingIntent getLaunchPendingIntent(@NonNull Bundle extras, @NonNull Context context) {
        PendingIntent pIntent;
        if (Build.VERSION.SDK_INT >= 31) {
            pIntent = LaunchPendingIntentFactory.getActivityIntent(extras, context);
        } else {
            Intent launchIntent = new Intent(context, CTPushNotificationReceiver.class);
            launchIntent.putExtras(extras);
            launchIntent.removeExtra("wzrk_acts");
            int flagsLaunchPendingIntent = 0x8000000;
            if (Build.VERSION.SDK_INT >= 23) {
                flagsLaunchPendingIntent |= 0x4000000;
            }
            pIntent = PendingIntent.getBroadcast((Context)context, (int)new Random().nextInt(), (Intent)launchIntent, (int)flagsLaunchPendingIntent);
        }
        return pIntent;
    }

    public static PendingIntent getActivityIntent(@NonNull Bundle extras, @NonNull Context context) {
        Intent launchIntent;
        if (extras.containsKey("wzrk_dl") && extras.getString("wzrk_dl") != null) {
            launchIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)extras.getString("wzrk_dl")));
            Utils.setPackageNameFromResolveInfoList(context, launchIntent);
        } else {
            launchIntent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
            if (launchIntent == null) {
                return null;
            }
        }
        launchIntent.setFlags(0x34000000);
        launchIntent.putExtras(extras);
        launchIntent.removeExtra("wzrk_acts");
        int flagsLaunchPendingIntent = 0x8000000;
        if (Build.VERSION.SDK_INT >= 23) {
            flagsLaunchPendingIntent |= 0x4000000;
        }
        return PendingIntent.getActivity((Context)context, (int)new Random().nextInt(), (Intent)launchIntent, (int)flagsLaunchPendingIntent, null);
    }
}

