/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.profile.traversal;

import com.clevertap.android.sdk.profile.traversal.ArrayOperationHandler;
import com.clevertap.android.sdk.profile.traversal.JsonComparisonUtils;
import com.clevertap.android.sdk.profile.traversal.NumberOperationUtils;
import com.clevertap.android.sdk.profile.traversal.ProfileChange;
import com.clevertap.android.sdk.profile.traversal.ProfileChangeTracker;
import com.clevertap.android.sdk.profile.traversal.ProfileOperation;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007Jv\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\r2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u001422\u0010\u0015\u001a.\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\r\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00120\u0011\u0012\u0004\u0012\u00020\t0\u0016JD\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\r2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002JL\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\r2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002JD\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\r2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J,\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\r2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00120\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/clevertap/android/sdk/profile/traversal/OperationHandler;", "", "changeTracker", "Lcom/clevertap/android/sdk/profile/traversal/ProfileChangeTracker;", "arrayHandler", "Lcom/clevertap/android/sdk/profile/traversal/ArrayOperationHandler;", "<init>", "(Lcom/clevertap/android/sdk/profile/traversal/ProfileChangeTracker;Lcom/clevertap/android/sdk/profile/traversal/ArrayOperationHandler;)V", "handleOperation", "", "target", "Lorg/json/JSONObject;", "key", "", "newValue", "currentPath", "changes", "", "Lcom/clevertap/android/sdk/profile/traversal/ProfileChange;", "operation", "Lcom/clevertap/android/sdk/profile/traversal/ProfileOperation;", "recursiveApply", "Lkotlin/Function4;", "handleMissingKey", "handleNumberOperation", "parent", "oldValue", "path", "handleValueUpdate", "handleGetOperation", "clevertap-core_release"})
public final class OperationHandler {
    @NotNull
    private final ProfileChangeTracker changeTracker;
    @NotNull
    private final ArrayOperationHandler arrayHandler;

    public OperationHandler(@NotNull ProfileChangeTracker changeTracker, @NotNull ArrayOperationHandler arrayHandler) {
        Intrinsics.checkNotNullParameter((Object)changeTracker, (String)"changeTracker");
        Intrinsics.checkNotNullParameter((Object)arrayHandler, (String)"arrayHandler");
        this.changeTracker = changeTracker;
        this.arrayHandler = arrayHandler;
    }

    public final void handleOperation(@NotNull JSONObject target, @NotNull String key, @NotNull Object newValue, @NotNull String currentPath, @NotNull Map<String, ProfileChange> changes, @NotNull ProfileOperation operation, @NotNull Function4<? super JSONObject, ? super JSONObject, ? super String, ? super Map<String, ProfileChange>, Unit> recursiveApply) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        Intrinsics.checkNotNullParameter((Object)currentPath, (String)"currentPath");
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        Intrinsics.checkNotNullParameter(recursiveApply, (String)"recursiveApply");
        if (!target.has(key)) {
            this.handleMissingKey(target, key, newValue, currentPath, changes, operation);
            return;
        }
        Object oldValue = target.get(key);
        if (oldValue instanceof JSONObject && newValue instanceof JSONObject) {
            recursiveApply.invoke(oldValue, newValue, (Object)currentPath, changes);
        } else if (oldValue instanceof JSONArray && newValue instanceof JSONArray) {
            this.arrayHandler.handleArrayOperation(target, key, (JSONArray)oldValue, (JSONArray)newValue, currentPath, changes, operation, recursiveApply);
        } else if (operation.isNumericOperation()) {
            Intrinsics.checkNotNull((Object)oldValue);
            this.handleNumberOperation(target, key, oldValue, newValue, currentPath, changes, operation);
        } else if (operation == ProfileOperation.GET) {
            Intrinsics.checkNotNull((Object)oldValue);
            this.handleGetOperation(oldValue, currentPath, changes);
        } else {
            Intrinsics.checkNotNull((Object)oldValue);
            this.handleValueUpdate(target, key, oldValue, newValue, currentPath, changes);
        }
    }

    private final void handleMissingKey(JSONObject target, String key, Object newValue, String currentPath, Map<String, ProfileChange> changes, ProfileOperation operation) {
        Object object;
        if (operation == ProfileOperation.GET || operation == ProfileOperation.ARRAY_REMOVE) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[operation.ordinal()]) {
            case 1: {
                if (!(newValue instanceof Number)) {
                    return;
                }
                object = NumberOperationUtils.INSTANCE.negateNumber((Number)newValue);
                break;
            }
            case 2: {
                if (!(newValue instanceof Number)) {
                    return;
                }
                object = newValue;
                break;
            }
            default: {
                object = newValue;
            }
        }
        Object updatedValue = object;
        target.put(key, updatedValue);
        this.changeTracker.recordAddition(currentPath, updatedValue, changes);
    }

    private final void handleNumberOperation(JSONObject parent, String key, Object oldValue, Object newValue, String path, Map<String, ProfileChange> changes, ProfileOperation operation) {
        Number result;
        if (!(oldValue instanceof Number) || !(newValue instanceof Number)) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[operation.ordinal()]) {
            case 2: {
                Number number = NumberOperationUtils.INSTANCE.addNumbers((Number)oldValue, (Number)newValue);
                break;
            }
            case 1: {
                Number number = NumberOperationUtils.INSTANCE.subtractNumbers((Number)oldValue, (Number)newValue);
                break;
            }
            default: {
                Number number = result = (Number)oldValue;
            }
        }
        if (!JsonComparisonUtils.INSTANCE.areEqual(oldValue, result)) {
            parent.put(key, (Object)result);
            this.changeTracker.recordChange(path, oldValue, result, changes);
        }
    }

    private final void handleValueUpdate(JSONObject parent, String key, Object oldValue, Object newValue, String path, Map<String, ProfileChange> changes) {
        if (!JsonComparisonUtils.INSTANCE.areEqual(oldValue, newValue)) {
            parent.put(key, newValue);
            this.changeTracker.recordChange(path, oldValue, newValue, changes);
        }
    }

    private final void handleGetOperation(Object oldValue, String path, Map<String, ProfileChange> changes) {
        changes.put(path, new ProfileChange(oldValue, "__CLEVERTAP_GET__"));
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProfileOperation.values().length];
            try {
                nArray[ProfileOperation.DECREMENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProfileOperation.INCREMENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

