/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.profile.traversal;

import com.clevertap.android.sdk.profile.traversal.ArrayMergeUtilsKt;
import com.clevertap.android.sdk.profile.traversal.JsonComparisonUtils;
import com.clevertap.android.sdk.profile.traversal.NumberOperationUtils;
import com.clevertap.android.sdk.profile.traversal.ProfileChange;
import com.clevertap.android.sdk.profile.traversal.ProfileChangeTracker;
import com.clevertap.android.sdk.profile.traversal.ProfileOperation;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0004\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J~\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000b2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u001422\u0010\u0015\u001a.\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\u0004\u0012\u00020\u00070\u0016J4\u0010\u0017\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u000b2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002JD\u0010\u0019\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u000b2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002JD\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u000b2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002Jp\u0010\u001b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u000b2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u001422\u0010\u0015\u001a.\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\u0004\u0012\u00020\u00070\u0016H\u0002J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002Jh\u0010!\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u000b2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u001122\u0010\u0015\u001a.\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\u0004\u0012\u00020\u00070\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/clevertap/android/sdk/profile/traversal/ArrayOperationHandler;", "", "changeTracker", "Lcom/clevertap/android/sdk/profile/traversal/ProfileChangeTracker;", "<init>", "(Lcom/clevertap/android/sdk/profile/traversal/ProfileChangeTracker;)V", "handleArrayOperation", "", "parentJson", "Lorg/json/JSONObject;", "key", "", "oldArray", "Lorg/json/JSONArray;", "newArray", "currentPath", "changes", "", "Lcom/clevertap/android/sdk/profile/traversal/ProfileChange;", "operation", "Lcom/clevertap/android/sdk/profile/traversal/ProfileOperation;", "recursiveTraversal", "Lkotlin/Function4;", "handleArrayAdd", "path", "handleArrayReplacement", "handleArrayRemove", "processArrayElements", "basePath", "applyNumberOperation", "", "oldValue", "newValue", "getArrayElements", "clevertap-core_release"})
public final class ArrayOperationHandler {
    @NotNull
    private final ProfileChangeTracker changeTracker;

    public ArrayOperationHandler(@NotNull ProfileChangeTracker changeTracker) {
        Intrinsics.checkNotNullParameter((Object)changeTracker, (String)"changeTracker");
        this.changeTracker = changeTracker;
    }

    public final void handleArrayOperation(@NotNull JSONObject parentJson, @NotNull String key, @NotNull JSONArray oldArray, @NotNull JSONArray newArray, @NotNull String currentPath, @NotNull Map<String, ProfileChange> changes, @NotNull ProfileOperation operation, @NotNull Function4<? super JSONObject, ? super JSONObject, ? super String, ? super Map<String, ProfileChange>, Unit> recursiveTraversal) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)parentJson, (String)"parentJson");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)oldArray, (String)"oldArray");
        Intrinsics.checkNotNullParameter((Object)newArray, (String)"newArray");
        Intrinsics.checkNotNullParameter((Object)currentPath, (String)"currentPath");
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        Intrinsics.checkNotNullParameter(recursiveTraversal, (String)"recursiveTraversal");
        if (newArray.length() == 0) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[operation.ordinal()]) {
            case 1: {
                this.handleArrayAdd(oldArray, newArray, currentPath, changes);
                break;
            }
            case 2: {
                this.handleArrayRemove(parentJson, key, oldArray, newArray, currentPath, changes);
                break;
            }
            case 3: {
                this.getArrayElements(oldArray, newArray, currentPath, changes, recursiveTraversal);
                break;
            }
            case 4: {
                this.handleArrayReplacement(parentJson, key, oldArray, newArray, currentPath, changes);
                break;
            }
            case 5: 
            case 6: {
                this.processArrayElements(oldArray, newArray, currentPath, changes, operation, recursiveTraversal);
            }
        }
    }

    private final void handleArrayAdd(JSONArray oldArray, JSONArray newArray, String path, Map<String, ProfileChange> changes) {
        JSONArray oldArrayCopy = ArrayMergeUtilsKt.deepCopy(oldArray);
        boolean modified = false;
        int n = newArray.length();
        for (int i = 0; i < n; ++i) {
            Object item = newArray.get(i);
            if (!(item instanceof String)) continue;
            oldArray.put(item);
            modified = true;
        }
        if (modified) {
            this.changeTracker.recordChange(path, oldArrayCopy, oldArray, changes);
        }
    }

    private final void handleArrayReplacement(JSONObject parentJson, String key, JSONArray oldArray, JSONArray newArray, String path, Map<String, ProfileChange> changes) {
        if (!JsonComparisonUtils.INSTANCE.areEqual(oldArray, newArray)) {
            parentJson.put(key, (Object)newArray);
            this.changeTracker.recordChange(path, oldArray, newArray, changes);
        }
    }

    private final void handleArrayRemove(JSONObject parentJson, String key, JSONArray oldArray, JSONArray newArray, String path, Map<String, ProfileChange> changes) {
        JSONArray oldArrayCopy = ArrayMergeUtilsKt.deepCopy(oldArray);
        JSONArray resultArray = new JSONArray();
        boolean modified = false;
        int n = oldArray.length();
        for (int i = 0; i < n; ++i) {
            Object item = oldArray.get(i);
            if (item instanceof String && ArrayMergeUtilsKt.containsString(newArray, (String)item)) {
                modified = true;
                continue;
            }
            resultArray.put(item);
        }
        if (modified) {
            parentJson.put(key, (Object)resultArray);
            this.changeTracker.recordChange(path, oldArrayCopy, resultArray, changes);
        }
    }

    private final void processArrayElements(JSONArray oldArray, JSONArray newArray, String basePath, Map<String, ProfileChange> changes, ProfileOperation operation, Function4<? super JSONObject, ? super JSONObject, ? super String, ? super Map<String, ProfileChange>, Unit> recursiveTraversal) {
        JSONArray oldArrayCopy = ArrayMergeUtilsKt.deepCopy(oldArray);
        boolean arrayModified = false;
        int arrayLength = Math.min(oldArray.length(), newArray.length());
        for (int i = 0; i < arrayLength; ++i) {
            Number result;
            Object oldElement = oldArray.get(i);
            Object newElement = newArray.get(i);
            if (oldElement instanceof JSONObject && newElement instanceof JSONObject) {
                Map elementChanges = new LinkedHashMap();
                recursiveTraversal.invoke(oldElement, newElement, (Object)"", (Object)elementChanges);
                if (!(!elementChanges.isEmpty())) continue;
                arrayModified = true;
                continue;
            }
            if (!(oldElement instanceof Number) || !(newElement instanceof Number) || JsonComparisonUtils.INSTANCE.areEqual(oldElement, result = this.applyNumberOperation((Number)oldElement, (Number)newElement, operation))) continue;
            oldArray.put(i, (Object)result);
            arrayModified = true;
        }
        if (arrayModified) {
            this.changeTracker.recordChange(basePath, oldArrayCopy, oldArray, changes);
        }
    }

    private final Number applyNumberOperation(Number oldValue, Number newValue, ProfileOperation operation) {
        return operation == ProfileOperation.INCREMENT ? (Number)NumberOperationUtils.INSTANCE.addNumbers(oldValue, newValue) : (Number)NumberOperationUtils.INSTANCE.subtractNumbers(oldValue, newValue);
    }

    private final void getArrayElements(JSONArray oldArray, JSONArray newArray, String basePath, Map<String, ProfileChange> changes, Function4<? super JSONObject, ? super JSONObject, ? super String, ? super Map<String, ProfileChange>, Unit> recursiveTraversal) {
        int n = newArray.length();
        for (int i = 0; i < n; ++i) {
            if (i >= oldArray.length()) continue;
            Object oldElement = oldArray.get(i);
            Object newElement = newArray.get(i);
            String elementPath = basePath + '[' + i + ']';
            if (oldElement instanceof JSONObject && newElement instanceof JSONObject) {
                recursiveTraversal.invoke(oldElement, newElement, (Object)elementPath, changes);
                continue;
            }
            changes.put(elementPath, new ProfileChange(oldElement, "__CLEVERTAP_GET__"));
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProfileOperation.values().length];
            try {
                nArray[ProfileOperation.ARRAY_ADD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProfileOperation.ARRAY_REMOVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProfileOperation.GET.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProfileOperation.UPDATE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProfileOperation.INCREMENT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProfileOperation.DECREMENT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

