/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inbox;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.R;
import com.clevertap.android.sdk.inbox.CTCarouselImageViewHolder;
import com.clevertap.android.sdk.inbox.CTCarouselMessageViewHolder;
import com.clevertap.android.sdk.inbox.CTIconMessageViewHolder;
import com.clevertap.android.sdk.inbox.CTInboxBaseMessageViewHolder;
import com.clevertap.android.sdk.inbox.CTInboxListViewFragment;
import com.clevertap.android.sdk.inbox.CTInboxMessage;
import com.clevertap.android.sdk.inbox.CTSimpleMessageViewHolder;
import java.util.ArrayList;

class CTInboxMessageAdapter
extends RecyclerView.Adapter {
    private static final int SIMPLE = 0;
    private static final int ICON = 1;
    private static final int CAROUSEL = 2;
    private static final int IMAGE_CAROUSEL = 3;
    private CTInboxListViewFragment fragment;
    private ArrayList<CTInboxMessage> inboxMessages;

    CTInboxMessageAdapter(ArrayList<CTInboxMessage> inboxMessages, CTInboxListViewFragment fragment) {
        Logger.v("CTInboxMessageAdapter: messages=" + inboxMessages);
        this.inboxMessages = inboxMessages;
        this.fragment = fragment;
    }

    public int getItemCount() {
        return this.inboxMessages.size();
    }

    public int getItemViewType(int position) {
        switch (this.inboxMessages.get(position).getType()) {
            case SimpleMessage: {
                return 0;
            }
            case IconMessage: {
                return 1;
            }
            case CarouselMessage: {
                return 2;
            }
            case CarouselImageMessage: {
                return 3;
            }
        }
        return -1;
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int i) {
        CTInboxMessage inboxMessage = this.inboxMessages.get(i);
        CTInboxBaseMessageViewHolder _viewHolder = (CTInboxBaseMessageViewHolder)viewHolder;
        _viewHolder.configureWithMessage(inboxMessage, this.fragment, i);
    }

    public CTInboxBaseMessageViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int viewType) {
        switch (viewType) {
            case 0: {
                View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.inbox_simple_message_layout, viewGroup, false);
                return new CTSimpleMessageViewHolder(view);
            }
            case 1: {
                View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.inbox_icon_message_layout, viewGroup, false);
                return new CTIconMessageViewHolder(view);
            }
            case 2: {
                View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.inbox_carousel_text_layout, viewGroup, false);
                return new CTCarouselMessageViewHolder(view);
            }
            case 3: {
                View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.inbox_carousel_layout, viewGroup, false);
                return new CTCarouselImageViewHolder(view);
            }
        }
        return null;
    }
}

