/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inbox;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.core.content.res.ResourcesCompat;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.RecyclerView;
import com.clevertap.android.sdk.R;
import com.clevertap.android.sdk.inbox.CTInboxActivity;
import com.clevertap.android.sdk.inbox.CTInboxListViewFragment;
import com.clevertap.android.sdk.inbox.CTInboxMessage;
import com.clevertap.android.sdk.inbox.CTInboxMessageContent;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.Date;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class CTInboxBaseMessageViewHolder
extends RecyclerView.ViewHolder {
    Context context;
    LinearLayout ctaLinearLayout;
    LinearLayout bodyRelativeLayout;
    FrameLayout frameLayout;
    ImageView mediaImage;
    ImageView squareImage;
    RelativeLayout mediaLayout;
    FrameLayout progressBarFrameLayout;
    RelativeLayout relativeLayout;
    RelativeLayout clickLayout;
    private CTInboxMessageContent firstContentItem;
    private CTInboxMessage message;
    private ImageView muteIcon;
    private WeakReference<CTInboxListViewFragment> parentWeakReference;
    private boolean requiresMediaPlayer;
    protected final ImageView readDot;

    CTInboxBaseMessageViewHolder(@NonNull View itemView) {
        super(itemView);
        this.readDot = (ImageView)itemView.findViewById(R.id.read_circle);
    }

    public boolean addMediaPlayer(float currentVolume, Function0<Float> muteClick, Function3<String, Boolean, Boolean, Void> playMedia, View videoSurfaceView) {
        int height;
        int width;
        if (!this.requiresMediaPlayer) {
            return false;
        }
        FrameLayout frameLayout = this.getLayoutForMediaPlayer();
        if (frameLayout == null) {
            return false;
        }
        frameLayout.removeAllViews();
        frameLayout.setVisibility(8);
        Resources resources = this.context.getResources();
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        if (CTInboxActivity.orientation == 2) {
            if (this.message.getOrientation().equalsIgnoreCase("l")) {
                width = Math.round((float)this.mediaImage.getMeasuredHeight() * 1.76f);
                height = this.mediaImage.getMeasuredHeight();
            } else {
                width = height = this.squareImage.getMeasuredHeight();
            }
        } else {
            width = resources.getDisplayMetrics().widthPixels;
            height = this.message.getOrientation().equalsIgnoreCase("l") ? Math.round((float)width * 0.5625f) : width;
        }
        videoSurfaceView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(width, height));
        frameLayout.addView(videoSurfaceView);
        frameLayout.setBackgroundColor(Color.parseColor((String)this.message.getBgColor()));
        if (this.progressBarFrameLayout != null) {
            this.progressBarFrameLayout.setVisibility(0);
        }
        if (this.firstContentItem.mediaIsVideo()) {
            this.muteIcon = new ImageView(this.context);
            this.muteIcon.setVisibility(8);
            this.setMuteIconState(this.muteIcon, this.context, currentVolume);
            int iconWidth = (int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)displayMetrics);
            int iconHeight = (int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)displayMetrics);
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(iconWidth, iconHeight);
            int iconTop = (int)TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)displayMetrics);
            int iconRight = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)displayMetrics);
            layoutParams.setMargins(0, iconTop, iconRight, 0);
            layoutParams.gravity = 0x800005;
            this.muteIcon.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            View.OnClickListener updateMuteIcon = v -> {
                float volume = ((Float)muteClick.invoke()).floatValue();
                this.setMuteIconState(this.muteIcon, this.context, volume);
            };
            this.muteIcon.setOnClickListener(updateMuteIcon);
            frameLayout.addView((View)this.muteIcon);
        }
        playMedia.invoke((Object)this.firstContentItem.getMedia(), (Object)this.firstContentItem.mediaIsAudio(), (Object)this.firstContentItem.mediaIsVideo());
        return true;
    }

    private void setMuteIconState(ImageView icon, Context context, float volume) {
        boolean isMuted = volume <= 0.0f;
        int drawableRes = isMuted ? R.drawable.ct_volume_off : R.drawable.ct_volume_on;
        int contentDescRes = isMuted ? R.string.ct_inbox_mute_button_content_description : R.string.ct_inbox_unmute_button_content_description;
        icon.setContentDescription((CharSequence)context.getString(contentDescRes));
        icon.setImageDrawable(ResourcesCompat.getDrawable((Resources)context.getResources(), (int)drawableRes, null));
    }

    String calculateDisplayTimestamp(long time) {
        long now = System.currentTimeMillis() / 1000L;
        long diff = now - time;
        if (diff < 60L) {
            return "Just Now";
        }
        if (diff > 60L && diff < 3540L) {
            return diff / 60L + " mins ago";
        }
        if (diff > 3540L && diff < 81420L) {
            return diff / 3600L > 1L ? diff / 3600L + " hours ago" : diff / 3600L + " hour ago";
        }
        if (diff > 86400L && diff < 172800L) {
            return "Yesterday";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd MMM");
        return sdf.format(new Date(time * 1000L));
    }

    void configureWithMessage(CTInboxMessage inboxMessage, CTInboxListViewFragment parent, int position) {
        this.context = parent.getContext();
        this.parentWeakReference = new WeakReference<CTInboxListViewFragment>(parent);
        this.message = inboxMessage;
        this.firstContentItem = this.message.getInboxMessageContents().get(0);
        this.requiresMediaPlayer = this.firstContentItem.mediaIsStreamable();
    }

    int getImageBackgroundColor() {
        return 0;
    }

    CTInboxListViewFragment getParent() {
        return (CTInboxListViewFragment)((Object)this.parentWeakReference.get());
    }

    void hideOneButton(Button mainButton, Button secondaryButton, Button tertiaryButton) {
        tertiaryButton.setVisibility(8);
        mainButton.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 3.0f));
        secondaryButton.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 3.0f));
        tertiaryButton.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 0.0f));
    }

    void hideTwoButtons(Button mainButton, Button secondaryButton, Button tertiaryButton) {
        secondaryButton.setVisibility(8);
        tertiaryButton.setVisibility(8);
        mainButton.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 6.0f));
        secondaryButton.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 0.0f));
        tertiaryButton.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 0.0f));
    }

    public boolean needsMediaPlayer() {
        return this.requiresMediaPlayer;
    }

    public void playerBuffering() {
        if (this.progressBarFrameLayout != null) {
            this.progressBarFrameLayout.setVisibility(0);
        }
    }

    public void playerReady() {
        FrameLayout frameLayout = this.getLayoutForMediaPlayer();
        frameLayout.setVisibility(0);
        if (this.muteIcon != null) {
            this.muteIcon.setVisibility(0);
        }
        if (this.progressBarFrameLayout != null) {
            this.progressBarFrameLayout.setVisibility(8);
        }
    }

    public void playerRemoved() {
        FrameLayout frameLayout;
        if (this.progressBarFrameLayout != null) {
            this.progressBarFrameLayout.post(() -> this.progressBarFrameLayout.setVisibility(8));
        }
        if (this.muteIcon != null) {
            this.muteIcon.post(() -> this.muteIcon.setVisibility(8));
        }
        if ((frameLayout = this.getLayoutForMediaPlayer()) != null) {
            frameLayout.removeAllViews();
        }
    }

    void setDots(ImageView[] dots, int dotsCount, Context appContext, LinearLayout sliderDots) {
        for (int k = 0; k < dotsCount; ++k) {
            dots[k] = new ImageView(appContext);
            dots[k].setVisibility(0);
            dots[k].setImageDrawable(ResourcesCompat.getDrawable((Resources)appContext.getResources(), (int)R.drawable.ct_unselected_dot, null));
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
            params.setMargins(8, 6, 4, 6);
            params.gravity = 17;
            if (sliderDots.getChildCount() >= dotsCount) continue;
            sliderDots.addView((View)dots[k], (ViewGroup.LayoutParams)params);
        }
    }

    public boolean shouldAutoPlay() {
        return this.firstContentItem.mediaIsVideo();
    }

    private FrameLayout getLayoutForMediaPlayer() {
        return this.frameLayout;
    }

    protected void markItemAsRead(final CTInboxMessage inboxMessage, final int position) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                final CTInboxListViewFragment parent = CTInboxBaseMessageViewHolder.this.getParent();
                if (parent != null) {
                    FragmentActivity activity = parent.getActivity();
                    if (activity == null) {
                        return;
                    }
                    activity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (CTInboxBaseMessageViewHolder.this.readDot.getVisibility() == 0) {
                                parent.didShow(null, position);
                            }
                            CTInboxBaseMessageViewHolder.this.readDot.setVisibility(8);
                            inboxMessage.setRead(true);
                        }
                    });
                }
            }
        };
        Handler handler = new Handler();
        handler.postDelayed(runnable, 2000L);
    }
}

