/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp.delay;

import androidx.annotation.WorkerThread;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleOwnerKt;
import androidx.lifecycle.ProcessLifecycleOwner;
import androidx.lifecycle.RepeatOnLifecycleKt;
import com.clevertap.android.sdk.ILogger;
import com.clevertap.android.sdk.inapp.delay.InAppTimerManager;
import com.clevertap.android.sdk.utils.Clock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.NonCancellable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\n\b\u0000\u0018\u0000 +2\u00020\u0001:\u0004+,-.B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ,\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bH\u0007J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u0003J\u000e\u0010 \u001a\u00020\u001dH\u0082@\u00a2\u0006\u0002\u0010!J\u0010\u0010\"\u001a\u00020\u001dH\u0080@\u00a2\u0006\u0004\b#\u0010!J\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u0003J\u000e\u0010'\u001a\u00020\u001dH\u0086@\u00a2\u0006\u0002\u0010!J\u0006\u0010(\u001a\u00020\u001dJ\u0010\u0010)\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00140\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/clevertap/android/sdk/inapp/delay/InAppTimerManager;", "", "accountId", "", "logger", "Lcom/clevertap/android/sdk/ILogger;", "clock", "Lcom/clevertap/android/sdk/utils/Clock;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "tagSuffix", "<init>", "(Ljava/lang/String;Lcom/clevertap/android/sdk/ILogger;Lcom/clevertap/android/sdk/utils/Clock;Lkotlinx/coroutines/CoroutineScope;Landroidx/lifecycle/LifecycleOwner;Ljava/lang/String;)V", "TAG", "activeJobs", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkotlinx/coroutines/Job;", "cancelledJobs", "Lcom/clevertap/android/sdk/inapp/delay/InAppTimerManager$CancelledJobData;", "scheduleLock", "scheduleTimer", "id", "delayInMs", "", "callback", "Lkotlin/Function1;", "Lcom/clevertap/android/sdk/inapp/delay/InAppTimerManager$TimerResult;", "", "cancelTimer", "", "cancelAllTimers", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "cleanup", "cleanup$clevertap_core_release", "getActiveTimerCount", "", "isTimerScheduled", "onAppBackground", "onAppForeground", "logCoroutineInfo", "msg", "Companion", "TimerResult", "RescheduleData", "CancelledJobData", "clevertap-core_release"})
@SourceDebugExtension(value={"SMAP\nInAppTimerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InAppTimerManager.kt\ncom/clevertap/android/sdk/inapp/delay/InAppTimerManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,254:1\n1#2:255\n1863#3,2:256\n1863#3,2:260\n1863#3,2:262\n216#4,2:258\n*S KotlinDebug\n*F\n+ 1 InAppTimerManager.kt\ncom/clevertap/android/sdk/inapp/delay/InAppTimerManager\n*L\n140#1:256,2\n206#1:260,2\n217#1:262,2\n184#1:258,2\n*E\n"})
public final class InAppTimerManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String accountId;
    @NotNull
    private final ILogger logger;
    @NotNull
    private final Clock clock;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final LifecycleOwner lifecycleOwner;
    @NotNull
    private final String TAG;
    @NotNull
    private final ConcurrentHashMap<String, Job> activeJobs;
    @NotNull
    private final ConcurrentHashMap<String, CancelledJobData> cancelledJobs;
    @NotNull
    private final Object scheduleLock;
    private static final int PARALLEL_SCHEDULERS = 20;

    public InAppTimerManager(@NotNull String accountId, @NotNull ILogger logger, @NotNull Clock clock, @NotNull CoroutineScope scope, @NotNull LifecycleOwner lifecycleOwner, @NotNull String tagSuffix) {
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)tagSuffix, (String)"tagSuffix");
        this.accountId = accountId;
        this.logger = logger;
        this.clock = clock;
        this.scope = scope;
        this.lifecycleOwner = lifecycleOwner;
        this.TAG = "[InAppTimerManager:" + tagSuffix + "]:";
        this.activeJobs = new ConcurrentHashMap();
        this.cancelledJobs = new ConcurrentHashMap();
        this.scheduleLock = new Object();
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ InAppTimerManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                        Job job2 = (Job)$this$launch.getCoroutineContext().get((CoroutineContext.Key)Job.Key);
                        this.this$0.logCoroutineInfo("lifeCycleOwner scope launch, " + $this$launch.getCoroutineContext() + ", " + (job2 != null ? job2.getParent() : null) + '}');
                        this.label = 1;
                        Object object3 = RepeatOnLifecycleKt.repeatOnLifecycle((LifecycleOwner)this.this$0.lifecycleOwner, (Lifecycle.State)Lifecycle.State.STARTED, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ InAppTimerManager this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object var1_1) {
                                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        $this$repeatOnLifecycle = (CoroutineScope)this.L$0;
                                        v0 = (Job)$this$repeatOnLifecycle.getCoroutineContext().get((CoroutineContext.Key)Job.Key);
                                        InAppTimerManager.access$logCoroutineInfo(this.this$0, "process lifeCycleOwner: started, " + $this$repeatOnLifecycle.getCoroutineContext() + ", " + (v0 != null ? v0.getParent() : null) + '}');
                                        this.this$0.onAppForeground();
                                        this.L$0 = $this$repeatOnLifecycle;
                                        this.label = 1;
                                        v1 = DelayKt.awaitCancellation((Continuation)((Continuation)this));
                                        ** if (v1 != var4_2) goto lbl16
lbl15:
                                        // 1 sources

                                        return var4_2;
lbl16:
                                        // 1 sources

                                        ** GOTO lbl23
                                    }
                                    case 1: {
                                        $this$repeatOnLifecycle = (CoroutineScope)this.L$0;
                                        try {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v1 = $result;
lbl23:
                                            // 2 sources

                                            throw new KotlinNothingValueException();
                                        }
                                        catch (CancellationException var3_4) {
                                            v2 = (Job)$this$repeatOnLifecycle.getCoroutineContext().get((CoroutineContext.Key)Job.Key);
                                            InAppTimerManager.access$logCoroutineInfo(this.this$0, "process lifeCycleOwner: Stopped, " + $this$repeatOnLifecycle.getCoroutineContext() + ", " + (v2 != null ? v2.getParent() : null) + '}');
                                            this.L$0 = $this$repeatOnLifecycle;
                                            this.label = 2;
                                            v3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)NonCancellable.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                                int label;
                                                private /* synthetic */ Object L$0;
                                                final /* synthetic */ InAppTimerManager this$0;
                                                {
                                                    this.this$0 = $receiver;
                                                    super(2, $completion);
                                                }

                                                /*
                                                 * WARNING - void declaration
                                                 * Enabled force condition propagation
                                                 * Lifted jumps to return sites
                                                 */
                                                public final Object invokeSuspend(Object object) {
                                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)object);
                                                            CoroutineScope $this$withContext = (CoroutineScope)this.L$0;
                                                            Job job2 = (Job)$this$withContext.getCoroutineContext().get((CoroutineContext.Key)Job.Key);
                                                            this.this$0.logCoroutineInfo("process lifeCycleOwner: withContext block, " + $this$withContext.getCoroutineContext() + ", " + (job2 != null ? job2.getParent() : null) + '}');
                                                            this.label = 1;
                                                            Object object3 = this.this$0.onAppBackground((Continuation<? super Unit>)((Continuation)this));
                                                            if (object3 != object2) return Unit.INSTANCE;
                                                            return object2;
                                                        }
                                                        case 1: {
                                                            void $result;
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            Object object3 = $result;
                                                            return Unit.INSTANCE;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                                    function2.L$0 = value;
                                                    return (Continuation)function2;
                                                }

                                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (Continuation)((Continuation)this));
                                            if (v3 == var4_2) {
                                                return var4_2;
                                            }
                                            ** GOTO lbl37
                                        }
                                    }
                                    case 2: {
                                        $this$repeatOnLifecycle = (CoroutineScope)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v3 = $result;
lbl37:
                                        // 2 sources

                                        CoroutineScopeKt.ensureActive((CoroutineScope)$this$repeatOnLifecycle);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                function2.L$0 = value;
                                return (Continuation)function2;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public /* synthetic */ InAppTimerManager(String string2, ILogger iLogger, Clock clock, CoroutineScope coroutineScope, LifecycleOwner lifecycleOwner, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            clock = Clock.SYSTEM;
        }
        if ((n & 8) != 0) {
            coroutineScope = CoroutineScopeKt.plus((CoroutineScope)((CoroutineScope)LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)ProcessLifecycleOwner.Companion.get())), (CoroutineContext)((CoroutineContext)Dispatchers.getDefault().limitedParallelism(20)));
        }
        if ((n & 0x10) != 0) {
            lifecycleOwner = ProcessLifecycleOwner.Companion.get();
        }
        if ((n & 0x20) != 0) {
            string3 = "";
        }
        this(string2, iLogger, clock, coroutineScope, lifecycleOwner, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @NotNull
    public final Job scheduleTimer(@NotNull String id2, long delayInMs, @NotNull Function1<? super TimerResult, Unit> callback) {
        Job job2;
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Object object = this.scheduleLock;
        synchronized (object) {
            Job job3;
            block4: {
                Job job4;
                boolean bl = false;
                Object object2 = this.activeJobs.get(id2);
                if (object2 == null) break block4;
                Job it = job4 = object2;
                boolean bl2 = false;
                object2 = it.isActive() ? job4 : null;
                if (object2 == null) break block4;
                it = object2;
                boolean bl3 = false;
                this.logger.verbose(this.accountId, this.TAG + " Timer with id'" + id2 + "' already scheduled, keeping existing");
                Job job5 = it;
                return job5;
            }
            Job it = job3 = BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, delayInMs, callback, id2, null){
                long J$0;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ InAppTimerManager this$0;
                final /* synthetic */ long $delayInMs;
                final /* synthetic */ Function1<TimerResult, Unit> $callback;
                final /* synthetic */ String $id;
                {
                    this.this$0 = $receiver;
                    this.$delayInMs = $delayInMs;
                    this.$callback = $callback;
                    this.$id = $id;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$launch = (CoroutineScope)this.L$0;
                            scheduledAt = InAppTimerManager.access$getClock$p(this.this$0).currentTimeMillis();
                            this.L$0 = $this$launch;
                            this.J$0 = scheduledAt;
                            this.label = 1;
                            v0 = DelayKt.delay((long)this.$delayInMs, (Continuation)((Continuation)this));
                            ** if (v0 != var6_2) goto lbl15
lbl14:
                            // 1 sources

                            return var6_2;
lbl15:
                            // 1 sources

                            ** GOTO lbl23
                        }
                        case 1: {
                            scheduledAt = this.J$0;
                            $this$launch = (CoroutineScope)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl23:
                                // 2 sources

                                this.$callback.invoke((Object)new TimerResult.Completed(this.$id, scheduledAt));
                                InAppTimerManager.access$getCancelledJobs$p(this.this$0).remove(this.$id);
                            }
                            catch (CancellationException var5_5) {
                                InAppTimerManager.access$getLogger$p(this.this$0).verbose(InAppTimerManager.access$getAccountId$p(this.this$0), InAppTimerManager.access$getTAG$p(this.this$0) + " Cancelled timer with id: " + this.$id);
                                InAppTimerManager.access$getCancelledJobs$p(this.this$0).putIfAbsent(this.$id, new CancelledJobData(this.$delayInMs, scheduledAt, this.$callback));
                                CoroutineScopeKt.ensureActive((CoroutineScope)$this$launch);
                            }
                            catch (Exception e) {
                                InAppTimerManager.access$getLogger$p(this.this$0).verbose(InAppTimerManager.access$getAccountId$p(this.this$0), InAppTimerManager.access$getTAG$p(this.this$0) + " Error in timer with id: " + this.$id, e);
                                this.$callback.invoke((Object)new TimerResult.Error(this.$id, e));
                                InAppTimerManager.access$getCancelledJobs$p(this.this$0).remove(this.$id);
                                {
                                    catch (Throwable var5_7) {
                                        throw var5_7;
                                    }
                                }
                            }
                            InAppTimerManager.access$getActiveJobs$p(this.this$0).remove(this.$id);
                            ** GOTO lbl51
                        }
                        {
                            finally {
                                InAppTimerManager.access$getActiveJobs$p(this.this$0).remove(this.$id);
                            }
                        }
lbl51:
                        // 3 sources

                        return Unit.INSTANCE;
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)function2;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            boolean bl = false;
            ((Map)this.activeJobs).put(id2, it);
            this.logger.verbose(this.accountId, this.TAG + " Scheduled timer with id '" + id2 + "' for " + delayInMs + "ms delay");
            job2 = job3;
        }
        return job2;
    }

    public final boolean cancelTimer(@NotNull String id2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Job job2 = this.activeJobs.get(id2);
        if (job2 != null) {
            Job job3 = job2;
            boolean bl2 = false;
            Job.DefaultImpls.cancel$default((Job)job3, null, (int)1, null);
            this.activeJobs.remove(id2);
            this.logger.verbose(this.accountId, this.TAG + " Cancelled timer with id: " + id2);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    private final Object cancelAllTimers(Continuation<? super Unit> $completion) {
        if (!($completion instanceof cancelAllTimers.1)) ** GOTO lbl-1000
        var11_2 = $completion;
        if ((var11_2.label & -2147483648) != 0) {
            var11_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ InAppTimerManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return InAppTimerManager.access$cancelAllTimers(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                cancelledCount = this.activeJobs.size();
                v0 = this.activeJobs.values();
                Intrinsics.checkNotNullExpressionValue(v0, (String)"<get-values>(...)");
                jobsToCancel = CollectionsKt.toList((Iterable)v0);
                $this$forEach$iv = jobsToCancel;
                $i$f$forEach = false;
                var6_9 = $this$forEach$iv.iterator();
lbl19:
                // 3 sources

                while (var6_9.hasNext()) {
                    element$iv = var6_9.next();
                    it = (Job)element$iv;
                    $i$a$-forEach-InAppTimerManager$cancelAllTimers$2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    $continuation.L$0 = this;
                    $continuation.L$1 = var6_9;
                    $continuation.I$0 = cancelledCount;
                    $continuation.label = 1;
                    v1 = JobKt.cancelAndJoin((Job)it, (Continuation)$continuation);
                    if (v1 != var12_4) continue;
                    return var12_4;
                }
                break;
            }
            case 1: {
                $i$f$forEach = false;
                $i$a$-forEach-InAppTimerManager$cancelAllTimers$2 = false;
                cancelledCount = $continuation.I$0;
                var6_9 = (Iterator<T>)$continuation.L$1;
                this = (InAppTimerManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
                ** GOTO lbl19
            }
        }
        this.logger.verbose(this.accountId, this.TAG + " Cancelled " + cancelledCount + " timers");
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object cleanup$clevertap_core_release(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof cleanup.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ InAppTimerManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.cleanup$clevertap_core_release((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.logger.verbose(this.accountId, this.TAG + " cleaning up timer state");
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.cancelAllTimers((Continuation<? super Unit>)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl23
            }
            case 1: {
                this = (InAppTimerManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                this.activeJobs.clear();
                this.cancelledJobs.clear();
                this.logger.verbose(this.accountId, this.TAG + " cleanup complete");
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final int getActiveTimerCount() {
        return this.activeJobs.size();
    }

    public final boolean isTimerScheduled(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Job job2 = this.activeJobs.get(id2);
        return job2 != null ? job2.isActive() : false;
    }

    @Nullable
    public final Object onAppBackground(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.cancelAllTimers($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final void onAppForeground() {
        this.logger.verbose(this.accountId, this.TAG + " Handling foreground - rescheduling cancelled timers");
        long currentTime = this.clock.currentTimeMillis();
        List toReschedule = new ArrayList();
        List toDiscard = new ArrayList();
        Map $this$forEach$iv = this.cancelledJobs;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object object = element$iv = iterator.next();
            boolean bl = false;
            String id2 = (String)object.getKey();
            CancelledJobData cancelledData = (CancelledJobData)object.getValue();
            long originalDelayInMs = cancelledData.getOriginalDelayInMs();
            long scheduledAt = cancelledData.getScheduledAt();
            long elapsedTime = currentTime - scheduledAt;
            long remainingTime = originalDelayInMs - elapsedTime;
            this.logger.verbose(this.accountId, this.TAG + " Id " + id2 + " - Original delay: " + originalDelayInMs + "ms, Elapsed: " + elapsedTime + "ms, Remaining: " + remainingTime + "ms");
            boolean bl2 = remainingTime > 0L ? toReschedule.add(new RescheduleData(id2, remainingTime, cancelledData.getCallback())) : toDiscard.add(id2);
        }
        int rescheduledCount = 0;
        Iterable $this$forEach$iv2 = toReschedule;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            RescheduleData data = (RescheduleData)element$iv;
            boolean bl = false;
            this.scheduleTimer(data.getId(), data.getRemainingTimeInMs(), data.getCallback());
            ++rescheduledCount;
            this.logger.verbose(this.accountId, this.TAG + " Rescheduled " + data.getId() + " with " + data.getRemainingTimeInMs() + "ms remaining");
        }
        int discardedCount = 0;
        Iterable $this$forEach$iv3 = toDiscard;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv3) {
            String id3 = (String)element$iv;
            boolean bl = false;
            Function1<TimerResult, Unit> cancelledData = this.cancelledJobs.remove(id3);
            ++discardedCount;
            Function1<TimerResult, Unit> function1 = cancelledData;
            if (function1 != null && (function1 = function1.getCallback()) != null) {
                function1.invoke((Object)new TimerResult.Discarded(id3));
            }
            this.logger.verbose(this.accountId, this.TAG + " Discarded expired timer: " + id3);
        }
        this.logger.verbose(this.accountId, this.TAG + " Foreground handling complete - Rescheduled: " + rescheduledCount + ", Discarded: " + discardedCount);
    }

    private final void logCoroutineInfo(String msg) {
        this.logger.verbose(this.accountId, this.TAG + " Running on: [" + Thread.currentThread().getName() + "] | " + msg);
    }

    public static final /* synthetic */ Object access$cancelAllTimers(InAppTimerManager $this, Continuation $completion) {
        return $this.cancelAllTimers((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Clock access$getClock$p(InAppTimerManager $this) {
        return $this.clock;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getCancelledJobs$p(InAppTimerManager $this) {
        return $this.cancelledJobs;
    }

    public static final /* synthetic */ ILogger access$getLogger$p(InAppTimerManager $this) {
        return $this.logger;
    }

    public static final /* synthetic */ String access$getAccountId$p(InAppTimerManager $this) {
        return $this.accountId;
    }

    public static final /* synthetic */ String access$getTAG$p(InAppTimerManager $this) {
        return $this.TAG;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getActiveJobs$p(InAppTimerManager $this) {
        return $this.activeJobs;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u00c6\u0003J3\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/clevertap/android/sdk/inapp/delay/InAppTimerManager$CancelledJobData;", "", "originalDelayInMs", "", "scheduledAt", "callback", "Lkotlin/Function1;", "Lcom/clevertap/android/sdk/inapp/delay/InAppTimerManager$TimerResult;", "", "<init>", "(JJLkotlin/jvm/functions/Function1;)V", "getOriginalDelayInMs", "()J", "getScheduledAt", "getCallback", "()Lkotlin/jvm/functions/Function1;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "clevertap-core_release"})
    private static final class CancelledJobData {
        private final long originalDelayInMs;
        private final long scheduledAt;
        @NotNull
        private final Function1<TimerResult, Unit> callback;

        public CancelledJobData(long originalDelayInMs, long scheduledAt, @NotNull Function1<? super TimerResult, Unit> callback) {
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            this.originalDelayInMs = originalDelayInMs;
            this.scheduledAt = scheduledAt;
            this.callback = callback;
        }

        public final long getOriginalDelayInMs() {
            return this.originalDelayInMs;
        }

        public final long getScheduledAt() {
            return this.scheduledAt;
        }

        @NotNull
        public final Function1<TimerResult, Unit> getCallback() {
            return this.callback;
        }

        public final long component1() {
            return this.originalDelayInMs;
        }

        public final long component2() {
            return this.scheduledAt;
        }

        @NotNull
        public final Function1<TimerResult, Unit> component3() {
            return this.callback;
        }

        @NotNull
        public final CancelledJobData copy(long originalDelayInMs, long scheduledAt, @NotNull Function1<? super TimerResult, Unit> callback) {
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            return new CancelledJobData(originalDelayInMs, scheduledAt, callback);
        }

        public static /* synthetic */ CancelledJobData copy$default(CancelledJobData cancelledJobData, long l, long l2, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                l = cancelledJobData.originalDelayInMs;
            }
            if ((n & 2) != 0) {
                l2 = cancelledJobData.scheduledAt;
            }
            if ((n & 4) != 0) {
                function1 = cancelledJobData.callback;
            }
            return cancelledJobData.copy(l, l2, function1);
        }

        @NotNull
        public String toString() {
            return "CancelledJobData(originalDelayInMs=" + this.originalDelayInMs + ", scheduledAt=" + this.scheduledAt + ", callback=" + this.callback + ')';
        }

        public int hashCode() {
            int result = Long.hashCode(this.originalDelayInMs);
            result = result * 31 + Long.hashCode(this.scheduledAt);
            result = result * 31 + this.callback.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CancelledJobData)) {
                return false;
            }
            CancelledJobData cancelledJobData = (CancelledJobData)other;
            if (this.originalDelayInMs != cancelledJobData.originalDelayInMs) {
                return false;
            }
            if (this.scheduledAt != cancelledJobData.scheduledAt) {
                return false;
            }
            return Intrinsics.areEqual(this.callback, cancelledJobData.callback);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/clevertap/android/sdk/inapp/delay/InAppTimerManager$Companion;", "", "<init>", "()V", "PARALLEL_SCHEDULERS", "", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u00c6\u0003J3\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lcom/clevertap/android/sdk/inapp/delay/InAppTimerManager$RescheduleData;", "", "id", "", "remainingTimeInMs", "", "callback", "Lkotlin/Function1;", "Lcom/clevertap/android/sdk/inapp/delay/InAppTimerManager$TimerResult;", "", "<init>", "(Ljava/lang/String;JLkotlin/jvm/functions/Function1;)V", "getId", "()Ljava/lang/String;", "getRemainingTimeInMs", "()J", "getCallback", "()Lkotlin/jvm/functions/Function1;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "clevertap-core_release"})
    private static final class RescheduleData {
        @NotNull
        private final String id;
        private final long remainingTimeInMs;
        @NotNull
        private final Function1<TimerResult, Unit> callback;

        public RescheduleData(@NotNull String id2, long remainingTimeInMs, @NotNull Function1<? super TimerResult, Unit> callback) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            this.id = id2;
            this.remainingTimeInMs = remainingTimeInMs;
            this.callback = callback;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        public final long getRemainingTimeInMs() {
            return this.remainingTimeInMs;
        }

        @NotNull
        public final Function1<TimerResult, Unit> getCallback() {
            return this.callback;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        public final long component2() {
            return this.remainingTimeInMs;
        }

        @NotNull
        public final Function1<TimerResult, Unit> component3() {
            return this.callback;
        }

        @NotNull
        public final RescheduleData copy(@NotNull String id2, long remainingTimeInMs, @NotNull Function1<? super TimerResult, Unit> callback) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            return new RescheduleData(id2, remainingTimeInMs, callback);
        }

        public static /* synthetic */ RescheduleData copy$default(RescheduleData rescheduleData, String string2, long l, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = rescheduleData.id;
            }
            if ((n & 2) != 0) {
                l = rescheduleData.remainingTimeInMs;
            }
            if ((n & 4) != 0) {
                function1 = rescheduleData.callback;
            }
            return rescheduleData.copy(string2, l, function1);
        }

        @NotNull
        public String toString() {
            return "RescheduleData(id=" + this.id + ", remainingTimeInMs=" + this.remainingTimeInMs + ", callback=" + this.callback + ')';
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + Long.hashCode(this.remainingTimeInMs);
            result = result * 31 + this.callback.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RescheduleData)) {
                return false;
            }
            RescheduleData rescheduleData = (RescheduleData)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)rescheduleData.id)) {
                return false;
            }
            if (this.remainingTimeInMs != rescheduleData.remainingTimeInMs) {
                return false;
            }
            return Intrinsics.areEqual(this.callback, rescheduleData.callback);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n"}, d2={"Lcom/clevertap/android/sdk/inapp/delay/InAppTimerManager$TimerResult;", "", "<init>", "()V", "Completed", "Error", "Discarded", "Lcom/clevertap/android/sdk/inapp/delay/InAppTimerManager$TimerResult$Completed;", "Lcom/clevertap/android/sdk/inapp/delay/InAppTimerManager$TimerResult$Discarded;", "Lcom/clevertap/android/sdk/inapp/delay/InAppTimerManager$TimerResult$Error;", "clevertap-core_release"})
    public static abstract class TimerResult {
        private TimerResult() {
        }

        public /* synthetic */ TimerResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/clevertap/android/sdk/inapp/delay/InAppTimerManager$TimerResult$Completed;", "Lcom/clevertap/android/sdk/inapp/delay/InAppTimerManager$TimerResult;", "id", "", "scheduledAt", "", "<init>", "(Ljava/lang/String;J)V", "getId", "()Ljava/lang/String;", "getScheduledAt", "()J", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "clevertap-core_release"})
        public static final class Completed
        extends TimerResult {
            @NotNull
            private final String id;
            private final long scheduledAt;

            public Completed(@NotNull String id2, long scheduledAt) {
                Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
                super(null);
                this.id = id2;
                this.scheduledAt = scheduledAt;
            }

            @NotNull
            public final String getId() {
                return this.id;
            }

            public final long getScheduledAt() {
                return this.scheduledAt;
            }

            @NotNull
            public final String component1() {
                return this.id;
            }

            public final long component2() {
                return this.scheduledAt;
            }

            @NotNull
            public final Completed copy(@NotNull String id2, long scheduledAt) {
                Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
                return new Completed(id2, scheduledAt);
            }

            public static /* synthetic */ Completed copy$default(Completed completed, String string2, long l, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = completed.id;
                }
                if ((n & 2) != 0) {
                    l = completed.scheduledAt;
                }
                return completed.copy(string2, l);
            }

            @NotNull
            public String toString() {
                return "Completed(id=" + this.id + ", scheduledAt=" + this.scheduledAt + ')';
            }

            public int hashCode() {
                int result = this.id.hashCode();
                result = result * 31 + Long.hashCode(this.scheduledAt);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Completed)) {
                    return false;
                }
                Completed completed = (Completed)other;
                if (!Intrinsics.areEqual((Object)this.id, (Object)completed.id)) {
                    return false;
                }
                return this.scheduledAt == completed.scheduledAt;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/clevertap/android/sdk/inapp/delay/InAppTimerManager$TimerResult$Discarded;", "Lcom/clevertap/android/sdk/inapp/delay/InAppTimerManager$TimerResult;", "id", "", "<init>", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "clevertap-core_release"})
        public static final class Discarded
        extends TimerResult {
            @NotNull
            private final String id;

            public Discarded(@NotNull String id2) {
                Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
                super(null);
                this.id = id2;
            }

            @NotNull
            public final String getId() {
                return this.id;
            }

            @NotNull
            public final String component1() {
                return this.id;
            }

            @NotNull
            public final Discarded copy(@NotNull String id2) {
                Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
                return new Discarded(id2);
            }

            public static /* synthetic */ Discarded copy$default(Discarded discarded, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = discarded.id;
                }
                return discarded.copy(string2);
            }

            @NotNull
            public String toString() {
                return "Discarded(id=" + this.id + ')';
            }

            public int hashCode() {
                return this.id.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Discarded)) {
                    return false;
                }
                Discarded discarded = (Discarded)other;
                return Intrinsics.areEqual((Object)this.id, (Object)discarded.id);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0006j\u0002`\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0012\u0010\u000f\u001a\u00060\u0006j\u0002`\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ&\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\f\b\u0002\u0010\u0004\u001a\u00060\u0006j\u0002`\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\u00060\u0006j\u0002`\u0005\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/clevertap/android/sdk/inapp/delay/InAppTimerManager$TimerResult$Error;", "Lcom/clevertap/android/sdk/inapp/delay/InAppTimerManager$TimerResult;", "id", "", "exception", "Lkotlin/Exception;", "Ljava/lang/Exception;", "<init>", "(Ljava/lang/String;Ljava/lang/Exception;)V", "getId", "()Ljava/lang/String;", "getException", "()Ljava/lang/Exception;", "Ljava/lang/Exception;", "component1", "component2", "copy", "(Ljava/lang/String;Ljava/lang/Exception;)Lcom/clevertap/android/sdk/inapp/delay/InAppTimerManager$TimerResult$Error;", "equals", "", "other", "", "hashCode", "", "toString", "clevertap-core_release"})
        public static final class Error
        extends TimerResult {
            @NotNull
            private final String id;
            @NotNull
            private final Exception exception;

            public Error(@NotNull String id2, @NotNull Exception exception) {
                Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                super(null);
                this.id = id2;
                this.exception = exception;
            }

            @NotNull
            public final String getId() {
                return this.id;
            }

            @NotNull
            public final Exception getException() {
                return this.exception;
            }

            @NotNull
            public final String component1() {
                return this.id;
            }

            @NotNull
            public final Exception component2() {
                return this.exception;
            }

            @NotNull
            public final Error copy(@NotNull String id2, @NotNull Exception exception) {
                Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                return new Error(id2, exception);
            }

            public static /* synthetic */ Error copy$default(Error error, String string2, Exception exception, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = error.id;
                }
                if ((n & 2) != 0) {
                    exception = error.exception;
                }
                return error.copy(string2, exception);
            }

            @NotNull
            public String toString() {
                return "Error(id=" + this.id + ", exception=" + this.exception + ')';
            }

            public int hashCode() {
                int result = this.id.hashCode();
                result = result * 31 + this.exception.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Error)) {
                    return false;
                }
                Error error = (Error)other;
                if (!Intrinsics.areEqual((Object)this.id, (Object)error.id)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.exception, (Object)error.exception);
            }
        }
    }
}

