/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.gif;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.gif.GifFrame;
import com.clevertap.android.sdk.gif.GifHeader;
import com.clevertap.android.sdk.gif.GifHeaderParser;
import com.clevertap.android.sdk.gif.SimpleBitmapProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

class GifDecoder {
    static final int STATUS_OK = 0;
    static final int STATUS_FORMAT_ERROR = 1;
    static final int STATUS_OPEN_ERROR = 2;
    static final int STATUS_PARTIAL_DECODE = 3;
    static final int LOOP_FOREVER = -1;
    private static final String TAG = GifDecoder.class.getSimpleName();
    private static final int MAX_STACK_SIZE = 4096;
    private static final int DISPOSAL_UNSPECIFIED = 0;
    private static final int DISPOSAL_NONE = 1;
    private static final int DISPOSAL_BACKGROUND = 2;
    private static final int DISPOSAL_PREVIOUS = 3;
    private static final int NULL_CODE = -1;
    private static final int INITIAL_FRAME_POINTER = -1;
    private static final int BYTES_PER_INTEGER = 4;
    private static final int WORK_BUFFER_SIZE = 16384;
    private int[] act;
    private final BitmapProvider bitmapProvider;
    private byte[] block;
    private int downsampledHeight;
    private int downsampledWidth;
    private int framePointer;
    private GifHeader header;
    private boolean isFirstFrameTransparent;
    private int loopIndex;
    private byte[] mainPixels;
    private int[] mainScratch;
    private GifHeaderParser parser;
    private final int[] pct = new int[256];
    private byte[] pixelStack;
    private short[] prefix;
    private Bitmap previousImage;
    private ByteBuffer rawData;
    private int sampleSize;
    private boolean savePrevious;
    private int status;
    private byte[] suffix;
    @Nullable
    private byte[] workBuffer;
    private int workBufferPosition = 0;
    private int workBufferSize = 0;

    GifDecoder(BitmapProvider provider, GifHeader gifHeader, ByteBuffer rawData) {
        this(provider, gifHeader, rawData, 1);
    }

    GifDecoder(BitmapProvider provider, GifHeader gifHeader, ByteBuffer rawData, int sampleSize) {
        this(provider);
        this.setData(gifHeader, rawData, sampleSize);
    }

    GifDecoder(BitmapProvider provider) {
        this.bitmapProvider = provider;
        this.header = new GifHeader();
    }

    GifDecoder() {
        this(new SimpleBitmapProvider());
    }

    boolean advance() {
        if (this.header.frameCount <= 0) {
            return false;
        }
        if (this.framePointer == this.getFrameCount() - 1) {
            ++this.loopIndex;
        }
        if (this.header.loopCount != -1 && this.loopIndex > this.header.loopCount) {
            return false;
        }
        this.framePointer = (this.framePointer + 1) % this.header.frameCount;
        return true;
    }

    void clear() {
        this.header = null;
        if (this.mainPixels != null) {
            this.bitmapProvider.release(this.mainPixels);
        }
        if (this.mainScratch != null) {
            this.bitmapProvider.release(this.mainScratch);
        }
        if (this.previousImage != null) {
            this.bitmapProvider.release(this.previousImage);
        }
        this.previousImage = null;
        this.rawData = null;
        this.isFirstFrameTransparent = false;
        if (this.block != null) {
            this.bitmapProvider.release(this.block);
        }
        if (this.workBuffer != null) {
            this.bitmapProvider.release(this.workBuffer);
        }
    }

    int getByteSize() {
        return this.rawData.limit() + this.mainPixels.length + this.mainScratch.length * 4;
    }

    int getCurrentFrameIndex() {
        return this.framePointer;
    }

    ByteBuffer getData() {
        return this.rawData;
    }

    int getDelay(int n) {
        int delay = -1;
        if (n >= 0 && n < this.header.frameCount) {
            delay = this.header.frames.get((int)n).delay;
        }
        return delay;
    }

    int getFrameCount() {
        return this.header.frameCount;
    }

    int getHeight() {
        return this.header.height;
    }

    int getLoopCount() {
        return this.header.loopCount;
    }

    int getLoopIndex() {
        return this.loopIndex;
    }

    int getNextDelay() {
        if (this.header.frameCount <= 0 || this.framePointer < 0) {
            return 0;
        }
        return this.getDelay(this.framePointer);
    }

    synchronized Bitmap getNextFrame() {
        if (this.header.frameCount <= 0 || this.framePointer < 0) {
            Logger.d(TAG, "unable to decode frame, frameCount=" + this.header.frameCount + " framePointer=" + this.framePointer);
            this.status = 1;
        }
        if (this.status == 1 || this.status == 2) {
            Logger.d(TAG, "Unable to decode frame, status=" + this.status);
            return null;
        }
        this.status = 0;
        GifFrame currentFrame = this.header.frames.get(this.framePointer);
        GifFrame previousFrame = null;
        int previousIndex = this.framePointer - 1;
        if (previousIndex >= 0) {
            previousFrame = this.header.frames.get(previousIndex);
        }
        int[] nArray = this.act = currentFrame.lct != null ? currentFrame.lct : this.header.gct;
        if (this.act == null) {
            Logger.d(TAG, "No Valid Color Table for frame #" + this.framePointer);
            this.status = 1;
            return null;
        }
        if (currentFrame.transparency) {
            System.arraycopy(this.act, 0, this.pct, 0, this.act.length);
            this.act = this.pct;
            this.act[currentFrame.transIndex] = 0;
        }
        return this.setPixels(currentFrame, previousFrame);
    }

    int getStatus() {
        return this.status;
    }

    int getWidth() {
        return this.header.width;
    }

    int read(InputStream is, int contentLength) {
        if (is != null) {
            try {
                int nRead;
                int capacity = contentLength > 0 ? contentLength + 4096 : 16384;
                ByteArrayOutputStream buffer = new ByteArrayOutputStream(capacity);
                byte[] data = new byte[16384];
                while ((nRead = is.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
                buffer.flush();
                this.read(buffer.toByteArray());
            }
            catch (IOException e) {
                Logger.d(TAG, "Error reading data from stream", e);
            }
        } else {
            this.status = 2;
        }
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException e) {
            Logger.d(TAG, "Error closing stream", e);
        }
        return this.status;
    }

    synchronized int read(byte[] data) {
        this.header = this.getHeaderParser().setData(data).parseHeader();
        if (data != null) {
            this.setData(this.header, data);
        }
        return this.status;
    }

    void resetFrameIndex() {
        this.framePointer = -1;
    }

    void resetLoopIndex() {
        this.loopIndex = 0;
    }

    synchronized void setData(GifHeader header, byte[] data) {
        this.setData(header, ByteBuffer.wrap(data));
    }

    synchronized void setData(GifHeader header, ByteBuffer buffer) {
        this.setData(header, buffer, 1);
    }

    synchronized void setData(GifHeader header, ByteBuffer buffer, int sampleSize) {
        if (sampleSize <= 0) {
            throw new IllegalArgumentException("Sample size must be >=0, not: " + sampleSize);
        }
        sampleSize = Integer.highestOneBit(sampleSize);
        this.status = 0;
        this.header = header;
        this.isFirstFrameTransparent = false;
        this.framePointer = -1;
        this.resetLoopIndex();
        this.rawData = buffer.asReadOnlyBuffer();
        this.rawData.position(0);
        this.rawData.order(ByteOrder.LITTLE_ENDIAN);
        this.savePrevious = false;
        for (GifFrame frame : header.frames) {
            if (frame.dispose != 3) continue;
            this.savePrevious = true;
            break;
        }
        this.sampleSize = sampleSize;
        this.downsampledWidth = header.width / sampleSize;
        this.downsampledHeight = header.height / sampleSize;
        this.mainPixels = this.bitmapProvider.obtainByteArray(header.width * header.height);
        this.mainScratch = this.bitmapProvider.obtainIntArray(this.downsampledWidth * this.downsampledHeight);
    }

    boolean setFrameIndex(int frame) {
        if (frame < -1 || frame >= this.getFrameCount()) {
            return false;
        }
        this.framePointer = frame;
        return true;
    }

    private int averageColorsNear(int positionInMainPixels, int maxPositionInMainPixels, int currentFrameIw) {
        int currentColor;
        int currentColorIndex;
        int i;
        int alphaSum = 0;
        int redSum = 0;
        int greenSum = 0;
        int blueSum = 0;
        int totalAdded = 0;
        for (i = positionInMainPixels; i < positionInMainPixels + this.sampleSize && i < this.mainPixels.length && i < maxPositionInMainPixels; ++i) {
            currentColorIndex = this.mainPixels[i] & 0xFF;
            currentColor = this.act[currentColorIndex];
            if (currentColor == 0) continue;
            alphaSum += currentColor >> 24 & 0xFF;
            redSum += currentColor >> 16 & 0xFF;
            greenSum += currentColor >> 8 & 0xFF;
            blueSum += currentColor & 0xFF;
            ++totalAdded;
        }
        for (i = positionInMainPixels + currentFrameIw; i < positionInMainPixels + currentFrameIw + this.sampleSize && i < this.mainPixels.length && i < maxPositionInMainPixels; ++i) {
            currentColorIndex = this.mainPixels[i] & 0xFF;
            currentColor = this.act[currentColorIndex];
            if (currentColor == 0) continue;
            alphaSum += currentColor >> 24 & 0xFF;
            redSum += currentColor >> 16 & 0xFF;
            greenSum += currentColor >> 8 & 0xFF;
            blueSum += currentColor & 0xFF;
            ++totalAdded;
        }
        if (totalAdded == 0) {
            return 0;
        }
        return alphaSum / totalAdded << 24 | redSum / totalAdded << 16 | greenSum / totalAdded << 8 | blueSum / totalAdded;
    }

    private void decodeBitmapData(GifFrame frame) {
        int code;
        int npix;
        this.workBufferSize = 0;
        this.workBufferPosition = 0;
        if (frame != null) {
            this.rawData.position(frame.bufferFrameStart);
        }
        int n = npix = frame == null ? this.header.width * this.header.height : frame.iw * frame.ih;
        if (this.mainPixels == null || this.mainPixels.length < npix) {
            this.mainPixels = this.bitmapProvider.obtainByteArray(npix);
        }
        if (this.prefix == null) {
            this.prefix = new short[4096];
        }
        if (this.suffix == null) {
            this.suffix = new byte[4096];
        }
        if (this.pixelStack == null) {
            this.pixelStack = new byte[4097];
        }
        int dataSize = this.readByte();
        int clear = 1 << dataSize;
        int endOfInformation = clear + 1;
        int available = clear + 2;
        int oldCode = -1;
        int codeSize = dataSize + 1;
        int codeMask = (1 << codeSize) - 1;
        for (code = 0; code < clear; ++code) {
            this.prefix[code] = 0;
            this.suffix[code] = (byte)code;
        }
        int bi = 0;
        int pi = 0;
        int top = 0;
        int first = 0;
        int count = 0;
        int bits = 0;
        int datum = 0;
        int i = 0;
        block1: while (i < npix) {
            if (count == 0) {
                count = this.readBlock();
                if (count <= 0) {
                    this.status = 3;
                    break;
                }
                bi = 0;
            }
            datum += (this.block[bi] & 0xFF) << bits;
            bits += 8;
            ++bi;
            --count;
            while (bits >= codeSize) {
                code = datum & codeMask;
                datum >>= codeSize;
                bits -= codeSize;
                if (code == clear) {
                    codeSize = dataSize + 1;
                    codeMask = (1 << codeSize) - 1;
                    available = clear + 2;
                    oldCode = -1;
                    continue;
                }
                if (code > available) {
                    this.status = 3;
                    continue block1;
                }
                if (code == endOfInformation) continue block1;
                if (oldCode == -1) {
                    this.pixelStack[top++] = this.suffix[code];
                    oldCode = code;
                    first = code;
                    continue;
                }
                int inCode = code;
                if (code >= available) {
                    this.pixelStack[top++] = (byte)first;
                    code = oldCode;
                }
                while (code >= clear) {
                    this.pixelStack[top++] = this.suffix[code];
                    code = this.prefix[code];
                }
                first = this.suffix[code] & 0xFF;
                this.pixelStack[top++] = (byte)first;
                if (available < 4096) {
                    this.prefix[available] = (short)oldCode;
                    this.suffix[available] = (byte)first;
                    if ((++available & codeMask) == 0 && available < 4096) {
                        ++codeSize;
                        codeMask += available;
                    }
                }
                oldCode = inCode;
                while (top > 0) {
                    this.mainPixels[pi++] = this.pixelStack[--top];
                    ++i;
                }
            }
        }
        for (i = pi; i < npix; ++i) {
            this.mainPixels[i] = 0;
        }
    }

    private void fillRect(int[] dest, GifFrame frame, int bgColor) {
        int downsampledIH = frame.ih / this.sampleSize;
        int downsampledIY = frame.iy / this.sampleSize;
        int downsampledIW = frame.iw / this.sampleSize;
        int downsampledIX = frame.ix / this.sampleSize;
        int topLeft = downsampledIY * this.downsampledWidth + downsampledIX;
        int bottomLeft = topLeft + downsampledIH * this.downsampledWidth;
        for (int left = topLeft; left < bottomLeft; left += this.downsampledWidth) {
            int right = left + downsampledIW;
            for (int pointer = left; pointer < right; ++pointer) {
                dest[pointer] = bgColor;
            }
        }
    }

    private GifHeaderParser getHeaderParser() {
        if (this.parser == null) {
            this.parser = new GifHeaderParser();
        }
        return this.parser;
    }

    private Bitmap getNextBitmap() {
        Bitmap.Config config = this.isFirstFrameTransparent ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
        Bitmap result = this.bitmapProvider.obtain(this.downsampledWidth, this.downsampledHeight, config);
        GifDecoder.setAlpha(result);
        return result;
    }

    private int readBlock() {
        int blockSize = this.readByte();
        if (blockSize > 0) {
            try {
                int remaining;
                if (this.block == null) {
                    this.block = this.bitmapProvider.obtainByteArray(255);
                }
                if ((remaining = this.workBufferSize - this.workBufferPosition) >= blockSize) {
                    System.arraycopy(this.workBuffer, this.workBufferPosition, this.block, 0, blockSize);
                    this.workBufferPosition += blockSize;
                } else if (this.rawData.remaining() + remaining >= blockSize) {
                    System.arraycopy(this.workBuffer, this.workBufferPosition, this.block, 0, remaining);
                    this.workBufferPosition = this.workBufferSize;
                    this.readChunkIfNeeded();
                    int secondHalfRemaining = blockSize - remaining;
                    System.arraycopy(this.workBuffer, 0, this.block, remaining, secondHalfRemaining);
                    this.workBufferPosition += secondHalfRemaining;
                } else {
                    this.status = 1;
                }
            }
            catch (Exception e) {
                Logger.d(TAG, "Error Reading Block", e);
                this.status = 1;
            }
        }
        return blockSize;
    }

    private int readByte() {
        try {
            this.readChunkIfNeeded();
            return this.workBuffer[this.workBufferPosition++] & 0xFF;
        }
        catch (Exception e) {
            this.status = 1;
            return 0;
        }
    }

    private void readChunkIfNeeded() {
        if (this.workBufferSize > this.workBufferPosition) {
            return;
        }
        if (this.workBuffer == null) {
            this.workBuffer = this.bitmapProvider.obtainByteArray(16384);
        }
        this.workBufferPosition = 0;
        this.workBufferSize = Math.min(this.rawData.remaining(), 16384);
        this.rawData.get(this.workBuffer, 0, this.workBufferSize);
    }

    private Bitmap setPixels(GifFrame currentFrame, GifFrame previousFrame) {
        int downsampledIX;
        int downsampledIW;
        int downsampledIY;
        int downsampledIH;
        int[] dest = this.mainScratch;
        if (previousFrame == null) {
            Arrays.fill(dest, 0);
        }
        if (previousFrame != null && previousFrame.dispose > 0) {
            if (previousFrame.dispose == 2) {
                int c = 0;
                if (!currentFrame.transparency) {
                    c = this.header.bgColor;
                    if (currentFrame.lct != null && this.header.bgIndex == currentFrame.transIndex) {
                        c = 0;
                    }
                } else if (this.framePointer == 0) {
                    this.isFirstFrameTransparent = true;
                }
                this.fillRect(dest, previousFrame, c);
            } else if (previousFrame.dispose == 3) {
                if (this.previousImage == null) {
                    this.fillRect(dest, previousFrame, 0);
                } else {
                    downsampledIH = previousFrame.ih / this.sampleSize;
                    downsampledIY = previousFrame.iy / this.sampleSize;
                    downsampledIW = previousFrame.iw / this.sampleSize;
                    downsampledIX = previousFrame.ix / this.sampleSize;
                    int topLeft = downsampledIY * this.downsampledWidth + downsampledIX;
                    this.previousImage.getPixels(dest, topLeft, this.downsampledWidth, downsampledIX, downsampledIY, downsampledIW, downsampledIH);
                }
            }
        }
        this.decodeBitmapData(currentFrame);
        downsampledIH = currentFrame.ih / this.sampleSize;
        downsampledIY = currentFrame.iy / this.sampleSize;
        downsampledIW = currentFrame.iw / this.sampleSize;
        downsampledIX = currentFrame.ix / this.sampleSize;
        int pass = 1;
        int inc = 8;
        int iline = 0;
        boolean isFirstFrame = this.framePointer == 0;
        for (int i = 0; i < downsampledIH; ++i) {
            int line = i;
            if (currentFrame.interlace) {
                if (iline >= downsampledIH) {
                    switch (++pass) {
                        case 2: {
                            iline = 4;
                            break;
                        }
                        case 3: {
                            iline = 2;
                            inc = 4;
                            break;
                        }
                        case 4: {
                            iline = 1;
                            inc = 2;
                            break;
                        }
                    }
                }
                line = iline;
                iline += inc;
            }
            if ((line += downsampledIY) >= this.downsampledHeight) continue;
            int k = line * this.downsampledWidth;
            int dx = k + downsampledIX;
            int dlim = dx + downsampledIW;
            if (k + this.downsampledWidth < dlim) {
                dlim = k + this.downsampledWidth;
            }
            int sx = i * this.sampleSize * currentFrame.iw;
            int maxPositionInSource = sx + (dlim - dx) * this.sampleSize;
            while (dx < dlim) {
                int averageColor;
                if (this.sampleSize == 1) {
                    int currentColorIndex = this.mainPixels[sx] & 0xFF;
                    averageColor = this.act[currentColorIndex];
                } else {
                    averageColor = this.averageColorsNear(sx, maxPositionInSource, currentFrame.iw);
                }
                if (averageColor != 0) {
                    dest[dx] = averageColor;
                } else if (!this.isFirstFrameTransparent && isFirstFrame) {
                    this.isFirstFrameTransparent = true;
                }
                sx += this.sampleSize;
                ++dx;
            }
        }
        if (this.savePrevious && (currentFrame.dispose == 0 || currentFrame.dispose == 1)) {
            if (this.previousImage == null) {
                this.previousImage = this.getNextBitmap();
            }
            this.previousImage.setPixels(dest, 0, this.downsampledWidth, 0, 0, this.downsampledWidth, this.downsampledHeight);
        }
        Bitmap result = this.getNextBitmap();
        result.setPixels(dest, 0, this.downsampledWidth, 0, 0, this.downsampledWidth, this.downsampledHeight);
        return result;
    }

    @TargetApi(value=12)
    private static void setAlpha(Bitmap bitmap) {
        if (Build.VERSION.SDK_INT >= 12) {
            bitmap.setHasAlpha(true);
        }
    }

    static interface BitmapProvider {
        @NonNull
        public Bitmap obtain(int var1, int var2, Bitmap.Config var3);

        public byte[] obtainByteArray(int var1);

        public int[] obtainIntArray(int var1);

        public void release(byte[] var1);

        public void release(Bitmap var1);

        public void release(int[] var1);
    }
}

