/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.db.dao;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.ILogger;
import com.clevertap.android.sdk.db.DatabaseHelper;
import com.clevertap.android.sdk.db.Table;
import com.clevertap.android.sdk.db.dao.PushNotificationDAO;
import com.clevertap.android.sdk.utils.Clock;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u0013\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013H\u0017\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u001b\u0010\u0016\u001a\u00020\r2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013H\u0017\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\rH\u0017J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/clevertap/android/sdk/db/dao/PushNotificationDAOImpl;", "Lcom/clevertap/android/sdk/db/dao/PushNotificationDAO;", "dbHelper", "Lcom/clevertap/android/sdk/db/DatabaseHelper;", "logger", "Lcom/clevertap/android/sdk/ILogger;", "clock", "Lcom/clevertap/android/sdk/utils/Clock;", "<init>", "(Lcom/clevertap/android/sdk/db/DatabaseHelper;Lcom/clevertap/android/sdk/ILogger;Lcom/clevertap/android/sdk/utils/Clock;)V", "rtlDirtyFlag", "", "storePushNotificationId", "", "id", "", "ttlInSeconds", "", "fetchPushNotificationIds", "", "()[Ljava/lang/String;", "doesPushNotificationIdExist", "updatePushNotificationIds", "ids", "([Ljava/lang/String;)V", "cleanUpPushNotifications", "fetchPushNotificationId", "getTemplateMarkersList", "count", "", "clevertap-core_release"})
@SourceDebugExtension(value={"SMAP\nPushNotificationDAOImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PushNotificationDAOImpl.kt\ncom/clevertap/android/sdk/db/dao/PushNotificationDAOImpl\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,158:1\n37#2,2:159\n*S KotlinDebug\n*F\n+ 1 PushNotificationDAOImpl.kt\ncom/clevertap/android/sdk/db/dao/PushNotificationDAOImpl\n*L\n78#1:159,2\n*E\n"})
public final class PushNotificationDAOImpl
implements PushNotificationDAO {
    @NotNull
    private final DatabaseHelper dbHelper;
    @NotNull
    private final ILogger logger;
    @NotNull
    private final Clock clock;
    private volatile boolean rtlDirtyFlag;

    public PushNotificationDAOImpl(@NotNull DatabaseHelper dbHelper, @NotNull ILogger logger, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)((Object)dbHelper), (String)"dbHelper");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.dbHelper = dbHelper;
        this.logger = logger;
        this.clock = clock;
        this.rtlDirtyFlag = true;
    }

    public /* synthetic */ PushNotificationDAOImpl(DatabaseHelper databaseHelper, ILogger iLogger, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            clock = Clock.SYSTEM;
        }
        this(databaseHelper, iLogger, clock);
    }

    @Override
    @WorkerThread
    public void storePushNotificationId(@NotNull String id2, long ttlInSeconds) {
        ContentValues contentValues;
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        if (!this.dbHelper.belowMemThreshold()) {
            this.logger.verbose("There is not enough space left on the device to store data, data discarded");
            return;
        }
        String tableName = Table.PUSH_NOTIFICATIONS.getTableName();
        long expiresAt = ttlInSeconds > 0L ? ttlInSeconds : this.clock.currentTimeSeconds() + 345600L;
        ContentValues $this$storePushNotificationId_u24lambda_u240 = contentValues = new ContentValues();
        boolean bl = false;
        $this$storePushNotificationId_u24lambda_u240.put("data", id2);
        $this$storePushNotificationId_u24lambda_u240.put("created_at", Long.valueOf(expiresAt));
        $this$storePushNotificationId_u24lambda_u240.put("isRead", Integer.valueOf(0));
        ContentValues cv = contentValues;
        try {
            this.dbHelper.getWritableDatabase().insert(tableName, null, cv);
            this.rtlDirtyFlag = true;
            this.logger.verbose("Stored PN - " + id2 + " with TTL - " + expiresAt);
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error adding data to table " + tableName + ". Recreating DB", e);
            this.dbHelper.deleteDatabase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    @NotNull
    public String[] fetchPushNotificationIds() {
        List pushIds;
        block9: {
            if (!this.rtlDirtyFlag) {
                return new String[0];
            }
            String tName = Table.PUSH_NOTIFICATIONS.getTableName();
            pushIds = new ArrayList();
            try {
                Cursor cursor = this.dbHelper.getReadableDatabase().query(tName, null, "isRead = 0", null, null, null, null);
                if (cursor == null) break block9;
                Closeable closeable = (Closeable)cursor;
                Throwable throwable = null;
                try {
                    Cursor cursor2 = (Cursor)closeable;
                    boolean bl = false;
                    while (cursor2.moveToNext()) {
                        int dataIndex = cursor2.getColumnIndex("data");
                        if (dataIndex < 0) continue;
                        String data = cursor2.getString(dataIndex);
                        this.logger.verbose("Fetching PID - " + data);
                        if (data == null) continue;
                        pushIds.add(data);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (SQLiteException e) {
                this.logger.verbose("Could not fetch records out of database " + tName + '.', e);
            }
        }
        Collection $this$toTypedArray$iv = pushIds;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    @Override
    @WorkerThread
    public boolean doesPushNotificationIdExist(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        return Intrinsics.areEqual((Object)id2, (Object)this.fetchPushNotificationId(id2));
    }

    @Override
    @WorkerThread
    public void updatePushNotificationIds(@NotNull String[] ids) {
        ContentValues contentValues;
        Intrinsics.checkNotNullParameter((Object)ids, (String)"ids");
        if (ids.length == 0) {
            return;
        }
        if (!this.dbHelper.belowMemThreshold()) {
            this.logger.verbose("There is not enough space left on the device to store data, data discarded");
            return;
        }
        String tableName = Table.PUSH_NOTIFICATIONS.getTableName();
        ContentValues $this$updatePushNotificationIds_u24lambda_u242 = contentValues = new ContentValues();
        boolean bl = false;
        $this$updatePushNotificationIds_u24lambda_u242.put("isRead", Integer.valueOf(1));
        ContentValues cv = contentValues;
        String idsTemplateGroup = this.getTemplateMarkersList(ids.length);
        try {
            this.dbHelper.getWritableDatabase().update(tableName, cv, "data IN (" + idsTemplateGroup + ')', ids);
            this.rtlDirtyFlag = false;
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error updating data in table " + tableName + ". Recreating DB", e);
            this.dbHelper.deleteDatabase();
        }
    }

    @Override
    @WorkerThread
    public void cleanUpPushNotifications() {
        long time = this.clock.currentTimeSeconds();
        String tName = Table.PUSH_NOTIFICATIONS.getTableName();
        try {
            this.dbHelper.getWritableDatabase().delete(tName, "created_at <= " + time, null);
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error removing stale push notification records from " + tName + ". Recreating DB.", e);
            this.dbHelper.deleteDatabase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String fetchPushNotificationId(String id2) {
        String pushId;
        block8: {
            String tName = Table.PUSH_NOTIFICATIONS.getTableName();
            pushId = null;
            pushId = "";
            try {
                Object object = new String[]{id2};
                Cursor cursor = this.dbHelper.getReadableDatabase().query(tName, null, "data = ?", object, null, null, null);
                if (cursor == null) break block8;
                object = (Closeable)cursor;
                Throwable throwable = null;
                try {
                    Cursor cursor2 = (Cursor)object;
                    boolean bl = false;
                    if (cursor2.moveToFirst()) {
                        pushId = cursor2.getString(cursor2.getColumnIndexOrThrow("data"));
                    }
                    this.logger.verbose("Fetching PID for check - " + pushId);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                this.logger.verbose("Could not fetch records out of database " + tName + '.', e);
            }
        }
        return pushId;
    }

    private final String getTemplateMarkersList(int count) {
        StringBuilder stringBuilder;
        StringBuilder $this$getTemplateMarkersList_u24lambda_u245 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (count > 0) {
            $this$getTemplateMarkersList_u24lambda_u245.append("?");
            int n = count - 1;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl2 = false;
                $this$getTemplateMarkersList_u24lambda_u245.append(", ?");
            }
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }
}

