/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.db;

import android.content.Context;
import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.CTLockManager;
import com.clevertap.android.sdk.ILogger;
import com.clevertap.android.sdk.db.BaseDatabaseManager;
import com.clevertap.android.sdk.db.DBAdapter;
import com.clevertap.android.sdk.db.DBEncryptionHandler;
import com.clevertap.android.sdk.db.QueueData;
import com.clevertap.android.sdk.db.Table;
import com.clevertap.android.sdk.events.EventGroup;
import com.clevertap.android.sdk.network.IJRepo;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 42\u00020\u0001:\u00014BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J,\u0010 \u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030#H\u0016J\u001e\u0010%\u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030#H\u0016J\u0018\u0010'\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010(\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001cH\u0017J\u0018\u0010,\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010)\u001a\u00020*H\u0017J\u0010\u0010-\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010.\u001a\u00020\u000fH\u0002J\u0010\u0010/\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u00100\u001a\u00020\u000fH\u0002J \u00101\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010)\u001a\u00020*2\u0006\u00102\u001a\u000203H\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/clevertap/android/sdk/db/DBManager;", "Lcom/clevertap/android/sdk/db/BaseDatabaseManager;", "accountId", "", "logger", "Lcom/clevertap/android/sdk/ILogger;", "databaseName", "ctLockManager", "Lcom/clevertap/android/sdk/CTLockManager;", "ijRepo", "Lcom/clevertap/android/sdk/network/IJRepo;", "dbEncryptionHandler", "Lcom/clevertap/android/sdk/db/DBEncryptionHandler;", "clearFirstRequestTs", "Lkotlin/Function0;", "", "clearLastRequestTs", "<init>", "(Ljava/lang/String;Lcom/clevertap/android/sdk/ILogger;Ljava/lang/String;Lcom/clevertap/android/sdk/CTLockManager;Lcom/clevertap/android/sdk/network/IJRepo;Lcom/clevertap/android/sdk/db/DBEncryptionHandler;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "dbAdapter", "Lcom/clevertap/android/sdk/db/DBAdapter;", "loadDBAdapter", "context", "Landroid/content/Context;", "clearQueues", "getQueuedEvents", "Lcom/clevertap/android/sdk/db/QueueData;", "batchSize", "", "eventGroup", "Lcom/clevertap/android/sdk/events/EventGroup;", "getCombinedQueuedEvents", "cleanupSentEvents", "", "eventIds", "", "profileEventIds", "cleanupPushNotificationEvents", "ids", "getPushNotificationViewedQueuedEvents", "queueEventToDB", "event", "Lorg/json/JSONObject;", "type", "queuePushNotificationViewedEventToDB", "clearIJ", "clearLastRequestTimestamp", "clearUserContext", "clearFirstRequestTimestamp", "queueEventForTable", "table", "Lcom/clevertap/android/sdk/db/Table;", "Companion", "clevertap-core_release"})
public final class DBManager
implements BaseDatabaseManager {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final String accountId;
    @NotNull
    private final ILogger logger;
    @NotNull
    private final String databaseName;
    @NotNull
    private final CTLockManager ctLockManager;
    @NotNull
    private final IJRepo ijRepo;
    @NotNull
    private final DBEncryptionHandler dbEncryptionHandler;
    @NotNull
    private final Function0<Unit> clearFirstRequestTs;
    @NotNull
    private final Function0<Unit> clearLastRequestTs;
    @Nullable
    private DBAdapter dbAdapter;
    private static final int USER_EVENT_LOG_ROWS_PER_USER = 2304;
    private static final int USER_EVENT_LOG_ROWS_THRESHOLD = 11520;

    public DBManager(@NotNull String accountId, @NotNull ILogger logger, @NotNull String databaseName, @NotNull CTLockManager ctLockManager, @NotNull IJRepo ijRepo, @NotNull DBEncryptionHandler dbEncryptionHandler, @NotNull Function0<Unit> clearFirstRequestTs, @NotNull Function0<Unit> clearLastRequestTs) {
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        Intrinsics.checkNotNullParameter((Object)ctLockManager, (String)"ctLockManager");
        Intrinsics.checkNotNullParameter((Object)ijRepo, (String)"ijRepo");
        Intrinsics.checkNotNullParameter((Object)dbEncryptionHandler, (String)"dbEncryptionHandler");
        Intrinsics.checkNotNullParameter(clearFirstRequestTs, (String)"clearFirstRequestTs");
        Intrinsics.checkNotNullParameter(clearLastRequestTs, (String)"clearLastRequestTs");
        this.accountId = accountId;
        this.logger = logger;
        this.databaseName = databaseName;
        this.ctLockManager = ctLockManager;
        this.ijRepo = ijRepo;
        this.dbEncryptionHandler = dbEncryptionHandler;
        this.clearFirstRequestTs = clearFirstRequestTs;
        this.clearLastRequestTs = clearLastRequestTs;
    }

    public /* synthetic */ DBManager(String string2, ILogger iLogger, String string3, CTLockManager cTLockManager, IJRepo iJRepo, DBEncryptionHandler dBEncryptionHandler, Function0 function0, Function0 function02, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            function0 = DBManager::_init_$lambda$0;
        }
        if ((n & 0x80) != 0) {
            function02 = DBManager::_init_$lambda$1;
        }
        this(string2, iLogger, string3, cTLockManager, iJRepo, dBEncryptionHandler, (Function0<Unit>)function0, (Function0<Unit>)function02);
    }

    @Override
    @WorkerThread
    @NotNull
    public synchronized DBAdapter loadDBAdapter(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DBAdapter dbAdapter = this.dbAdapter;
        if (dbAdapter == null) {
            this.dbAdapter = dbAdapter = new DBAdapter(context, this.databaseName, this.accountId, this.logger, this.dbEncryptionHandler, null, 32, null);
            dbAdapter.cleanupStaleEvents(Table.EVENTS);
            dbAdapter.cleanupStaleEvents(Table.PROFILE_EVENTS);
            dbAdapter.cleanupStaleEvents(Table.PUSH_NOTIFICATION_VIEWED);
            dbAdapter.cleanUpPushNotifications();
            dbAdapter.userEventLogDAO().cleanUpExtraEvents(11520, 2304);
            dbAdapter.delayedLegacyInAppDAO().clearAll();
        }
        return dbAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public void clearQueues(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = this.ctLockManager.getEventLock();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getEventLock(...)");
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            DBAdapter adapter = this.loadDBAdapter(context);
            Table tableName = Table.EVENTS;
            adapter.removeEvents(tableName);
            tableName = Table.PROFILE_EVENTS;
            adapter.removeEvents(tableName);
            this.clearUserContext(context);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    @NotNull
    public QueueData getQueuedEvents(@NotNull Context context, int batchSize, @NotNull EventGroup eventGroup) {
        QueueData queueData;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)eventGroup), (String)"eventGroup");
        if (WhenMappings.$EnumSwitchMapping$0[eventGroup.ordinal()] == 1) {
            this.logger.verbose(this.accountId, "Returning Queued Notification Viewed events");
            queueData = this.getPushNotificationViewedQueuedEvents(context, batchSize);
        } else {
            this.logger.verbose(this.accountId, "Returning combined queued events");
            queueData = this.getCombinedQueuedEvents(context, batchSize);
        }
        return queueData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public QueueData getCombinedQueuedEvents(@NotNull Context context, int batchSize) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = this.ctLockManager.getEventLock();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getEventLock(...)");
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            DBAdapter adapter = this.loadDBAdapter(context);
            QueueData queueData = adapter.fetchCombinedEvents(batchSize);
            return queueData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cleanupSentEvents(@NotNull Context context, @NotNull List<String> eventIds, @NotNull List<String> profileEventIds) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(eventIds, (String)"eventIds");
        Intrinsics.checkNotNullParameter(profileEventIds, (String)"profileEventIds");
        Object object = this.ctLockManager.getEventLock();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getEventLock(...)");
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            if (eventIds.isEmpty() && profileEventIds.isEmpty()) {
                boolean bl2 = true;
                return bl2;
            }
            DBAdapter adapter = this.loadDBAdapter(context);
            if (!((Collection)eventIds).isEmpty()) {
                adapter.cleanupEventsFromLastId(eventIds.get(eventIds.size() - 1), Table.EVENTS);
                this.logger.verbose(this.accountId, "Cleaned " + eventIds.size() + " events from events table");
            }
            if (!((Collection)profileEventIds).isEmpty()) {
                adapter.cleanupEventsFromLastId(profileEventIds.get(profileEventIds.size() - 1), Table.PROFILE_EVENTS);
                this.logger.verbose(this.accountId, "Cleaned " + profileEventIds.size() + " events from profileEvents table");
            }
            boolean bl3 = true;
            return bl3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cleanupPushNotificationEvents(@NotNull Context context, @NotNull List<String> ids) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Object object = this.ctLockManager.getEventLock();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getEventLock(...)");
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            if (ids.isEmpty()) {
                boolean bl2 = true;
                return bl2;
            }
            DBAdapter adapter = this.loadDBAdapter(context);
            if (!((Collection)ids).isEmpty()) {
                adapter.cleanupEventsFromLastId(ids.get(ids.size() - 1), Table.PUSH_NOTIFICATION_VIEWED);
                this.logger.verbose(this.accountId, "Cleaned " + ids.size() + " events from Push impressions table");
            }
            boolean bl3 = true;
            return bl3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public QueueData getPushNotificationViewedQueuedEvents(@NotNull Context context, int batchSize) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = this.ctLockManager.getEventLock();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getEventLock(...)");
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            DBAdapter adapter = this.loadDBAdapter(context);
            QueueData queueData = adapter.fetchEvents(Table.PUSH_NOTIFICATION_VIEWED, batchSize);
            return queueData;
        }
    }

    @Override
    @WorkerThread
    public void queueEventToDB(@NotNull Context context, @NotNull JSONObject event, int type) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Table table = type == 3 ? Table.PROFILE_EVENTS : Table.EVENTS;
        this.queueEventForTable(context, event, table);
    }

    @Override
    @WorkerThread
    public void queuePushNotificationViewedEventToDB(@NotNull Context context, @NotNull JSONObject event) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.queueEventForTable(context, event, Table.PUSH_NOTIFICATION_VIEWED);
    }

    private final void clearIJ(Context context) {
        this.ijRepo.clearIJ(context);
    }

    private final void clearLastRequestTimestamp() {
        this.clearLastRequestTs.invoke();
    }

    private final void clearUserContext(Context context) {
        this.clearIJ(context);
        this.clearFirstRequestTimestamp();
        this.clearLastRequestTimestamp();
    }

    private final void clearFirstRequestTimestamp() {
        this.clearFirstRequestTs.invoke();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private final void queueEventForTable(Context context, JSONObject event, Table table) {
        Object object = this.ctLockManager.getEventLock();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getEventLock(...)");
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            DBAdapter adapter = this.loadDBAdapter(context);
            long returnCode = adapter.storeObject(event, table);
            if (returnCode > 0L) {
                this.logger.debug(this.accountId, "Queued event: " + event);
                this.logger.verbose(this.accountId, "Queued event to DB table " + (Object)((Object)table) + ": " + event);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final Unit _init_$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/clevertap/android/sdk/db/DBManager$Companion;", "", "<init>", "()V", "USER_EVENT_LOG_ROWS_PER_USER", "", "USER_EVENT_LOG_ROWS_THRESHOLD", "clevertap-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EventGroup.values().length];
            try {
                nArray[EventGroup.PUSH_NOTIFICATION_VIEWED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

