/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.db;

import com.clevertap.android.sdk.ILogger;
import com.clevertap.android.sdk.cryption.CryptHandler;
import com.clevertap.android.sdk.cryption.EncryptionLevel;
import com.clevertap.android.sdk.cryption.ICryptHandler;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u000bJ6\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u000b2\b\b\u0002\u0010\u0013\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0015H\u0082\b\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/clevertap/android/sdk/db/DBEncryptionHandler;", "", "crypt", "Lcom/clevertap/android/sdk/cryption/ICryptHandler;", "logger", "Lcom/clevertap/android/sdk/ILogger;", "encryptionLevel", "Lcom/clevertap/android/sdk/cryption/EncryptionLevel;", "<init>", "(Lcom/clevertap/android/sdk/cryption/ICryptHandler;Lcom/clevertap/android/sdk/ILogger;Lcom/clevertap/android/sdk/cryption/EncryptionLevel;)V", "unwrapDbData", "", "data", "wrapDbData", "isInCorrectEncryptionFormat", "", "measureTimeInMillisAndLog", "T", "tag", "message", "block", "Lkotlin/Function0;", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion", "clevertap-core_release"})
@SourceDebugExtension(value={"SMAP\nDBEncryptionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DBEncryptionHandler.kt\ncom/clevertap/android/sdk/db/DBEncryptionHandler\n+ 2 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,98:1\n88#1,2:99\n90#1,2:106\n93#1,4:109\n88#1,2:113\n90#1,2:120\n93#1,4:123\n17#2,5:101\n22#2:108\n17#2,5:115\n22#2:122\n17#2,6:127\n*S KotlinDebug\n*F\n+ 1 DBEncryptionHandler.kt\ncom/clevertap/android/sdk/db/DBEncryptionHandler\n*L\n43#1:99,2\n43#1:106,2\n43#1:109,4\n60#1:113,2\n60#1:120,2\n60#1:123,4\n43#1:101,5\n43#1:108\n60#1:115,5\n60#1:122\n89#1:127,6\n*E\n"})
public final class DBEncryptionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ICryptHandler crypt;
    @NotNull
    private final ILogger logger;
    @NotNull
    private final EncryptionLevel encryptionLevel;
    @NotNull
    private static final String TAG = "DBEncryptionHandler";

    public DBEncryptionHandler(@NotNull ICryptHandler crypt, @NotNull ILogger logger, @NotNull EncryptionLevel encryptionLevel) {
        Intrinsics.checkNotNullParameter((Object)crypt, (String)"crypt");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)((Object)encryptionLevel), (String)"encryptionLevel");
        this.crypt = crypt;
        this.logger = logger;
        this.encryptionLevel = encryptionLevel;
    }

    public /* synthetic */ DBEncryptionHandler(ICryptHandler iCryptHandler, ILogger iLogger, EncryptionLevel encryptionLevel, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            encryptionLevel = EncryptionLevel.NONE;
        }
        this(iCryptHandler, iLogger, encryptionLevel);
    }

    @Nullable
    public final String unwrapDbData(@Nullable String data) {
        String string2;
        DBEncryptionHandler dBEncryptionHandler = this;
        String string3 = TAG;
        String message$iv = "unwrapDbData";
        boolean $i$f$measureTimeInMillisAndLog = false;
        String result$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        boolean bl = false;
        boolean bl2 = false;
        if (data == null) {
            string2 = data;
        } else {
            String op = this.crypt.decryptSafe(data);
            if (op == null) {
                this.logger.verbose(TAG, "unwrapDbData: Decryption failed for " + data);
            }
            string2 = op;
        }
        result$iv = string2;
        long timeMillis$iv = System.currentTimeMillis() - start$iv$iv;
        return result$iv;
    }

    @NotNull
    public final String wrapDbData(@NotNull String data) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        DBEncryptionHandler dBEncryptionHandler = this;
        String string3 = TAG;
        String message$iv = "wrapDbData";
        boolean $i$f$measureTimeInMillisAndLog = false;
        String result$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        boolean bl = false;
        boolean bl2 = false;
        if (this.encryptionLevel == EncryptionLevel.FULL_DATA) {
            String op = this.crypt.encryptSafe(data);
            if (op == null) {
                this.logger.verbose(TAG, "wrapDbData: Encryption failed for " + data);
            }
            if ((string2 = op) == null) {
                string2 = data;
            }
        } else {
            string2 = data;
        }
        result$iv = string2;
        long timeMillis$iv = System.currentTimeMillis() - start$iv$iv;
        return result$iv;
    }

    public final boolean isInCorrectEncryptionFormat(@NotNull String data) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        switch (WhenMappings.$EnumSwitchMapping$0[this.encryptionLevel.ordinal()]) {
            case 1: 
            case 2: {
                if (!CryptHandler.Companion.isTextEncrypted(data)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                bl = CryptHandler.Companion.isTextAESGCMEncrypted(data);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private final <T> T measureTimeInMillisAndLog(String tag, String message, Function0<? extends T> block) {
        boolean $i$f$measureTimeInMillisAndLog = false;
        Object result = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        result = block.invoke();
        long timeMillis = System.currentTimeMillis() - start$iv;
        return (T)result;
    }

    static /* synthetic */ Object measureTimeInMillisAndLog$default(DBEncryptionHandler $this, String tag, String message, Function0 block, int n, Object object) {
        if ((n & 1) != 0) {
            tag = "TimeMeasurement";
        }
        if ((n & 2) != 0) {
            message = "Execution took";
        }
        boolean $i$f$measureTimeInMillisAndLog = false;
        Object result = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        result = block.invoke();
        long timeMillis = System.currentTimeMillis() - start$iv;
        return result;
    }

    public static final /* synthetic */ ILogger access$getLogger$p(DBEncryptionHandler $this) {
        return $this.logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/clevertap/android/sdk/db/DBEncryptionHandler$Companion;", "", "<init>", "()V", "TAG", "", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EncryptionLevel.values().length];
            try {
                nArray[EncryptionLevel.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EncryptionLevel.MEDIUM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EncryptionLevel.FULL_DATA.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

