/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.customviews;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.RestrictTo;
import androidx.core.content.res.ResourcesCompat;
import androidx.media3.common.util.UnstableApi;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.clevertap.android.sdk.R;
import com.clevertap.android.sdk.inbox.CTInboxBaseMessageViewHolder;
import com.clevertap.android.sdk.video.InboxVideoPlayerHandle;
import com.clevertap.android.sdk.video.VideoLibChecker;
import com.clevertap.android.sdk.video.VideoLibraryIntegrated;
import com.clevertap.android.sdk.video.inbox.ExoplayerHandle;
import com.clevertap.android.sdk.video.inbox.Media3Handle;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0004\u0010\u000bJ\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017J\u0006\u0010\u0019\u001a\u00020\u0017J\u0006\u0010\u001a\u001a\u00020\u0017J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0015H\u0002J\b\u0010\u001c\u001a\u00020\u0017H\u0002J\b\u0010\u001d\u001a\u00020\u0017H\u0002J\b\u0010\u001e\u001a\u00020\u0017H\u0002J\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u0017H\u0002J\b\u0010\"\u001a\u00020\u0017H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/clevertap/android/sdk/customviews/MediaPlayerRecyclerView;", "Landroidx/recyclerview/widget/RecyclerView;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "handle", "Lcom/clevertap/android/sdk/video/InboxVideoPlayerHandle;", "rect", "Landroid/graphics/Rect;", "onScrollListener", "Landroidx/recyclerview/widget/RecyclerView$OnScrollListener;", "onChildAttachStateChangeListener", "Landroidx/recyclerview/widget/RecyclerView$OnChildAttachStateChangeListener;", "playingHolder", "Lcom/clevertap/android/sdk/inbox/CTInboxBaseMessageViewHolder;", "onPausePlayer", "", "onRestartPlayer", "playVideo", "stop", "findBestVisibleMediaHolder", "initialize", "bufferingStarted", "playerReady", "artworkAsset", "Landroid/graphics/drawable/Drawable;", "recyclerViewListeners", "removeVideoView", "clevertap-core_release"})
@UnstableApi
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class MediaPlayerRecyclerView
extends RecyclerView {
    @NotNull
    private final InboxVideoPlayerHandle handle;
    @NotNull
    private final Rect rect;
    @NotNull
    private final RecyclerView.OnScrollListener onScrollListener;
    @NotNull
    private final RecyclerView.OnChildAttachStateChangeListener onChildAttachStateChangeListener;
    @Nullable
    private CTInboxBaseMessageViewHolder playingHolder;

    public MediaPlayerRecyclerView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.handle = WhenMappings.$EnumSwitchMapping$0[VideoLibChecker.mediaLibType.ordinal()] == 1 ? (InboxVideoPlayerHandle)new Media3Handle() : (InboxVideoPlayerHandle)new ExoplayerHandle();
        this.rect = new Rect();
        this.onScrollListener = new RecyclerView.OnScrollListener(this){
            final /* synthetic */ MediaPlayerRecyclerView this$0;
            {
                this.this$0 = $receiver;
            }

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
                super.onScrollStateChanged(recyclerView, newState);
                if (newState == 0) {
                    this.this$0.playVideo();
                }
            }
        };
        this.onChildAttachStateChangeListener = new RecyclerView.OnChildAttachStateChangeListener(this){
            final /* synthetic */ MediaPlayerRecyclerView this$0;
            {
                this.this$0 = $receiver;
            }

            public void onChildViewAttachedToWindow(View view) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            }

            public void onChildViewDetachedFromWindow(View view) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                    CTInboxBaseMessageViewHolder cTInboxBaseMessageViewHolder = MediaPlayerRecyclerView.access$getPlayingHolder$p(this.this$0);
                    if (cTInboxBaseMessageViewHolder == null) break block1;
                    CTInboxBaseMessageViewHolder cTInboxBaseMessageViewHolder2 = cTInboxBaseMessageViewHolder;
                    MediaPlayerRecyclerView mediaPlayerRecyclerView = this.this$0;
                    CTInboxBaseMessageViewHolder ph = cTInboxBaseMessageViewHolder2;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)ph.itemView, (Object)view)) {
                        mediaPlayerRecyclerView.stop();
                    }
                }
            }
        };
        this.initialize();
    }

    public MediaPlayerRecyclerView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.handle = WhenMappings.$EnumSwitchMapping$0[VideoLibChecker.mediaLibType.ordinal()] == 1 ? (InboxVideoPlayerHandle)new Media3Handle() : (InboxVideoPlayerHandle)new ExoplayerHandle();
        this.rect = new Rect();
        this.onScrollListener = new /* invalid duplicate definition of identical inner class */;
        this.onChildAttachStateChangeListener = new /* invalid duplicate definition of identical inner class */;
        this.initialize();
    }

    public MediaPlayerRecyclerView(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.handle = WhenMappings.$EnumSwitchMapping$0[VideoLibChecker.mediaLibType.ordinal()] == 1 ? (InboxVideoPlayerHandle)new Media3Handle() : (InboxVideoPlayerHandle)new ExoplayerHandle();
        this.rect = new Rect();
        this.onScrollListener = new /* invalid duplicate definition of identical inner class */;
        this.onChildAttachStateChangeListener = new /* invalid duplicate definition of identical inner class */;
        this.initialize();
    }

    public final void onPausePlayer() {
        this.handle.setPlayWhenReady(false);
    }

    public final void onRestartPlayer() {
        this.initialize();
        this.playVideo();
    }

    public final void playVideo() {
        CTInboxBaseMessageViewHolder targetHolder = this.findBestVisibleMediaHolder();
        if (targetHolder == null) {
            this.removeVideoView();
            return;
        }
        CTInboxBaseMessageViewHolder cTInboxBaseMessageViewHolder = this.playingHolder;
        if (cTInboxBaseMessageViewHolder != null) {
            CTInboxBaseMessageViewHolder ph = cTInboxBaseMessageViewHolder;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)ph.itemView, (Object)targetHolder.itemView)) {
                boolean play;
                boolean measured = ph.itemView.getGlobalVisibleRect(this.rect);
                int visibleHeight = measured ? this.rect.height() : 0;
                boolean bl2 = play = visibleHeight >= 400;
                if (play && ph.shouldAutoPlay()) {
                    this.handle.setPlayWhenReady(true);
                } else {
                    this.handle.setPlayWhenReady(false);
                }
                return;
            }
        }
        this.removeVideoView();
        this.initialize();
        float currentVolume = this.handle.playerVolume();
        boolean addedVideo = targetHolder.addMediaPlayer(currentVolume, (Function0<Float>)((Function0)() -> MediaPlayerRecyclerView.playVideo$lambda$1(this)), (Function3<String, Boolean, Boolean, Void>)((Function3)(arg_0, arg_1, arg_2) -> MediaPlayerRecyclerView.playVideo$lambda$2(this, arg_0, arg_1, arg_2)), this.handle.videoSurface());
        if (addedVideo) {
            this.playingHolder = targetHolder;
        }
    }

    public final void stop() {
        this.handle.pause();
        this.playingHolder = null;
    }

    private final CTInboxBaseMessageViewHolder findBestVisibleMediaHolder() {
        CTInboxBaseMessageViewHolder bestHolder = null;
        LinearLayoutManager linearLayoutManager = (LinearLayoutManager)this.getLayoutManager();
        int startPosition = linearLayoutManager != null ? linearLayoutManager.findFirstVisibleItemPosition() : 0;
        LinearLayoutManager linearLayoutManager2 = (LinearLayoutManager)this.getLayoutManager();
        int endPosition = linearLayoutManager2 != null ? linearLayoutManager2.findLastVisibleItemPosition() : 0;
        int bestHeight = 0;
        int i = startPosition;
        if (i <= endPosition) {
            while (true) {
                int pos;
                if (this.getChildAt(pos = i - startPosition) != null) {
                    CTInboxBaseMessageViewHolder holder;
                    View child;
                    Object object = child.getTag();
                    CTInboxBaseMessageViewHolder cTInboxBaseMessageViewHolder = holder = object instanceof CTInboxBaseMessageViewHolder ? (CTInboxBaseMessageViewHolder)((Object)object) : null;
                    if (holder != null && holder.needsMediaPlayer()) {
                        int height;
                        boolean measured = holder.itemView.getGlobalVisibleRect(this.rect);
                        int n = height = measured ? this.rect.height() : 0;
                        if (height > bestHeight) {
                            bestHeight = height;
                            bestHolder = holder;
                        }
                    }
                }
                if (i == endPosition) break;
                ++i;
            }
        }
        return bestHolder;
    }

    private final void initialize() {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        this.handle.initExoplayer(context, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                MediaPlayerRecyclerView.access$bufferingStarted((MediaPlayerRecyclerView)((Object)this.receiver));
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                MediaPlayerRecyclerView.access$playerReady((MediaPlayerRecyclerView)((Object)this.receiver));
            }
        }));
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
        this.handle.initPlayerView(context2, (Function0<? extends Drawable>)((Function0)new Function0<Drawable>((Object)this){

            public final Drawable invoke() {
                return MediaPlayerRecyclerView.access$artworkAsset((MediaPlayerRecyclerView)((Object)this.receiver));
            }
        }));
        this.recyclerViewListeners();
    }

    private final void bufferingStarted() {
        block0: {
            CTInboxBaseMessageViewHolder cTInboxBaseMessageViewHolder = this.playingHolder;
            if (cTInboxBaseMessageViewHolder == null) break block0;
            cTInboxBaseMessageViewHolder.playerBuffering();
        }
    }

    private final void playerReady() {
        block0: {
            CTInboxBaseMessageViewHolder cTInboxBaseMessageViewHolder = this.playingHolder;
            if (cTInboxBaseMessageViewHolder == null) break block0;
            cTInboxBaseMessageViewHolder.playerReady();
        }
    }

    private final Drawable artworkAsset() {
        Drawable drawable2 = ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.drawable.ct_audio, null);
        Intrinsics.checkNotNull((Object)drawable2);
        return drawable2;
    }

    private final void recyclerViewListeners() {
        this.removeOnScrollListener(this.onScrollListener);
        this.removeOnChildAttachStateChangeListener(this.onChildAttachStateChangeListener);
        this.addOnScrollListener(this.onScrollListener);
        this.addOnChildAttachStateChangeListener(this.onChildAttachStateChangeListener);
    }

    private final void removeVideoView() {
        block0: {
            this.handle.pause();
            CTInboxBaseMessageViewHolder cTInboxBaseMessageViewHolder = this.playingHolder;
            if (cTInboxBaseMessageViewHolder == null) break block0;
            cTInboxBaseMessageViewHolder.playerRemoved();
        }
    }

    private static final Float playVideo$lambda$1(MediaPlayerRecyclerView this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.handle.handleMute();
        return Float.valueOf(this$0.handle.playerVolume());
    }

    private static final Void playVideo$lambda$2(MediaPlayerRecyclerView this$0, String uri, boolean isMediaAudio, boolean isMediaVideo) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        InboxVideoPlayerHandle inboxVideoPlayerHandle = this$0.handle;
        Context context = this$0.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        inboxVideoPlayerHandle.startPlaying(context, uri, isMediaAudio, isMediaVideo);
        return null;
    }

    public static final /* synthetic */ void access$bufferingStarted(MediaPlayerRecyclerView $this) {
        $this.bufferingStarted();
    }

    public static final /* synthetic */ void access$playerReady(MediaPlayerRecyclerView $this) {
        $this.playerReady();
    }

    public static final /* synthetic */ Drawable access$artworkAsset(MediaPlayerRecyclerView $this) {
        return $this.artworkAsset();
    }

    public static final /* synthetic */ CTInboxBaseMessageViewHolder access$getPlayingHolder$p(MediaPlayerRecyclerView $this) {
        return $this.playingHolder;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VideoLibraryIntegrated.values().length];
            try {
                nArray[VideoLibraryIntegrated.MEDIA3.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

