/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.bitmap;

import android.content.Context;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.bitmap.BitmapDownloadRequest;
import com.clevertap.android.sdk.bitmap.BitmapDownloader;
import com.clevertap.android.sdk.bitmap.IBitmapDownloadRequestHandler;
import com.clevertap.android.sdk.network.DownloadedBitmap;
import com.clevertap.android.sdk.network.DownloadedBitmapFactory;
import com.clevertap.android.sdk.network.NetworkManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/clevertap/android/sdk/bitmap/BitmapDownloadRequestHandler;", "Lcom/clevertap/android/sdk/bitmap/IBitmapDownloadRequestHandler;", "bitmapDownloader", "Lcom/clevertap/android/sdk/bitmap/BitmapDownloader;", "<init>", "(Lcom/clevertap/android/sdk/bitmap/BitmapDownloader;)V", "handleRequest", "Lcom/clevertap/android/sdk/network/DownloadedBitmap;", "bitmapDownloadRequest", "Lcom/clevertap/android/sdk/bitmap/BitmapDownloadRequest;", "clevertap-core_release"})
public class BitmapDownloadRequestHandler
implements IBitmapDownloadRequestHandler {
    @NotNull
    private final BitmapDownloader bitmapDownloader;

    public BitmapDownloadRequestHandler(@NotNull BitmapDownloader bitmapDownloader) {
        Intrinsics.checkNotNullParameter((Object)bitmapDownloader, (String)"bitmapDownloader");
        this.bitmapDownloader = bitmapDownloader;
    }

    @Override
    @NotNull
    public DownloadedBitmap handleRequest(@NotNull BitmapDownloadRequest bitmapDownloadRequest) {
        Intrinsics.checkNotNullParameter((Object)bitmapDownloadRequest, (String)"bitmapDownloadRequest");
        Logger.v("handling bitmap download request in BitmapDownloadRequestHandler....");
        String srcUrl = null;
        srcUrl = bitmapDownloadRequest.getBitmapPath();
        Context context = bitmapDownloadRequest.getContext();
        CharSequence charSequence = srcUrl;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return DownloadedBitmapFactory.INSTANCE.nullBitmapWithStatus(DownloadedBitmap.Status.NO_IMAGE);
        }
        srcUrl = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)srcUrl, (String)"///", (String)"/", (boolean)false, (int)4, null), (String)"//", (String)"/", (boolean)false, (int)4, null), (String)"http:/", (String)"http://", (boolean)false, (int)4, null), (String)"https:/", (String)"https://", (boolean)false, (int)4, null);
        Context context2 = context;
        if (context2 != null) {
            Context $this$handleRequest_u24lambda_u240 = context2;
            boolean bl = false;
            boolean isNetworkOnline = NetworkManager.Companion.isNetworkOnline($this$handleRequest_u24lambda_u240);
            if (!isNetworkOnline) {
                Logger.v("Network connectivity unavailable. Not downloading bitmap. URL was: " + srcUrl);
                return DownloadedBitmapFactory.INSTANCE.nullBitmapWithStatus(DownloadedBitmap.Status.NO_NETWORK);
            }
        }
        return this.bitmapDownloader.downloadBitmap(srcUrl);
    }
}

