/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.location.Location;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.MainThread;
import androidx.annotation.RequiresApi;
import androidx.annotation.WorkerThread;
import androidx.core.app.NotificationManagerCompat;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ManifestInfo;
import com.clevertap.android.sdk.R;
import com.clevertap.android.sdk.events.EventGroup;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.Task;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0088\u0001\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\t\u001a\u00020\n\u001a\n\u0010\u000b\u001a\u00020\u0001*\u00020\u0002\u001a*\u0010\f\u001a\u0004\u0018\u00010\n*\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u00022\b\b\u0002\u0010\u0010\u001a\u00020\u0001H\u0007\u001a(\u0010\u0011\u001a\u0004\u0018\u00010\n*\u00020\r2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\nH\u0003\u001a\u001c\u0010\u0013\u001a\u00020\n*\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0001H\u0003\u001a\f\u0010\u0014\u001a\u00020\n*\u00020\rH\u0003\u001a\u0014\u0010\u0015\u001a\u00020\n*\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0002H\u0003\u001a$\u0010\u0016\u001a\u00020\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0002H\u0007\u001a\u0014\u0010\u001b\u001a\u00020\u0001*\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0004\u001a\n\u0010\u001e\u001a\u00020\u0001*\u00020\u001f\u001a\f\u0010 \u001a\u00020\u001c*\u0004\u0018\u00010\u001c\u001a\u001b\u0010!\u001a\b\u0012\u0004\u0012\u0002H#0\"\"\u0006\b\u0000\u0010#\u0018\u0001*\u00020\u001cH\u0086\b\u001a;\u0010$\u001a\u00020\u0017\"\u0006\b\u0000\u0010#\u0018\u0001*\u00020\u001c2!\u0010%\u001a\u001d\u0012\u0013\u0012\u0011H#\u00a2\u0006\f\b'\u0012\b\b(\u0012\u0004\b\b()\u0012\u0004\u0012\u00020\u00170&H\u0086\b\u00f8\u0001\u0000\u001a \u0010*\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u001c0+*\u00020,2\u0006\u0010-\u001a\u00020\n\u001a$\u0010.\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0/0+*\u00020,2\u0006\u0010-\u001a\u00020\n\u001a \u00100\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u001c0+*\u00020,2\u0006\u0010-\u001a\u00020\n\u001a\u0012\u00101\u001a\u00020\u0017*\u00020,2\u0006\u00102\u001a\u00020,\u001a\n\u00103\u001a\u00020,*\u00020,\u001a\f\u00104\u001a\u00020\u0001*\u0004\u0018\u00010,\u001a\"\u00105\u001a\u0004\u0018\u00010\n*\u0004\u0018\u00010\n2\b\u00102\u001a\u0004\u0018\u00010\n2\b\b\u0002\u00106\u001a\u00020\n\u001a\n\u00107\u001a\u00020\u0001*\u000208\u001a\u000e\u00109\u001a\u0004\u0018\u00010,*\u0004\u0018\u00010\n\u001a\u001d\u0010:\u001a\u00020\u0001*\u0004\u0018\u00010\n\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\b\u0003\u0010\u0000\u001aB\u0010;\u001a\u00020\u0017*\u00020<26\u0010=\u001a2\u0012\u0013\u0012\u00110?\u00a2\u0006\f\b'\u0012\b\b(\u0012\u0004\b\b(@\u0012\u0013\u0012\u00110A\u00a2\u0006\f\b'\u0012\b\b(\u0012\u0004\b\b(B\u0012\u0004\u0012\u00020\u00170>\u001a8\u0010C\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c0+\"\u0006\b\u0000\u0010#\u0018\u0001*\u00020\u001c2\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u0002H#\u0012\u0004\u0012\u00020\u00010&H\u0086\b\u00f8\u0001\u0000\"\u0015\u0010\u0005\u001a\u00020\u0004*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006E"}, d2={"isPackageAndOsTargetsAbove", "", "Landroid/content/Context;", "apiLevel", "", "targetSdkVersion", "getTargetSdkVersion", "(Landroid/content/Context;)I", "isNotificationChannelEnabled", "channelId", "", "areAppNotificationsEnabled", "getOrCreateChannel", "Landroid/app/NotificationManager;", "msgChannel", "context", "hideHeadsUp", "tryGetChannel", "channelSource", "createFallbackChannel", "createLowImportanceFallback", "createDefaultFallbackChannel", "flushPushImpressionsOnPostAsyncSafely", "", "Lcom/clevertap/android/sdk/CleverTapAPI;", "logTag", "caller", "isInvalidIndex", "Lorg/json/JSONArray;", "index", "hasData", "Landroid/content/SharedPreferences;", "orEmptyArray", "toList", "", "T", "iterator", "foreach", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "element", "safeGetJSONArrayOrNullIfEmpty", "Lkotlin/Pair;", "Lorg/json/JSONObject;", "key", "safeGetJSONObjectListOrEmpty", "", "safeGetJSONArray", "copyFrom", "other", "copy", "isNotNullAndEmpty", "concatIfNotNull", "separator", "isValid", "Landroid/location/Location;", "toJsonOrNull", "isNotNullAndBlank", "applyInsetsWithMarginAdjustment", "Landroid/view/View;", "marginAdjuster", "Lkotlin/Function2;", "Landroidx/core/graphics/Insets;", "insets", "Landroid/view/ViewGroup$MarginLayoutParams;", "mlp", "partition", "predicate", "clevertap-core_release"})
@JvmName(name="CTXtensions")
@SourceDebugExtension(value={"SMAP\nCTXtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CTXtensions.kt\ncom/clevertap/android/sdk/CTXtensions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 View.kt\nandroidx/core/view/ViewKt\n*L\n1#1,465:1\n271#1,8:467\n1#2:466\n326#3,4:475\n*S KotlinDebug\n*F\n+ 1 CTXtensions.kt\ncom/clevertap/android/sdk/CTXtensions\n*L\n312#1:467,8\n441#1:475,4\n*E\n"})
public final class CTXtensions {
    public static final boolean isPackageAndOsTargetsAbove(@NotNull Context $this$isPackageAndOsTargetsAbove, int apiLevel) {
        Intrinsics.checkNotNullParameter((Object)$this$isPackageAndOsTargetsAbove, (String)"<this>");
        return Build.VERSION.SDK_INT > apiLevel && CTXtensions.getTargetSdkVersion($this$isPackageAndOsTargetsAbove) > apiLevel;
    }

    public static final int getTargetSdkVersion(@NotNull Context $this$targetSdkVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$targetSdkVersion, (String)"<this>");
        return $this$targetSdkVersion.getApplicationContext().getApplicationInfo().targetSdkVersion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isNotificationChannelEnabled(@NotNull Context $this$isNotificationChannelEnabled, @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)$this$isNotificationChannelEnabled, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        if (Build.VERSION.SDK_INT >= 26) {
            if (!CTXtensions.areAppNotificationsEnabled($this$isNotificationChannelEnabled)) return false;
            try {
                Object object = $this$isNotificationChannelEnabled.getSystemService("notification");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
                NotificationManager nm = (NotificationManager)object;
                if (nm.getNotificationChannel(channelId).getImportance() == 0) return false;
                return true;
            }
            catch (Exception e) {
                Logger.d("Unable to find notification channel with id = " + channelId);
                return false;
            }
        }
        boolean bl = CTXtensions.areAppNotificationsEnabled($this$isNotificationChannelEnabled);
        return bl;
    }

    public static final boolean areAppNotificationsEnabled(@NotNull Context $this$areAppNotificationsEnabled) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$areAppNotificationsEnabled, (String)"<this>");
        try {
            bl = NotificationManagerCompat.from((Context)$this$areAppNotificationsEnabled).areNotificationsEnabled();
        }
        catch (Exception e) {
            Logger.d("Unable to query notifications enabled flag, returning true!");
            e.printStackTrace();
            bl = true;
        }
        return bl;
    }

    @RequiresApi(value=26)
    @WorkerThread
    @Nullable
    public static final String getOrCreateChannel(@NotNull NotificationManager $this$getOrCreateChannel, @Nullable String msgChannel, @NotNull Context context, boolean hideHeadsUp) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$getOrCreateChannel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            String string3 = CTXtensions.tryGetChannel($this$getOrCreateChannel, msgChannel, hideHeadsUp, "Payload");
            if (string3 != null) {
                String it = string3;
                boolean bl = false;
                return it;
            }
            String manifestChannel = ManifestInfo.getInstance(context).getDevDefaultPushChannelId();
            String string4 = CTXtensions.tryGetChannel($this$getOrCreateChannel, manifestChannel, hideHeadsUp, "Manifest");
            if (string4 != null) {
                String it = string4;
                boolean bl = false;
                return it;
            }
            string2 = CTXtensions.createFallbackChannel($this$getOrCreateChannel, context, hideHeadsUp);
        }
        catch (Exception e) {
            Logger.v("CleverTap", "Error getting or creating notification channel", e);
            string2 = null;
        }
        return string2;
    }

    public static /* synthetic */ String getOrCreateChannel$default(NotificationManager notificationManager, String string2, Context context, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return CTXtensions.getOrCreateChannel(notificationManager, string2, context, bl);
    }

    @RequiresApi(value=26)
    private static final String tryGetChannel(NotificationManager $this$tryGetChannel, String channelId, boolean hideHeadsUp, String channelSource) {
        boolean shouldSkip;
        CharSequence charSequence = channelId;
        if (charSequence == null || charSequence.length() == 0) {
            Logger.d("CleverTap", "channelID from " + channelSource + " is null or empty");
            return null;
        }
        NotificationChannel notificationChannel = $this$tryGetChannel.getNotificationChannel(channelId);
        if (notificationChannel == null) {
            return null;
        }
        NotificationChannel channel = notificationChannel;
        boolean bl = shouldSkip = hideHeadsUp && channel.getImportance() != 2;
        if (shouldSkip) {
            Logger.d("CleverTap", "Skipping channel " + channelId + " because heads-up should be hidden in FG but importance is " + channel.getImportance());
            return null;
        }
        return channelId;
    }

    @RequiresApi(value=26)
    private static final String createFallbackChannel(NotificationManager $this$createFallbackChannel, Context context, boolean hideHeadsUp) {
        if (hideHeadsUp) {
            return CTXtensions.createLowImportanceFallback($this$createFallbackChannel);
        }
        return CTXtensions.createDefaultFallbackChannel($this$createFallbackChannel, context);
    }

    @RequiresApi(value=26)
    private static final String createLowImportanceFallback(NotificationManager $this$createLowImportanceFallback) {
        String channelId = "ct_fallback_notification_channel_low_importance";
        if ($this$createLowImportanceFallback.getNotificationChannel(channelId) != null) {
            return channelId;
        }
        $this$createLowImportanceFallback.createNotificationChannel(new NotificationChannel(channelId, (CharSequence)"Silent Misc", 2));
        Logger.d("CleverTap", "Created low importance fallback channel: " + channelId);
        return channelId;
    }

    @RequiresApi(value=26)
    private static final String createDefaultFallbackChannel(NotificationManager $this$createDefaultFallbackChannel, Context context) {
        String channelId = "fcm_fallback_notification_channel";
        if ($this$createDefaultFallbackChannel.getNotificationChannel(channelId) == null) {
            String string2;
            try {
                string2 = context.getString(R.string.ct_fcm_fallback_notification_channel_label);
            }
            catch (Exception e) {
                string2 = "Misc";
            }
            String string3 = string2;
            Intrinsics.checkNotNull((Object)string3);
            String channelName = string3;
            $this$createDefaultFallbackChannel.createNotificationChannel(new NotificationChannel(channelId, (CharSequence)channelName, 3));
            Logger.d("CleverTap", "Created default fallback channel: " + channelId);
        }
        return channelId;
    }

    @MainThread
    public static final void flushPushImpressionsOnPostAsyncSafely(@NotNull CleverTapAPI $this$flushPushImpressionsOnPostAsyncSafely, @NotNull String logTag, @NotNull String caller, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$flushPushImpressionsOnPostAsyncSafely, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)logTag, (String)"logTag");
        Intrinsics.checkNotNullParameter((Object)caller, (String)"caller");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Task<Void> flushTask = CTExecutorFactory.executors($this$flushPushImpressionsOnPostAsyncSafely.getCoreState().getConfig()).postAsyncSafelyTask();
        Future<?> flushFutureResult = flushTask.submit(logTag, () -> CTXtensions.flushPushImpressionsOnPostAsyncSafely$lambda$2($this$flushPushImpressionsOnPostAsyncSafely, context, caller, logTag));
        try {
            flushFutureResult.get();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final boolean isInvalidIndex(@Nullable JSONArray $this$isInvalidIndex, int index) {
        return $this$isInvalidIndex == null || index < 0 || index >= $this$isInvalidIndex.length();
    }

    public static final boolean hasData(@NotNull SharedPreferences $this$hasData) {
        Intrinsics.checkNotNullParameter((Object)$this$hasData, (String)"<this>");
        Map map = $this$hasData.getAll();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getAll(...)");
        return !map.isEmpty();
    }

    @NotNull
    public static final JSONArray orEmptyArray(@Nullable JSONArray $this$orEmptyArray) {
        JSONArray jSONArray = $this$orEmptyArray;
        if (jSONArray == null) {
            jSONArray = new JSONArray();
        }
        return jSONArray;
    }

    public static final /* synthetic */ <T> List<T> toList(JSONArray $this$toList) {
        Intrinsics.checkNotNullParameter((Object)$this$toList, (String)"<this>");
        boolean $i$f$toList = false;
        List list = new ArrayList();
        int n = $this$toList.length();
        for (int index = 0; index < n; ++index) {
            Object element = $this$toList.get(index);
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (!(element instanceof Object)) continue;
            list.add(element);
        }
        return list;
    }

    public static final /* synthetic */ <T> void iterator(JSONArray $this$iterator, Function1<? super T, Unit> foreach) {
        Intrinsics.checkNotNullParameter((Object)$this$iterator, (String)"<this>");
        Intrinsics.checkNotNullParameter(foreach, (String)"foreach");
        boolean $i$f$iterator = false;
        int n = $this$iterator.length();
        for (int index = 0; index < n; ++index) {
            Object element = $this$iterator.get(index);
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (!(element instanceof Object)) continue;
            foreach.invoke(element);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Pair<Boolean, JSONArray> safeGetJSONArrayOrNullIfEmpty(@NotNull JSONObject $this$safeGetJSONArrayOrNullIfEmpty, @NotNull String key) {
        void it;
        JSONArray jSONArray;
        Intrinsics.checkNotNullParameter((Object)$this$safeGetJSONArrayOrNullIfEmpty, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        JSONArray jSONArray2 = $this$safeGetJSONArrayOrNullIfEmpty.optJSONArray(key);
        if (jSONArray2 == null) {
            return new Pair((Object)false, null);
        }
        JSONArray list = jSONArray2;
        boolean bl = list.length() > 0;
        JSONArray jSONArray3 = jSONArray = list;
        Boolean bl2 = bl;
        boolean bl3 = false;
        boolean bl4 = it.length() > 0;
        JSONArray jSONArray4 = bl4 ? jSONArray : null;
        Boolean bl5 = bl2;
        return new Pair((Object)bl5, (Object)jSONArray4);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Pair<Boolean, List<JSONObject>> safeGetJSONObjectListOrEmpty(@NotNull JSONObject $this$safeGetJSONObjectListOrEmpty, @NotNull String key) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)$this$safeGetJSONObjectListOrEmpty, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        JSONArray array = $this$safeGetJSONObjectListOrEmpty.optJSONArray(key);
        if (array != null) {
            void $this$toList$iv;
            JSONArray jSONArray = array;
            Boolean bl = true;
            boolean $i$f$toList = false;
            List list$iv = new ArrayList();
            int n = $this$toList$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                Object element$iv = $this$toList$iv.get(index$iv);
                if (!(element$iv instanceof JSONObject)) continue;
                list$iv.add(element$iv);
            }
            List list = list$iv;
            Boolean bl2 = bl;
            pair = new Pair((Object)bl2, (Object)list);
        } else {
            pair = new Pair((Object)false, (Object)CollectionsKt.emptyList());
        }
        return pair;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Pair<Boolean, JSONArray> safeGetJSONArray(@NotNull JSONObject $this$safeGetJSONArray, @NotNull String key) {
        void it;
        JSONArray jSONArray;
        Intrinsics.checkNotNullParameter((Object)$this$safeGetJSONArray, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        JSONArray jSONArray2 = $this$safeGetJSONArray.optJSONArray(key);
        if (jSONArray2 == null) {
            return new Pair((Object)false, null);
        }
        JSONArray list = jSONArray2;
        boolean bl = list.length() >= 0;
        JSONArray jSONArray3 = jSONArray = list;
        Boolean bl2 = bl;
        boolean bl3 = false;
        boolean bl4 = it.length() >= 0;
        JSONArray jSONArray4 = bl4 ? jSONArray : null;
        Boolean bl5 = bl2;
        return new Pair((Object)bl5, (Object)jSONArray4);
    }

    public static final void copyFrom(@NotNull JSONObject $this$copyFrom, @NotNull JSONObject other) {
        Intrinsics.checkNotNullParameter((Object)$this$copyFrom, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Iterator iterator = other.keys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"keys(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            String key = (String)iterator2.next();
            $this$copyFrom.put(key, other.opt(key));
        }
    }

    @NotNull
    public static final JSONObject copy(@NotNull JSONObject $this$copy) {
        Intrinsics.checkNotNullParameter((Object)$this$copy, (String)"<this>");
        JSONObject json = new JSONObject();
        CTXtensions.copyFrom(json, $this$copy);
        return json;
    }

    public static final boolean isNotNullAndEmpty(@Nullable JSONObject $this$isNotNullAndEmpty) {
        return $this$isNotNullAndEmpty != null && $this$isNotNullAndEmpty.length() > 0;
    }

    @Nullable
    public static final String concatIfNotNull(@Nullable String $this$concatIfNotNull, @Nullable String other, @NotNull String separator) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        if ($this$concatIfNotNull != null && other != null) {
            string2 = $this$concatIfNotNull + separator + other;
        } else {
            string2 = $this$concatIfNotNull;
            if (string2 == null) {
                string2 = other;
            }
        }
        return string2;
    }

    public static /* synthetic */ String concatIfNotNull$default(String string2, String string3, String string4, int n, Object object) {
        if ((n & 2) != 0) {
            string4 = "";
        }
        return CTXtensions.concatIfNotNull(string2, string3, string4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isValid(@NotNull Location $this$isValid) {
        Intrinsics.checkNotNullParameter((Object)$this$isValid, (String)"<this>");
        double d = $this$isValid.getLatitude();
        if (!(-90.0 <= d)) return false;
        if (!(d <= 90.0)) return false;
        boolean bl = true;
        if (!bl) return false;
        d = $this$isValid.getLongitude();
        if (!(-180.0 <= d)) return false;
        if (!(d <= 180.0)) return false;
        return true;
    }

    @Nullable
    public static final JSONObject toJsonOrNull(@Nullable String $this$toJsonOrNull) {
        JSONObject jSONObject;
        String string2 = $this$toJsonOrNull;
        if (string2 != null) {
            JSONObject jSONObject2;
            String it = string2;
            boolean bl = false;
            try {
                jSONObject2 = new JSONObject(it);
            }
            catch (JSONException e) {
                jSONObject2 = null;
            }
            jSONObject = jSONObject2;
        } else {
            jSONObject = null;
        }
        return jSONObject;
    }

    public static final boolean isNotNullAndBlank(@Nullable String $this$isNotNullAndBlank) {
        CharSequence charSequence = $this$isNotNullAndBlank;
        return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
    }

    public static final void applyInsetsWithMarginAdjustment(@NotNull View $this$applyInsetsWithMarginAdjustment, @NotNull Function2<? super Insets, ? super ViewGroup.MarginLayoutParams, Unit> marginAdjuster) {
        Intrinsics.checkNotNullParameter((Object)$this$applyInsetsWithMarginAdjustment, (String)"<this>");
        Intrinsics.checkNotNullParameter(marginAdjuster, (String)"marginAdjuster");
        ViewCompat.setOnApplyWindowInsetsListener((View)$this$applyInsetsWithMarginAdjustment, (arg_0, arg_1) -> CTXtensions.applyInsetsWithMarginAdjustment$lambda$7(marginAdjuster, arg_0, arg_1));
    }

    public static final /* synthetic */ <T> Pair<JSONArray, JSONArray> partition(JSONArray $this$partition, Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)$this$partition, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$partition = false;
        JSONArray first = new JSONArray();
        JSONArray second = new JSONArray();
        int n = $this$partition.length();
        for (int i = 0; i < n; ++i) {
            Object element = $this$partition.get(i);
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (!(element instanceof Object)) continue;
            JSONArray jSONArray = (Boolean)predicate.invoke(element) != false ? first.put(element) : second.put(element);
        }
        return TuplesKt.to((Object)first, (Object)second);
    }

    private static final Void flushPushImpressionsOnPostAsyncSafely$lambda$2(CleverTapAPI $this_flushPushImpressionsOnPostAsyncSafely, Context $context, String $caller, String $logTag) {
        Intrinsics.checkNotNullParameter((Object)$this_flushPushImpressionsOnPostAsyncSafely, (String)"$this_flushPushImpressionsOnPostAsyncSafely");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$caller, (String)"$caller");
        Intrinsics.checkNotNullParameter((Object)$logTag, (String)"$logTag");
        try {
            $this_flushPushImpressionsOnPostAsyncSafely.getCoreState().getBaseEventQueueManager().flushQueueSync($context, EventGroup.PUSH_NOTIFICATION_VIEWED, $caller);
        }
        catch (Exception e) {
            Logger.d($logTag, "failed to flush push impressions on ct instance = " + $this_flushPushImpressionsOnPostAsyncSafely.getCoreState().getConfig().getAccountId());
        }
        return null;
    }

    private static final WindowInsetsCompat applyInsetsWithMarginAdjustment$lambda$7(Function2 $marginAdjuster, View v, WindowInsetsCompat insets) {
        Intrinsics.checkNotNullParameter((Object)$marginAdjuster, (String)"$marginAdjuster");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)insets, (String)"insets");
        Insets insets2 = insets.getInsets(WindowInsetsCompat.Type.systemBars() | WindowInsetsCompat.Type.displayCutout());
        Intrinsics.checkNotNullExpressionValue((Object)insets2, (String)"getInsets(...)");
        Insets bars = insets2;
        View $this$updateLayoutParams$iv = v;
        boolean $i$f$updateLayoutParamsTyped = false;
        ViewGroup.LayoutParams layoutParams = $this$updateLayoutParams$iv.getLayoutParams();
        if (layoutParams == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
        }
        ViewGroup.LayoutParams params$iv = (ViewGroup.LayoutParams)((ViewGroup.MarginLayoutParams)layoutParams);
        ViewGroup.MarginLayoutParams $this$applyInsetsWithMarginAdjustment_u24lambda_u247_u24lambda_u246 = (ViewGroup.MarginLayoutParams)params$iv;
        boolean bl = false;
        $marginAdjuster.invoke((Object)bars, (Object)$this$applyInsetsWithMarginAdjustment_u24lambda_u247_u24lambda_u246);
        $this$updateLayoutParams$iv.setLayoutParams(params$iv);
        return WindowInsetsCompat.CONSUMED;
    }
}

