/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import android.location.Location;
import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.AnalyticsManagerBundler;
import com.clevertap.android.sdk.BaseAnalyticsManager;
import com.clevertap.android.sdk.BaseCallbackManager;
import com.clevertap.android.sdk.CTLockManager;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.ControllerManager;
import com.clevertap.android.sdk.CoreMetaData;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.LocalDataStore;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.displayunits.model.CleverTapDisplayUnit;
import com.clevertap.android.sdk.events.BaseEventQueueManager;
import com.clevertap.android.sdk.events.FlattenedEventData;
import com.clevertap.android.sdk.inapp.CTInAppNotification;
import com.clevertap.android.sdk.inapp.InAppPreviewHandler;
import com.clevertap.android.sdk.inbox.CTInboxMessage;
import com.clevertap.android.sdk.profile.ProfileCommand;
import com.clevertap.android.sdk.profile.traversal.ProfileChange;
import com.clevertap.android.sdk.profile.traversal.ProfileOperation;
import com.clevertap.android.sdk.response.CleverTapResponse;
import com.clevertap.android.sdk.response.DisplayUnitResponse;
import com.clevertap.android.sdk.response.InboxResponse;
import com.clevertap.android.sdk.task.CTExecutors;
import com.clevertap.android.sdk.task.Task;
import com.clevertap.android.sdk.utils.CTJsonConverter;
import com.clevertap.android.sdk.utils.Clock;
import com.clevertap.android.sdk.utils.JsonFlattener;
import com.clevertap.android.sdk.utils.UriHelper;
import com.clevertap.android.sdk.validation.ValidationConfig;
import com.clevertap.android.sdk.validation.pipeline.ChargedEventItemsValidationResult;
import com.clevertap.android.sdk.validation.pipeline.EventDataValidationResult;
import com.clevertap.android.sdk.validation.pipeline.EventNameValidationResult;
import com.clevertap.android.sdk.validation.pipeline.PropertyKeyValidationResult;
import com.clevertap.android.sdk.validation.pipeline.ValidationPipelineProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AnalyticsManager
extends BaseAnalyticsManager {
    private final CTLockManager ctLockManager;
    private final HashMap<String, Integer> installReferrerMap = new HashMap(8);
    private final BaseEventQueueManager baseEventQueueManager;
    private final BaseCallbackManager callbackManager;
    private final CleverTapInstanceConfig config;
    private final Context context;
    private final ControllerManager controllerManager;
    private final CoreMetaData coreMetaData;
    private final DeviceInfo deviceInfo;
    private final ValidationPipelineProvider validationPipelineProvider;
    private final ValidationConfig validationConfig;
    private final Clock currentTimeProvider;
    private final CTExecutors executors;
    private final Object notificationMapLock = new Object();
    private final LocalDataStore localDataStore;
    private final InAppPreviewHandler inAppPreviewHandler;
    private final HashMap<String, Long> notificationIdTagMap = new HashMap();
    private final HashMap<String, Long> notificationViewedIdTagMap = new HashMap();

    AnalyticsManager(Context context, CleverTapInstanceConfig config, BaseEventQueueManager baseEventQueueManager, ValidationPipelineProvider validationPipelineProvider, ValidationConfig validationConfig, CoreMetaData coreMetaData, DeviceInfo deviceInfo, BaseCallbackManager callbackManager, ControllerManager controllerManager, CTLockManager ctLockManager, Clock currentTimeProvider, CTExecutors executors, LocalDataStore localDataStore, InAppPreviewHandler inAppPreviewHandler) {
        this.context = context;
        this.config = config;
        this.baseEventQueueManager = baseEventQueueManager;
        this.validationPipelineProvider = validationPipelineProvider;
        this.validationConfig = validationConfig;
        this.coreMetaData = coreMetaData;
        this.deviceInfo = deviceInfo;
        this.callbackManager = callbackManager;
        this.ctLockManager = ctLockManager;
        this.controllerManager = controllerManager;
        this.currentTimeProvider = currentTimeProvider;
        this.executors = executors;
        this.localDataStore = localDataStore;
        this.inAppPreviewHandler = inAppPreviewHandler;
    }

    @Override
    public void addMultiValuesForKey(String key, ArrayList<String> values) {
        this.config.getLogger().verbose(this.config.getAccountId(), "addMultiValuesForKey: key=" + key + ", values=" + values);
        Task<Void> task = this.executors.postAsyncSafelyTask();
        task.execute("addMultiValuesForKey", () -> {
            this._handleMultiValues(values, key, ProfileCommand.ADD);
            return null;
        });
    }

    @Override
    public void incrementValue(String key, Number value) {
        this.config.getLogger().verbose(this.config.getAccountId(), "incrementValue: key=" + key + ", value=" + value);
        Task<Void> task = this.executors.postAsyncSafelyTask();
        task.execute("incrementValue", () -> {
            this._constructIncrementDecrementValues(value, key, ProfileCommand.INCREMENT);
            return null;
        });
    }

    @Override
    public void decrementValue(String key, Number value) {
        this.config.getLogger().verbose(this.config.getAccountId(), "decrementValue: key=" + key + ", value=" + value);
        Task<Void> task = this.executors.postAsyncSafelyTask();
        task.execute("decrementValue", () -> {
            this._constructIncrementDecrementValues(value, key, ProfileCommand.DECREMENT);
            return null;
        });
    }

    @Override
    public void fetchFeatureFlags() {
        if (this.config.isAnalyticsOnly()) {
            return;
        }
        JSONObject event = new JSONObject();
        JSONObject notif = new JSONObject();
        try {
            notif.put("t", 1);
            event.put("evtName", (Object)"wzrk_fetch");
            event.put("evtData", (Object)notif);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.sendFetchEvent(event);
    }

    @Override
    public void forcePushAppLaunchedEvent() {
        this.coreMetaData.setAppLaunchPushed(false);
        this.pushAppLaunchedEvent();
    }

    @Override
    public void pushAppLaunchedEvent() {
        if (this.config.isDisableAppLaunchedEvent()) {
            this.coreMetaData.setAppLaunchPushed(true);
            this.config.getLogger().debug(this.config.getAccountId(), "App Launched Events disabled in the Android Manifest file");
            return;
        }
        if (this.coreMetaData.isAppLaunchPushed()) {
            this.config.getLogger().verbose(this.config.getAccountId(), "App Launched has already been triggered. Will not trigger it ");
            return;
        }
        this.config.getLogger().verbose(this.config.getAccountId(), "Firing App Launched event");
        this.coreMetaData.setAppLaunchPushed(true);
        JSONObject event = new JSONObject();
        try {
            event.put("evtName", (Object)"App Launched");
            event.put("evtData", (Object)this.deviceInfo.getAppLaunchedFields());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.baseEventQueueManager.queueEvent(this.context, event, 4, new FlattenedEventData.EventProperties(Collections.emptyMap()));
    }

    @Override
    public void pushDefineVarsEvent(JSONObject data) {
        this.baseEventQueueManager.queueEvent(this.context, data, 8);
    }

    @Override
    public void pushDisplayUnitClickedEventForID(String unitID) {
        block4: {
            JSONObject event = new JSONObject();
            try {
                JSONObject eventExtraData;
                CleverTapDisplayUnit displayUnit;
                event.put("evtName", (Object)"Notification Clicked");
                if (this.controllerManager.getCTDisplayUnitController() == null || (displayUnit = this.controllerManager.getCTDisplayUnitController().getDisplayUnitForID(unitID)) == null || (eventExtraData = displayUnit.getWZRKFields()) == null) break block4;
                event.put("evtData", (Object)eventExtraData);
                try {
                    this.coreMetaData.setWzrkParams(eventExtraData);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.baseEventQueueManager.queueEvent(this.context, event, 4, this.getFlattenedEventProperties(eventExtraData));
            }
            catch (Throwable t) {
                this.config.getLogger().verbose(this.config.getAccountId(), "DisplayUnit : Failed to push Display Unit clicked event" + t);
            }
        }
    }

    @Override
    public void pushDisplayUnitViewedEventForID(String unitID) {
        JSONObject event = new JSONObject();
        try {
            JSONObject eventExtras;
            CleverTapDisplayUnit displayUnit;
            event.put("evtName", (Object)"Notification Viewed");
            if (this.controllerManager.getCTDisplayUnitController() != null && (displayUnit = this.controllerManager.getCTDisplayUnitController().getDisplayUnitForID(unitID)) != null && (eventExtras = displayUnit.getWZRKFields()) != null) {
                event.put("evtData", (Object)eventExtras);
                this.baseEventQueueManager.queueEvent(this.context, event, 4, this.getFlattenedEventProperties(eventExtras));
            }
        }
        catch (Throwable t) {
            this.config.getLogger().verbose(this.config.getAccountId(), "DisplayUnit : Failed to push Display Unit viewed event" + t);
        }
    }

    @Override
    public void pushError(String errorMessage, int errorCode) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("Error Message", errorMessage);
        props.put("Error Code", errorCode);
        try {
            String activityName = CoreMetaData.getCurrentActivityName();
            if (activityName != null) {
                props.put("Location", activityName);
            } else {
                props.put("Location", "Unknown");
            }
        }
        catch (Throwable t) {
            props.put("Location", "Unknown");
        }
        this.pushEvent("Error Occurred", props);
    }

    @Override
    public void pushEvent(String eventName, Map<String, Object> eventActions) {
        this.config.getLogger().verbose(this.config.getAccountId(), "pushEvent: eventName=" + eventName + ", eventActions=" + eventActions);
        Task<Void> task = this.executors.postAsyncSafelyTask();
        task.execute("pushEvent", () -> {
            this._pushEvent(eventName, eventActions);
            return null;
        });
    }

    @WorkerThread
    private void _pushEvent(String eventName, Map<String, Object> eventActions) {
        JSONObject event = new JSONObject();
        try {
            EventNameValidationResult nameValidationResult = this.validationPipelineProvider.getEventNamePipeline().execute(eventName, this.validationConfig);
            if (nameValidationResult.shouldDrop()) {
                return;
            }
            ValidationConfig eventConfig = new ValidationConfig.Builder().from(this.validationConfig).setRestrictedMultiValueFields(Collections.emptySet()).build();
            EventDataValidationResult dataValidationResult = this.validationPipelineProvider.getEventDataPipeline().execute(eventActions, eventConfig);
            if (dataValidationResult.shouldDrop()) {
                return;
            }
            JSONObject eventData = dataValidationResult.getCleanedData();
            FlattenedEventData flattenedData = this.getFlattenedEventProperties(eventData);
            event.put("evtName", (Object)nameValidationResult.getCleanedName());
            event.put("evtData", (Object)eventData);
            this.baseEventQueueManager.queueEvent(this.context, event, 4, flattenedData);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void pushInAppNotificationStateEvent(boolean clicked, CTInAppNotification data, Bundle customData) {
        JSONObject event = new JSONObject();
        try {
            JSONObject notif = CTJsonConverter.getWzrkFields(data);
            if (customData != null) {
                for (String x : customData.keySet()) {
                    Object value = customData.get(x);
                    if (value == null) continue;
                    notif.put(x, value);
                }
            }
            if (clicked) {
                try {
                    this.coreMetaData.setWzrkParams(notif);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                event.put("evtName", (Object)"Notification Clicked");
            } else {
                event.put("evtName", (Object)"Notification Viewed");
            }
            event.put("evtData", (Object)notif);
            this.baseEventQueueManager.queueEvent(this.context, event, 4, this.getFlattenedEventProperties(notif));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void pushInstallReferrer(String url) {
        try {
            this.config.getLogger().verbose(this.config.getAccountId(), "Referrer received: " + url);
            if (url == null) {
                return;
            }
            int now = (int)(System.currentTimeMillis() / 1000L);
            if (this.installReferrerMap.containsKey(url) && now - this.installReferrerMap.get(url) < 10) {
                this.config.getLogger().verbose(this.config.getAccountId(), "Skipping install referrer due to duplicate within 10 seconds");
                return;
            }
            this.installReferrerMap.put(url, now);
            Uri uri = Uri.parse((String)("wzrk://track?install=true&" + url));
            this.pushDeepLink(uri, true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public synchronized void pushInstallReferrer(String source, String medium, String campaign) {
        if (source == null && medium == null && campaign == null) {
            return;
        }
        try {
            int status = StorageHelper.getInt(this.context, "app_install_status", 0);
            if (status != 0) {
                Logger.d("Install referrer has already been set. Will not override it");
                return;
            }
            StorageHelper.putInt(this.context, "app_install_status", 1);
            if (source != null) {
                source = Uri.encode((String)source);
            }
            if (medium != null) {
                medium = Uri.encode((String)medium);
            }
            if (campaign != null) {
                campaign = Uri.encode((String)campaign);
            }
            String uriStr = "wzrk://track?install=true";
            if (source != null) {
                uriStr = uriStr + "&utm_source=" + source;
            }
            if (medium != null) {
                uriStr = uriStr + "&utm_medium=" + medium;
            }
            if (campaign != null) {
                uriStr = uriStr + "&utm_campaign=" + campaign;
            }
            Uri uri = Uri.parse((String)uriStr);
            this.pushDeepLink(uri, true);
        }
        catch (Throwable t) {
            Logger.v("Failed to push install referrer", t);
        }
    }

    @Override
    public void pushNotificationClickedEvent(Bundle extras) {
        boolean shouldProcess;
        if (this.config.isAnalyticsOnly()) {
            this.config.getLogger().debug(this.config.getAccountId(), "is Analytics Only - will not process Notification Clicked event.");
            return;
        }
        if (extras == null || extras.isEmpty() || extras.get("wzrk_pn") == null) {
            this.config.getLogger().debug(this.config.getAccountId(), "Push notification not from CleverTap - will not process Notification Clicked event.");
            return;
        }
        String accountId = null;
        try {
            accountId = extras.getString("wzrk_acct_id");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean bl = shouldProcess = accountId == null && this.config.isDefaultInstance() || this.config.getAccountId().equals(accountId);
        if (!shouldProcess) {
            this.config.getLogger().debug(this.config.getAccountId(), "Push notification not targeted at this instance, not processing Notification Clicked Event");
            return;
        }
        if (extras.containsKey("wzrk_inapp_type")) {
            this.inAppPreviewHandler.handleInAppPreview(extras);
            return;
        }
        if (extras.containsKey("wzrk_inbox")) {
            this.handleInboxPreview(extras);
            return;
        }
        if (extras.containsKey("wzrk_adunit")) {
            this.handleSendTestForDisplayUnits(extras);
            return;
        }
        if (!extras.containsKey("wzrk_id") || extras.getString("wzrk_id") == null) {
            this.config.getLogger().debug(this.config.getAccountId(), "Push notification ID Tag is null, not processing Notification Clicked event for:  " + extras);
            return;
        }
        boolean isDuplicate = this.checkDuplicateNotificationIds(this.dedupeCheckKey(extras), this.notificationIdTagMap, 5000);
        if (isDuplicate) {
            this.config.getLogger().debug(this.config.getAccountId(), "Already processed Notification Clicked event for " + extras + ", dropping duplicate.");
            return;
        }
        try {
            JSONObject notif = AnalyticsManagerBundler.wzrkBundleToJson(extras);
            JSONObject event = AnalyticsManagerBundler.notificationClickedJson(notif);
            this.baseEventQueueManager.queueEvent(this.context, event, 4, this.getFlattenedEventProperties(notif));
            this.coreMetaData.setWzrkParams(notif);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.callbackManager.getPushNotificationListener() != null) {
            this.callbackManager.getPushNotificationListener().onNotificationClickedPayloadReceived(Utils.convertBundleObjectToHashMap(extras));
        } else {
            Logger.d("CTPushNotificationListener is not set");
        }
    }

    private void handleInboxPreview(Bundle extras) {
        Task<Void> task = this.executors.postAsyncSafelyTask();
        task.execute("testInboxNotification", () -> {
            try {
                Logger.v("Received inbox via push payload: " + extras.getString("wzrk_inbox"));
                JSONObject r = new JSONObject();
                JSONArray inboxNotifs = new JSONArray();
                r.put("inbox_notifs", (Object)inboxNotifs);
                JSONObject testPushObject = new JSONObject(extras.getString("wzrk_inbox"));
                testPushObject.put("_id", (Object)String.valueOf(System.currentTimeMillis() / 1000L));
                inboxNotifs.put((Object)testPushObject);
                InboxResponse cleverTapResponse = new InboxResponse(this.config, this.ctLockManager, this.callbackManager, this.controllerManager);
                ((CleverTapResponse)cleverTapResponse).processResponse(r, null, this.context);
            }
            catch (Throwable t) {
                Logger.v("Failed to process inbox message from push notification payload", t);
            }
            return null;
        });
    }

    @Override
    public void pushNotificationViewedEvent(Bundle extras) {
        if (extras == null || extras.isEmpty() || extras.get("wzrk_pn") == null) {
            this.config.getLogger().debug(this.config.getAccountId(), "Push notification: " + (extras == null ? "NULL" : extras.toString()) + " not from CleverTap - will not process Notification Viewed event.");
            return;
        }
        if (!extras.containsKey("wzrk_id") || extras.getString("wzrk_id") == null) {
            this.config.getLogger().debug(this.config.getAccountId(), "Push notification ID Tag is null, not processing Notification Viewed event for:  " + extras);
            return;
        }
        boolean isDuplicate = this.checkDuplicateNotificationIds(this.dedupeCheckKey(extras), this.notificationViewedIdTagMap, 2000);
        if (isDuplicate) {
            this.config.getLogger().debug(this.config.getAccountId(), "Already processed Notification Viewed event for " + extras + ", dropping duplicate.");
            return;
        }
        this.config.getLogger().debug("Recording Notification Viewed event for notification:  " + extras);
        try {
            JSONObject notif = AnalyticsManagerBundler.wzrkBundleToJson(extras);
            JSONObject event = AnalyticsManagerBundler.notificationViewedJson(notif);
            this.baseEventQueueManager.queueEvent(this.context, event, 6, this.getFlattenedEventProperties(notif));
        }
        catch (JSONException e) {
            this.config.getLogger().debug("Failed to recording Notification Viewed " + (Object)((Object)e));
        }
    }

    @Override
    public void pushProfile(Map<String, Object> profile) {
        this.config.getLogger().verbose(this.config.getAccountId(), "pushProfile: profile=" + profile);
        if (profile == null || profile.isEmpty() || this.deviceInfo.getDeviceID() == null) {
            return;
        }
        Task<Void> task = this.executors.postAsyncSafelyTask();
        task.execute("profilePush", () -> {
            this._push(profile);
            return null;
        });
    }

    @Override
    public void removeMultiValuesForKey(String key, ArrayList<String> values) {
        this.config.getLogger().verbose(this.config.getAccountId(), "removeMultiValuesForKey: key=" + key + ", values=" + values);
        Task<Void> task = this.executors.postAsyncSafelyTask();
        task.execute("removeMultiValuesForKey", () -> {
            this._handleMultiValues(values, key, ProfileCommand.REMOVE);
            return null;
        });
    }

    @Override
    public void removeValueForKey(String key) {
        this.config.getLogger().verbose(this.config.getAccountId(), "removeValueForKey: key=" + key);
        Task<Void> task = this.executors.postAsyncSafelyTask();
        task.execute("removeValueForKey", () -> {
            this._removeValueForKey(key);
            return null;
        });
    }

    @Override
    public void sendDataEvent(JSONObject event) {
        this.baseEventQueueManager.queueEvent(this.context, event, 5);
    }

    public void pushChargedEvent(HashMap<String, Object> chargeDetails, ArrayList<HashMap<String, Object>> items) {
        this.config.getLogger().verbose(this.config.getAccountId(), "pushChargedEvent: chargeDetails=" + chargeDetails + ", items=" + items);
        Task<Void> task = this.executors.postAsyncSafelyTask();
        task.execute("pushChargedEvent", () -> {
            this._pushChargedEvent(chargeDetails, items);
            return null;
        });
    }

    @WorkerThread
    private void _pushChargedEvent(HashMap<String, Object> chargeDetails, ArrayList<HashMap<String, Object>> items) {
        if (chargeDetails == null || items == null) {
            this.config.getLogger().debug(this.config.getAccountId(), "Invalid Charged event: details and or items is null");
            return;
        }
        ChargedEventItemsValidationResult validationResult = this.validationPipelineProvider.getChargedEventItemsValidationPipeline().execute((List<?>)items, this.validationConfig);
        if (validationResult.shouldDrop()) {
            return;
        }
        JSONObject chargedEvent = new JSONObject();
        try {
            EventDataValidationResult detailsResult = this.validationPipelineProvider.getEventDataPipeline().execute((Map<?, ?>)chargeDetails, this.validationConfig);
            if (detailsResult.shouldDrop()) {
                return;
            }
            JSONObject evtData = detailsResult.getCleanedData();
            JSONArray jsonItemsArray = new JSONArray();
            for (HashMap<String, Object> map : items) {
                EventDataValidationResult itemResult = this.validationPipelineProvider.getEventDataPipeline().execute((Map<?, ?>)map, this.validationConfig);
                if (itemResult.shouldDrop()) continue;
                JSONObject itemDetails = itemResult.getCleanedData();
                jsonItemsArray.put((Object)itemDetails);
            }
            evtData.put("Items", (Object)jsonItemsArray);
            chargedEvent.put("evtName", (Object)"Charged");
            chargedEvent.put("evtData", (Object)evtData);
            FlattenedEventData flattenedData = this.getFlattenedEventProperties(evtData);
            this.baseEventQueueManager.queueEvent(this.context, chargedEvent, 4, flattenedData);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    synchronized void pushDeepLink(Uri uri, boolean install) {
        if (uri == null) {
            return;
        }
        try {
            JSONObject referrer = UriHelper.getUrchinFromUri(uri);
            if (referrer.has("us")) {
                this.coreMetaData.setSource(referrer.get("us").toString());
            }
            if (referrer.has("um")) {
                this.coreMetaData.setMedium(referrer.get("um").toString());
            }
            if (referrer.has("uc")) {
                this.coreMetaData.setCampaign(referrer.get("uc").toString());
            }
            referrer.put("referrer", (Object)uri.toString());
            if (install) {
                referrer.put("install", true);
            }
            this.recordPageEventWithExtras(referrer);
        }
        catch (Throwable t) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Failed to push deep link", t);
        }
    }

    @Deprecated
    Future<?> raiseEventForSignedCall(String eventName, JSONObject dcEventProperties) {
        Future<?> future = null;
        JSONObject event = new JSONObject();
        try {
            event.put("evtName", (Object)eventName);
            event.put("evtData", (Object)dcEventProperties);
            future = this.baseEventQueueManager.queueEvent(this.context, event, 4);
        }
        catch (JSONException e) {
            this.config.getLogger().debug(this.config.getAccountId(), "SignedCall : JSON Exception when raising Signed Call event " + eventName + " - " + e.getLocalizedMessage());
        }
        return future;
    }

    Future<?> raiseEventForGeofences(String eventName, JSONObject geofenceProperties) {
        Future<?> future = null;
        JSONObject event = new JSONObject();
        try {
            event.put("evtName", (Object)eventName);
            event.put("evtData", (Object)geofenceProperties);
            Location location = new Location("");
            location.setLatitude(geofenceProperties.getDouble("triggered_lat"));
            location.setLongitude(geofenceProperties.getDouble("triggered_lng"));
            geofenceProperties.remove("triggered_lat");
            geofenceProperties.remove("triggered_lng");
            this.coreMetaData.setLocationFromUser(location);
            future = this.baseEventQueueManager.queueEvent(this.context, event, 4, this.getFlattenedEventProperties(geofenceProperties));
        }
        catch (JSONException e) {
            this.config.getLogger().debug(this.config.getAccountId(), "Geofences : JSON Exception when raising GeoFence event " + eventName + " - " + e.getLocalizedMessage());
        }
        return future;
    }

    void recordPageEventWithExtras(JSONObject extras) {
        try {
            JSONObject jsonObject = new JSONObject();
            if (extras != null && extras.length() > 0) {
                Iterator keys = extras.keys();
                while (keys.hasNext()) {
                    try {
                        String key = (String)keys.next();
                        jsonObject.put(key, (Object)extras.getString(key));
                    }
                    catch (ClassCastException classCastException) {}
                }
            }
            this.baseEventQueueManager.queueEvent(this.context, jsonObject, 1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void setMultiValuesForKey(String key, ArrayList<String> values) {
        this.config.getLogger().verbose(this.config.getAccountId(), "setMultiValuesForKey: key=" + key + ", values=" + values);
        Task<Void> task = this.executors.postAsyncSafelyTask();
        task.execute("setMultiValuesForKey", () -> {
            this._handleMultiValues(values, key, ProfileCommand.SET);
            return null;
        });
    }

    private void _handleMultiValues(ArrayList<String> values, String key, ProfileCommand command) {
        if (key == null) {
            return;
        }
        HashMap<String, ArrayList<String>> eventData = new HashMap<String, ArrayList<String>>();
        eventData.put(key, values);
        EventDataValidationResult eventDataValidationResult = this.validationPipelineProvider.getMultiValueDataPipeline().execute((Map<?, ?>)eventData, this.validationConfig);
        if (eventDataValidationResult.shouldDrop()) {
            return;
        }
        try {
            this._pushMultiValue(eventDataValidationResult.getCleanedData().getJSONArray(key), key, command);
        }
        catch (JSONException e) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Failed to handle Multi Values for key" + key, e);
        }
    }

    private void _constructIncrementDecrementValues(Number value, String key, ProfileCommand command) {
        if (value == null) {
            return;
        }
        try {
            PropertyKeyValidationResult keyResult = this.validationPipelineProvider.getPropertyKeyPipeline().execute(key, this.validationConfig);
            if (keyResult.shouldDrop()) {
                return;
            }
            key = keyResult.getCleanedKey();
            JSONObject profileCommand = new JSONObject().put(command.getCommandString(), (Object)value);
            JSONObject profileUpdate = new JSONObject().put(key, (Object)profileCommand);
            ProfileOperation operation = command.getOperation();
            this.baseEventQueueManager.pushBasicProfile(profileUpdate, false, this.mergeProfileChanges(key, value, operation));
        }
        catch (Throwable t) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Failed to update profile value for key " + key, t);
        }
    }

    private void _push(Map<String, Object> profile) {
        try {
            EventDataValidationResult profileResult = this.validationPipelineProvider.getEventDataPipeline().execute(profile, this.validationConfig);
            if (profileResult.shouldDrop()) {
                return;
            }
            JSONObject cleanedProfile = profileResult.getCleanedData();
            this.config.getLogger().verbose(this.config.getAccountId(), "Constructed custom profile: " + cleanedProfile);
            this.baseEventQueueManager.pushBasicProfile(cleanedProfile, false, this.mergeProfileChanges(cleanedProfile, ProfileOperation.UPDATE));
        }
        catch (Throwable t) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Failed to push profile", t);
        }
    }

    private void _removeValueForKey(String key) {
        try {
            PropertyKeyValidationResult keyValidationResult = this.validationPipelineProvider.getPropertyKeyPipeline().execute(key, this.validationConfig);
            if (keyValidationResult.shouldDrop()) {
                return;
            }
            key = keyValidationResult.getCleanedKey();
            if (key.toLowerCase().contains("identity")) {
                this.config.getLogger().verbose(this.config.getAccountId(), "Cannot remove value for key " + key + " from user profile");
                return;
            }
            ProfileCommand command = ProfileCommand.DELETE;
            JSONObject profileCommand = new JSONObject().put(command.getCommandString(), true);
            JSONObject profileUpdate = new JSONObject().put(key, (Object)profileCommand);
            this.baseEventQueueManager.pushBasicProfile(profileUpdate, true, this.mergeProfileChanges(key, "__CLEVERTAP_DELETE__", command.getOperation()));
            this.config.getLogger().verbose(this.config.getAccountId(), "removing value for key " + key + " from user profile");
        }
        catch (Throwable t) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Failed to remove profile value for key " + key, t);
        }
    }

    private void _pushMultiValue(JSONArray originalValues, String key, ProfileCommand command) {
        try {
            JSONObject profileCommand = new JSONObject();
            profileCommand.put(command.getCommandString(), (Object)originalValues);
            JSONObject profileUpdate = new JSONObject();
            profileUpdate.put(key, (Object)profileCommand);
            ProfileOperation operation = command.getOperation();
            this.baseEventQueueManager.pushBasicProfile(profileUpdate, false, this.mergeProfileChanges(key, originalValues, operation));
            this.config.getLogger().verbose(this.config.getAccountId(), "Constructed multi-value profile push: " + profileUpdate);
        }
        catch (Throwable t) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Error pushing multiValue for key " + key, t);
        }
    }

    String dedupeCheckKey(Bundle extras) {
        Object doDedupeCheck = extras.get("wzrk_dd");
        boolean check = false;
        if (doDedupeCheck != null) {
            if (doDedupeCheck instanceof String) {
                check = "true".equalsIgnoreCase((String)doDedupeCheck);
            }
            if (doDedupeCheck instanceof Boolean) {
                check = (Boolean)doDedupeCheck;
            }
        }
        String notificationIdTag = check ? extras.getString("wzrk_pid") : extras.getString("wzrk_id");
        return notificationIdTag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDuplicateNotificationIds(String notificationIdTag, HashMap<String, Long> notificationTagMap, int interval) {
        Object object = this.notificationMapLock;
        synchronized (object) {
            boolean isDupe = false;
            try {
                long timestamp;
                long now = this.currentTimeProvider.currentTimeMillis();
                if (notificationTagMap.containsKey(notificationIdTag) && now - (timestamp = notificationTagMap.get(notificationIdTag).longValue()) < (long)interval) {
                    isDupe = true;
                }
                notificationTagMap.put(notificationIdTag, now);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return isDupe;
        }
    }

    public void sendPingEvent(JSONObject eventObject) {
        this.baseEventQueueManager.queueEvent(this.context, eventObject, 2);
    }

    @Override
    public void sendFetchEvent(JSONObject eventObject) {
        this.baseEventQueueManager.queueEvent(this.context, eventObject, 7);
    }

    private void handleSendTestForDisplayUnits(Bundle extras) {
        try {
            JSONObject r = CTJsonConverter.displayUnitFromExtras(extras);
            DisplayUnitResponse cleverTapResponse = new DisplayUnitResponse(this.config, this.callbackManager, this.controllerManager);
            ((CleverTapResponse)cleverTapResponse).processResponse(r, null, this.context);
        }
        catch (Throwable t) {
            Logger.v("Failed to process Display Unit from push notification payload", t);
        }
    }

    void pushInboxMessageStateEvent(boolean clicked, CTInboxMessage data, Bundle customData) {
        JSONObject event = new JSONObject();
        try {
            JSONObject notif = CTJsonConverter.getWzrkFields(data);
            if (customData != null) {
                for (String x : customData.keySet()) {
                    Object value = customData.get(x);
                    if (value == null) continue;
                    notif.put(x, value);
                }
            }
            if (clicked) {
                try {
                    this.coreMetaData.setWzrkParams(notif);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                event.put("evtName", (Object)"Notification Clicked");
            } else {
                event.put("evtName", (Object)"Notification Viewed");
            }
            event.put("evtData", (Object)notif);
            this.baseEventQueueManager.queueEvent(this.context, event, 4, this.getFlattenedEventProperties(notif));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private FlattenedEventData getFlattenedEventProperties(JSONObject properties) {
        return new FlattenedEventData.EventProperties(JsonFlattener.flatten(properties));
    }

    private FlattenedEventData.ProfileChanges mergeProfileChanges(String key, Object originalValues, ProfileOperation operation) {
        Map<String, ProfileChange> profileChanges = this.localDataStore.processProfileTree(key, originalValues, operation);
        return new FlattenedEventData.ProfileChanges(profileChanges);
    }

    private FlattenedEventData.ProfileChanges mergeProfileChanges(JSONObject originalValues, ProfileOperation operation) {
        Map<String, ProfileChange> profileChanges = this.localDataStore.processProfileTree(originalValues, operation);
        return new FlattenedEventData.ProfileChanges(profileChanges);
    }
}

