/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.login;

import android.content.Context;
import androidx.annotation.RestrictTo;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.login.ConfigurableIdentityRepo;
import com.clevertap.android.sdk.login.IdentityRepo;
import com.clevertap.android.sdk.login.LegacyIdentityRepo;
import com.clevertap.android.sdk.login.LoginInfoProvider;
import com.clevertap.android.sdk.validation.ValidationResultStack;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class IdentityRepoFactory {
    public static IdentityRepo getRepo(Context context, CleverTapInstanceConfig config, ValidationResultStack validationResultStack) {
        LoginInfoProvider infoProvider = new LoginInfoProvider(context, config);
        IdentityRepo repo = infoProvider.isLegacyProfileLoggedIn() ? new LegacyIdentityRepo(config) : new ConfigurableIdentityRepo(config, infoProvider, validationResultStack);
        config.log("ON_USER_LOGIN", "Repo provider: " + repo.getClass().getSimpleName());
        return repo;
    }

    private IdentityRepoFactory() {
    }
}

