/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp.store.preference;

import com.clevertap.android.sdk.StoreProvider;
import com.clevertap.android.sdk.cryption.ICryptHandler;
import com.clevertap.android.sdk.login.ChangeUserCallback;
import com.clevertap.android.sdk.store.preference.ICTPreference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u001b\b\u0000\u0018\u0000 .2\u00020\u0001:\u0001.B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\tJ\u000e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\tJ\u000e\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\tJ\u0006\u0010\u001e\u001a\u00020\tJ\u0006\u0010\u001f\u001a\u00020\tJ\u0006\u0010 \u001a\u00020\tJ\u000e\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\rJ\u0006\u0010#\u001a\u00020\tJ\u0010\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\rH\u0002J\u0006\u0010&\u001a\u00020\tJ\u000e\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\tJ\u0006\u0010)\u001a\u00020\tJ\u0006\u0010*\u001a\u00020\u0014J\u0018\u0010+\u001a\u00020\u00142\u0006\u0010,\u001a\u00020\r2\u0006\u0010-\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006/"}, d2={"Lcom/clevertap/android/sdk/inapp/store/preference/InAppStore;", "Lcom/clevertap/android/sdk/login/ChangeUserCallback;", "ctPreference", "Lcom/clevertap/android/sdk/store/preference/ICTPreference;", "cryptHandler", "Lcom/clevertap/android/sdk/cryption/ICryptHandler;", "<init>", "(Lcom/clevertap/android/sdk/store/preference/ICTPreference;Lcom/clevertap/android/sdk/cryption/ICryptHandler;)V", "clientSideInApps", "Lorg/json/JSONArray;", "serverSideInApps", "clientSideDelayedInApps", "value", "", "mode", "getMode", "()Ljava/lang/String;", "setMode", "(Ljava/lang/String;)V", "removeClientSideInApps", "", "removeServerSideInAppsMetaData", "storeClientSideInApps", "storeServerSideInAppsMetaData", "serverSideInAppsMetaData", "storeServerSideInApps", "storeEvaluatedServerSideInAppIds", "evaluatedServerSideInAppIds", "storeSuppressedClientSideInAppIds", "suppressedClientSideInAppIds", "readClientSideInApps", "readServerSideInAppsMetaData", "readEvaluatedServerSideInAppIds", "migrateEvaluatedServerSideInAppIds", "evaluatedIds", "readSuppressedClientSideInAppIds", "migrateInAppHeaderPrefsForEventType", "inAppIds", "readServerSideInApps", "storeClientSideDelayedInApps", "delayedInApps", "readClientSideDelayedInApps", "removeClientSideDelayedInApps", "onChangeUser", "deviceId", "accountId", "Companion", "clevertap-core_release"})
@SourceDebugExtension(value={"SMAP\nInAppStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InAppStore.kt\ncom/clevertap/android/sdk/inapp/store/preference/InAppStore\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,347:1\n1#2:348\n*E\n"})
public final class InAppStore
implements ChangeUserCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ICTPreference ctPreference;
    @NotNull
    private final ICryptHandler cryptHandler;
    @Nullable
    private JSONArray clientSideInApps;
    @Nullable
    private JSONArray serverSideInApps;
    @Nullable
    private JSONArray clientSideDelayedInApps;
    @Nullable
    private String mode;
    @NotNull
    public static final String CLIENT_SIDE_MODE = "CS";
    @NotNull
    public static final String SERVER_SIDE_MODE = "SS";
    @NotNull
    public static final String NO_MODE = "NO_MODE";
    @NotNull
    public static final String PREFS_DELAYED_INAPP_KEY_CS = "delayed_inapp_notifs_cs";

    public InAppStore(@NotNull ICTPreference ctPreference, @NotNull ICryptHandler cryptHandler) {
        Intrinsics.checkNotNullParameter((Object)ctPreference, (String)"ctPreference");
        Intrinsics.checkNotNullParameter((Object)cryptHandler, (String)"cryptHandler");
        this.ctPreference = ctPreference;
        this.cryptHandler = cryptHandler;
    }

    @Nullable
    public final String getMode() {
        return this.mode;
    }

    public final void setMode(@Nullable String value) {
        block14: {
            if (Intrinsics.areEqual((Object)this.mode, (Object)value)) {
                return;
            }
            this.mode = value;
            String string2 = value;
            if (string2 == null) break block14;
            int n = -1;
            switch (string2.hashCode()) {
                case 2160: {
                    if (string2.equals(CLIENT_SIDE_MODE)) {
                        n = 1;
                    }
                    break;
                }
                case 2656: {
                    if (string2.equals(SERVER_SIDE_MODE)) {
                        n = 2;
                    }
                    break;
                }
                case -1437347487: {
                    if (string2.equals(NO_MODE)) {
                        n = 3;
                    }
                    break;
                }
            }
            switch (n) {
                case 1: {
                    this.removeServerSideInAppsMetaData();
                    break;
                }
                case 2: {
                    this.removeClientSideInApps();
                    this.removeClientSideDelayedInApps();
                    break;
                }
                case 3: {
                    this.removeServerSideInAppsMetaData();
                    this.removeClientSideInApps();
                    this.removeClientSideDelayedInApps();
                }
            }
        }
    }

    private final void removeClientSideInApps() {
        this.ctPreference.remove("inapp_notifs_cs");
        this.clientSideInApps = null;
    }

    private final void removeServerSideInAppsMetaData() {
        this.ctPreference.remove("inapp_notifs_ss");
    }

    public final void storeClientSideInApps(@NotNull JSONArray clientSideInApps) {
        block0: {
            String string2;
            String encryptedString;
            Intrinsics.checkNotNullParameter((Object)clientSideInApps, (String)"clientSideInApps");
            this.clientSideInApps = clientSideInApps;
            String string3 = clientSideInApps.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            String string4 = encryptedString = this.cryptHandler.encrypt(string3);
            if (string4 == null) break block0;
            String $this$storeClientSideInApps_u24lambda_u240 = string2 = string4;
            boolean bl = false;
            this.ctPreference.writeString("inapp_notifs_cs", $this$storeClientSideInApps_u24lambda_u240);
        }
    }

    public final void storeServerSideInAppsMetaData(@NotNull JSONArray serverSideInAppsMetaData) {
        Intrinsics.checkNotNullParameter((Object)serverSideInAppsMetaData, (String)"serverSideInAppsMetaData");
        String string2 = serverSideInAppsMetaData.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        this.ctPreference.writeString("inapp_notifs_ss", string2);
    }

    public final void storeServerSideInApps(@NotNull JSONArray serverSideInApps) {
        block0: {
            String string2;
            String encryptedString;
            Intrinsics.checkNotNullParameter((Object)serverSideInApps, (String)"serverSideInApps");
            this.serverSideInApps = serverSideInApps;
            String string3 = serverSideInApps.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            String string4 = encryptedString = this.cryptHandler.encrypt(string3);
            if (string4 == null) break block0;
            String $this$storeServerSideInApps_u24lambda_u241 = string2 = string4;
            boolean bl = false;
            this.ctPreference.writeString("inApp", $this$storeServerSideInApps_u24lambda_u241);
        }
    }

    public final void storeEvaluatedServerSideInAppIds(@NotNull JSONArray evaluatedServerSideInAppIds) {
        Intrinsics.checkNotNullParameter((Object)evaluatedServerSideInAppIds, (String)"evaluatedServerSideInAppIds");
        String string2 = evaluatedServerSideInAppIds.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        this.ctPreference.writeString("evaluated_ss", string2);
    }

    public final void storeSuppressedClientSideInAppIds(@NotNull JSONArray suppressedClientSideInAppIds) {
        Intrinsics.checkNotNullParameter((Object)suppressedClientSideInAppIds, (String)"suppressedClientSideInAppIds");
        String string2 = suppressedClientSideInAppIds.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        this.ctPreference.writeString("suppressed_ss", string2);
    }

    @NotNull
    public final JSONArray readClientSideInApps() {
        Object object;
        if (this.clientSideInApps != null) {
            JSONArray jSONArray = this.clientSideInApps;
            Intrinsics.checkNotNull((Object)jSONArray, (String)"null cannot be cast to non-null type org.json.JSONArray");
            return jSONArray;
        }
        String csInAppsEncrypted = this.ctPreference.readString("inapp_notifs_cs", "");
        InAppStore inAppStore = this;
        CharSequence charSequence = csInAppsEncrypted;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            object = new JSONArray();
        } else {
            InAppStore inAppStore2 = inAppStore;
            try {
                inAppStore = inAppStore2;
                charSequence = new JSONArray(this.cryptHandler.decrypt(csInAppsEncrypted));
            }
            catch (Exception exception) {
                inAppStore = inAppStore2;
                charSequence = new JSONArray();
            }
            object = charSequence;
        }
        inAppStore.clientSideInApps = object;
        JSONArray jSONArray = this.clientSideInApps;
        Intrinsics.checkNotNull((Object)jSONArray, (String)"null cannot be cast to non-null type org.json.JSONArray");
        return jSONArray;
    }

    @NotNull
    public final JSONArray readServerSideInAppsMetaData() {
        String ssInAppsMetaData = this.ctPreference.readString("inapp_notifs_ss", "");
        CharSequence charSequence = ssInAppsMetaData;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return new JSONArray();
        }
        return new JSONArray(ssInAppsMetaData);
    }

    @NotNull
    public final JSONArray readEvaluatedServerSideInAppIds() {
        String evaluatedServerSideInAppIds = this.ctPreference.readString("evaluated_ss", "");
        CharSequence charSequence = evaluatedServerSideInAppIds;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return new JSONArray();
        }
        try {
            charSequence = new JSONArray(evaluatedServerSideInAppIds);
        }
        catch (JSONException e) {
            charSequence = this.migrateEvaluatedServerSideInAppIds(evaluatedServerSideInAppIds);
        }
        return charSequence;
    }

    @NotNull
    public final JSONArray migrateEvaluatedServerSideInAppIds(@NotNull String evaluatedIds) {
        Intrinsics.checkNotNullParameter((Object)evaluatedIds, (String)"evaluatedIds");
        try {
            int count;
            int n;
            JSONArray jSONArray;
            JSONObject oldFormatted = new JSONObject(evaluatedIds);
            JSONArray raisedArray = oldFormatted.optJSONArray("raised");
            JSONArray profileArray = oldFormatted.optJSONArray("profile");
            JSONArray $this$migrateEvaluatedServerSideInAppIds_u24lambda_u242 = jSONArray = new JSONArray();
            boolean bl = false;
            if (raisedArray != null) {
                n = raisedArray.length();
                for (count = 0; count < n; ++count) {
                    $this$migrateEvaluatedServerSideInAppIds_u24lambda_u242.put(raisedArray.get(count));
                }
            }
            if (profileArray != null) {
                n = profileArray.length();
                for (count = 0; count < n; ++count) {
                    $this$migrateEvaluatedServerSideInAppIds_u24lambda_u242.put(profileArray.get(count));
                }
            }
            return jSONArray;
        }
        catch (JSONException e) {
            return new JSONArray();
        }
    }

    @NotNull
    public final JSONArray readSuppressedClientSideInAppIds() {
        String suppressedClientSideInAppIds = this.ctPreference.readString("suppressed_ss", "");
        CharSequence charSequence = suppressedClientSideInAppIds;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return new JSONArray();
        }
        try {
            charSequence = new JSONArray(suppressedClientSideInAppIds);
        }
        catch (JSONException jsonException) {
            charSequence = this.migrateInAppHeaderPrefsForEventType(suppressedClientSideInAppIds);
        }
        return charSequence;
    }

    private final JSONArray migrateInAppHeaderPrefsForEventType(String inAppIds) {
        try {
            int count;
            int n;
            JSONArray jSONArray;
            JSONObject oldJsonObject = new JSONObject(inAppIds);
            JSONArray raisedArray = oldJsonObject.optJSONArray("raised");
            JSONArray profileArray = oldJsonObject.optJSONArray("profile");
            JSONArray $this$migrateInAppHeaderPrefsForEventType_u24lambda_u243 = jSONArray = new JSONArray();
            boolean bl = false;
            if (raisedArray != null) {
                n = raisedArray.length();
                for (count = 0; count < n; ++count) {
                    $this$migrateInAppHeaderPrefsForEventType_u24lambda_u243.put(raisedArray.get(count));
                }
            }
            if (profileArray != null) {
                n = profileArray.length();
                for (count = 0; count < n; ++count) {
                    $this$migrateInAppHeaderPrefsForEventType_u24lambda_u243.put(profileArray.get(count));
                }
            }
            return jSONArray;
        }
        catch (JSONException jSONException) {
            return new JSONArray();
        }
    }

    @NotNull
    public final JSONArray readServerSideInApps() {
        Object object;
        if (this.serverSideInApps != null) {
            JSONArray jSONArray = this.serverSideInApps;
            Intrinsics.checkNotNull((Object)jSONArray, (String)"null cannot be cast to non-null type org.json.JSONArray");
            return jSONArray;
        }
        String ssEncryptedInApps = this.ctPreference.readString("inApp", "");
        InAppStore inAppStore = this;
        CharSequence charSequence = ssEncryptedInApps;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            object = new JSONArray();
        } else {
            InAppStore inAppStore2 = inAppStore;
            try {
                inAppStore = inAppStore2;
                charSequence = new JSONArray(this.cryptHandler.decrypt(ssEncryptedInApps));
            }
            catch (Exception exception) {
                inAppStore = inAppStore2;
                charSequence = new JSONArray();
            }
            object = charSequence;
        }
        inAppStore.serverSideInApps = object;
        JSONArray jSONArray = this.serverSideInApps;
        Intrinsics.checkNotNull((Object)jSONArray, (String)"null cannot be cast to non-null type org.json.JSONArray");
        return jSONArray;
    }

    public final void storeClientSideDelayedInApps(@NotNull JSONArray delayedInApps) {
        block0: {
            String string2;
            String encryptedString;
            Intrinsics.checkNotNullParameter((Object)delayedInApps, (String)"delayedInApps");
            this.clientSideDelayedInApps = delayedInApps;
            String string3 = delayedInApps.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            String string4 = encryptedString = this.cryptHandler.encrypt(string3);
            if (string4 == null) break block0;
            String $this$storeClientSideDelayedInApps_u24lambda_u244 = string2 = string4;
            boolean bl = false;
            this.ctPreference.writeString(PREFS_DELAYED_INAPP_KEY_CS, $this$storeClientSideDelayedInApps_u24lambda_u244);
        }
    }

    @NotNull
    public final JSONArray readClientSideDelayedInApps() {
        Object object;
        if (this.clientSideDelayedInApps != null) {
            JSONArray jSONArray = this.clientSideDelayedInApps;
            Intrinsics.checkNotNull((Object)jSONArray, (String)"null cannot be cast to non-null type org.json.JSONArray");
            return jSONArray;
        }
        String csDelayedInAppsEncrypted = this.ctPreference.readString(PREFS_DELAYED_INAPP_KEY_CS, "");
        InAppStore inAppStore = this;
        CharSequence charSequence = csDelayedInAppsEncrypted;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            object = new JSONArray();
        } else {
            InAppStore inAppStore2 = inAppStore;
            try {
                inAppStore = inAppStore2;
                charSequence = new JSONArray(this.cryptHandler.decrypt(csDelayedInAppsEncrypted));
            }
            catch (Exception exception) {
                inAppStore = inAppStore2;
                charSequence = new JSONArray();
            }
            object = charSequence;
        }
        inAppStore.clientSideDelayedInApps = object;
        JSONArray jSONArray = this.clientSideDelayedInApps;
        Intrinsics.checkNotNull((Object)jSONArray, (String)"null cannot be cast to non-null type org.json.JSONArray");
        return jSONArray;
    }

    public final void removeClientSideDelayedInApps() {
        this.ctPreference.remove(PREFS_DELAYED_INAPP_KEY_CS);
        this.clientSideDelayedInApps = null;
    }

    @Override
    public void onChangeUser(@NotNull String deviceId, @NotNull String accountId) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        String newPrefName = StoreProvider.Companion.getInstance().constructStorePreferenceName(1, deviceId, accountId);
        this.ctPreference.changePreferenceName(newPrefName);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/clevertap/android/sdk/inapp/store/preference/InAppStore$Companion;", "", "<init>", "()V", "CLIENT_SIDE_MODE", "", "SERVER_SIDE_MODE", "NO_MODE", "PREFS_DELAYED_INAPP_KEY_CS", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

