/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp.delay;

import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleOwnerKt;
import androidx.lifecycle.ProcessLifecycleOwner;
import androidx.lifecycle.RepeatOnLifecycleKt;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.inapp.delay.DelayedInAppResult;
import com.clevertap.android.sdk.inapp.delay.InAppDelayManager;
import com.clevertap.android.sdk.inapp.store.db.DelayedLegacyInAppStore;
import com.clevertap.android.sdk.utils.Clock;
import com.clevertap.android.sdk.utils.JsonUtilsKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.NonCancellable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 =2\u00020\u0001:\u0003=>?BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ,\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001eH\u0002J)\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001eH\u0000\u00a2\u0006\u0002\b$J\u000e\u0010%\u001a\u00020 H\u0086@\u00a2\u0006\u0002\u0010&J\u0006\u0010'\u001a\u00020 J\u0015\u0010(\u001a\u00020)2\u0006\u0010\u001a\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b*J\u000e\u0010+\u001a\u00020 H\u0082@\u00a2\u0006\u0002\u0010&J\r\u0010,\u001a\u00020-H\u0000\u00a2\u0006\u0002\b.J\r\u0010/\u001a\u00020-H\u0000\u00a2\u0006\u0002\b0J\u0015\u00101\u001a\u00020)2\u0006\u0010\u001a\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b2J\u0013\u00103\u001a\b\u0012\u0004\u0012\u00020\u000304H\u0000\u00a2\u0006\u0002\b5J\u0010\u00106\u001a\u00020 H\u0080@\u00a2\u0006\u0004\b7\u0010&J\u0010\u00108\u001a\u00020\u001c2\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010;\u001a\u00020 2\u0006\u0010<\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00180\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/clevertap/android/sdk/inapp/delay/InAppDelayManager;", "", "accountId", "", "logger", "Lcom/clevertap/android/sdk/Logger;", "delayedLegacyInAppStore", "Lcom/clevertap/android/sdk/inapp/store/db/DelayedLegacyInAppStore;", "clock", "Lcom/clevertap/android/sdk/utils/Clock;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "<init>", "(Ljava/lang/String;Lcom/clevertap/android/sdk/Logger;Lcom/clevertap/android/sdk/inapp/store/db/DelayedLegacyInAppStore;Lcom/clevertap/android/sdk/utils/Clock;Lkotlinx/coroutines/CoroutineScope;Landroidx/lifecycle/LifecycleOwner;)V", "getDelayedLegacyInAppStore$clevertap_core_release", "()Lcom/clevertap/android/sdk/inapp/store/db/DelayedLegacyInAppStore;", "setDelayedLegacyInAppStore$clevertap_core_release", "(Lcom/clevertap/android/sdk/inapp/store/db/DelayedLegacyInAppStore;)V", "activeJobs", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkotlinx/coroutines/Job;", "cancelledJobs", "Lcom/clevertap/android/sdk/inapp/delay/InAppDelayManager$CancelledJobData;", "scheduleInAppCallbackWithDispatcher", "id", "delayInMs", "", "callback", "Lkotlin/Function1;", "Lcom/clevertap/android/sdk/inapp/delay/DelayedInAppResult;", "", "scheduleDelayedInApps", "delayedInApps", "Lorg/json/JSONArray;", "scheduleDelayedInApps$clevertap_core_release", "onAppBackground", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onAppForeground", "cancelCallback", "", "cancelCallback$clevertap_core_release", "cancelAllCallbacks", "getActiveCallbackCount", "", "getActiveCallbackCount$clevertap_core_release", "getCancelledJobsCount", "getCancelledJobsCount$clevertap_core_release", "isCallbackScheduled", "isCallbackScheduled$clevertap_core_release", "getActiveCallbackIds", "", "getActiveCallbackIds$clevertap_core_release", "cleanup", "cleanup$clevertap_core_release", "getInAppDelayInMs", "inApp", "Lorg/json/JSONObject;", "logCoroutineInfo", "msg", "Companion", "RescheduleData", "CancelledJobData", "clevertap-core_release"})
@SourceDebugExtension(value={"SMAP\nInAppDelayManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InAppDelayManager.kt\ncom/clevertap/android/sdk/inapp/delay/InAppDelayManager\n+ 2 CTXtensions.kt\ncom/clevertap/android/sdk/CTXtensions\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,385:1\n288#2,7:386\n288#2,7:393\n216#3,2:400\n1863#4,2:402\n1863#4,2:404\n1863#4,2:406\n503#5,7:408\n*S KotlinDebug\n*F\n+ 1 InAppDelayManager.kt\ncom/clevertap/android/sdk/inapp/delay/InAppDelayManager\n*L\n178#1:386,7\n188#1:393,7\n243#1:400,2\n276#1:402,2\n291#1:404,2\n326#1:406,2\n349#1:408,7\n*E\n"})
public final class InAppDelayManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String accountId;
    @NotNull
    private final Logger logger;
    @Nullable
    private DelayedLegacyInAppStore delayedLegacyInAppStore;
    @NotNull
    private final Clock clock;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final LifecycleOwner lifecycleOwner;
    @NotNull
    private final ConcurrentHashMap<String, Job> activeJobs;
    @NotNull
    private final ConcurrentHashMap<String, CancelledJobData> cancelledJobs;
    private static final int PARALLEL_SCHEDULERS = 20;
    @NotNull
    private static final String TAG = "[InAppDelayManager]:";

    public InAppDelayManager(@NotNull String accountId, @NotNull Logger logger, @Nullable DelayedLegacyInAppStore delayedLegacyInAppStore, @NotNull Clock clock, @NotNull CoroutineScope scope, @NotNull LifecycleOwner lifecycleOwner) {
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        this.accountId = accountId;
        this.logger = logger;
        this.delayedLegacyInAppStore = delayedLegacyInAppStore;
        this.clock = clock;
        this.scope = scope;
        this.lifecycleOwner = lifecycleOwner;
        this.activeJobs = new ConcurrentHashMap();
        this.cancelledJobs = new ConcurrentHashMap();
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ InAppDelayManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                        Job job2 = (Job)$this$launch.getCoroutineContext().get((CoroutineContext.Key)Job.Key);
                        this.this$0.logCoroutineInfo("lifeCycleOwner scope launch, " + $this$launch.getCoroutineContext() + ", " + (job2 != null ? job2.getParent() : null) + '}');
                        this.label = 1;
                        Object object3 = RepeatOnLifecycleKt.repeatOnLifecycle((LifecycleOwner)this.this$0.lifecycleOwner, (Lifecycle.State)Lifecycle.State.STARTED, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ InAppDelayManager this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object var1_1) {
                                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        $this$repeatOnLifecycle = (CoroutineScope)this.L$0;
                                        v0 = (Job)$this$repeatOnLifecycle.getCoroutineContext().get((CoroutineContext.Key)Job.Key);
                                        InAppDelayManager.access$logCoroutineInfo(this.this$0, "process lifeCycleOwner: started, " + $this$repeatOnLifecycle.getCoroutineContext() + ", " + (v0 != null ? v0.getParent() : null) + '}');
                                        this.this$0.onAppForeground();
                                        this.L$0 = $this$repeatOnLifecycle;
                                        this.label = 1;
                                        v1 = DelayKt.awaitCancellation((Continuation)((Continuation)this));
                                        ** if (v1 != var4_2) goto lbl16
lbl15:
                                        // 1 sources

                                        return var4_2;
lbl16:
                                        // 1 sources

                                        ** GOTO lbl23
                                    }
                                    case 1: {
                                        $this$repeatOnLifecycle = (CoroutineScope)this.L$0;
                                        try {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v1 = $result;
lbl23:
                                            // 2 sources

                                            throw new KotlinNothingValueException();
                                        }
                                        catch (CancellationException var3_4) {
                                            v2 = (Job)$this$repeatOnLifecycle.getCoroutineContext().get((CoroutineContext.Key)Job.Key);
                                            InAppDelayManager.access$logCoroutineInfo(this.this$0, "process lifeCycleOwner: Stopped, " + $this$repeatOnLifecycle.getCoroutineContext() + ", " + (v2 != null ? v2.getParent() : null) + '}');
                                            this.L$0 = $this$repeatOnLifecycle;
                                            this.label = 2;
                                            v3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)NonCancellable.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                                int label;
                                                private /* synthetic */ Object L$0;
                                                final /* synthetic */ InAppDelayManager this$0;
                                                {
                                                    this.this$0 = $receiver;
                                                    super(2, $completion);
                                                }

                                                /*
                                                 * WARNING - void declaration
                                                 * Enabled force condition propagation
                                                 * Lifted jumps to return sites
                                                 */
                                                public final Object invokeSuspend(Object object) {
                                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)object);
                                                            CoroutineScope $this$withContext = (CoroutineScope)this.L$0;
                                                            Job job2 = (Job)$this$withContext.getCoroutineContext().get((CoroutineContext.Key)Job.Key);
                                                            this.this$0.logCoroutineInfo("process lifeCycleOwner: withContext block, " + $this$withContext.getCoroutineContext() + ", " + (job2 != null ? job2.getParent() : null) + '}');
                                                            this.label = 1;
                                                            Object object3 = this.this$0.onAppBackground((Continuation<? super Unit>)((Continuation)this));
                                                            if (object3 != object2) return Unit.INSTANCE;
                                                            return object2;
                                                        }
                                                        case 1: {
                                                            void $result;
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            Object object3 = $result;
                                                            return Unit.INSTANCE;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                                    function2.L$0 = value;
                                                    return (Continuation)function2;
                                                }

                                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (Continuation)((Continuation)this));
                                            if (v3 == var4_2) {
                                                return var4_2;
                                            }
                                            ** GOTO lbl37
                                        }
                                    }
                                    case 2: {
                                        $this$repeatOnLifecycle = (CoroutineScope)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v3 = $result;
lbl37:
                                        // 2 sources

                                        CoroutineScopeKt.ensureActive((CoroutineScope)$this$repeatOnLifecycle);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                function2.L$0 = value;
                                return (Continuation)function2;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public /* synthetic */ InAppDelayManager(String string2, Logger logger, DelayedLegacyInAppStore delayedLegacyInAppStore, Clock clock, CoroutineScope coroutineScope, LifecycleOwner lifecycleOwner, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            delayedLegacyInAppStore = null;
        }
        if ((n & 8) != 0) {
            clock = Clock.SYSTEM;
        }
        if ((n & 0x10) != 0) {
            coroutineScope = CoroutineScopeKt.plus((CoroutineScope)((CoroutineScope)LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)ProcessLifecycleOwner.Companion.get())), (CoroutineContext)((CoroutineContext)Dispatchers.getDefault().limitedParallelism(20)));
        }
        if ((n & 0x20) != 0) {
            lifecycleOwner = ProcessLifecycleOwner.Companion.get();
        }
        this(string2, logger, delayedLegacyInAppStore, clock, coroutineScope, lifecycleOwner);
    }

    @Nullable
    public final DelayedLegacyInAppStore getDelayedLegacyInAppStore$clevertap_core_release() {
        return this.delayedLegacyInAppStore;
    }

    public final void setDelayedLegacyInAppStore$clevertap_core_release(@Nullable DelayedLegacyInAppStore delayedLegacyInAppStore) {
        this.delayedLegacyInAppStore = delayedLegacyInAppStore;
    }

    private final Job scheduleInAppCallbackWithDispatcher(String id2, long delayInMs, Function1<? super DelayedInAppResult, Unit> callback) {
        Job job2 = this.activeJobs.get(id2);
        if (job2 != null) {
            Job existingJob = job2;
            boolean bl = false;
            if (existingJob.isActive()) {
                this.logger.verbose(this.accountId, "[InAppDelayManager]: InApp callback with id '" + id2 + "' already scheduled, keeping existing");
                return existingJob;
            }
            this.activeJobs.remove(id2);
        }
        Job job3 = BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, delayInMs, id2, callback, null){
            long J$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ InAppDelayManager this$0;
            final /* synthetic */ long $delayInMs;
            final /* synthetic */ String $id;
            final /* synthetic */ Function1<DelayedInAppResult, Unit> $callback;
            {
                this.this$0 = $receiver;
                this.$delayInMs = $delayInMs;
                this.$id = $id;
                this.$callback = $callback;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
                        scheduledAt = InAppDelayManager.access$getClock$p(this.this$0).currentTimeMillis();
                        this.L$0 = $this$launch;
                        this.J$0 = scheduledAt;
                        this.label = 1;
                        v0 = DelayKt.delay((long)this.$delayInMs, (Continuation)((Continuation)this));
                        ** if (v0 != var8_2) goto lbl15
lbl14:
                        // 1 sources

                        return var8_2;
lbl15:
                        // 1 sources

                        ** GOTO lbl23
                    }
                    case 1: {
                        scheduledAt = this.J$0;
                        $this$launch = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl23:
                        // 2 sources

                        if ((store = this.this$0.getDelayedLegacyInAppStore$clevertap_core_release()) != null) ** GOTO lbl31
                        InAppDelayManager.access$getLogger$p(this.this$0).verbose(InAppDelayManager.access$getAccountId$p(this.this$0), "[InAppDelayManager]: DelayedLegacyInAppStore is null for callback id: " + this.$id);
                        this.$callback.invoke((Object)new DelayedInAppResult.Error(DelayedInAppResult.Error.ErrorReason.STORE_NOT_INITIALIZED, this.$id, null, 4, null));
                        var6_6 = Unit.INSTANCE;
                        InAppDelayManager.access$getActiveJobs$p(this.this$0).remove(this.$id);
                        return var6_6;
lbl31:
                        // 1 sources

                        try {
                            delayedInAppJSONObj = store.getDelayedInApp(this.$id);
                            result = delayedInAppJSONObj != null ? (DelayedInAppResult)new DelayedInAppResult.Success(delayedInAppJSONObj, this.$id) : (DelayedInAppResult)new DelayedInAppResult.Error(DelayedInAppResult.Error.ErrorReason.NOT_FOUND_IN_DB, this.$id, null, 4, null);
                            this.$callback.invoke((Object)result);
                            InAppDelayManager.access$getCancelledJobs$p(this.this$0).remove(this.$id);
                            store.removeDelayedInApp(this.$id);
                        }
                        catch (CancellationException delayedInAppJSONObj) {
                            InAppDelayManager.access$getLogger$p(this.this$0).verbose(InAppDelayManager.access$getAccountId$p(this.this$0), "[InAppDelayManager]: Cancelled InApp callback with id: " + this.$id);
                            InAppDelayManager.access$getCancelledJobs$p(this.this$0).putIfAbsent(this.$id, new CancelledJobData(this.$delayInMs, scheduledAt, this.$callback));
                            CoroutineScopeKt.ensureActive((CoroutineScope)$this$launch);
                        }
                        catch (Exception e) {
                            InAppDelayManager.access$getLogger$p(this.this$0).verbose(InAppDelayManager.access$getAccountId$p(this.this$0), "[InAppDelayManager]: Error in InApp callback with id: " + this.$id, e);
                            this.$callback.invoke((Object)new DelayedInAppResult.Error(DelayedInAppResult.Error.ErrorReason.UNKNOWN, this.$id, e));
                            InAppDelayManager.access$getCancelledJobs$p(this.this$0).remove(this.$id);
                            v1 = this.this$0.getDelayedLegacyInAppStore$clevertap_core_release();
                            Intrinsics.checkNotNull((Object)v1);
                            v1.removeDelayedInApp(this.$id);
                            {
                                catch (Throwable var6_10) {
                                    throw var6_10;
                                }
                            }
                        }
                        InAppDelayManager.access$getActiveJobs$p(this.this$0).remove(this.$id);
                        ** GOTO lbl68
                    }
                    {
                        finally {
                            InAppDelayManager.access$getActiveJobs$p(this.this$0).remove(this.$id);
                        }
                    }
lbl68:
                    // 3 sources

                    return Unit.INSTANCE;
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        ((Map)this.activeJobs).put(id2, job3);
        this.logger.verbose(this.accountId, "[InAppDelayManager]: Scheduled new InApp callback with id '" + id2 + "' for " + delayInMs + "ms delay");
        return job3;
    }

    public final void scheduleDelayedInApps$clevertap_core_release(@NotNull JSONArray delayedInApps, @NotNull Function1<? super DelayedInAppResult, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)delayedInApps, (String)"delayedInApps");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.logger.verbose(this.accountId, "[InAppDelayManager]: Scheduling " + delayedInApps.length() + " delayed in-apps");
        if (this.delayedLegacyInAppStore == null) {
            this.logger.verbose(this.accountId, "[InAppDelayManager]: DelayedLegacyInAppStore is null, aborting scheduling");
            return;
        }
        JSONArray newDelayedInAppsToSchedule = JsonUtilsKt.filterObjects(delayedInApps, (Function1<? super JSONObject, Boolean>)((Function1)arg_0 -> InAppDelayManager.scheduleDelayedInApps$lambda$1(this, arg_0)));
        DelayedLegacyInAppStore delayedLegacyInAppStore = this.delayedLegacyInAppStore;
        Intrinsics.checkNotNull((Object)delayedLegacyInAppStore);
        boolean saveSuccess = delayedLegacyInAppStore.saveDelayedInAppsBatch(newDelayedInAppsToSchedule);
        if (!saveSuccess) {
            JSONArray $this$iterator$iv = newDelayedInAppsToSchedule;
            boolean $i$f$iterator = false;
            int n = $this$iterator$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                Object element$iv = $this$iterator$iv.get(index$iv);
                if (!(element$iv instanceof JSONObject)) continue;
                JSONObject it = (JSONObject)element$iv;
                boolean bl = false;
                String inAppId = it.optString("ti");
                Intrinsics.checkNotNull((Object)inAppId);
                callback.invoke((Object)new DelayedInAppResult.Error(DelayedInAppResult.Error.ErrorReason.DB_SAVE_FAILED, inAppId, null, 4, null));
            }
            return;
        }
        JSONArray $this$iterator$iv = newDelayedInAppsToSchedule;
        boolean $i$f$iterator = false;
        int n = $this$iterator$iv.length();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            Object element$iv = $this$iterator$iv.get(index$iv);
            if (!(element$iv instanceof JSONObject)) continue;
            JSONObject it = (JSONObject)element$iv;
            boolean bl = false;
            String inAppId = it.optString("ti");
            long delayInMilliSeconds = this.getInAppDelayInMs(it);
            if (delayInMilliSeconds <= 0L) continue;
            Intrinsics.checkNotNull((Object)inAppId);
            this.scheduleInAppCallbackWithDispatcher(inAppId, delayInMilliSeconds, callback);
        }
    }

    @Nullable
    public final Object onAppBackground(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.cancelAllCallbacks($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final void onAppForeground() {
        this.logger.verbose(this.accountId, "[InAppDelayManager]: App coming to foreground, checking for pending in-apps");
        if (this.delayedLegacyInAppStore == null) {
            this.logger.verbose(this.accountId, "[InAppDelayManager]: DelayedLegacyInAppStore is null, aborting foreground handling");
            return;
        }
        if (this.cancelledJobs.isEmpty()) {
            this.logger.verbose(this.accountId, "[InAppDelayManager]: No pending delayed in-apps found");
            return;
        }
        this.logger.verbose(this.accountId, "[InAppDelayManager]: Found " + this.cancelledJobs.size() + " pending delayed in-apps");
        long currentTime = this.clock.currentTimeMillis();
        List toReschedule = new ArrayList();
        List toDiscard = new ArrayList();
        Map $this$forEach$iv = this.cancelledJobs;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object object = element$iv = iterator.next();
            boolean bl = false;
            String inAppId = (String)object.getKey();
            CancelledJobData jobData = (CancelledJobData)object.getValue();
            long originalDelayInMs = jobData.getOriginalDelayInMs();
            long scheduledAt = jobData.getScheduledAt();
            Function1<DelayedInAppResult, Unit> callback = jobData.getCallback();
            long elapsedTimeMs = currentTime - scheduledAt;
            long remainingTimeInMs = originalDelayInMs - elapsedTimeMs;
            this.logger.verbose(this.accountId, "[InAppDelayManager]: InApp " + inAppId + " - Original delay: " + originalDelayInMs + "ms, Elapsed: " + elapsedTimeMs + "ms, Remaining: " + remainingTimeInMs + "ms");
            boolean bl2 = remainingTimeInMs > 0L ? toReschedule.add(new RescheduleData(inAppId, remainingTimeInMs, callback)) : toDiscard.add(inAppId);
        }
        int rescheduledCount = 0;
        Iterable $this$forEach$iv2 = toReschedule;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            RescheduleData data = (RescheduleData)element$iv;
            boolean bl = false;
            this.scheduleInAppCallbackWithDispatcher(data.getInAppId(), data.getRemainingTimeInMs(), data.getCallback());
            ++rescheduledCount;
            this.logger.verbose(this.accountId, "[InAppDelayManager]: Rescheduled " + data.getInAppId() + " with " + data.getRemainingTimeInMs() + "ms remaining");
        }
        int discardedCount = 0;
        Iterable $this$forEach$iv3 = toDiscard;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv3) {
            String inAppId = (String)element$iv;
            boolean bl = false;
            DelayedLegacyInAppStore delayedLegacyInAppStore = this.delayedLegacyInAppStore;
            Intrinsics.checkNotNull((Object)delayedLegacyInAppStore);
            delayedLegacyInAppStore.removeDelayedInApp(inAppId);
            this.cancelledJobs.remove(inAppId);
            ++discardedCount;
            this.logger.verbose(this.accountId, "[InAppDelayManager]: Discarded expired in-app " + inAppId);
        }
        this.logger.verbose(this.accountId, "[InAppDelayManager]: Foreground handling complete - Rescheduled: " + rescheduledCount + ", Discarded: " + discardedCount);
    }

    public final boolean cancelCallback$clevertap_core_release(@NotNull String id2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Job job2 = this.activeJobs.get(id2);
        if (job2 != null) {
            Job job3 = job2;
            boolean bl2 = false;
            Job.DefaultImpls.cancel$default((Job)job3, null, (int)1, null);
            this.activeJobs.remove(id2);
            this.logger.verbose(this.accountId, "Cancelled InApp callback with id: " + id2);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    private final Object cancelAllCallbacks(Continuation<? super Unit> $completion) {
        if (!($completion instanceof cancelAllCallbacks.1)) ** GOTO lbl-1000
        var11_2 = $completion;
        if ((var11_2.label & -2147483648) != 0) {
            var11_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ InAppDelayManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return InAppDelayManager.access$cancelAllCallbacks(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                cancelledCount = this.activeJobs.size();
                v0 = this.activeJobs.values();
                Intrinsics.checkNotNullExpressionValue(v0, (String)"<get-values>(...)");
                jobsToCancel = CollectionsKt.toList((Iterable)v0);
                $this$forEach$iv = jobsToCancel;
                $i$f$forEach = false;
                var6_9 = $this$forEach$iv.iterator();
lbl19:
                // 3 sources

                while (var6_9.hasNext()) {
                    element$iv = var6_9.next();
                    it = (Job)element$iv;
                    $i$a$-forEach-InAppDelayManager$cancelAllCallbacks$2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    $continuation.L$0 = this;
                    $continuation.L$1 = var6_9;
                    $continuation.I$0 = cancelledCount;
                    $continuation.label = 1;
                    v1 = JobKt.cancelAndJoin((Job)it, (Continuation)$continuation);
                    if (v1 != var12_4) continue;
                    return var12_4;
                }
                break;
            }
            case 1: {
                $i$f$forEach = false;
                $i$a$-forEach-InAppDelayManager$cancelAllCallbacks$2 = false;
                cancelledCount = $continuation.I$0;
                var6_9 = (Iterator<T>)$continuation.L$1;
                this = (InAppDelayManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
                ** GOTO lbl19
            }
        }
        this.logger.verbose(this.accountId, "[InAppDelayManager]: Cancelled " + cancelledCount + " InApp callbacks");
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final int getActiveCallbackCount$clevertap_core_release() {
        return this.activeJobs.size();
    }

    public final int getCancelledJobsCount$clevertap_core_release() {
        return this.cancelledJobs.size();
    }

    public final boolean isCallbackScheduled$clevertap_core_release(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Job job2 = this.activeJobs.get(id2);
        return job2 != null ? job2.isActive() : false;
    }

    @NotNull
    public final Set<String> getActiveCallbackIds$clevertap_core_release() {
        Map $this$filterValues$iv = this.activeJobs;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            Job it = (Job)entry$iv.getValue();
            boolean bl = false;
            if (!it.isActive()) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return CollectionsKt.toSet((Iterable)((Map)result$iv).keySet());
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object cleanup$clevertap_core_release(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof cleanup.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ InAppDelayManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.cleanup$clevertap_core_release((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.cancelAllCallbacks((Continuation<? super Unit>)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (InAppDelayManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                CoroutineScopeKt.cancel$default((CoroutineScope)this.scope, null, (int)1, null);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final long getInAppDelayInMs(JSONObject inApp) {
        int delaySeconds = inApp.optInt("delayAfterTrigger", 0);
        return (1 <= delaySeconds ? delaySeconds < 1201 : false) ? Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)delaySeconds, (DurationUnit)DurationUnit.SECONDS)) : 0L;
    }

    private final void logCoroutineInfo(String msg) {
        this.logger.verbose(this.accountId, "[InAppDelayManager]: Running on: [" + Thread.currentThread().getName() + "] | " + msg);
    }

    private static final boolean scheduleDelayedInApps$lambda$1(InAppDelayManager this$0, JSONObject jsonObject) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        String inAppId = jsonObject.optString("ti");
        Intrinsics.checkNotNull((Object)inAppId);
        return !StringsKt.isBlank((CharSequence)inAppId) && this$0.activeJobs.get(inAppId) == null;
    }

    public static final /* synthetic */ Clock access$getClock$p(InAppDelayManager $this) {
        return $this.clock;
    }

    public static final /* synthetic */ Logger access$getLogger$p(InAppDelayManager $this) {
        return $this.logger;
    }

    public static final /* synthetic */ String access$getAccountId$p(InAppDelayManager $this) {
        return $this.accountId;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getCancelledJobs$p(InAppDelayManager $this) {
        return $this.cancelledJobs;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getActiveJobs$p(InAppDelayManager $this) {
        return $this.activeJobs;
    }

    public static final /* synthetic */ Object access$cancelAllCallbacks(InAppDelayManager $this, Continuation $completion) {
        return $this.cancelAllCallbacks((Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u00c6\u0003J3\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/clevertap/android/sdk/inapp/delay/InAppDelayManager$CancelledJobData;", "", "originalDelayInMs", "", "scheduledAt", "callback", "Lkotlin/Function1;", "Lcom/clevertap/android/sdk/inapp/delay/DelayedInAppResult;", "", "<init>", "(JJLkotlin/jvm/functions/Function1;)V", "getOriginalDelayInMs", "()J", "getScheduledAt", "getCallback", "()Lkotlin/jvm/functions/Function1;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "clevertap-core_release"})
    private static final class CancelledJobData {
        private final long originalDelayInMs;
        private final long scheduledAt;
        @NotNull
        private final Function1<DelayedInAppResult, Unit> callback;

        public CancelledJobData(long originalDelayInMs, long scheduledAt, @NotNull Function1<? super DelayedInAppResult, Unit> callback) {
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            this.originalDelayInMs = originalDelayInMs;
            this.scheduledAt = scheduledAt;
            this.callback = callback;
        }

        public final long getOriginalDelayInMs() {
            return this.originalDelayInMs;
        }

        public final long getScheduledAt() {
            return this.scheduledAt;
        }

        @NotNull
        public final Function1<DelayedInAppResult, Unit> getCallback() {
            return this.callback;
        }

        public final long component1() {
            return this.originalDelayInMs;
        }

        public final long component2() {
            return this.scheduledAt;
        }

        @NotNull
        public final Function1<DelayedInAppResult, Unit> component3() {
            return this.callback;
        }

        @NotNull
        public final CancelledJobData copy(long originalDelayInMs, long scheduledAt, @NotNull Function1<? super DelayedInAppResult, Unit> callback) {
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            return new CancelledJobData(originalDelayInMs, scheduledAt, callback);
        }

        public static /* synthetic */ CancelledJobData copy$default(CancelledJobData cancelledJobData, long l, long l2, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                l = cancelledJobData.originalDelayInMs;
            }
            if ((n & 2) != 0) {
                l2 = cancelledJobData.scheduledAt;
            }
            if ((n & 4) != 0) {
                function1 = cancelledJobData.callback;
            }
            return cancelledJobData.copy(l, l2, function1);
        }

        @NotNull
        public String toString() {
            return "CancelledJobData(originalDelayInMs=" + this.originalDelayInMs + ", scheduledAt=" + this.scheduledAt + ", callback=" + this.callback + ')';
        }

        public int hashCode() {
            int result = Long.hashCode(this.originalDelayInMs);
            result = result * 31 + Long.hashCode(this.scheduledAt);
            result = result * 31 + this.callback.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CancelledJobData)) {
                return false;
            }
            CancelledJobData cancelledJobData = (CancelledJobData)other;
            if (this.originalDelayInMs != cancelledJobData.originalDelayInMs) {
                return false;
            }
            if (this.scheduledAt != cancelledJobData.scheduledAt) {
                return false;
            }
            return Intrinsics.areEqual(this.callback, cancelledJobData.callback);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/clevertap/android/sdk/inapp/delay/InAppDelayManager$Companion;", "", "<init>", "()V", "PARALLEL_SCHEDULERS", "", "TAG", "", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u00c6\u0003J3\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lcom/clevertap/android/sdk/inapp/delay/InAppDelayManager$RescheduleData;", "", "inAppId", "", "remainingTimeInMs", "", "callback", "Lkotlin/Function1;", "Lcom/clevertap/android/sdk/inapp/delay/DelayedInAppResult;", "", "<init>", "(Ljava/lang/String;JLkotlin/jvm/functions/Function1;)V", "getInAppId", "()Ljava/lang/String;", "getRemainingTimeInMs", "()J", "getCallback", "()Lkotlin/jvm/functions/Function1;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "clevertap-core_release"})
    private static final class RescheduleData {
        @NotNull
        private final String inAppId;
        private final long remainingTimeInMs;
        @NotNull
        private final Function1<DelayedInAppResult, Unit> callback;

        public RescheduleData(@NotNull String inAppId, long remainingTimeInMs, @NotNull Function1<? super DelayedInAppResult, Unit> callback) {
            Intrinsics.checkNotNullParameter((Object)inAppId, (String)"inAppId");
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            this.inAppId = inAppId;
            this.remainingTimeInMs = remainingTimeInMs;
            this.callback = callback;
        }

        @NotNull
        public final String getInAppId() {
            return this.inAppId;
        }

        public final long getRemainingTimeInMs() {
            return this.remainingTimeInMs;
        }

        @NotNull
        public final Function1<DelayedInAppResult, Unit> getCallback() {
            return this.callback;
        }

        @NotNull
        public final String component1() {
            return this.inAppId;
        }

        public final long component2() {
            return this.remainingTimeInMs;
        }

        @NotNull
        public final Function1<DelayedInAppResult, Unit> component3() {
            return this.callback;
        }

        @NotNull
        public final RescheduleData copy(@NotNull String inAppId, long remainingTimeInMs, @NotNull Function1<? super DelayedInAppResult, Unit> callback) {
            Intrinsics.checkNotNullParameter((Object)inAppId, (String)"inAppId");
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            return new RescheduleData(inAppId, remainingTimeInMs, callback);
        }

        public static /* synthetic */ RescheduleData copy$default(RescheduleData rescheduleData, String string2, long l, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = rescheduleData.inAppId;
            }
            if ((n & 2) != 0) {
                l = rescheduleData.remainingTimeInMs;
            }
            if ((n & 4) != 0) {
                function1 = rescheduleData.callback;
            }
            return rescheduleData.copy(string2, l, function1);
        }

        @NotNull
        public String toString() {
            return "RescheduleData(inAppId=" + this.inAppId + ", remainingTimeInMs=" + this.remainingTimeInMs + ", callback=" + this.callback + ')';
        }

        public int hashCode() {
            int result = this.inAppId.hashCode();
            result = result * 31 + Long.hashCode(this.remainingTimeInMs);
            result = result * 31 + this.callback.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RescheduleData)) {
                return false;
            }
            RescheduleData rescheduleData = (RescheduleData)other;
            if (!Intrinsics.areEqual((Object)this.inAppId, (Object)rescheduleData.inAppId)) {
                return false;
            }
            if (this.remainingTimeInMs != rescheduleData.remainingTimeInMs) {
                return false;
            }
            return Intrinsics.areEqual(this.callback, rescheduleData.callback);
        }
    }
}

