/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Insets;
import android.graphics.Point;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.WindowMetrics;
import android.webkit.WebSettings;
import android.webkit.WebView;
import androidx.annotation.Px;
import androidx.annotation.RequiresApi;
import com.clevertap.android.sdk.CTWebInterface;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 '2\u00020\u0001:\u0001'B9\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fB1\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000b\u0010\rJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0014J\u0006\u0010\u0019\u001a\u00020\u0016J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0003J\b\u0010\u001c\u001a\u00020\u0005H\u0003J\b\u0010\u001d\u001a\u00020\u0005H\u0003J\b\u0010\u001e\u001a\u00020\u0005H\u0003J\b\u0010\u001f\u001a\u00020\u0005H\u0003J\b\u0010 \u001a\u00020\u0005H\u0003J\b\u0010!\u001a\u00020\u0005H\u0003J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$H\u0007J\u000e\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006("}, d2={"Lcom/clevertap/android/sdk/inapp/CTInAppWebView;", "Landroid/webkit/WebView;", "context", "Landroid/content/Context;", "widthDp", "", "heightDp", "widthPercentage", "heightPercentage", "aspectRatio", "", "<init>", "(Landroid/content/Context;IIIID)V", "(Landroid/content/Context;IIII)V", "dim", "Landroid/graphics/Point;", "isFullscreen", "", "()Z", "setFullscreen", "(Z)V", "onMeasure", "", "widthMeasureSpec", "heightMeasureSpec", "updateDimension", "dpToPx", "dp", "calculatePercentageWidth", "calculatePercentageHeight", "calculateWidthWithWindowMetrics", "calculateHeightWithWindowMetrics", "calculateWidthWithDisplayMetrics", "calculateHeightWithDisplayMetrics", "setJavaScriptInterface", "webInterface", "Lcom/clevertap/android/sdk/CTWebInterface;", "cleanup", "isJsEnabled", "Companion", "clevertap-core_release"})
@SuppressLint(value={"ViewConstructor"})
public final class CTInAppWebView
extends WebView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    private final int widthDp;
    private final int heightDp;
    private final int widthPercentage;
    private final int heightPercentage;
    private final double aspectRatio;
    @JvmField
    @NotNull
    public final Point dim;
    private boolean isFullscreen;
    @NotNull
    private static final String JAVASCRIPT_INTERFACE_NAME = "CleverTap";
    private static final double DEFAULT_ASPECT_RATIO = -1.0;

    @SuppressLint(value={"ResourceType"})
    public CTInAppWebView(@NotNull Context context, int widthDp, int heightDp, int widthPercentage, int heightPercentage, double aspectRatio) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.context = context;
        this.widthDp = widthDp;
        this.heightDp = heightDp;
        this.widthPercentage = widthPercentage;
        this.heightPercentage = heightPercentage;
        this.aspectRatio = aspectRatio;
        this.dim = new Point();
        this.setHorizontalScrollBarEnabled(false);
        this.setVerticalScrollBarEnabled(false);
        this.setHorizontalFadingEdgeEnabled(false);
        this.setVerticalFadingEdgeEnabled(false);
        this.setOverScrollMode(2);
        this.setBackgroundColor(0);
        this.getSettings().setTextZoom(100);
        this.setId(188293);
    }

    public final boolean isFullscreen() {
        return this.isFullscreen;
    }

    public final void setFullscreen(boolean bl) {
        this.isFullscreen = bl;
    }

    @SuppressLint(value={"ResourceType"})
    public CTInAppWebView(@NotNull Context context, int widthDp, int heightDp, int widthPercentage, int heightPercentage) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, widthDp, heightDp, widthPercentage, heightPercentage, -1.0);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.updateDimension();
        this.setMeasuredDimension(this.dim.x, this.dim.y);
    }

    public final void updateDimension() {
        int width;
        int n = width = this.widthDp > 0 ? this.dpToPx(this.widthDp) : this.calculatePercentageWidth();
        int height = this.heightDp > 0 ? this.dpToPx(this.heightDp) : (!(this.aspectRatio == -1.0) && this.aspectRatio > 0.0 ? (int)((double)width / this.aspectRatio) : this.calculatePercentageHeight());
        this.dim.x = width;
        this.dim.y = height;
    }

    @Px
    private final int dpToPx(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    @Px
    private final int calculatePercentageWidth() {
        if (Build.VERSION.SDK_INT >= 30) {
            return this.calculateWidthWithWindowMetrics();
        }
        return this.calculateWidthWithDisplayMetrics();
    }

    @Px
    private final int calculatePercentageHeight() {
        if (Build.VERSION.SDK_INT >= 30) {
            return this.calculateHeightWithWindowMetrics();
        }
        return this.calculateHeightWithDisplayMetrics();
    }

    @RequiresApi(api=30)
    @Px
    private final int calculateWidthWithWindowMetrics() {
        int n;
        Object object = this.context.getSystemService("window");
        WindowManager windowManager = object instanceof WindowManager ? (WindowManager)object : null;
        if (windowManager == null) {
            return this.calculateWidthWithDisplayMetrics();
        }
        WindowManager windowManager2 = windowManager;
        WindowMetrics windowMetrics = windowManager2.getCurrentWindowMetrics();
        Intrinsics.checkNotNullExpressionValue((Object)windowMetrics, (String)"getCurrentWindowMetrics(...)");
        WindowMetrics metrics = windowMetrics;
        if (this.isFullscreen) {
            n = metrics.getBounds().width();
        } else {
            Insets insets = metrics.getWindowInsets().getInsetsIgnoringVisibility(WindowInsets.Type.systemBars() | WindowInsets.Type.displayCutout());
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getInsetsIgnoringVisibility(...)");
            Insets insets2 = insets;
            n = metrics.getBounds().width() - insets2.left - insets2.right;
        }
        int availableWidth = n;
        return (int)((float)(availableWidth * this.widthPercentage) / 100.0f);
    }

    @RequiresApi(api=30)
    @Px
    private final int calculateHeightWithWindowMetrics() {
        int n;
        Object object = this.context.getSystemService("window");
        WindowManager windowManager = object instanceof WindowManager ? (WindowManager)object : null;
        if (windowManager == null) {
            return this.calculateHeightWithDisplayMetrics();
        }
        WindowManager windowManager2 = windowManager;
        WindowMetrics windowMetrics = windowManager2.getCurrentWindowMetrics();
        Intrinsics.checkNotNullExpressionValue((Object)windowMetrics, (String)"getCurrentWindowMetrics(...)");
        WindowMetrics metrics = windowMetrics;
        if (this.isFullscreen) {
            n = metrics.getBounds().height();
        } else {
            Insets insets = metrics.getWindowInsets().getInsetsIgnoringVisibility(WindowInsets.Type.systemBars() | WindowInsets.Type.displayCutout());
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getInsetsIgnoringVisibility(...)");
            Insets insets2 = insets;
            n = metrics.getBounds().height() - insets2.top - insets2.bottom;
        }
        int availableHeight = n;
        return (int)((float)(availableHeight * this.heightPercentage) / 100.0f);
    }

    @Px
    private final int calculateWidthWithDisplayMetrics() {
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        return (int)((float)(metrics.widthPixels * this.widthPercentage) / 100.0f);
    }

    @Px
    private final int calculateHeightWithDisplayMetrics() {
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        return (int)((float)(metrics.heightPixels * this.heightPercentage) / 100.0f);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public final void setJavaScriptInterface(@NotNull CTWebInterface webInterface) {
        WebSettings webSettings;
        Intrinsics.checkNotNullParameter((Object)webInterface, (String)"webInterface");
        WebSettings $this$setJavaScriptInterface_u24lambda_u240 = webSettings = this.getSettings();
        boolean bl = false;
        $this$setJavaScriptInterface_u24lambda_u240.setJavaScriptEnabled(true);
        $this$setJavaScriptInterface_u24lambda_u240.setJavaScriptCanOpenWindowsAutomatically(false);
        $this$setJavaScriptInterface_u24lambda_u240.setAllowContentAccess(false);
        $this$setJavaScriptInterface_u24lambda_u240.setAllowFileAccess(false);
        $this$setJavaScriptInterface_u24lambda_u240.setAllowFileAccessFromFileURLs(false);
        this.addJavascriptInterface(webInterface, JAVASCRIPT_INTERFACE_NAME);
    }

    public final void cleanup(boolean isJsEnabled) {
        this.removeAllViews();
        this.destroyDrawingCache();
        this.loadUrl("about:blank");
        if (isJsEnabled) {
            this.removeJavascriptInterface(JAVASCRIPT_INTERFACE_NAME);
        }
        this.clearHistory();
        this.destroy();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/clevertap/android/sdk/inapp/CTInAppWebView$Companion;", "", "<init>", "()V", "JAVASCRIPT_INTERFACE_NAME", "", "DEFAULT_ASPECT_RATIO", "", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

