/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.db.dao;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.ILogger;
import com.clevertap.android.sdk.db.DBEncryptionHandler;
import com.clevertap.android.sdk.db.DatabaseHelper;
import com.clevertap.android.sdk.db.Table;
import com.clevertap.android.sdk.db.dao.UserProfileDAO;
import java.io.Closeable;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u001c\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\u00122\u0006\u0010\f\u001a\u00020\rH\u0017J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/clevertap/android/sdk/db/dao/UserProfileDAOImpl;", "Lcom/clevertap/android/sdk/db/dao/UserProfileDAO;", "dbHelper", "Lcom/clevertap/android/sdk/db/DatabaseHelper;", "logger", "Lcom/clevertap/android/sdk/ILogger;", "dbEncryptionHandler", "Lcom/clevertap/android/sdk/db/DBEncryptionHandler;", "<init>", "(Lcom/clevertap/android/sdk/db/DatabaseHelper;Lcom/clevertap/android/sdk/ILogger;Lcom/clevertap/android/sdk/db/DBEncryptionHandler;)V", "storeUserProfile", "", "accountId", "", "deviceId", "profile", "Lorg/json/JSONObject;", "fetchUserProfilesByAccountId", "", "fetchUserProfile", "clevertap-core_release"})
public final class UserProfileDAOImpl
implements UserProfileDAO {
    @NotNull
    private final DatabaseHelper dbHelper;
    @NotNull
    private final ILogger logger;
    @NotNull
    private final DBEncryptionHandler dbEncryptionHandler;

    public UserProfileDAOImpl(@NotNull DatabaseHelper dbHelper, @NotNull ILogger logger, @NotNull DBEncryptionHandler dbEncryptionHandler) {
        Intrinsics.checkNotNullParameter((Object)((Object)dbHelper), (String)"dbHelper");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)dbEncryptionHandler, (String)"dbEncryptionHandler");
        this.dbHelper = dbHelper;
        this.logger = logger;
        this.dbEncryptionHandler = dbEncryptionHandler;
    }

    @Override
    @WorkerThread
    public long storeUserProfile(@NotNull String accountId, @NotNull String deviceId, @NotNull JSONObject profile) {
        long l;
        ContentValues contentValues;
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        if (!this.dbHelper.belowMemThreshold()) {
            this.logger.verbose("There is not enough space left on the device to store data, data discarded");
            return -2L;
        }
        String tableName = Table.USER_PROFILES.getTableName();
        this.logger.verbose("Inserting or updating userProfile for accountID = " + accountId + " + deviceID = " + deviceId);
        ContentValues $this$storeUserProfile_u24lambda_u240 = contentValues = new ContentValues();
        boolean bl = false;
        String string2 = profile.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String encryptedProfile = this.dbEncryptionHandler.wrapDbData(string2);
        $this$storeUserProfile_u24lambda_u240.put("data", encryptedProfile);
        $this$storeUserProfile_u24lambda_u240.put("_id", accountId);
        $this$storeUserProfile_u24lambda_u240.put("deviceID", deviceId);
        ContentValues cv = contentValues;
        try {
            l = this.dbHelper.getWritableDatabase().insertWithOnConflict(tableName, null, cv, 5);
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error adding data to table " + tableName + ". Recreating DB", e);
            this.dbHelper.deleteDatabase();
            l = -1L;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    @NotNull
    public Map<String, JSONObject> fetchUserProfilesByAccountId(@NotNull String accountId) {
        Map profiles;
        block9: {
            Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
            profiles = new LinkedHashMap();
            String tName = Table.USER_PROFILES.getTableName();
            try {
                Object object = new String[]{accountId};
                Cursor cursor = this.dbHelper.getReadableDatabase().query(tName, null, "_id = ?", object, null, null, null);
                if (cursor == null) break block9;
                object = (Closeable)cursor;
                Throwable throwable = null;
                try {
                    Cursor cursor2 = (Cursor)object;
                    boolean bl = false;
                    int dataIndex = cursor2.getColumnIndex("data");
                    int deviceIdIndex = cursor2.getColumnIndex("deviceID");
                    while (cursor2.moveToNext()) {
                        String profileString = cursor2.getString(dataIndex);
                        String deviceIdString = cursor2.getString(deviceIdIndex);
                        String decryptedProfile = this.dbEncryptionHandler.unwrapDbData(profileString);
                        if (decryptedProfile != null) {
                            JSONObject jsonObject = new JSONObject(decryptedProfile);
                            profiles.put(deviceIdString, jsonObject);
                            continue;
                        }
                        this.logger.verbose("Error decrypting JSON for profile");
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            catch (SQLiteException e) {
                this.logger.verbose("Could not fetch records out of database " + tName + '.', e);
            }
        }
        return profiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    @Nullable
    public JSONObject fetchUserProfile(@NotNull String accountId, @NotNull String deviceId) {
        JSONObject op;
        block12: {
            Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
            Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
            String tName = Table.USER_PROFILES.getTableName();
            op = null;
            try {
                Object object = new String[]{accountId, deviceId};
                Cursor cursor = this.dbHelper.getReadableDatabase().query(tName, null, "_id = ? AND deviceID = ?", object, null, null, null);
                if (cursor == null) break block12;
                object = (Closeable)cursor;
                Throwable throwable = null;
                try {
                    Cursor cursor2 = (Cursor)object;
                    boolean bl = false;
                    if (cursor2.moveToFirst()) {
                        int dataIndex = cursor2.getColumnIndex("data");
                        if (dataIndex >= 0) {
                            String profileString = cursor2.getString(dataIndex);
                            String decryptedProfile = this.dbEncryptionHandler.unwrapDbData(profileString);
                            if (decryptedProfile != null) {
                                op = new JSONObject(decryptedProfile);
                            } else {
                                this.logger.verbose("Failed profile decryption");
                            }
                        }
                    } else {
                        this.logger.verbose("There was no profile found in DB");
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            catch (SQLiteException e) {
                this.logger.verbose("Could not fetch records out of database " + tName + '.', e);
            }
        }
        return op;
    }
}

