/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.db.dao;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.ILogger;
import com.clevertap.android.sdk.db.DatabaseHelper;
import com.clevertap.android.sdk.db.Table;
import com.clevertap.android.sdk.db.dao.UninstallTimestampDAO;
import com.clevertap.android.sdk.utils.Clock;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0017J\b\u0010\f\u001a\u00020\rH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/clevertap/android/sdk/db/dao/UninstallTimestampDAOImpl;", "Lcom/clevertap/android/sdk/db/dao/UninstallTimestampDAO;", "dbHelper", "Lcom/clevertap/android/sdk/db/DatabaseHelper;", "logger", "Lcom/clevertap/android/sdk/ILogger;", "clock", "Lcom/clevertap/android/sdk/utils/Clock;", "<init>", "(Lcom/clevertap/android/sdk/db/DatabaseHelper;Lcom/clevertap/android/sdk/ILogger;Lcom/clevertap/android/sdk/utils/Clock;)V", "storeUninstallTimestamp", "", "getLastUninstallTimestamp", "", "clevertap-core_release"})
public final class UninstallTimestampDAOImpl
implements UninstallTimestampDAO {
    @NotNull
    private final DatabaseHelper dbHelper;
    @NotNull
    private final ILogger logger;
    @NotNull
    private final Clock clock;

    public UninstallTimestampDAOImpl(@NotNull DatabaseHelper dbHelper, @NotNull ILogger logger, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)((Object)dbHelper), (String)"dbHelper");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.dbHelper = dbHelper;
        this.logger = logger;
        this.clock = clock;
    }

    public /* synthetic */ UninstallTimestampDAOImpl(DatabaseHelper databaseHelper, ILogger iLogger, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            clock = Clock.SYSTEM;
        }
        this(databaseHelper, iLogger, clock);
    }

    @Override
    @WorkerThread
    public void storeUninstallTimestamp() {
        ContentValues contentValues;
        if (!this.dbHelper.belowMemThreshold()) {
            this.logger.verbose("There is not enough space left on the device to store data, data discarded");
            return;
        }
        String tableName = Table.UNINSTALL_TS.getTableName();
        ContentValues $this$storeUninstallTimestamp_u24lambda_u240 = contentValues = new ContentValues();
        boolean bl = false;
        $this$storeUninstallTimestamp_u24lambda_u240.put("created_at", Long.valueOf(this.clock.currentTimeMillis()));
        ContentValues cv = contentValues;
        try {
            this.dbHelper.getWritableDatabase().insert(tableName, null, cv);
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error adding data to table " + tableName + ". Recreating DB", e);
            this.dbHelper.deleteDatabase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public long getLastUninstallTimestamp() {
        long timestamp;
        block8: {
            String tName = Table.UNINSTALL_TS.getTableName();
            timestamp = 0L;
            try {
                Cursor cursor = this.dbHelper.getReadableDatabase().query(tName, null, null, null, null, null, "created_at DESC", "1");
                if (cursor == null) break block8;
                Closeable closeable = (Closeable)cursor;
                Throwable throwable = null;
                try {
                    Cursor cursor2 = (Cursor)closeable;
                    boolean bl = false;
                    if (cursor2.moveToFirst()) {
                        timestamp = cursor2.getLong(cursor2.getColumnIndexOrThrow("created_at"));
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                this.logger.verbose("Could not fetch records out of database " + tName + '.', e);
            }
        }
        return timestamp;
    }
}

