/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.db.dao;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.ILogger;
import com.clevertap.android.sdk.db.DBEncryptionHandler;
import com.clevertap.android.sdk.db.DatabaseHelper;
import com.clevertap.android.sdk.db.Table;
import com.clevertap.android.sdk.db.dao.InboxMessageDAO;
import com.clevertap.android.sdk.inbox.CTMessageDAO;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ%\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\rj\b\u0012\u0004\u0012\u00020\f`\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u0014H\u0017J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u001e\u0010\u0018\u001a\u00020\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0018\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u001e\u0010\u001b\u001a\u00020\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/clevertap/android/sdk/db/dao/InboxMessageDAOImpl;", "Lcom/clevertap/android/sdk/db/dao/InboxMessageDAO;", "dbHelper", "Lcom/clevertap/android/sdk/db/DatabaseHelper;", "logger", "Lcom/clevertap/android/sdk/ILogger;", "dbEncryptionHandler", "Lcom/clevertap/android/sdk/db/DBEncryptionHandler;", "<init>", "(Lcom/clevertap/android/sdk/db/DatabaseHelper;Lcom/clevertap/android/sdk/ILogger;Lcom/clevertap/android/sdk/db/DBEncryptionHandler;)V", "getMessages", "Lkotlin/collections/ArrayList;", "Lcom/clevertap/android/sdk/inbox/CTMessageDAO;", "Ljava/util/ArrayList;", "userId", "", "(Ljava/lang/String;)Ljava/util/ArrayList;", "upsertMessages", "", "inboxMessages", "", "deleteMessage", "", "messageId", "deleteMessages", "messageIds", "markMessageAsRead", "markMessagesAsRead", "getTemplateMarkersList", "count", "", "clevertap-core_release"})
@SourceDebugExtension(value={"SMAP\nInboxMessageDAOImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InboxMessageDAOImpl.kt\ncom/clevertap/android/sdk/db/dao/InboxMessageDAOImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,195:1\n1#2:196\n37#3,2:197\n37#3,2:199\n*S KotlinDebug\n*F\n+ 1 InboxMessageDAOImpl.kt\ncom/clevertap/android/sdk/db/dao/InboxMessageDAOImpl\n*L\n133#1:197,2\n175#1:199,2\n*E\n"})
public final class InboxMessageDAOImpl
implements InboxMessageDAO {
    @NotNull
    private final DatabaseHelper dbHelper;
    @NotNull
    private final ILogger logger;
    @NotNull
    private final DBEncryptionHandler dbEncryptionHandler;

    public InboxMessageDAOImpl(@NotNull DatabaseHelper dbHelper, @NotNull ILogger logger, @NotNull DBEncryptionHandler dbEncryptionHandler) {
        Intrinsics.checkNotNullParameter((Object)((Object)dbHelper), (String)"dbHelper");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)dbEncryptionHandler, (String)"dbEncryptionHandler");
        this.dbHelper = dbHelper;
        this.logger = logger;
        this.dbEncryptionHandler = dbEncryptionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    @NotNull
    public ArrayList<CTMessageDAO> getMessages(@NotNull String userId) {
        ArrayList<CTMessageDAO> messageDAOArrayList;
        block9: {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            String tName = Table.INBOX_MESSAGES.getTableName();
            messageDAOArrayList = new ArrayList<CTMessageDAO>();
            try {
                Object object = new String[]{userId};
                Cursor cursor = this.dbHelper.getReadableDatabase().query(tName, null, "messageUser = ?", object, null, null, "created_at DESC");
                if (cursor == null) break block9;
                object = (Closeable)cursor;
                Throwable throwable = null;
                try {
                    Cursor cursor2 = (Cursor)object;
                    boolean bl = false;
                    int idColumnIndex = cursor2.getColumnIndexOrThrow("_id");
                    int dataColumnIndex = cursor2.getColumnIndexOrThrow("data");
                    int wzrkParamsColumnIndex = cursor2.getColumnIndexOrThrow("wzrkParams");
                    int createdAtColumnIndex = cursor2.getColumnIndexOrThrow("created_at");
                    int expiresColumnIndex = cursor2.getColumnIndexOrThrow("expires");
                    int isReadColumnIndex = cursor2.getColumnIndexOrThrow("isRead");
                    int userIdColumnIndex = cursor2.getColumnIndexOrThrow("messageUser");
                    int tagsColumnIndex = cursor2.getColumnIndexOrThrow("tags");
                    int campaignColumnIndex = cursor2.getColumnIndexOrThrow("campaignId");
                    while (cursor2.moveToNext()) {
                        CTMessageDAO cTMessageDAO;
                        String decryptedData = this.dbEncryptionHandler.unwrapDbData(cursor2.getString(dataColumnIndex));
                        if (decryptedData == null) {
                            this.logger.debug("There was some problem in loading inbox message from DB");
                            continue;
                        }
                        CTMessageDAO $this$getMessages_u24lambda_u241_u24lambda_u240 = cTMessageDAO = new CTMessageDAO();
                        boolean bl2 = false;
                        $this$getMessages_u24lambda_u241_u24lambda_u240.setId(cursor2.getString(idColumnIndex));
                        $this$getMessages_u24lambda_u241_u24lambda_u240.setJsonData(new JSONObject(decryptedData));
                        $this$getMessages_u24lambda_u241_u24lambda_u240.setWzrkParams(new JSONObject(cursor2.getString(wzrkParamsColumnIndex)));
                        $this$getMessages_u24lambda_u241_u24lambda_u240.setDate(cursor2.getLong(createdAtColumnIndex));
                        $this$getMessages_u24lambda_u241_u24lambda_u240.setExpires(cursor2.getLong(expiresColumnIndex));
                        $this$getMessages_u24lambda_u241_u24lambda_u240.setRead(cursor2.getInt(isReadColumnIndex));
                        $this$getMessages_u24lambda_u241_u24lambda_u240.setUserId(cursor2.getString(userIdColumnIndex));
                        $this$getMessages_u24lambda_u241_u24lambda_u240.setTags(cursor2.getString(tagsColumnIndex));
                        $this$getMessages_u24lambda_u241_u24lambda_u240.setCampaignId(cursor2.getString(campaignColumnIndex));
                        CTMessageDAO ctMessageDAO = cTMessageDAO;
                        messageDAOArrayList.add(ctMessageDAO);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                this.logger.verbose("Error retrieving records from " + tName, e);
            }
        }
        return messageDAOArrayList;
    }

    @Override
    @WorkerThread
    public void upsertMessages(@NotNull List<? extends CTMessageDAO> inboxMessages) {
        Intrinsics.checkNotNullParameter(inboxMessages, (String)"inboxMessages");
        if (!this.dbHelper.belowMemThreshold()) {
            this.logger.verbose("There is not enough space left on the device to store data, data discarded");
            return;
        }
        for (CTMessageDAO cTMessageDAO : inboxMessages) {
            Object object;
            ContentValues $this$upsertMessages_u24lambda_u242 = object = new ContentValues();
            boolean bl = false;
            $this$upsertMessages_u24lambda_u242.put("_id", cTMessageDAO.getId());
            String string2 = cTMessageDAO.getJsonData().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String encryptedData = this.dbEncryptionHandler.wrapDbData(string2);
            $this$upsertMessages_u24lambda_u242.put("data", encryptedData);
            $this$upsertMessages_u24lambda_u242.put("wzrkParams", cTMessageDAO.getWzrkParams().toString());
            $this$upsertMessages_u24lambda_u242.put("campaignId", cTMessageDAO.getCampaignId());
            $this$upsertMessages_u24lambda_u242.put("tags", cTMessageDAO.getTags());
            $this$upsertMessages_u24lambda_u242.put("isRead", Integer.valueOf(cTMessageDAO.isRead()));
            $this$upsertMessages_u24lambda_u242.put("expires", Long.valueOf(cTMessageDAO.getExpires()));
            $this$upsertMessages_u24lambda_u242.put("created_at", Long.valueOf(cTMessageDAO.getDate()));
            $this$upsertMessages_u24lambda_u242.put("messageUser", cTMessageDAO.getUserId());
            ContentValues cv = object;
            try {
                object = this.dbHelper.getWritableDatabase().insertWithOnConflict(Table.INBOX_MESSAGES.getTableName(), null, cv, 5);
            }
            catch (SQLiteException e) {
                this.logger.verbose("Error adding data to table " + Table.INBOX_MESSAGES.getTableName(), e);
                object = Unit.INSTANCE;
            }
        }
    }

    @Override
    @WorkerThread
    public boolean deleteMessage(@NotNull String messageId, @NotNull String userId) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        String tName = Table.INBOX_MESSAGES.getTableName();
        try {
            String[] stringArray = new String[]{messageId, userId};
            this.dbHelper.getWritableDatabase().delete(tName, "_id = ? AND messageUser = ?", stringArray);
            bl = true;
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error removing stale records from " + tName, e);
            bl = false;
        }
        return bl;
    }

    @Override
    @WorkerThread
    public boolean deleteMessages(@NotNull List<String> messageIds, @NotNull String userId) {
        boolean bl;
        List list;
        Intrinsics.checkNotNullParameter(messageIds, (String)"messageIds");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        if (messageIds.isEmpty()) {
            this.logger.verbose("messageIds list is empty, nothing to delete.");
            return true;
        }
        String tName = Table.INBOX_MESSAGES.getTableName();
        String idsTemplateGroup = this.getTemplateMarkersList(messageIds.size());
        List $this$deleteMessages_u24lambda_u243 = list = CollectionsKt.toMutableList((Collection)messageIds);
        boolean bl2 = false;
        $this$deleteMessages_u24lambda_u243.add(userId);
        List whereArgs = list;
        try {
            Collection $this$toTypedArray$iv = whereArgs;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            this.dbHelper.getWritableDatabase().delete(tName, "_id IN (" + idsTemplateGroup + ") AND messageUser = ?", thisCollection$iv.toArray(new String[0]));
            bl = true;
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error removing stale records from " + tName, e);
            bl = false;
        }
        return bl;
    }

    @Override
    @WorkerThread
    public boolean markMessageAsRead(@NotNull String messageId, @NotNull String userId) {
        boolean bl;
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        String tName = Table.INBOX_MESSAGES.getTableName();
        String[] $this$markMessageAsRead_u24lambda_u244 = stringArray = new ContentValues();
        boolean bl2 = false;
        $this$markMessageAsRead_u24lambda_u244.put("isRead", Integer.valueOf(1));
        String[] cv = stringArray;
        try {
            stringArray = new String[]{messageId, userId};
            this.dbHelper.getWritableDatabase().update(tName, (ContentValues)cv, "_id = ? AND messageUser = ?", stringArray);
            bl = true;
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error updating record in " + tName, e);
            bl = false;
        }
        return bl;
    }

    @Override
    @WorkerThread
    public boolean markMessagesAsRead(@NotNull List<String> messageIds, @NotNull String userId) {
        boolean bl;
        List list;
        Intrinsics.checkNotNullParameter(messageIds, (String)"messageIds");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        String tName = Table.INBOX_MESSAGES.getTableName();
        String idsTemplateGroup = this.getTemplateMarkersList(messageIds.size());
        List $this$markMessagesAsRead_u24lambda_u245 = list = CollectionsKt.toMutableList((Collection)messageIds);
        boolean bl2 = false;
        $this$markMessagesAsRead_u24lambda_u245.add(userId);
        List whereArgs = list;
        List $this$markMessagesAsRead_u24lambda_u246 = $this$markMessagesAsRead_u24lambda_u245 = new ContentValues();
        boolean bl3 = false;
        $this$markMessagesAsRead_u24lambda_u246.put("isRead", 1);
        List cv = $this$markMessagesAsRead_u24lambda_u245;
        try {
            Collection $this$toTypedArray$iv = whereArgs;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            this.dbHelper.getWritableDatabase().update(tName, (ContentValues)cv, "_id IN (" + idsTemplateGroup + ") AND messageUser = ?", thisCollection$iv.toArray(new String[0]));
            bl = true;
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error updating records in " + tName, e);
            bl = false;
        }
        return bl;
    }

    private final String getTemplateMarkersList(int count) {
        StringBuilder stringBuilder;
        StringBuilder $this$getTemplateMarkersList_u24lambda_u248 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (count > 0) {
            $this$getTemplateMarkersList_u24lambda_u248.append("?");
            int n = count - 1;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl2 = false;
                $this$getTemplateMarkersList_u24lambda_u248.append(", ?");
            }
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }
}

