/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.response;

import android.content.Context;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.ControllerManager;
import com.clevertap.android.sdk.CoreMetaData;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.inapp.InAppController;
import com.clevertap.android.sdk.inapp.TriggerManager;
import com.clevertap.android.sdk.inapp.customtemplates.TemplatesManager;
import com.clevertap.android.sdk.inapp.data.CtCacheType;
import com.clevertap.android.sdk.inapp.data.InAppResponseAdapter;
import com.clevertap.android.sdk.inapp.data.PartitionedInApps;
import com.clevertap.android.sdk.inapp.images.repo.FileResourcesRepoFactory;
import com.clevertap.android.sdk.inapp.images.repo.FileResourcesRepoImpl;
import com.clevertap.android.sdk.inapp.store.preference.FileStore;
import com.clevertap.android.sdk.inapp.store.preference.ImpressionStore;
import com.clevertap.android.sdk.inapp.store.preference.InAppAssetsStore;
import com.clevertap.android.sdk.inapp.store.preference.InAppStore;
import com.clevertap.android.sdk.inapp.store.preference.LegacyInAppStore;
import com.clevertap.android.sdk.inapp.store.preference.StoreRegistry;
import com.clevertap.android.sdk.response.CleverTapResponseDecorator;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.Task;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Pair;
import org.json.JSONArray;
import org.json.JSONObject;

public class InAppResponse
extends CleverTapResponseDecorator {
    private final CleverTapInstanceConfig config;
    private final ControllerManager controllerManager;
    private final boolean isSendTest;
    private final Logger logger;
    private final StoreRegistry storeRegistry;
    private final TemplatesManager templatesManager;
    private final TriggerManager triggerManager;
    private final CoreMetaData coreMetaData;

    public InAppResponse(CleverTapInstanceConfig config, ControllerManager controllerManager, boolean isSendTest, StoreRegistry storeRegistry, TriggerManager triggerManager, TemplatesManager templatesManager, CoreMetaData coreMetaData) {
        this.config = config;
        this.logger = this.config.getLogger();
        this.controllerManager = controllerManager;
        this.isSendTest = isSendTest;
        this.storeRegistry = storeRegistry;
        this.triggerManager = triggerManager;
        this.coreMetaData = coreMetaData;
        this.templatesManager = templatesManager;
    }

    @Override
    public void processResponse(JSONObject response, String stringBody, Context context) {
        this.processResponse(response, stringBody, context, false);
    }

    public void processResponse(JSONObject response, String stringBody, Context context, boolean isUserSwitching) {
        try {
            Pair<Boolean, JSONArray> ssInApps;
            PartitionedInApps partitionedClientSideInApps;
            PartitionedInApps partitionedAppLaunchServerSideInApps;
            String mode;
            if (this.config.isAnalyticsOnly()) {
                this.logger.verbose(this.config.getAccountId(), "CleverTap instance is configured to analytics only, not processing inapp messages");
                return;
            }
            if (response == null || response.length() == 0) {
                this.logger.verbose(this.config.getAccountId(), "There is no inapps data to handle");
                return;
            }
            InAppResponseAdapter res = new InAppResponseAdapter(response, this.templatesManager);
            ImpressionStore impressionStore = this.storeRegistry.getImpressionStore();
            InAppStore inAppStore = this.storeRegistry.getInAppStore();
            InAppAssetsStore inAppAssetStore = this.storeRegistry.getInAppAssetsStore();
            FileStore fileStore = this.storeRegistry.getFilesStore();
            LegacyInAppStore legacyInAppStore = this.storeRegistry.getLegacyInAppStore();
            if (impressionStore == null || inAppStore == null || inAppAssetStore == null || legacyInAppStore == null || fileStore == null) {
                this.logger.verbose(this.config.getAccountId(), "Stores are not initialised, ignoring inapps!!!!");
                return;
            }
            this.logger.verbose(this.config.getAccountId(), "InApp: Processing response");
            int perSession = res.getInAppsPerSession();
            int perDay = res.getInAppsPerDay();
            if (!this.isSendTest && this.controllerManager.getInAppFCManager() != null) {
                Logger.v("Updating InAppFC Limits");
                this.controllerManager.getInAppFCManager().updateLimits(context, perDay, perSession);
                this.controllerManager.getInAppFCManager().processResponse(context, response);
            } else {
                this.logger.verbose(this.config.getAccountId(), "controllerManager.getInAppFCManager() is NULL, not Updating InAppFC Limits");
            }
            Pair<Boolean, JSONArray> inappStaleList = res.getStaleInApps();
            if (((Boolean)inappStaleList.getFirst()).booleanValue()) {
                this.clearStaleInAppCache((JSONArray)inappStaleList.getSecond(), impressionStore, this.triggerManager);
            }
            if (!(mode = res.getInAppMode()).isEmpty()) {
                inAppStore.setMode(mode);
            }
            if (isUserSwitching) {
                return;
            }
            PartitionedInApps partitionedLegacyInApps = res.getPartitionedLegacyInApps();
            if (partitionedLegacyInApps.getHasImmediateInApps()) {
                this.displayInApp(partitionedLegacyInApps.getImmediateInApps());
            }
            if (partitionedLegacyInApps.getHasDelayedInApps()) {
                this.scheduleDelayedLegacyInApps(partitionedLegacyInApps.getDelayedInApps());
            }
            if ((partitionedAppLaunchServerSideInApps = res.getPartitionedAppLaunchServerSideInApps()).getHasImmediateInApps()) {
                this.controllerManager.getInAppController().onAppLaunchServerSideInAppsResponse(partitionedAppLaunchServerSideInApps.getImmediateInApps(), this.coreMetaData.getLocationFromUser());
            }
            if (partitionedAppLaunchServerSideInApps.getHasDelayedInApps()) {
                this.controllerManager.getInAppController().onAppLaunchServerSideDelayedInAppsResponse(partitionedAppLaunchServerSideInApps.getDelayedInApps(), this.coreMetaData.getLocationFromUser());
            }
            if ((partitionedClientSideInApps = res.getPartitionedClientSideInApps()).getHasImmediateInApps()) {
                inAppStore.storeClientSideInApps(partitionedClientSideInApps.getImmediateInApps());
            }
            if (partitionedClientSideInApps.getHasDelayedInApps()) {
                inAppStore.storeClientSideDelayedInApps(partitionedClientSideInApps.getDelayedInApps());
            }
            if (((Boolean)(ssInApps = res.getServerSideInApps()).getFirst()).booleanValue()) {
                inAppStore.storeServerSideInAppsMetaData((JSONArray)ssInApps.getSecond());
            }
            List<Pair<String, CtCacheType>> preloadAssetsMeta = res.getPreloadAssetsMeta();
            FileResourcesRepoImpl assetRepo = FileResourcesRepoFactory.createFileResourcesRepo(context, this.logger, this.storeRegistry);
            if (!preloadAssetsMeta.isEmpty()) {
                assetRepo.preloadFilesAndCache(preloadAssetsMeta);
            }
            if (this.isFullResponse) {
                this.logger.verbose(this.config.getAccountId(), "Handling cache eviction");
                assetRepo.cleanupStaleFiles(res.getPreloadAssets());
            } else {
                this.logger.verbose(this.config.getAccountId(), "Ignoring cache eviction");
            }
        }
        catch (Throwable t) {
            Logger.v("InAppManager: Failed to parse response", t);
        }
    }

    private void clearStaleInAppCache(JSONArray inappStaleList, ImpressionStore impressionStore, TriggerManager triggerManager) {
        for (int i = 0; i < inappStaleList.length(); ++i) {
            String inappStaleId = inappStaleList.optString(i);
            impressionStore.clear(inappStaleId);
            triggerManager.removeTriggers(inappStaleId);
        }
    }

    private void displayInApp(final JSONArray inappNotifsArray) {
        Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask("TAG_FEATURE_IN_APPS");
        task.execute("InAppResponse#processResponse", new Callable<Void>(){

            @Override
            public Void call() {
                InAppResponse.this.controllerManager.getInAppController().addInAppNotificationsToQueue(inappNotifsArray);
                return null;
            }
        });
    }

    private void scheduleDelayedLegacyInApps(JSONArray delayedLegacyInApps) {
        InAppController inAppController = this.controllerManager.getInAppController();
        inAppController.scheduleDelayedInAppsForAllModes(delayedLegacyInApps);
        this.logger.verbose(this.config.getAccountId(), "InApp: scheduling " + delayedLegacyInApps.length() + " delayed in-apps. Active delays: " + inAppController.getActiveDelayedInAppsCount());
    }
}

