/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.network;

import android.content.Context;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.utils.Clock;
import java.security.SecureRandom;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\t\b\u0000\u0018\u0000 -2\u00020\u0001:\u0001-B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u0015\u001a\u00020\bJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\bJ\u0006\u0010\u0019\u001a\u00020\u0017J\u000e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\bJ\u0006\u0010\u001c\u001a\u00020\u0017J\u0006\u0010\u001d\u001a\u00020\bJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\bJ\u000e\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u001fJ\u0010\u0010#\u001a\u00020\u00172\b\u0010$\u001a\u0004\u0018\u00010%J\b\u0010&\u001a\u0004\u0018\u00010%J\b\u0010'\u001a\u0004\u0018\u00010%J\u000e\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020%J\u0016\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006."}, d2={"Lcom/clevertap/android/sdk/network/NetworkRepo;", "", "context", "Landroid/content/Context;", "config", "Lcom/clevertap/android/sdk/CleverTapInstanceConfig;", "generateRandomDelay", "Lkotlin/Function0;", "", "clock", "Lcom/clevertap/android/sdk/utils/Clock;", "<init>", "(Landroid/content/Context;Lcom/clevertap/android/sdk/CleverTapInstanceConfig;Lkotlin/jvm/functions/Function0;Lcom/clevertap/android/sdk/utils/Clock;)V", "getContext", "()Landroid/content/Context;", "getConfig", "()Lcom/clevertap/android/sdk/CleverTapInstanceConfig;", "getGenerateRandomDelay", "()Lkotlin/jvm/functions/Function0;", "getClock", "()Lcom/clevertap/android/sdk/utils/Clock;", "getFirstRequestTs", "setFirstRequestTs", "", "firstRequestTs", "clearFirstRequestTs", "setLastRequestTs", "lastRequestTs", "clearLastRequestTs", "getLastRequestTs", "isMuted", "", "getMuted", "setMuted", "mute", "setDomain", "domainName", "", "getDomain", "getSpikyDomain", "setSpikyDomain", "spikyDomainName", "getMinDelayFrequency", "currentDelay", "networkRetryCount", "Companion", "clevertap-core_release"})
public final class NetworkRepo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final CleverTapInstanceConfig config;
    @NotNull
    private final Function0<Integer> generateRandomDelay;
    @NotNull
    private final Clock clock;
    @NotNull
    public static final String KEY_DOMAIN_NAME = "comms_dmn";
    @NotNull
    public static final String SPIKY_KEY_DOMAIN_NAME = "comms_dmn_spiky";
    @NotNull
    public static final String KEY_LAST_TS = "comms_last_ts";
    @NotNull
    public static final String KEY_FIRST_TS = "comms_first_ts";
    public static final int PUSH_DELAY_MS = 1000;
    public static final int MAX_DELAY_FREQUENCY = 600000;

    public NetworkRepo(@NotNull Context context, @NotNull CleverTapInstanceConfig config, @NotNull Function0<Integer> generateRandomDelay, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(generateRandomDelay, (String)"generateRandomDelay");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.context = context;
        this.config = config;
        this.generateRandomDelay = generateRandomDelay;
        this.clock = clock;
    }

    public /* synthetic */ NetworkRepo(Context context, CleverTapInstanceConfig cleverTapInstanceConfig, Function0 function0, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function0 = NetworkRepo::_init_$lambda$0;
        }
        if ((n & 8) != 0) {
            clock = Clock.SYSTEM;
        }
        this(context, cleverTapInstanceConfig, (Function0<Integer>)function0, clock);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final CleverTapInstanceConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final Function0<Integer> getGenerateRandomDelay() {
        return this.generateRandomDelay;
    }

    @NotNull
    public final Clock getClock() {
        return this.clock;
    }

    public final int getFirstRequestTs() {
        String string2 = this.config.getAccountId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAccountId(...)");
        return StorageHelper.getIntFromPrefs(this.context, string2, KEY_FIRST_TS, 0);
    }

    public final void setFirstRequestTs(int firstRequestTs) {
        String string2 = this.config.getAccountId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAccountId(...)");
        StorageHelper.putInt(this.context, string2, KEY_FIRST_TS, firstRequestTs);
    }

    public final void clearFirstRequestTs() {
        String string2 = this.config.getAccountId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAccountId(...)");
        StorageHelper.putInt(this.context, string2, KEY_FIRST_TS, 0);
    }

    public final void setLastRequestTs(int lastRequestTs) {
        String string2 = this.config.getAccountId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAccountId(...)");
        StorageHelper.putInt(this.context, string2, KEY_LAST_TS, lastRequestTs);
    }

    public final void clearLastRequestTs() {
        String string2 = this.config.getAccountId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAccountId(...)");
        StorageHelper.putInt(this.context, string2, KEY_LAST_TS, 0);
    }

    public final int getLastRequestTs() {
        String string2 = this.config.getAccountId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAccountId(...)");
        return StorageHelper.getIntFromPrefs(this.context, string2, KEY_LAST_TS, 0);
    }

    public final boolean isMuted() {
        int muteTS;
        int now = this.clock.currentTimeSecondsInt();
        return now - (muteTS = this.getMuted()) < 86400;
    }

    public final int getMuted() {
        String string2 = this.config.getAccountId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAccountId(...)");
        return StorageHelper.getIntFromPrefs(this.context, string2, "comms_mtd", 0);
    }

    public final void setMuted(boolean mute) {
        if (mute) {
            int now = this.clock.currentTimeSecondsInt();
            String string2 = this.config.getAccountId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAccountId(...)");
            StorageHelper.putInt(this.context, string2, "comms_mtd", now);
        } else {
            String string3 = this.config.getAccountId();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAccountId(...)");
            StorageHelper.putInt(this.context, string3, "comms_mtd", 0);
        }
    }

    public final void setDomain(@Nullable String domainName) {
        String string2 = this.config.getAccountId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAccountId(...)");
        StorageHelper.putString(this.context, string2, KEY_DOMAIN_NAME, domainName);
    }

    @Nullable
    public final String getDomain() {
        String string2 = this.config.getAccountId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAccountId(...)");
        return StorageHelper.getStringFromPrefs(this.context, string2, KEY_DOMAIN_NAME, null);
    }

    @Nullable
    public final String getSpikyDomain() {
        String string2 = this.config.getAccountId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAccountId(...)");
        return StorageHelper.getStringFromPrefs(this.context, string2, SPIKY_KEY_DOMAIN_NAME, null);
    }

    public final void setSpikyDomain(@NotNull String spikyDomainName) {
        Intrinsics.checkNotNullParameter((Object)spikyDomainName, (String)"spikyDomainName");
        String string2 = this.config.getAccountId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAccountId(...)");
        StorageHelper.putString(this.context, string2, SPIKY_KEY_DOMAIN_NAME, spikyDomainName);
    }

    public final int getMinDelayFrequency(int currentDelay, int networkRetryCount) {
        this.config.getLogger().debug(this.config.getAccountId(), "Network retry #" + networkRetryCount);
        if (networkRetryCount < 10) {
            this.config.getLogger().debug(this.config.getAccountId(), "Failure count is " + networkRetryCount + ". Setting delay frequency to 1s");
            return 1000;
        }
        if (this.config.getAccountRegion() == null) {
            this.config.getLogger().debug(this.config.getAccountId(), "Setting delay frequency to 1s");
            return 1000;
        }
        int delayBy = currentDelay + ((Number)this.generateRandomDelay.invoke()).intValue();
        if (delayBy < 600000) {
            this.config.getLogger().debug(this.config.getAccountId(), "Setting delay frequency to " + currentDelay);
            return delayBy;
        }
        return 1000;
    }

    private static final int _init_$lambda$0() {
        SecureRandom randomGen = new SecureRandom();
        return (randomGen.nextInt(10) + 1) * 1000;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/clevertap/android/sdk/network/NetworkRepo$Companion;", "", "<init>", "()V", "KEY_DOMAIN_NAME", "", "SPIKY_KEY_DOMAIN_NAME", "KEY_LAST_TS", "KEY_FIRST_TS", "PUSH_DELAY_MS", "", "MAX_DELAY_FREQUENCY", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

