/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.network;

import android.content.Context;
import android.content.SharedPreferences;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.StorageHelper;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0010J\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00032\b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u0004\u0018\u00010\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/clevertap/android/sdk/network/ArpRepo;", "", "accountId", "", "logger", "Lcom/clevertap/android/sdk/Logger;", "deviceInfo", "Lcom/clevertap/android/sdk/DeviceInfo;", "<init>", "(Ljava/lang/String;Lcom/clevertap/android/sdk/Logger;Lcom/clevertap/android/sdk/DeviceInfo;)V", "newNamespaceARPKey", "getNewNamespaceARPKey", "()Ljava/lang/String;", "namespaceARPKey", "getNamespaceARPKey", "getARP", "Lorg/json/JSONObject;", "context", "Landroid/content/Context;", "handleARPUpdate", "", "arp", "migrateARPToNewNameSpace", "Landroid/content/SharedPreferences;", "newKey", "oldKey", "clevertap-core_release"})
@SourceDebugExtension(value={"SMAP\nArpRepo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArpRepo.kt\ncom/clevertap/android/sdk/network/ArpRepo\n+ 2 SharedPreferences.kt\nandroidx/core/content/SharedPreferencesKt\n*L\n1#1,167:1\n39#2,12:168\n*S KotlinDebug\n*F\n+ 1 ArpRepo.kt\ncom/clevertap/android/sdk/network/ArpRepo\n*L\n164#1:168,12\n*E\n"})
public final class ArpRepo {
    @NotNull
    private final String accountId;
    @NotNull
    private final Logger logger;
    @NotNull
    private final DeviceInfo deviceInfo;

    public ArpRepo(@NotNull String accountId, @NotNull Logger logger, @NotNull DeviceInfo deviceInfo) {
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)deviceInfo, (String)"deviceInfo");
        this.accountId = accountId;
        this.logger = logger;
        this.deviceInfo = deviceInfo;
    }

    private final String getNewNamespaceARPKey() {
        String string2 = this.accountId;
        if (string2 == null) {
            return null;
        }
        String accountId = string2;
        this.logger.verbose(accountId, "New ARP Key = ARP:" + accountId + ':' + this.deviceInfo.getDeviceID());
        return "ARP:" + accountId + ':' + this.deviceInfo.getDeviceID();
    }

    private final String getNamespaceARPKey() {
        String string2 = this.accountId;
        if (string2 == null) {
            return null;
        }
        String accountId = string2;
        this.logger.verbose(accountId, "Old ARP Key = ARP:" + accountId);
        return "ARP:" + accountId;
    }

    @Nullable
    public final JSONObject getARP(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            String string2 = this.getNewNamespaceARPKey();
            if (string2 == null) {
                return null;
            }
            String nameSpaceKey = string2;
            SharedPreferences newPrefsFile = StorageHelper.getPreferences(context, nameSpaceKey);
            Map map = newPrefsFile.getAll();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getAll(...)");
            SharedPreferences prefs = !map.isEmpty() ? newPrefsFile : this.migrateARPToNewNameSpace(context, nameSpaceKey, this.getNamespaceARPKey());
            Map all = prefs.getAll();
            Iterator iter = all.entrySet().iterator();
            while (iter.hasNext()) {
                Object o;
                Map.Entry kv = iter.next();
                Intrinsics.checkNotNull(kv.getValue());
                if (!(o instanceof Number) || ((Number)o).intValue() != -1) continue;
                iter.remove();
            }
            JSONObject ret = new JSONObject(all);
            this.logger.verbose(this.accountId, "Fetched ARP for namespace key: " + nameSpaceKey + " values: " + all);
            return ret;
        }
        catch (Exception e) {
            this.logger.verbose(this.accountId, "Failed to construct ARP object", e);
            return null;
        }
    }

    public final void handleARPUpdate(@NotNull Context context, @NotNull JSONObject arp) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)arp, (String)"arp");
        if (arp.length() == 0) {
            return;
        }
        String string2 = this.getNewNamespaceARPKey();
        if (string2 == null) {
            return;
        }
        String nameSpaceKey = string2;
        SharedPreferences prefs = StorageHelper.getPreferences(context, nameSpaceKey);
        SharedPreferences.Editor editor = prefs.edit();
        Iterator keys = arp.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                SharedPreferences.Editor editor2;
                Object o = arp.get(key);
                if (o instanceof Number) {
                    int update = ((Number)o).intValue();
                    editor2 = editor.putInt(key, update);
                    continue;
                }
                if (o instanceof String) {
                    if (((String)o).length() < 100) {
                        editor2 = editor.putString(key, (String)o);
                        continue;
                    }
                    this.logger.verbose(this.accountId, "ARP update for key " + key + " rejected (string value too long)");
                    editor2 = Unit.INSTANCE;
                    continue;
                }
                if (o instanceof Boolean) {
                    editor2 = editor.putBoolean(key, ((Boolean)o).booleanValue());
                    continue;
                }
                this.logger.verbose(this.accountId, "ARP update for key " + key + " rejected (invalid data type)");
                editor2 = Unit.INSTANCE;
            }
            catch (Exception exception) {}
        }
        this.logger.verbose(this.accountId, "Stored ARP for namespace key: " + nameSpaceKey + " values: " + arp);
        Intrinsics.checkNotNull((Object)editor);
        StorageHelper.persist(editor);
    }

    private final SharedPreferences migrateARPToNewNameSpace(Context context, String newKey, String oldKey) {
        SharedPreferences.Editor editor$iv;
        SharedPreferences oldPrefs = StorageHelper.getPreferences(context, oldKey);
        SharedPreferences newPrefs = StorageHelper.getPreferences(context, newKey);
        SharedPreferences.Editor editor = newPrefs.edit();
        Map all = oldPrefs.getAll();
        Intrinsics.checkNotNull((Object)all);
        for (Map.Entry entry : all.entrySet()) {
            SharedPreferences.Editor editor2;
            Object o;
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Intrinsics.checkNotNull(value);
            if (o instanceof Number) {
                int update = ((Number)o).intValue();
                editor2 = editor.putInt(key, update);
                continue;
            }
            if (o instanceof String) {
                if (((String)o).length() < 100) {
                    editor2 = editor.putString(key, (String)o);
                    continue;
                }
                this.logger.verbose(this.accountId, "ARP update for key " + key + " rejected (string value too long)");
                editor2 = Unit.INSTANCE;
                continue;
            }
            if (o instanceof Boolean) {
                editor2 = editor.putBoolean(key, ((Boolean)o).booleanValue());
                continue;
            }
            this.logger.verbose(this.accountId, "ARP update for key " + key + " rejected (invalid data type)");
            editor2 = Unit.INSTANCE;
        }
        this.logger.verbose(this.accountId, "Completed ARP update for namespace key: " + newKey);
        Intrinsics.checkNotNull((Object)editor);
        StorageHelper.persist(editor);
        SharedPreferences $this$edit_u24default$iv = oldPrefs;
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor $this$migrateARPToNewNameSpace_u24lambda_u240 = editor$iv = $this$edit_u24default$iv.edit();
        boolean bl = false;
        $this$migrateARPToNewNameSpace_u24lambda_u240.clear();
        editor$iv.apply();
        return newPrefs;
    }
}

