/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp.store.db;

import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.ILogger;
import com.clevertap.android.sdk.cryption.CryptHandler;
import com.clevertap.android.sdk.db.DelayedLegacyInAppDAO;
import com.clevertap.android.sdk.db.DelayedLegacyInAppData;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0007J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\tH\u0007J\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\tH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/clevertap/android/sdk/inapp/store/db/DelayedLegacyInAppStore;", "", "delayedLegacyInAppDAO", "Lcom/clevertap/android/sdk/db/DelayedLegacyInAppDAO;", "cryptHandler", "Lcom/clevertap/android/sdk/cryption/CryptHandler;", "logger", "Lcom/clevertap/android/sdk/ILogger;", "accountId", "", "<init>", "(Lcom/clevertap/android/sdk/db/DelayedLegacyInAppDAO;Lcom/clevertap/android/sdk/cryption/CryptHandler;Lcom/clevertap/android/sdk/ILogger;Ljava/lang/String;)V", "saveDelayedInAppsBatch", "", "delayedInApps", "Lorg/json/JSONArray;", "getDelayedInApp", "Lorg/json/JSONObject;", "inAppId", "removeDelayedInApp", "removeDelayedInAppsBatch", "", "inAppIds", "", "hasDelayedInApp", "clevertap-core_release"})
@SourceDebugExtension(value={"SMAP\nDelayedLegacyInAppStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DelayedLegacyInAppStore.kt\ncom/clevertap/android/sdk/inapp/store/db/DelayedLegacyInAppStore\n+ 2 CTXtensions.kt\ncom/clevertap/android/sdk/CTXtensions\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n288#2,7:127\n1863#3,2:134\n*S KotlinDebug\n*F\n+ 1 DelayedLegacyInAppStore.kt\ncom/clevertap/android/sdk/inapp/store/db/DelayedLegacyInAppStore\n*L\n42#1:127,7\n114#1:134,2\n*E\n"})
public final class DelayedLegacyInAppStore {
    @NotNull
    private final DelayedLegacyInAppDAO delayedLegacyInAppDAO;
    @NotNull
    private final CryptHandler cryptHandler;
    @NotNull
    private final ILogger logger;
    @NotNull
    private final String accountId;

    public DelayedLegacyInAppStore(@NotNull DelayedLegacyInAppDAO delayedLegacyInAppDAO, @NotNull CryptHandler cryptHandler, @NotNull ILogger logger, @NotNull String accountId) {
        Intrinsics.checkNotNullParameter((Object)delayedLegacyInAppDAO, (String)"delayedLegacyInAppDAO");
        Intrinsics.checkNotNullParameter((Object)cryptHandler, (String)"cryptHandler");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        this.delayedLegacyInAppDAO = delayedLegacyInAppDAO;
        this.cryptHandler = cryptHandler;
        this.logger = logger;
        this.accountId = accountId;
    }

    @WorkerThread
    public final boolean saveDelayedInAppsBatch(@NotNull JSONArray delayedInApps) {
        Intrinsics.checkNotNullParameter((Object)delayedInApps, (String)"delayedInApps");
        if (delayedInApps.length() == 0) {
            return true;
        }
        List dataList = new ArrayList();
        int encryptionFailureCount = 0;
        JSONArray $this$iterator$iv = delayedInApps;
        boolean $i$f$iterator = false;
        int n = $this$iterator$iv.length();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            Object element$iv = $this$iterator$iv.get(index$iv);
            if (!(element$iv instanceof JSONObject)) continue;
            JSONObject inAppJson = (JSONObject)element$iv;
            boolean bl = false;
            String inAppId = inAppJson.optString("ti");
            int delay = inAppJson.optInt("delayAfterTrigger");
            String string2 = inAppJson.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String encryptedInAppData = this.cryptHandler.encrypt(string2);
            if (encryptedInAppData == null) {
                this.logger.verbose(this.accountId, "Failed to encrypt delayed in-app: " + inAppId + ". Skipping this item.");
                int n2 = encryptionFailureCount;
                encryptionFailureCount = n2 + 1;
                continue;
            }
            Intrinsics.checkNotNull((Object)inAppId);
            dataList.add(new DelayedLegacyInAppData(inAppId, delay, encryptedInAppData));
        }
        if (dataList.isEmpty()) {
            this.logger.verbose(this.accountId, "No delayed in-apps to save. All items failed encryption or parsing.");
            return false;
        }
        if (encryptionFailureCount > 0) {
            this.logger.verbose(this.accountId, "Skipped " + encryptionFailureCount + " delayed in-apps due to encryption failure");
        }
        return this.delayedLegacyInAppDAO.insertBatch(dataList);
    }

    @WorkerThread
    @Nullable
    public final JSONObject getDelayedInApp(@NotNull String inAppId) {
        JSONObject jSONObject;
        String encryptedInAppDataString;
        Intrinsics.checkNotNullParameter((Object)inAppId, (String)"inAppId");
        String string2 = encryptedInAppDataString = this.delayedLegacyInAppDAO.fetchSingleInApp(inAppId);
        if (string2 != null) {
            JSONObject jSONObject2;
            String it = string2;
            boolean bl = false;
            try {
                String decryptedInAppData = this.cryptHandler.decrypt(it);
                if (decryptedInAppData == null) {
                    this.logger.verbose(this.accountId, "Failed to decrypt delayed in-app: " + inAppId);
                    return null;
                }
                jSONObject2 = new JSONObject(decryptedInAppData);
            }
            catch (JSONException e) {
                this.logger.verbose(this.accountId, "Error parsing delayed in-app: " + inAppId, e);
                jSONObject2 = null;
            }
            jSONObject = jSONObject2;
        } else {
            jSONObject = null;
        }
        return jSONObject;
    }

    @WorkerThread
    public final boolean removeDelayedInApp(@NotNull String inAppId) {
        Intrinsics.checkNotNullParameter((Object)inAppId, (String)"inAppId");
        return this.delayedLegacyInAppDAO.remove(inAppId);
    }

    @WorkerThread
    public final int removeDelayedInAppsBatch(@NotNull List<String> inAppIds) {
        Intrinsics.checkNotNullParameter(inAppIds, (String)"inAppIds");
        int removedCount = 0;
        Iterable $this$forEach$iv = inAppIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String inAppId = (String)element$iv;
            boolean bl = false;
            if (!this.delayedLegacyInAppDAO.remove(inAppId)) continue;
            ++removedCount;
        }
        return removedCount;
    }

    @WorkerThread
    public final boolean hasDelayedInApp(@NotNull String inAppId) {
        Intrinsics.checkNotNullParameter((Object)inAppId, (String)"inAppId");
        return this.delayedLegacyInAppDAO.fetchSingleInApp(inAppId) != null;
    }
}

