/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp.images.memory;

import com.clevertap.android.sdk.ILogger;
import com.clevertap.android.sdk.inapp.images.memory.MemoryAccessObject;
import com.clevertap.android.sdk.inapp.images.memory.MemoryAccessObjectKt;
import com.clevertap.android.sdk.inapp.images.memory.MemoryDataTransformationType;
import com.clevertap.android.sdk.utils.CTCaches;
import com.clevertap.android.sdk.utils.DiskMemory;
import com.clevertap.android.sdk.utils.InMemoryLruCache;
import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001e\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0016J+\u0010\u000e\u001a\u0004\u0018\u0001H\u000f\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J+\u0010\u0013\u001a\u0004\u0018\u0001H\u000f\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0016J$\u0010\u001a\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000b0\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/clevertap/android/sdk/inapp/images/memory/FileMemoryAccessObject;", "Lcom/clevertap/android/sdk/inapp/images/memory/MemoryAccessObject;", "", "ctCaches", "Lcom/clevertap/android/sdk/utils/CTCaches;", "logger", "Lcom/clevertap/android/sdk/ILogger;", "<init>", "(Lcom/clevertap/android/sdk/utils/CTCaches;Lcom/clevertap/android/sdk/ILogger;)V", "fetchInMemory", "Lkotlin/Pair;", "Ljava/io/File;", "key", "", "fetchInMemoryAndTransform", "A", "transformTo", "Lcom/clevertap/android/sdk/inapp/images/memory/MemoryDataTransformationType;", "(Ljava/lang/String;Lcom/clevertap/android/sdk/inapp/images/memory/MemoryDataTransformationType;)Ljava/lang/Object;", "fetchDiskMemoryAndTransform", "fetchDiskMemory", "saveDiskMemory", "data", "removeDiskMemory", "", "removeInMemory", "saveInMemory", "clevertap-core_release"})
public final class FileMemoryAccessObject
implements MemoryAccessObject<byte[]> {
    @NotNull
    private final CTCaches ctCaches;
    @Nullable
    private final ILogger logger;

    public FileMemoryAccessObject(@NotNull CTCaches ctCaches, @Nullable ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)ctCaches, (String)"ctCaches");
        this.ctCaches = ctCaches;
        this.logger = logger;
    }

    public /* synthetic */ FileMemoryAccessObject(CTCaches cTCaches, ILogger iLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            iLogger = null;
        }
        this(cTCaches, iLogger);
    }

    @Override
    @Nullable
    public Pair<byte[], File> fetchInMemory(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        InMemoryLruCache<Pair<byte[], File>> fileInMemory = this.ctCaches.fileInMemory();
        return fileInMemory.get(key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public <A> A fetchInMemoryAndTransform(@NotNull String key, @NotNull MemoryDataTransformationType<A> transformTo) {
        Object object;
        Pair<byte[], File> pair;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(transformTo, (String)"transformTo");
        Pair<byte[], File> pair2 = pair = this.fetchInMemory(key);
        if (pair2 != null) {
            Pair<byte[], File> it = pair2;
            boolean bl = false;
            ILogger iLogger = this.logger;
            if (iLogger != null) {
                iLogger.verbose("FileDownload", key + " data found in FILE in-memory");
            }
            MemoryDataTransformationType<A> memoryDataTransformationType = transformTo;
            if (Intrinsics.areEqual(memoryDataTransformationType, (Object)MemoryDataTransformationType.ToBitmap.INSTANCE)) {
                object = MemoryAccessObjectKt.getBytesToBitmap().invoke(it.getFirst());
                if (object != null) return (A)object;
                object = null;
                return (A)object;
            } else if (Intrinsics.areEqual(memoryDataTransformationType, (Object)MemoryDataTransformationType.ToByteArray.INSTANCE)) {
                object = it.getFirst();
                if (object != null) return (A)object;
                object = null;
                return (A)object;
            } else {
                if (!Intrinsics.areEqual(memoryDataTransformationType, (Object)MemoryDataTransformationType.ToFile.INSTANCE)) throw new NoWhenBranchMatchedException();
                object = it.getSecond();
                if (object != null) return (A)object;
                object = null;
            }
            return (A)object;
        } else {
            object = null;
        }
        return (A)object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public <A> A fetchDiskMemoryAndTransform(@NotNull String key, @NotNull MemoryDataTransformationType<A> transformTo) {
        Object object;
        File file;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(transformTo, (String)"transformTo");
        File file2 = file = this.fetchDiskMemory(key);
        if (file2 != null) {
            MemoryDataTransformationType<A> memoryDataTransformationType;
            File it = file2;
            boolean bl = false;
            ILogger iLogger = this.logger;
            if (iLogger != null) {
                iLogger.verbose("FileDownload", key + " data found in FILE disk memory");
            }
            byte[] bytes = (byte[])MemoryAccessObjectKt.getFileToBytes().invoke((Object)it);
            if (bytes != null) {
                this.saveInMemory(key, (Pair<byte[], ? extends File>)new Pair((Object)bytes, (Object)it));
            }
            if (Intrinsics.areEqual(memoryDataTransformationType = transformTo, (Object)MemoryDataTransformationType.ToBitmap.INSTANCE)) {
                object = MemoryAccessObjectKt.getFileToBitmap().invoke((Object)it);
                if (object != null) return (A)object;
                object = null;
                return (A)object;
            } else if (Intrinsics.areEqual(memoryDataTransformationType, (Object)MemoryDataTransformationType.ToByteArray.INSTANCE)) {
                object = bytes instanceof Object ? (Object)bytes : null;
                return (A)object;
            } else {
                if (!Intrinsics.areEqual(memoryDataTransformationType, (Object)MemoryDataTransformationType.ToFile.INSTANCE)) throw new NoWhenBranchMatchedException();
                object = it instanceof Object ? it : null;
            }
            return (A)object;
        } else {
            object = null;
        }
        return (A)object;
    }

    @Override
    @Nullable
    public File fetchDiskMemory(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ILogger iLogger = this.logger;
        if (iLogger != null) {
            iLogger.verbose("FileDownload", "FILE In-Memory cache miss for " + key + " data");
        }
        DiskMemory fileDiskMemory = this.ctCaches.fileDiskMemory();
        return fileDiskMemory.get(key);
    }

    @Override
    @NotNull
    public File saveDiskMemory(@NotNull String key, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        DiskMemory fileDiskMemory = this.ctCaches.fileDiskMemory();
        return fileDiskMemory.addAndReturnFileInstance(key, data);
    }

    @Override
    public boolean removeDiskMemory(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ILogger iLogger = this.logger;
        if (iLogger != null) {
            iLogger.verbose("FileDownload", "If present, will remove " + key + " data from FILE disk-memory");
        }
        DiskMemory fileDiskMemory = this.ctCaches.fileDiskMemory();
        return fileDiskMemory.remove(key);
    }

    @Override
    @Nullable
    public Pair<byte[], File> removeInMemory(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ILogger iLogger = this.logger;
        if (iLogger != null) {
            iLogger.verbose("FileDownload", "If present, will remove " + key + " data from FILE in-memory");
        }
        InMemoryLruCache<Pair<byte[], File>> fileInMemory = this.ctCaches.fileInMemory();
        return fileInMemory.remove(key);
    }

    @Override
    public boolean saveInMemory(@NotNull String key, @NotNull Pair<byte[], ? extends File> data) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        ILogger iLogger = this.logger;
        if (iLogger != null) {
            iLogger.verbose("FileDownload", "Saving " + key + " data in FILE in-memory");
        }
        InMemoryLruCache<Pair<byte[], File>> fileInMemory = this.ctCaches.fileInMemory();
        return fileInMemory.add(key, data);
    }
}

