/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u0000 &2\u00020\u0001:\u0001&B3\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\u0011\b\u0012\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\t\u0010\rJ\b\u0010\u0017\u001a\u00020\bH\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\bH\u0016J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001dJ\u0006\u0010\u001f\u001a\u00020\u001dJ\u0006\u0010 \u001a\u00020\u001dJ\u0006\u0010!\u001a\u00020\u001dJ\u0013\u0010\"\u001a\u00020\u001d2\b\u0010#\u001a\u0004\u0018\u00010$H\u0096\u0002J\b\u0010%\u001a\u00020\bH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006'"}, d2={"Lcom/clevertap/android/sdk/inapp/CTInAppNotificationMedia;", "Landroid/os/Parcelable;", "mediaUrl", "", "contentType", "contentDescription", "cacheKey", "orientation", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)V", "parcel", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "getMediaUrl", "()Ljava/lang/String;", "setMediaUrl", "(Ljava/lang/String;)V", "getContentType", "getContentDescription", "getCacheKey", "getOrientation", "()I", "describeContents", "writeToParcel", "", "dest", "flags", "isAudio", "", "isGIF", "isImage", "isVideo", "isMediaStreamable", "equals", "other", "", "hashCode", "Companion", "clevertap-core_release"})
public final class CTInAppNotificationMedia
implements Parcelable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String mediaUrl;
    @NotNull
    private final String contentType;
    @NotNull
    private final String contentDescription;
    @Nullable
    private final String cacheKey;
    private final int orientation;
    @JvmField
    @NotNull
    public static final Parcelable.Creator<CTInAppNotificationMedia> CREATOR = (Parcelable.Creator)new Parcelable.Creator<CTInAppNotificationMedia>(){

        public CTInAppNotificationMedia createFromParcel(Parcel parcel) {
            Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
            return new CTInAppNotificationMedia(parcel, null);
        }

        public CTInAppNotificationMedia[] newArray(int size) {
            return new CTInAppNotificationMedia[size];
        }
    };

    @NotNull
    public final String getMediaUrl() {
        return this.mediaUrl;
    }

    public final void setMediaUrl(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.mediaUrl = string2;
    }

    @NotNull
    public final String getContentType() {
        return this.contentType;
    }

    @NotNull
    public final String getContentDescription() {
        return this.contentDescription;
    }

    @Nullable
    public final String getCacheKey() {
        return this.cacheKey;
    }

    public final int getOrientation() {
        return this.orientation;
    }

    public CTInAppNotificationMedia(@NotNull String mediaUrl, @NotNull String contentType, @NotNull String contentDescription, @Nullable String cacheKey, int orientation) {
        Intrinsics.checkNotNullParameter((Object)mediaUrl, (String)"mediaUrl");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)contentDescription, (String)"contentDescription");
        this.mediaUrl = mediaUrl;
        this.contentType = contentType;
        this.contentDescription = contentDescription;
        this.cacheKey = cacheKey;
        this.orientation = orientation;
    }

    private CTInAppNotificationMedia(Parcel parcel) {
        String string2;
        String string3;
        String string4 = parcel.readString();
        if (string4 == null) {
            string4 = this.mediaUrl = "";
        }
        if ((string3 = parcel.readString()) == null) {
            string3 = this.contentType = "";
        }
        if ((string2 = parcel.readString()) == null) {
            string2 = "";
        }
        this.contentDescription = string2;
        this.cacheKey = parcel.readString();
        this.orientation = parcel.readInt();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel dest, int flags) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        dest.writeString(this.mediaUrl);
        dest.writeString(this.contentType);
        dest.writeString(this.contentDescription);
        dest.writeString(this.cacheKey);
        dest.writeInt(this.orientation);
    }

    public final boolean isAudio() {
        return !StringsKt.isBlank((CharSequence)this.mediaUrl) && StringsKt.startsWith$default((String)this.contentType, (String)"audio", (boolean)false, (int)2, null);
    }

    public final boolean isGIF() {
        return !StringsKt.isBlank((CharSequence)this.mediaUrl) && Intrinsics.areEqual((Object)this.contentType, (Object)"image/gif");
    }

    public final boolean isImage() {
        return !StringsKt.isBlank((CharSequence)this.mediaUrl) && StringsKt.startsWith$default((String)this.contentType, (String)"image", (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)this.contentType, (Object)"image/gif");
    }

    public final boolean isVideo() {
        return !StringsKt.isBlank((CharSequence)this.mediaUrl) && StringsKt.startsWith$default((String)this.contentType, (String)"video", (boolean)false, (int)2, null);
    }

    public final boolean isMediaStreamable() {
        return this.isVideo() || this.isAudio();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.clevertap.android.sdk.inapp.CTInAppNotificationMedia");
        CTInAppNotificationMedia cfr_ignored_0 = (CTInAppNotificationMedia)other;
        if (this.orientation != ((CTInAppNotificationMedia)other).orientation) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.mediaUrl, (Object)((CTInAppNotificationMedia)other).mediaUrl)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.contentType, (Object)((CTInAppNotificationMedia)other).contentType)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.contentDescription, (Object)((CTInAppNotificationMedia)other).contentDescription)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.cacheKey, (Object)((CTInAppNotificationMedia)other).cacheKey);
    }

    public int hashCode() {
        int result = this.orientation;
        result = 31 * result + this.mediaUrl.hashCode();
        result = 31 * result + this.contentType.hashCode();
        result = 31 * result + this.contentDescription.hashCode();
        String string2 = this.cacheKey;
        result = 31 * result + (string2 != null ? string2.hashCode() : 0);
        return result;
    }

    @JvmStatic
    @Nullable
    public static final CTInAppNotificationMedia create(@NotNull JSONObject json, int orientation) {
        return Companion.create(json, orientation);
    }

    public /* synthetic */ CTInAppNotificationMedia(Parcel parcel, DefaultConstructorMarker $constructor_marker) {
        this(parcel);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/clevertap/android/sdk/inapp/CTInAppNotificationMedia$Companion;", "", "<init>", "()V", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcom/clevertap/android/sdk/inapp/CTInAppNotificationMedia;", "create", "json", "Lorg/json/JSONObject;", "orientation", "", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final CTInAppNotificationMedia create(@NotNull JSONObject json, int orientation) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            String contentType = json.optString("content_type");
            Intrinsics.checkNotNull((Object)contentType);
            if (StringsKt.isBlank((CharSequence)contentType)) {
                return null;
            }
            String mediaUrl = json.optString("url");
            String cacheKey = null;
            Intrinsics.checkNotNull((Object)mediaUrl);
            if (!StringsKt.isBlank((CharSequence)mediaUrl) && StringsKt.startsWith$default((String)contentType, (String)"image", (boolean)false, (int)2, null)) {
                cacheKey = UUID.randomUUID() + json.optString("key");
            }
            String contentDescription = json.optString("alt_text");
            Intrinsics.checkNotNull((Object)contentDescription);
            return new CTInAppNotificationMedia(mediaUrl, contentType, contentDescription, cacheKey, orientation);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

