/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.utils;

import android.app.Activity;
import android.content.Context;
import com.clevertap.android.sdk.CoreMetaData;
import com.clevertap.android.sdk.Logger;
import com.google.android.gms.tasks.Task;
import com.google.android.play.core.review.ReviewInfo;
import com.google.android.play.core.review.ReviewManager;
import com.google.android.play.core.review.ReviewManagerFactory;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bJ@\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\u001a\u0010\u0014\u001a\u0016\u0012\f\u0012\n\u0018\u00010\u0017j\u0004\u0018\u0001`\u0016\u0012\u0004\u0012\u00020\r0\u0015R!\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lcom/clevertap/android/sdk/utils/PlayStoreReviewHandler;", "", "<init>", "()V", "reviewManagerFactoryClass", "Ljava/lang/Class;", "getReviewManagerFactoryClass", "()Ljava/lang/Class;", "reviewManagerFactoryClass$delegate", "Lkotlin/Lazy;", "isPlayStoreReviewLibraryAvailable", "", "launchReview", "", "context", "Landroid/content/Context;", "logger", "Lcom/clevertap/android/sdk/Logger;", "onCompleted", "Lkotlin/Function0;", "onError", "Lkotlin/Function1;", "Lkotlin/Exception;", "Ljava/lang/Exception;", "clevertap-core_release"})
public final class PlayStoreReviewHandler {
    @NotNull
    private final Lazy reviewManagerFactoryClass$delegate = LazyKt.lazy(PlayStoreReviewHandler::reviewManagerFactoryClass_delegate$lambda$0);

    private final Class<?> getReviewManagerFactoryClass() {
        Lazy lazy = this.reviewManagerFactoryClass$delegate;
        return (Class)lazy.getValue();
    }

    public final boolean isPlayStoreReviewLibraryAvailable() {
        return this.getReviewManagerFactoryClass() != null;
    }

    public final void launchReview(@NotNull Context context, @NotNull Logger logger, @NotNull Function0<Unit> onCompleted, @NotNull Function1<? super Exception, Unit> onError) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(onCompleted, (String)"onCompleted");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        if (!this.isPlayStoreReviewLibraryAvailable()) {
            logger.debug("Could not launch Play Store Review flow: Play store review library not found.");
            onError.invoke(null);
            return;
        }
        ReviewManager reviewManager = ReviewManagerFactory.create((Context)context);
        Intrinsics.checkNotNullExpressionValue((Object)reviewManager, (String)"create(...)");
        ReviewManager manager = reviewManager;
        Task task = manager.requestReviewFlow();
        Intrinsics.checkNotNullExpressionValue((Object)task, (String)"requestReviewFlow(...)");
        Task request = task;
        request.addOnCompleteListener(arg_0 -> PlayStoreReviewHandler.launchReview$lambda$2(manager, logger, onError, onCompleted, arg_0));
    }

    private static final Class reviewManagerFactoryClass_delegate$lambda$0() {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.google.android.play.core.review.ReviewManagerFactory");
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = null;
        }
        return clazz;
    }

    private static final void launchReview$lambda$2$lambda$1(Function0 $onCompleted, Task task) {
        Intrinsics.checkNotNullParameter((Object)$onCompleted, (String)"$onCompleted");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        $onCompleted.invoke();
    }

    private static final void launchReview$lambda$2(ReviewManager $manager, Logger $logger, Function1 $onError, Function0 $onCompleted, Task task) {
        Intrinsics.checkNotNullParameter((Object)$manager, (String)"$manager");
        Intrinsics.checkNotNullParameter((Object)$logger, (String)"$logger");
        Intrinsics.checkNotNullParameter((Object)$onError, (String)"$onError");
        Intrinsics.checkNotNullParameter((Object)$onCompleted, (String)"$onCompleted");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (task.isSuccessful()) {
            ReviewInfo reviewInfo = (ReviewInfo)task.getResult();
            Activity currentActivity = CoreMetaData.getCurrentActivity();
            if (currentActivity != null) {
                Task task2 = $manager.launchReviewFlow(currentActivity, reviewInfo);
                Intrinsics.checkNotNullExpressionValue((Object)task2, (String)"launchReviewFlow(...)");
                Task flow = task2;
                flow.addOnCompleteListener(arg_0 -> PlayStoreReviewHandler.launchReview$lambda$2$lambda$1($onCompleted, arg_0));
            } else {
                $logger.debug("Could not launch Play Store Review flow: current Activity is null.");
                $onError.invoke(null);
            }
        } else {
            $logger.debug("Could not launch Play Store Review flow.", task.getException());
            $onError.invoke((Object)task.getException());
        }
    }
}

