/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.usereventlogs;

import android.content.ContentValues;
import android.database.Cursor;
import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.db.DatabaseHelper;
import com.clevertap.android.sdk.db.Table;
import com.clevertap.android.sdk.usereventlogs.UserEventLog;
import com.clevertap.android.sdk.usereventlogs.UserEventLogDAO;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0017J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0017J*\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0018\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u00150\u0014H\u0017J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0017J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0017J\u0018\u0010\u001a\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0017J \u0010\u001b\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u0019H\u0017J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00170\u001e2\u0006\u0010\f\u001a\u00020\rH\u0017J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00170\u001eH\u0017J\u0018\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u0019H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/clevertap/android/sdk/usereventlogs/UserEventLogDAOImpl;", "Lcom/clevertap/android/sdk/usereventlogs/UserEventLogDAO;", "db", "Lcom/clevertap/android/sdk/db/DatabaseHelper;", "logger", "Lcom/clevertap/android/sdk/Logger;", "table", "Lcom/clevertap/android/sdk/db/Table;", "<init>", "(Lcom/clevertap/android/sdk/db/DatabaseHelper;Lcom/clevertap/android/sdk/Logger;Lcom/clevertap/android/sdk/db/Table;)V", "insertEvent", "", "deviceID", "", "eventName", "normalizedEventName", "updateEventByDeviceIdAndNormalizedEventName", "", "upsertEventsByDeviceIdAndNormalizedEventName", "setOfActualAndNormalizedEventNamePair", "", "Lkotlin/Pair;", "readEventByDeviceIdAndNormalizedEventName", "Lcom/clevertap/android/sdk/usereventlogs/UserEventLog;", "readEventCountByDeviceIdAndNormalizedEventName", "", "eventExistsByDeviceIdAndNormalizedEventName", "eventExistsByDeviceIdAndNormalizedEventNameAndCount", "count", "allEventsByDeviceID", "", "allEvents", "cleanUpExtraEvents", "threshold", "numberOfRowsToCleanup", "clevertap-core_release"})
@SourceDebugExtension(value={"SMAP\nUserEventLogDAOImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserEventLogDAOImpl.kt\ncom/clevertap/android/sdk/usereventlogs/UserEventLogDAOImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,332:1\n1863#2,2:333\n*S KotlinDebug\n*F\n+ 1 UserEventLogDAOImpl.kt\ncom/clevertap/android/sdk/usereventlogs/UserEventLogDAOImpl\n*L\n91#1:333,2\n*E\n"})
public final class UserEventLogDAOImpl
implements UserEventLogDAO {
    @NotNull
    private final DatabaseHelper db;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Table table;

    public UserEventLogDAOImpl(@NotNull DatabaseHelper db, @NotNull Logger logger, @NotNull Table table) {
        Intrinsics.checkNotNullParameter((Object)((Object)db), (String)"db");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        this.db = db;
        this.logger = logger;
        this.table = table;
    }

    @Override
    @WorkerThread
    public long insertEvent(@NotNull String deviceID, @NotNull String eventName, @NotNull String normalizedEventName) {
        long l;
        ContentValues contentValues;
        Intrinsics.checkNotNullParameter((Object)deviceID, (String)"deviceID");
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        Intrinsics.checkNotNullParameter((Object)normalizedEventName, (String)"normalizedEventName");
        if (!this.db.belowMemThreshold()) {
            this.logger.verbose("There is not enough space left on the device to store data, data discarded");
            return -2L;
        }
        String tableName = this.table.getTableName();
        this.logger.verbose("Inserting event " + eventName + " with deviceID = " + deviceID + " in " + tableName);
        long now = Utils.getNowInMillis();
        ContentValues $this$insertEvent_u24lambda_u240 = contentValues = new ContentValues();
        boolean bl = false;
        $this$insertEvent_u24lambda_u240.put("eventName", eventName);
        $this$insertEvent_u24lambda_u240.put("normalizedEventName", normalizedEventName);
        $this$insertEvent_u24lambda_u240.put("firstTs", Long.valueOf(now));
        $this$insertEvent_u24lambda_u240.put("lastTs", Long.valueOf(now));
        $this$insertEvent_u24lambda_u240.put("count", Integer.valueOf(1));
        $this$insertEvent_u24lambda_u240.put("deviceID", deviceID);
        ContentValues values = contentValues;
        try {
            l = this.db.getWritableDatabase().insertWithOnConflict(tableName, null, values, 5);
        }
        catch (Exception e) {
            this.logger.verbose("Error adding row to table " + tableName + " Recreating DB. Exception: " + e);
            this.db.deleteDatabase();
            l = -1L;
        }
        return l;
    }

    @Override
    @WorkerThread
    public boolean updateEventByDeviceIdAndNormalizedEventName(@NotNull String deviceID, @NotNull String normalizedEventName) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)deviceID, (String)"deviceID");
        Intrinsics.checkNotNullParameter((Object)normalizedEventName, (String)"normalizedEventName");
        String tableName = this.table.getTableName();
        long now = Utils.getNowInMillis();
        try {
            String query = StringsKt.trimIndent((String)("\n            UPDATE " + tableName + " \n            SET \n                count = count + 1,\n                lastTs = ?\n            WHERE deviceID = ? \n            AND normalizedEventName = ?;\n        "));
            this.logger.verbose("Updating event " + normalizedEventName + " with deviceID = " + deviceID + " in " + tableName);
            Object[] objectArray = new Object[]{now, deviceID, normalizedEventName};
            this.db.getWritableDatabase().execSQL(query, objectArray);
            bl = true;
        }
        catch (Exception e) {
            this.logger.verbose("Could not update event in database " + tableName + '.', e);
            bl = false;
        }
        return bl;
    }

    @Override
    @WorkerThread
    public boolean upsertEventsByDeviceIdAndNormalizedEventName(@NotNull String deviceID, @NotNull Set<Pair<String, String>> setOfActualAndNormalizedEventNamePair) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)deviceID, (String)"deviceID");
        Intrinsics.checkNotNullParameter(setOfActualAndNormalizedEventNamePair, (String)"setOfActualAndNormalizedEventNamePair");
        String tableName = this.table.getTableName();
        this.logger.verbose("UserEventLog: upsert EventLog for bulk events");
        try {
            this.db.getWritableDatabase().beginTransaction();
            Iterable $this$forEach$iv = setOfActualAndNormalizedEventNamePair;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair it = (Pair)element$iv;
                boolean bl2 = false;
                if (this.eventExistsByDeviceIdAndNormalizedEventName(deviceID, (String)it.getSecond())) {
                    this.logger.verbose("UserEventLog: Updating EventLog for event " + it);
                    this.updateEventByDeviceIdAndNormalizedEventName(deviceID, (String)it.getSecond());
                    continue;
                }
                this.logger.verbose("UserEventLog: Inserting EventLog for event " + it);
                this.insertEvent(deviceID, (String)it.getFirst(), (String)it.getSecond());
            }
            this.db.getWritableDatabase().setTransactionSuccessful();
            this.db.getWritableDatabase().endTransaction();
            bl = true;
        }
        catch (Exception e) {
            this.logger.verbose("Failed to perform bulk upsert on table " + tableName, e);
            try {
                this.db.getWritableDatabase().endTransaction();
            }
            catch (Exception e2) {
                this.logger.verbose("Failed to end transaction on table " + tableName, e2);
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    @Nullable
    public UserEventLog readEventByDeviceIdAndNormalizedEventName(@NotNull String deviceID, @NotNull String normalizedEventName) {
        Intrinsics.checkNotNullParameter((Object)deviceID, (String)"deviceID");
        Intrinsics.checkNotNullParameter((Object)normalizedEventName, (String)"normalizedEventName");
        String tName = this.table.getTableName();
        String selection = "deviceID = ? AND normalizedEventName = ?";
        String[] stringArray = new String[]{deviceID, normalizedEventName};
        String[] selectionArgs = stringArray;
        try {
            UserEventLog userEventLog;
            stringArray = this.db.getReadableDatabase().query(tName, null, selection, selectionArgs, null, null, null, null);
            if (stringArray != null) {
                Closeable closeable = (Closeable)stringArray;
                Throwable throwable = null;
                try {
                    UserEventLog userEventLog2;
                    Cursor cursor = (Cursor)closeable;
                    boolean bl = false;
                    if (cursor.moveToFirst()) {
                        UserEventLog eventLog;
                        String string2 = cursor.getString(cursor.getColumnIndexOrThrow("eventName"));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                        String string3 = cursor.getString(cursor.getColumnIndexOrThrow("normalizedEventName"));
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
                        long l = cursor.getLong(cursor.getColumnIndexOrThrow("firstTs"));
                        long l2 = cursor.getLong(cursor.getColumnIndexOrThrow("lastTs"));
                        int n = cursor.getInt(cursor.getColumnIndexOrThrow("count"));
                        String string4 = cursor.getString(cursor.getColumnIndexOrThrow("deviceID"));
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
                        userEventLog2 = eventLog = new UserEventLog(string2, string3, l, l2, n, string4);
                    } else {
                        userEventLog2 = null;
                    }
                    UserEventLog userEventLog3 = userEventLog2;
                    userEventLog = userEventLog3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else {
                userEventLog = null;
            }
            stringArray = userEventLog;
        }
        catch (Exception e) {
            this.logger.verbose("Could not fetch records out of database " + tName + '.', e);
            stringArray = null;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public int readEventCountByDeviceIdAndNormalizedEventName(@NotNull String deviceID, @NotNull String normalizedEventName) {
        int n;
        Intrinsics.checkNotNullParameter((Object)deviceID, (String)"deviceID");
        Intrinsics.checkNotNullParameter((Object)normalizedEventName, (String)"normalizedEventName");
        String tName = this.table.getTableName();
        String selection = "deviceID = ? AND normalizedEventName = ?";
        String[] stringArray = new String[]{deviceID, normalizedEventName};
        String[] selectionArgs = stringArray;
        String[] stringArray2 = new String[]{"count"};
        String[] projection = stringArray2;
        try {
            int n2;
            stringArray2 = this.db.getReadableDatabase().query(tName, projection, selection, selectionArgs, null, null, null, null);
            if (stringArray2 != null) {
                Closeable closeable = (Closeable)stringArray2;
                Throwable throwable = null;
                try {
                    Cursor cursor = (Cursor)closeable;
                    boolean bl = false;
                    int n3 = cursor.moveToFirst() ? cursor.getInt(cursor.getColumnIndexOrThrow("count")) : 0;
                    n2 = n3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else {
                n2 = -1;
            }
            n = n2;
        }
        catch (Exception e) {
            this.logger.verbose("Could not fetch records out of database " + tName + '.', e);
            n = -1;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public boolean eventExistsByDeviceIdAndNormalizedEventName(@NotNull String deviceID, @NotNull String normalizedEventName) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)deviceID, (String)"deviceID");
        Intrinsics.checkNotNullParameter((Object)normalizedEventName, (String)"normalizedEventName");
        String tName = this.table.getTableName();
        String selection = "deviceID = ? AND normalizedEventName = ?";
        String[] stringArray = new String[]{deviceID, normalizedEventName};
        String[] selectionArgs = stringArray;
        String resultColumn = "eventExists";
        String query = StringsKt.trimIndent((String)("\n            SELECT EXISTS(\n                SELECT 1 \n                FROM " + tName + " \n                WHERE " + selection + "\n            ) AS " + resultColumn + ";\n        "));
        try {
            boolean bl2;
            Cursor cursor = this.db.getReadableDatabase().rawQuery(query, selectionArgs);
            if (cursor != null) {
                Closeable closeable = (Closeable)cursor;
                Throwable throwable = null;
                try {
                    Cursor cursor2 = (Cursor)closeable;
                    boolean bl3 = false;
                    boolean bl4 = cursor2.moveToFirst() ? cursor2.getInt(cursor2.getColumnIndexOrThrow(resultColumn)) == 1 : false;
                    bl2 = bl4;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        catch (Exception e) {
            this.logger.verbose("Could not fetch records out of database " + tName + '.', e);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public boolean eventExistsByDeviceIdAndNormalizedEventNameAndCount(@NotNull String deviceID, @NotNull String normalizedEventName, int count) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)deviceID, (String)"deviceID");
        Intrinsics.checkNotNullParameter((Object)normalizedEventName, (String)"normalizedEventName");
        String tName = this.table.getTableName();
        String selection = "deviceID = ? AND normalizedEventName = ? AND count = ?";
        String[] stringArray = new String[]{deviceID, normalizedEventName, String.valueOf(count)};
        String[] selectionArgs = stringArray;
        String resultColumn = "eventExists";
        String query = StringsKt.trimIndent((String)("\n            SELECT EXISTS(\n                SELECT 1 \n                FROM " + tName + " \n                WHERE " + selection + "\n                ) AS " + resultColumn + ";\n        "));
        try {
            boolean bl2;
            Cursor cursor = this.db.getReadableDatabase().rawQuery(query, selectionArgs);
            if (cursor != null) {
                Closeable closeable = (Closeable)cursor;
                Throwable throwable = null;
                try {
                    Cursor cursor2 = (Cursor)closeable;
                    boolean bl3 = false;
                    boolean bl4 = cursor2.moveToFirst() ? cursor2.getInt(cursor2.getColumnIndexOrThrow(resultColumn)) == 1 : false;
                    bl2 = bl4;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        catch (Exception e) {
            this.logger.verbose("Could not fetch records out of database " + tName + '.', e);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    @NotNull
    public List<UserEventLog> allEventsByDeviceID(@NotNull String deviceID) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)deviceID, (String)"deviceID");
        String tName = this.table.getTableName();
        List eventList = new ArrayList();
        String selection = "deviceID = ?";
        String[] stringArray = new String[]{deviceID};
        String[] selectionArgs = stringArray;
        String orderBy = "lastTs ASC";
        try {
            List list;
            object = this.db.getReadableDatabase().query(tName, null, selection, selectionArgs, null, null, orderBy, null);
            if (object != null) {
                Closeable closeable = (Closeable)object;
                Throwable throwable = null;
                try {
                    Cursor cursor = (Cursor)closeable;
                    boolean bl = false;
                    while (cursor.moveToNext()) {
                        String string2 = cursor.getString(cursor.getColumnIndexOrThrow("eventName"));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                        String string3 = cursor.getString(cursor.getColumnIndexOrThrow("normalizedEventName"));
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
                        long l = cursor.getLong(cursor.getColumnIndexOrThrow("firstTs"));
                        long l2 = cursor.getLong(cursor.getColumnIndexOrThrow("lastTs"));
                        int n = cursor.getInt(cursor.getColumnIndexOrThrow("count"));
                        String string4 = cursor.getString(cursor.getColumnIndexOrThrow("deviceID"));
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
                        UserEventLog eventLog = new UserEventLog(string2, string3, l, l2, n, string4);
                        eventList.add(eventLog);
                    }
                    List list2 = eventList;
                    list = list2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            object = list;
        }
        catch (Exception e) {
            this.logger.verbose("Could not fetch records out of database " + tName + '.', e);
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    @NotNull
    public List<UserEventLog> allEvents() {
        Object object;
        String tName = this.table.getTableName();
        List eventList = new ArrayList();
        String orderBy = "lastTs ASC";
        try {
            List list;
            object = this.db.getReadableDatabase().query(tName, null, null, null, null, null, orderBy);
            if (object != null) {
                Closeable closeable = (Closeable)object;
                Throwable throwable = null;
                try {
                    Cursor cursor = (Cursor)closeable;
                    boolean bl = false;
                    while (cursor.moveToNext()) {
                        String string2 = cursor.getString(cursor.getColumnIndexOrThrow("eventName"));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                        String string3 = cursor.getString(cursor.getColumnIndexOrThrow("normalizedEventName"));
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
                        long l = cursor.getLong(cursor.getColumnIndexOrThrow("firstTs"));
                        long l2 = cursor.getLong(cursor.getColumnIndexOrThrow("lastTs"));
                        int n = cursor.getInt(cursor.getColumnIndexOrThrow("count"));
                        String string4 = cursor.getString(cursor.getColumnIndexOrThrow("deviceID"));
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
                        UserEventLog eventLog = new UserEventLog(string2, string3, l, l2, n, string4);
                        eventList.add(eventLog);
                    }
                    List list2 = eventList;
                    list = list2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            object = list;
        }
        catch (Exception e) {
            this.logger.verbose("Could not fetch records out of database " + tName + '.', e);
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Override
    @WorkerThread
    public boolean cleanUpExtraEvents(int threshold, int numberOfRowsToCleanup) {
        boolean bl;
        if (threshold <= 0) {
            this.logger.verbose("Invalid threshold value: " + threshold + ". Threshold should be greater than 0");
            return false;
        }
        if (numberOfRowsToCleanup < 0) {
            this.logger.verbose("Invalid numberOfRowsToCleanup value: " + numberOfRowsToCleanup + ". Should be greater than or equal to 0");
            return false;
        }
        if (numberOfRowsToCleanup >= threshold) {
            this.logger.verbose("Invalid numberOfRowsToCleanup value: " + numberOfRowsToCleanup + ". Should be less than threshold: " + threshold);
            return false;
        }
        String tName = this.table.getTableName();
        int numberOfRowsToKeep = threshold - numberOfRowsToCleanup;
        try {
            String query = StringsKt.trimIndent((String)("\n            DELETE FROM " + tName + "\n            WHERE (normalizedEventName, deviceID) IN (\n                SELECT normalizedEventName, deviceID\n                FROM " + tName + "\n                ORDER BY lastTs ASC \n                LIMIT (\n                SELECT CASE \n                    WHEN COUNT(*) > ? THEN COUNT(*) - ?\n                    ELSE 0\n                END \n                FROM " + tName + "\n                )\n            );\n        "));
            Object[] objectArray = new Integer[]{threshold, numberOfRowsToKeep};
            this.db.getWritableDatabase().execSQL(query, objectArray);
            this.logger.verbose("If row count is above " + threshold + " then only keep " + numberOfRowsToKeep + " rows in " + tName);
            bl = true;
        }
        catch (Exception e) {
            this.logger.verbose("Error cleaning up extra events in " + tName + '.', e);
            bl = false;
        }
        return bl;
    }
}

