/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.task;

import android.os.Build;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.task.CTExecutors;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J\b\u0010\f\u001a\u00020\bH\u0007J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u001e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/clevertap/android/sdk/task/CTExecutorFactory;", "", "<init>", "()V", "TAG_RESOURCE_DOWNLOADER", "", "executorMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/clevertap/android/sdk/task/CTExecutors;", "executors", "config", "Lcom/clevertap/android/sdk/CleverTapInstanceConfig;", "executorResourceDownloader", "ioPoolSize", "", "getOrCreateExecutorApi21", "key", "supplier", "Lkotlin/Function0;", "removeExecutor", "", "accountId", "clevertap-core_release"})
@SourceDebugExtension(value={"SMAP\nCTExecutorFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CTExecutorFactory.kt\ncom/clevertap/android/sdk/task/CTExecutorFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
public final class CTExecutorFactory {
    @NotNull
    public static final CTExecutorFactory INSTANCE = new CTExecutorFactory();
    @NotNull
    private static final String TAG_RESOURCE_DOWNLOADER = "Resource Downloader";
    @NotNull
    private static final ConcurrentHashMap<String, CTExecutors> executorMap = new ConcurrentHashMap();

    private CTExecutorFactory() {
    }

    @JvmStatic
    @NotNull
    public static final CTExecutors executors(@Nullable CleverTapInstanceConfig config) {
        CTExecutors cTExecutors;
        if (config == null) {
            boolean $i$a$-requireNotNull-CTExecutorFactory$executors$22 = false;
            String $i$a$-requireNotNull-CTExecutorFactory$executors$22 = "Can't create task for null config";
            throw new IllegalArgumentException($i$a$-requireNotNull-CTExecutorFactory$executors$22.toString());
        }
        String accountId = config.getAccountId();
        if (Build.VERSION.SDK_INT >= 24) {
            CTExecutors cTExecutors2 = executorMap.computeIfAbsent(accountId, arg_0 -> CTExecutorFactory.executors$lambda$2(arg_0 -> CTExecutorFactory.executors$lambda$1(config, arg_0), arg_0));
            Intrinsics.checkNotNull((Object)cTExecutors2);
            cTExecutors = cTExecutors2;
        } else {
            Intrinsics.checkNotNull((Object)accountId);
            cTExecutors = INSTANCE.getOrCreateExecutorApi21(accountId, (Function0<? extends CTExecutors>)((Function0)() -> CTExecutorFactory.executors$lambda$3(config)));
        }
        return cTExecutors;
    }

    @JvmStatic
    @NotNull
    public static final CTExecutors executorResourceDownloader() {
        return CTExecutorFactory.executorResourceDownloader(8);
    }

    @JvmStatic
    @NotNull
    public static final CTExecutors executorResourceDownloader(int ioPoolSize) {
        CTExecutors cTExecutors;
        if (Build.VERSION.SDK_INT >= 24) {
            CTExecutors cTExecutors2 = executorMap.computeIfAbsent(TAG_RESOURCE_DOWNLOADER, arg_0 -> CTExecutorFactory.executorResourceDownloader$lambda$5(arg_0 -> CTExecutorFactory.executorResourceDownloader$lambda$4(ioPoolSize, arg_0), arg_0));
            Intrinsics.checkNotNull((Object)cTExecutors2);
            cTExecutors = cTExecutors2;
        } else {
            cTExecutors = INSTANCE.getOrCreateExecutorApi21(TAG_RESOURCE_DOWNLOADER, (Function0<? extends CTExecutors>)((Function0)() -> CTExecutorFactory.executorResourceDownloader$lambda$6(ioPoolSize)));
        }
        return cTExecutors;
    }

    private final CTExecutors getOrCreateExecutorApi21(String key, Function0<? extends CTExecutors> supplier) {
        CTExecutors newExecutor;
        CTExecutors existingExecutor = executorMap.get(key);
        if (existingExecutor == null && (existingExecutor = executorMap.putIfAbsent(key, newExecutor = (CTExecutors)supplier.invoke())) == null) {
            existingExecutor = newExecutor;
        }
        return existingExecutor;
    }

    @JvmStatic
    public static final boolean removeExecutor(@NotNull String accountId) {
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        CTExecutors removed = executorMap.remove(accountId);
        return removed != null;
    }

    private static final CTExecutors executors$lambda$1(CleverTapInstanceConfig $config, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new CTExecutors($config);
    }

    private static final CTExecutors executors$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CTExecutors)$tmp0.invoke(p0);
    }

    private static final CTExecutors executors$lambda$3(CleverTapInstanceConfig $config) {
        return new CTExecutors($config);
    }

    private static final CTExecutors executorResourceDownloader$lambda$4(int $ioPoolSize, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new CTExecutors($ioPoolSize);
    }

    private static final CTExecutors executorResourceDownloader$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CTExecutors)$tmp0.invoke(p0);
    }

    private static final CTExecutors executorResourceDownloader$lambda$6(int $ioPoolSize) {
        return new CTExecutors($ioPoolSize);
    }
}

